-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  First_Name Middle_Initial Last_Name
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Radio.Container,
  Jpats_Ios_Interface;

package body JPATS_Radio.Ios_If is

   Ios : Container.Ios_Interface_Instance renames Container.This_Ios_Interface;

   procedure Set_Gs_Fail( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Gs_Fail := JPATS_IOS_Interface.Convert_To_Bool( pData );
   end Set_Gs_Fail;

   procedure Register_Ios_Variables  is
   begin
      JPATS_IOS_Interface.Register
        (Name        => "GS_Fail",
         Variable    => IOS.Gs_Fail'address,
         Set_Routine => Set_Gs_Fail'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Elt_Arm_Sw",
         Variable    => IOS.Elt_Arm_Sw'address
         );
   end Register_Ios_Variables;


end JPATS_Radio.Ios_If;
