with Stethoscope;

separate (Jpats_Radio.Controller)

procedure Scope is

begin

   Stethoscope.Register_Signal
     (Name              => "radio/station.icao",
      Units             => "ident",
      Object_Address    => Station.Icao'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/station.typ1",
      Units             => "packed word",
      Object_Address    => Station.Typ1'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/station.typ2",
      Units             => "packed word",
      Object_Address    => Station.Typ2'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/station.rng",
      Units             => "nm's",
      Object_Address    => Station.Rng'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/station.lat",
      Units             => "deg's",
      Object_Address    => Station.Lat'address,
      Value_Type        => "double",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/station.lon",
      Units             => "deg's",
      Object_Address    => Station.Lon'address,
      Value_Type        => "double",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/station.var",
      Units             => "deg's",
      Object_Address    => Station.Var'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/station.elv",
      Units             => "feet",
      Object_Address    => Station.Elv'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/station.frq",
      Units             => "mhz",
      Object_Address    => Station.Frq'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/station.hdg",
      Units             => "deg's",
      Object_Address    => Station.Hdg'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/station.aid",
      Units             => "x",
      Object_Address    => Station.Aid'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/station.rid",
      Units             => "x",
      Object_Address    => Station.Rid'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/station.lgd",
      Units             => "x",
      Object_Address    => Station.Lgd'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/station.lbw",
      Units             => "x",
      Object_Address    => Station.Lbw'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/station.gsa",
      Units             => "deg's",
      Object_Address    => Station.Gsa'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/station.gsw",
      Units             => "deg's",
      Object_Address    => Station.Gsw'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/station.gtd",
      Units             => "feet",
      Object_Address    => Station.Gtd'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/station.bad",
      Units             => "feet",
      Object_Address    => Station.Bad'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/position.latitude",
      Units             => "deg's",
      Object_Address    => Position.Latitude'address,
      Value_Type        => "double",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/position.longitude",
      Units             => "deg's",
      Object_Address    => Position.Longitude'address,
      Value_Type        => "double",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/position.altitude",
      Units             => "feet",
      Object_Address    => Position.Altitude'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/frequency_changed",
      Units             => "t-f",
      Object_Address    => Frequency_Changed'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/true_heading",
      Units             => "deg's",
      Object_Address    => True_Heading'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/aircraft_pitch",
      Units             => "deg's",
      Object_Address    => Aircraft_Pitch'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/reference_airfield.idnt",
      Units             => "x",
      Object_Address    => Reference_Airfield.Idnt'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/reference_airfield.icao",
      Units             => "x",
      Object_Address    => Reference_Airfield.Icao'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/reference_airfield.ata",
      Units             => "x",
      Object_Address    => Reference_Airfield.Ata'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/reference_airfield.typ1",
      Units             => "x",
      Object_Address    => Reference_Airfield.Typ1'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/reference_airfield.typ2",
      Units             => "x",
      Object_Address    => Reference_Airfield.Typ2'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/reference_airfield.lat",
      Units             => "deg's",
      Object_Address    => Reference_Airfield.Lat'address,
      Value_Type        => "double",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/reference_airfield.lon",
      Units             => "deg's",
      Object_Address    => Reference_Airfield.Lon'address,
      Value_Type        => "double",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/reference_airfield.var",
      Units             => "deg's",
      Object_Address    => Reference_Airfield.Var'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/reference_airfield.elv",
      Units             => "feet",
      Object_Address    => Reference_Airfield.Elv'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/crash",
      Units             => "t-f",
      Object_Address    => Crash'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/Discretes_Tx_Nav_034.Vor_Filtering",
      Units             => "t-f",
      Object_Address    => Discretes_Tx_Nav_034.Vor_Filtering'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/Discretes_Tx_Nav_034.Ils_Mode",
      Units             => "t-f",
      Object_Address    => Discretes_Tx_Nav_034.Ils_Mode'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/Discretes_Tx_Nav_173.Tune_Inhibit",
      Units             => "t-f",
      Object_Address    => Discretes_Tx_Nav_173.Tune_Inhibit'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/Discretes_Tx_Nav_174.Tune_Inhibit",
      Units             => "t-f",
      Object_Address    => Discretes_Tx_Nav_174.Tune_Inhibit'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/Discretes_Tx_Nav_222.Outer_Marker_Beacon",
      Units             => "t-f",
      Object_Address    => Discretes_Tx_Nav_222.Outer_Marker_Beacon'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/Discretes_Tx_Nav_222.Middle_Marker_Beacon",
      Units             => "t-f",
      Object_Address    => Discretes_Tx_Nav_222.Middle_Marker_Beacon'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/Discretes_Tx_Nav_222.Inner_Marker_Beacon",
      Units             => "t-f",
      Object_Address    => Discretes_Tx_Nav_222.Inner_Marker_Beacon'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/Discretes_Tx_Dme_035.Dme_Mode",
      Units             => "enumerated",
      Object_Address    => Discretes_Tx_Dme_035.Dme_Mode'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/Discretes_Tx_Dme_035.Nav_Mode",
      Units             => "enumerated",
      Object_Address    => Discretes_Tx_Dme_035.Nav_Mode'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/Discretes_Tx_Dme_035.Display_Enable",
      Units             => "t-f",
      Object_Address    => Discretes_Tx_Dme_035.Display_Enable'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/Discretes_Tx_Dme_035.Ident_On",
      Units             => "t-f",
      Object_Address    => Discretes_Tx_Dme_035.Ident_On'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/Discretes_Tx_Dme_035.Mhzp05",
      Units             => "t-f",
      Object_Address    => Discretes_Tx_Dme_035.Mhzp05'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/Discretes_Tx_Dme_202.Foreground",
      Units             => "t-f",
      Object_Address    => Discretes_Tx_Dme_202.Foreground'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/Discretes_Tx_Dme_202.Memory_On",
      Units             => "t-f",
      Object_Address    => Discretes_Tx_Dme_202.Memory_On'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/Vor_Bnr_Ssm",
      Units             => "x",
      Object_Address    => Vor_Bnr_Ssm'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/Loc_Bnr_Ssm",
      Units             => "x",
      Object_Address    => Loc_Bnr_Ssm'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/Gs_Ssm",
      Units             => "x",
      Object_Address    => Gs_Ssm'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/Dme_Bcd_Ssm",
      Units             => "x",
      Object_Address    => Dme_Bcd_Ssm'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "radio/Dme_Bnr_Ssm",
      Units             => "x",
      Object_Address    => Dme_Bnr_Ssm'address,
      Value_Type        => "int",
      Scope_Index       => 0);
end;
