-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Vhf_Nav,
  Radio.Audio.Dme,
  Radio.Elt,
  Radio.Transponder,
  Radio.Audio.Communication.Uhf_Comm,
  Radio.Audio.Communication.Vhf_Comm,
  Arinc_429_Types;

package JPATS_Radio.Container is

   package Jrt renames Jpats_Radio_Types;

   type Instance is
      record
         The_VHF_Nav     : Vhf_Nav.Instance;
         The_Dme         : Radio.Audio.Dme.Instance;
         The_Elt         : Radio.Elt.Instance;
         The_Transponder : Radio.Transponder.Instance;
         The_Uhf_Comm    : Radio.Audio.Communication.Uhf_Comm.Instance;
         The_Vhf_Comm    : Radio.Audio.Communication.Vhf_Comm.Instance;
         The_Magnetic_Variation : Float;
         The_Vhf_Status : Jrt.Vhf_Status_Type;
         The_Uhf_Status : Jrt.Uhf_Status_Type;
         The_Nav_Status : Jrt.Nav_Status_Type;
         The_Dme_Status : Jrt.Dme_Status_Type;
         The_Transponder_Status : Jrt.Transponder_Status_Type;
      end record;

   This_Subsystem : Instance;

   Init_Message : constant Arinc_429_Types.Message_Type :=
     (The_Label      => 0,                                 -- Bits  1 -  8
      The_Sdi        => 0,                                 -- Bits  9 - 10
      The_Value      => Arinc_429_Types.Zero_Value_Field,  -- Bits 11 - 29
      The_Ssm        => 0,                                 -- Bits 30 - 31
      The_Parity_Bit => False);                            -- Bit  32


   type Io_Interface_Instance is
      record
         --Audio Control Panel
         Mkr_Hi  : Boolean := False;
         --ELT Control Panel
         Elt_Arm_Sw : Boolean := False;
         Elt_Xmt_Lt : Boolean := False;
         --TAS Panel
         Tas_Lt : Boolean := False;
         Tas_Sw_Off : Boolean := False;
         --HSI Display aga023
         --The_Nav_Tx2 : Nav_Tx_Type;
         Tx_Nav_034 : Arinc_429_Types.Message_Type := Init_Message;
         Tx_Nav_173 : Arinc_429_Types.Message_Type := Init_Message;
         Tx_Nav_174 : Arinc_429_Types.Message_Type := Init_Message;
         Tx_Nav_222 : Arinc_429_Types.Message_Type := Init_Message;
         --The_DME_Tx2 : Dme_Tx_Type;
         Tx_Dme_252 : Arinc_429_Types.Message_Type := Init_Message;
         Tx_Dme_012 : Arinc_429_Types.Message_Type := Init_Message;
         Tx_Dme_035 : Arinc_429_Types.Message_Type := Init_Message;
         Tx_Dme_202 : Arinc_429_Types.Message_Type := Init_Message;
      end record;

   Io_Size : constant := 4;

   for Io_Interface_Instance use
      record
         Mkr_Hi       at 000*Io_Size range 0 .. 31;
         Elt_Arm_Sw   at 001*Io_Size range 0 .. 31;
         Elt_Xmt_Lt   at 002*Io_Size range 0 .. 31;
         Tas_Lt     at 003*Io_Size range 0 .. 31;
         Tas_Sw_Off at 004*Io_Size range 0 .. 31;
         Tx_Nav_034   at 005*Io_Size range 0 .. 31;
         Tx_Nav_173   at 006*Io_Size range 0 .. 31;
         Tx_Nav_174   at 007*Io_Size range 0 .. 31;
         Tx_Nav_222   at 008*Io_Size range 0 .. 31;
         Tx_Dme_252   at 009*Io_Size range 0 .. 31;
         Tx_Dme_012   at 010*Io_Size range 0 .. 31;
         Tx_Dme_035   at 011*Io_Size range 0 .. 31;
         Tx_Dme_202   at 012*Io_Size range 0 .. 31;
      end record;

   This_Io_Interface : Io_Interface_Instance;

   type Ios_Interface_Instance is
      record
         Gs_Fail     : Boolean := False;
         Elt_Arm_Sw  : Boolean := False;
      end record;

   This_Ios_Interface : Ios_Interface_Instance;

end JPATS_Radio.Container;
