-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Radio_Types,
  Jpats_Radio_Db_If_Types;

with Localizer,
     Glideslope;

package ILS is

   type Instance is private;

   procedure Set_Power
      (An_Instance : in out Instance;
       Power       : in     Boolean);

   procedure Set_Mode_On
      (An_Instance : in out Instance;
       Mode_On     : in     Boolean);

   procedure Set_Aircraft_True_Hdg
      (An_Instance       : in out Instance;
       Aircraft_True_Hdg : in     Radio_Types.Heading_Type);

   procedure Set_Aircraft_Position
      (An_Instance       : in out Instance;
       Aircraft_Position : in     Radio_Types.Position_Type);

   procedure Set_Station
      (An_Instance : in out Instance;
       Station     : in     Jpats_Radio_Db_If_Types.Stn_Struct_Type);

   procedure Set_Center_Of_Gravity_X
      (An_Instance         : in out Instance;
       Center_Of_Gravity_X : in     Float);

   procedure Set_Center_Of_Gravity_Z
      (An_Instance         : in out Instance;
       Center_Of_Gravity_Z : in     Float);

   procedure Set_Aircraft_Pitch
      (An_Instance    : in out Instance;
       Aircraft_Pitch : in     Float);

   procedure Set_Reference_Airfield
      (An_Instance        : in out Instance;
       Reference_Airfield : in     Jpats_Radio_Db_If_Types.Apt_Struct_Type);

   procedure Set_Reference_Runway
      (An_Instance      : in out Instance;
       Reference_Runway : in     Jpats_Radio_Db_If_Types.Rwy_Struct_Type);

   procedure Set_Audio_On
      (An_Instance : in out Instance;
       Audio_On    : in     Boolean);

   procedure Set_To_From_Flag
      (An_Instance  : in out Instance;
       To_From_Flag : in     Radio_Types.Normalized_Type);

   procedure Set_Localizer_Valid
      (An_Instance     : in out Instance;
       Localizer_Valid : in     Boolean);

   procedure Set_Glideslope_Valid
      (An_Instance      : in out Instance;
       Glideslope_Valid : in     Boolean);

   procedure Set_VCA
      (An_Instance   : in out Instance;
       Vca           : in     Radio_Types.Normalized_Type);

   procedure Set_Localizer_Receiving
      (An_Instance         : in out Instance;
       Localizer_Receiving : in     Boolean);

   procedure Set_Glideslope_Receiving
      (An_Instance          : in out Instance;
       Glideslope_Receiving : in     Boolean);

   procedure Set_Localizer_Dev_Dots
      (An_Instance        : in out Instance;
       Localizer_Dev_Dots : in     Radio_Types.Dots_Type);

   procedure Set_Glideslope_Dev_Dots
      (An_Instance         : in out Instance;
       Glideslope_Dev_Dots : in     Radio_Types.Dots_Type);

   function Power
      (An_Instance : in Instance)
       return Boolean;

   function Mode_On
      (An_Instance : in Instance)
       return Boolean;

   function Aircraft_True_Hdg
      (An_Instance : in Instance)
       return Radio_Types.Heading_Type;

   function Aircraft_Position
      (An_Instance : in Instance)
       return Radio_Types.Position_Type;

   function Station
      (An_Instance : in Instance)
       return Jpats_Radio_Db_If_Types.Stn_Struct_Type;

   function Center_Of_Gravity_X
      (An_Instance : in Instance)
       return Float;

   function Center_Of_Gravity_Z
      (An_Instance : in Instance)
       return Float;

   function Aircraft_Pitch
      (An_Instance : in Instance)
       return Float;

   function Reference_Airfield
      (An_Instance : in Instance)
       return Jpats_Radio_Db_If_Types.Apt_Struct_Type;

   function Reference_Runway
      (An_Instance : in Instance)
       return Jpats_Radio_Db_If_Types.Rwy_Struct_Type;

   function Audio_On
     (An_Instance : in Instance)
      return Boolean;

   function To_From_Flag
     (An_Instance : in Instance)
      return Radio_Types.Normalized_Type;

   function Localizer_Valid
     (An_Instance : in Instance)
      return Boolean;

   function Glideslope_Valid
     (An_Instance : in Instance)
      return Boolean;

   function VCA
     (An_Instance : in Instance)
      return Radio_Types.Normalized_Type;

   function Localizer_Receiving
     (An_Instance : in Instance)
      return Boolean;

   function Glideslope_Receiving
     (An_Instance : in Instance)
      return Boolean;

   function Localizer_Dev_Dots
     (An_Instance : in Instance)
      return Radio_Types.Dots_Type;

   function Glideslope_Dev_Dots
     (An_Instance : in Instance)
     return Radio_Types.Dots_Type;

   function The_Localizer
     (An_Instance : in Instance)
     return Localizer.Instance;

   function The_Glideslope
     (An_Instance : in Instance)
     return Glideslope.Instance;

   procedure Init(An_Instance : in out Instance);

   procedure Update(Integration_Constant : in Float;
                    An_Instance          : in out Instance);

private

   type Instance is
      record
         Power                      : Boolean;
         Mode_On                    : Boolean;
         Aircraft_Position          : Radio_Types.Position_Type;
         Aircraft_True_Hdg          : Radio_Types.Heading_Type;
         Station                    : Jpats_Radio_Db_If_Types.Stn_Struct_Type;
         Center_Of_Gravity_X        : Float;
         Center_Of_Gravity_Z        : Float;
         Aircraft_Pitch             : Float;
         Reference_Airfield         : Jpats_Radio_Db_If_Types.Apt_Struct_Type;
         Reference_Runway           : Jpats_Radio_Db_If_Types.Rwy_Struct_Type;
         Audio_On                   : Boolean;
         To_From_Flag               : Radio_Types.Normalized_Type;
         Localizer_Valid            : Boolean;
         Glideslope_Valid           : Boolean;
         VCA                        : Radio_Types.Normalized_Type;
         Localizer_Receiving        : Boolean;
         Glideslope_Receiving       : Boolean;
         Localizer_Dev_Dots         : Radio_Types.Dots_Type;
         Glideslope_Dev_Dots        : Radio_Types.Dots_Type;
         The_Localizer              : Localizer.Instance;
         The_Glideslope             : Glideslope.Instance;
      end record;

end ILS;
