-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Ada.Text_IO,Log;
use Ada.Text_IO,Log;

package body ILS is

   procedure Set_Power
     (An_Instance : in out Instance;
      Power       : in     Boolean) is
   begin
      An_Instance.Power := Power;
   end;

   procedure Set_Mode_On
     (An_Instance : in out Instance;
      Mode_On     : in     Boolean) is
   begin
      An_Instance.Mode_On := Mode_On;
   end;

   procedure Set_Aircraft_True_Hdg
     (An_Instance       : in out Instance;
      Aircraft_True_Hdg : in     Radio_Types.Heading_Type) is
   begin
      An_Instance.Aircraft_True_Hdg := Aircraft_True_Hdg;
   end;

   procedure Set_Aircraft_Position
     (An_Instance       : in out Instance;
      Aircraft_Position : in     Radio_Types.Position_Type) is
   begin
      An_Instance.Aircraft_Position := Aircraft_Position;
   end;

   procedure Set_Station
     (An_Instance : in out Instance;
      Station     : in     Jpats_Radio_Db_If_Types.Stn_Struct_Type) is
   begin
      An_Instance.Station := Station;
   end;

   procedure Set_Center_Of_Gravity_X
     (An_Instance         : in out Instance;
      Center_Of_Gravity_X : in     Float) is
   begin
      An_Instance.Center_Of_Gravity_X := Center_Of_Gravity_X;
   end;

   procedure Set_Center_Of_Gravity_Z
     (An_Instance         : in out Instance;
      Center_Of_Gravity_Z : in     Float) is
   begin
      An_Instance.Center_Of_Gravity_Z := Center_Of_Gravity_Z;
   end;

   procedure Set_Aircraft_Pitch
     (An_Instance    : in out Instance;
      Aircraft_Pitch : in     Float) is
   begin
      An_Instance.Aircraft_Pitch := Aircraft_Pitch;
   end;

   procedure Set_Reference_Airfield
     (An_Instance        : in out Instance;
      Reference_Airfield : in     Jpats_Radio_Db_If_Types.Apt_Struct_Type) is
   begin
      An_Instance.Reference_Airfield := Reference_Airfield;
   end;

   procedure Set_Reference_Runway
     (An_Instance      : in out Instance;
      Reference_Runway : in     Jpats_Radio_Db_If_Types.Rwy_Struct_Type) is
   begin
      An_Instance.Reference_Runway := Reference_Runway;
   end;

   procedure Set_Audio_On
     (An_Instance : in out Instance;
      Audio_On    : in     Boolean) is
   begin
      An_Instance.Audio_On := Audio_On;
   end;

   procedure Set_To_From_Flag
     (An_Instance  : in out Instance;
      To_From_Flag : in     Radio_Types.Normalized_Type) is
   begin
      An_Instance.To_From_Flag := To_From_Flag;
   end;

   procedure Set_Localizer_Valid
     (An_Instance     : in out Instance;
      Localizer_Valid : in     Boolean) is
   begin
      An_Instance.Localizer_Valid := Localizer_Valid;
   end;

   procedure Set_Glideslope_Valid
     (An_Instance      : in out Instance;
      Glideslope_Valid : in     Boolean) is
   begin
      An_Instance.Glideslope_Valid := Glideslope_Valid;
   end;

   procedure Set_VCA
     (An_Instance : in out Instance;
      Vca         : in     Radio_Types.Normalized_Type) is
   begin
      An_Instance.VCA := VCA;
   end;

   procedure Set_Localizer_Receiving
     (An_Instance         : in out Instance;
      Localizer_Receiving : in     Boolean) is
   begin
      An_Instance.Localizer_Receiving := Localizer_Receiving;
   end;

   procedure Set_Glideslope_Receiving
     (An_Instance          : in out Instance;
      Glideslope_Receiving : in     Boolean) is
   begin
      An_Instance.Glideslope_Receiving := Glideslope_Receiving;
   end;

   procedure Set_Localizer_Dev_Dots
     (An_Instance        : in out Instance;
      Localizer_Dev_Dots : in     Radio_Types.Dots_Type) is
   begin
      An_Instance.Localizer_Dev_Dots := Localizer_Dev_Dots;
   end;

   procedure Set_Glideslope_Dev_Dots
     (An_Instance         : in out Instance;
      Glideslope_Dev_Dots : in     Radio_Types.Dots_Type) is
   begin
      An_Instance.Glideslope_Dev_Dots := Glideslope_Dev_Dots;
   end;

   function Power
     (An_Instance : in Instance)
     return Boolean is
   begin
     return An_Instance.Power;
   end;

   function Mode_On
     (An_Instance : in Instance)
     return Boolean is
   begin
     return An_Instance.Mode_On;
   end;

   function Aircraft_True_Hdg
     (An_Instance : in Instance)
     return Radio_Types.Heading_Type is
   begin
     return An_Instance.Aircraft_True_Hdg;
   end;

   function Aircraft_Position
     (An_Instance : in Instance)
     return Radio_Types.Position_Type is
   begin
     return An_Instance.Aircraft_Position;
   end;

   function Station
     (An_Instance : in Instance)
     return Jpats_Radio_Db_If_Types.Stn_Struct_Type is
   begin
     return An_Instance.Station;
   end;

   function Center_Of_Gravity_X
     (An_Instance : in Instance)
     return Float is
   begin
     return An_Instance.Center_Of_Gravity_X;
   end;

   function Center_Of_Gravity_Z
     (An_Instance : in Instance)
     return Float is
   begin
     return An_Instance.Center_Of_Gravity_Z;
   end;

   function Aircraft_Pitch
     (An_Instance : in Instance)
     return Float is
   begin
     return An_Instance.Aircraft_Pitch;
   end;

   function Reference_Airfield
     (An_Instance : in Instance)
     return Jpats_Radio_Db_If_Types.Apt_Struct_Type is
   begin
     return An_Instance.Reference_Airfield;
   end;

   function Reference_Runway
     (An_Instance : in Instance)
     return Jpats_Radio_Db_If_Types.Rwy_Struct_Type is
   begin
     return An_Instance.Reference_Runway;
   end;

   function Audio_On
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Audio_On;
   end;

   function To_From_Flag
     (An_Instance : in Instance)
      return Radio_Types.Normalized_Type is
   begin
      return An_Instance.To_From_Flag;
   end;

    function Localizer_Valid
      (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Localizer_Valid;
   end;

    function Glideslope_Valid
      (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Glideslope_Valid;
   end;

   function VCA
     (An_Instance : in Instance)
      return Radio_Types.Normalized_Type is
   begin
      return An_Instance.VCA;
   end;

   function Localizer_Receiving
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Localizer_Receiving;
   end;
   function Glideslope_Receiving
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Glideslope_Receiving;
   end;

   function Localizer_Dev_Dots
     (An_Instance : in Instance)
      return Radio_Types.Dots_Type is
   begin
      return An_Instance.Localizer_Dev_Dots;
   end;

   function Glideslope_Dev_Dots
     (An_Instance : in Instance)
      return Radio_Types.Dots_Type is
   begin
      return An_Instance.Glideslope_Dev_Dots;
   end;

   function The_Localizer
     (An_Instance : in Instance)
     return Localizer.instance is
   begin
      return An_Instance.The_Localizer;
   end;

   function The_Glideslope
     (An_Instance : in Instance)
     return Glideslope.Instance is
   begin
      return An_Instance.The_Glideslope;
   end;

-- =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =

   procedure INIT(An_Instance : in out Instance) is

   begin

      --initialize localizer
      Localizer.Init(An_Instance.The_Localizer);

      --initialize glideslope
      Glideslope.Init(An_Instance.The_Glideslope);

      -- Initialize instance components:
      An_Instance.Power                := False;
      An_Instance.Mode_On              := False;
      An_Instance.Aircraft_Position    := (Latitude  => 45.0,
                                           Longitude => -45.0,
                                           Altitude  => 1000.0);
      An_Instance.Aircraft_True_Hdg    := 0.0;
      An_Instance.Center_Of_Gravity_X  := 0.0;
      An_Instance.Center_Of_Gravity_Z  := 0.0;
      An_Instance.Aircraft_Pitch       := 0.0;
      An_Instance.Audio_On             := False;
      An_Instance.To_From_Flag         := 0.0;
      An_Instance.Localizer_Valid      := False;
      An_Instance.Vca                  := 0.0;
      An_Instance.Localizer_Receiving  := False;
      An_Instance.Localizer_Dev_Dots   := 0.0;
      An_Instance.Glideslope_Valid     := False;
      An_Instance.Glideslope_Receiving := False;
      An_Instance.Glideslope_Dev_Dots  := 0.0;

   end Init;

-- =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =
   procedure Update(Integration_Constant : in     Float;
                        An_Instance          : in out Instance) is

   begin

      -- Provide inputs for Localizer processing
      Localizer.Set_Localizer_Inputs
        (An_Instance         => An_Instance.The_Localizer,
         Power               => Power(An_Instance),
         Mode_On             => Mode_On(An_Instance),
         Aircraft_Position   => Aircraft_Position(An_Instance),
         Aircraft_True_Hdg   => Aircraft_True_Hdg(An_Instance),
         Station             => Station(An_Instance),
         Center_Of_Gravity_X => Center_Of_Gravity_X(An_Instance),
         Reference_Airfield  => Reference_Airfield(An_Instance),
         Reference_Runway    => Reference_Runway(An_Instance));

      --Call Localizer
      Localizer.Update_Localizer(Integration_Constant,
                                 An_Instance.The_Localizer);

      --Get outputs from Localizer
      Set_Audio_On(An_Instance,Localizer.Audio_On(An_Instance.The_Localizer));
      Set_To_From_Flag(An_Instance,
                       Localizer.To_From_Flag(An_Instance.The_Localizer));
      Set_Localizer_Valid(An_Instance,
                          Localizer.Valid(An_Instance.The_Localizer));
      Set_VCA(An_Instance,Localizer.VCA(An_Instance.The_Localizer));
      Set_Localizer_Receiving(An_Instance,
                              Localizer.Receiving(An_Instance.The_Localizer));
      Set_Localizer_Dev_Dots(An_Instance,
                             Localizer.Dev_Dots(An_Instance.The_Localizer));

   -- Provide inputs for Glideslope processing
      Glideslope.Set_Glideslope_Inputs
        (An_Instance         => An_Instance.The_Glideslope,
         Power               => Power(An_Instance),
         Mode_On             => Mode_On(An_Instance),
         Aircraft_Position   => Aircraft_Position(An_Instance),
         Aircraft_True_Hdg   => Aircraft_True_Hdg(An_Instance),
         Station             => Station(An_Instance),
         Center_Of_Gravity_X => Center_Of_Gravity_X(An_Instance),
         Center_Of_Gravity_Z => Center_Of_Gravity_Z(An_Instance),
         Aircraft_Pitch      => Aircraft_Pitch(An_Instance));

      --Call Glideslope
      Glideslope.Update(Integration_Constant,
                        An_Instance.The_Glideslope);

      --Get outputs from Glideslope
      Set_Glideslope_Valid(
        An_Instance,Glideslope.Valid(An_Instance.The_Glideslope));
      Set_Glideslope_Receiving(An_Instance,
                            Glideslope.Receiving(An_Instance.The_Glideslope));
      Set_Glideslope_Dev_Dots(An_Instance,
                              Glideslope.Dev_Dots(An_Instance.The_Glideslope));

   end Update;

end ILS;
