-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0
with Ordered_Tuple;
with Vector_Types;
use  Vector_Types;
with Force_Types;
with Torque_Types;
with Angle_Types;
with Length_Types;
with Mass_Types;


package Jpats_Propeller_Types is

  package Torque_Vector_Type is new
    Ordered_Tuple
    (Index      => Vector_Types.Cartesian_Index_Type,
     Float_Type => Torque_Types.Ft_Lbf);


  package Coordinate_Type is new
    Ordered_Tuple
    ( Index       => Vector_Types.Cartesian_Index_Type,
      Float_Type  => Length_Types.Feet);

  package Coordinate_Rotation_Type is new
    Ordered_Tuple
    ( Index       => Vector_Types.Euler_Angle_Index_Type,
      Float_Type  => Angle_Types.Radians);

  package Coordinate_Translation_Type is new
    Ordered_Tuple
    ( Index       => Vector_Types.Cartesian_Index_Type,
      Float_Type  => Length_Types.Feet);

  package Angular_Rate_Vector_Type is new
    Ordered_Tuple
    ( Index       => Vector_Types.Euler_Angle_Index_Type,
      Float_Type  => Angle_Types.Radians_Per_Sec);

  package Propeller_Angular_Rate_Vector_Type is new
    Ordered_Tuple
    ( Index       => Vector_Types.Cartesian_Index_Type,
      Float_Type  => Angle_Types.Rpm);

  subtype Radians_Per_Sec_Sq is Float;

    package Propeller_Angular_Rate_Sq_Vector_Type is new
    Ordered_Tuple
    ( Index       => Vector_Types.Cartesian_Index_Type,
      Float_Type  => Radians_Per_Sec_Sq);

  package Propeller_Corrected_Angular_Rate_Vector_Type is new
    Ordered_Tuple
    ( Index       => Vector_Types.Cartesian_Index_Type,
      Float_Type  => Angle_Types.Revolutions_Per_Sec);

  package Force_Vector_Type is new
    Ordered_Tuple
    ( Index       => Vector_Types.Cartesian_Index_Type,
      Float_Type  => Force_Types.Lbf);

--  function "-"
--    (A : in Coordinate_Type.Instance;
--     B : in Coordinate_Type.Instance)
--  return Coordinate_Type.Instance;
--
--  function "-"
--    (A : in Torque_Vector_Type.Instance;
--     B : in Torque_Vector_Type.Instance)
--  return Torque_Vector_Type.Instance;
--
--  function "-"
--    (A : in Force_Vector_Type.Instance;
--     B : in Force_Vector_Type.Instance)
--  return Force_Vector_Type.Instance;

  function "*"
    (A : in Coordinate_Type.Instance;
     B : in Force_Vector_Type.Instance)
  return Torque_Vector_Type.Instance;

  function "*"
    (A : in Propeller_Angular_Rate_Vector_Type.Instance;
     B : in Angular_Rate_Vector_Type.Instance)
  return Torque_Vector_Type.Instance;

  function "*"
    (A : in Angular_Rate_Vector_Type.Instance;
     B : in Propeller_Angular_Rate_Vector_Type.Instance)
  return Propeller_Angular_Rate_Sq_Vector_Type.Instance;

  function "*"
    (A : in Propeller_Angular_Rate_Vector_Type.Instance;
     B : in Angular_Rate_Vector_Type.Instance)
  return Propeller_Angular_Rate_Sq_Vector_Type.Instance;

  function "*"
    (A : in Mass_Types.Slugs_Feet_Sq;
     B : in Propeller_Angular_Rate_Sq_Vector_Type.Instance)
  return Torque_Vector_Type.Instance;

--  function "*"
--    (A : in Float;
--     B : in Torque_Vector_Type.Instance)
--  return Torque_Vector_Type.Instance;
--
--  function "*"
--    (A : in Torque_Vector_Type.Instance;
--     B : in Float)
--  return Torque_Vector_Type.Instance;

end Jpats_Propeller_Types;








