-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0


package body Jpats_Propeller_Types is

--  function "-"
--    (A : in Coordinate_Type.Instance;
--     B : in Coordinate_Type.Instance)
--  return Coordinate_Type.Instance is
--  begin
--    return
--       (X => A(X)-B(X),
--        Y => A(Y)-B(Y),
--        Z => A(Z)-B(Z));
--  end "-";
--
--  function "-"
--    (A : in Torque_Vector_Type.Instance;
--     B : in Torque_Vector_Type.Instance)
--  return Torque_Vector_Type.Instance is
--  begin
--    return
--       (X => A(X)-B(X),
--        Y => A(Y)-B(Y),
--        Z => A(Z)-B(Z));
--  end "-";
--
--  function "-"
--    (A : in Force_Vector_Type.Instance;
--     B : in Force_Vector_Type.Instance)
--  return Force_Vector_Type.Instance is
--  begin
--    return
--       (X => A(X)-B(X),
--        Y => A(Y)-B(Y),
--        Z => A(Z)-B(Z));
--  end "-";

  function "*"
    ( A : in Coordinate_Type.Instance;
      B : in Force_Vector_Type.Instance)
  return Torque_Vector_Type.Instance is

  begin
    return
      ( X => A(Y) * B(Z) - A(Z) * B(Y),
        Y => A(Z) * B(X) - A(X) * B(Z),
        Z => A(X) * B(Y) - A(Y) * B(X) );
  end "*";

  function "*"
    ( A : in Propeller_Angular_Rate_Vector_Type.Instance;
      B : in Angular_Rate_Vector_Type.Instance)
  return Torque_Vector_Type.Instance is

  begin
    return
      ( X => A(Y) * B(Yaw  ) - A(Z) * B(Pitch),
        Y => A(Z) * B(Roll ) - A(X) * B(Yaw  ),
        Z => A(X) * B(Pitch) - A(Y) * B(Roll ));
  end "*";

  function "*"
    ( A : in Angular_Rate_Vector_Type.Instance;
      B : in Propeller_Angular_Rate_Vector_Type.Instance)

  return Propeller_Angular_Rate_Sq_Vector_Type.Instance is

  begin
    return
      ( X => A(Pitch) * B(Z) - A(Yaw  ) * B(Y),
        Y => A(Yaw  ) * B(X) - A(Roll ) * B(Z),
        Z => A(Roll ) * B(Y) - A(Pitch) * B(X));
  end "*";

  function "*"
    ( A : in Propeller_Angular_Rate_Vector_Type.Instance;
      B : in Angular_Rate_Vector_Type.Instance)

  return Propeller_Angular_Rate_Sq_Vector_Type.Instance is

  begin
    return
      ( X => A(Y) * B(Yaw  ) - A(Z) * B(Pitch),
        Y => A(Z) * B(Roll ) - A(X) * B(Yaw  ),
        Z => A(X) * B(Pitch) - A(Y) * B(Roll ));
  end "*";

  function "*"
    (A : Mass_Types.Slugs_Feet_Sq;
     B : Propeller_Angular_Rate_Sq_Vector_Type.Instance)
  return Jpats_Propeller_Types.Torque_Vector_Type.Instance is
  begin
    return (A*B(X),A*B(Y),A*B(Z));
  end "*";

--  function "*"
--    (A : Float;
--     B : Jpats_Propeller_Types.Torque_Vector_Type.Instance)
--  return Jpats_Propeller_Types.Torque_Vector_Type.Instance is
--  begin
--    return (A*B(X),A*B(Y),A*B(Z));
--  end "*";
--
--  function "*"
--    (A : Jpats_Propeller_Types.Torque_Vector_Type.Instance;
--     B : Float)
--  return Jpats_Propeller_Types.Torque_Vector_Type.Instance is
--  begin
--    return (B*A(X),B*A(Y),B*A(Z));
--  end "*";

end Jpats_Propeller_Types;
