-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Ada.Strings.Unbounded;
with Jpats_Propeller.Controller;   -- with the other subsystem Controllers too
with Scheduler_Collection;
with Ada.Text_IO;
use  Ada.Text_IO;
with Jpats_Propeller.Container;
with Jpats_Propeller.Ios_Interface;
with Jpats_Propeller.Io_Interface;

package body JPATS_Propeller.Scheduler is

--| Update the subsystem while providing double buffering with pointers.  This provides
--| for updating the system.

--   Buffer1 : aliased Container.Instance;
--   Buffer2 : aliased Container.Instance;
--   Swap_Ptr  : Container.Instance_Ptr := Buffer1'Access;

   procedure Update
     ( An_Instance          : in out Instance;
       Integration_Constant : in     Float )
   is
   begin
--     Put_Line ("Executing JPATS_Propeller.Scheduler.Update");
--     Controller.Update
--       (Next_Subsystem => Container.Next_Subsystem,
--        This_Subsystem => Container.This_Subsystem,
--        Iconst         => Integration_Constant);
--     Swap_Ptr := Container.This_Subsystem;
--     Container.This_Subsystem := Container.Next_Subsystem;
--     Container.Next_Subsystem := Swap_Ptr;
--   Next_Subsystem : Instance_Ptr;  -- current pass
--   This_Subsystem : Instance_Ptr;  -- n-1 pass
--     Container.Next_Subsystem.all := Container.This_Subsystem.all;
     JPATS_Propeller.Controller.Update
       (Integration_Constant => Integration_Constant);

   end Update;

   -- override default freeze behavior (do nothing) and instead call Update
   -- with a 0 time-step

   procedure Update_In_Freeze
     ( An_Instance : in out Instance )
   is
   begin
     null;
     --      Update ( An_Instance, 0.0 );
   end Update_In_Freeze;

   procedure Initialize
     (An_Instance : in out Instance )
   is
   begin
      -- Note that you can refer to another package in the same package
      -- hierarchy by its simple name, omitting the prefix.  We can say
      -- Controller.Initialize rather than JPATS_Foo.Controller.Initialize
      -- (Does not apply to the with clause, where the full name must be
      -- provided.)
     Jpats_Propeller.Io_Interface.Register_Io_Variables;
     Jpats_Propeller.Ios_Interface.Register_Ios_Variables;
--     Jpats_Propeller.Controller.Read_Tables;
     Jpats_Propeller.Controller.Initialize;
--       (A_Subsystem => Container.Next_Subsystem);
--     Jpats_Propeller.Controller.Initialize
--       (A_Subsystem => Container.This_Subsystem);
   end Initialize;

   -------------------------------------------------------------------------------
   -- Routine to save a snapshot of the instance to the given stream.
   --
   -- Note that the predefined attributes 'Write and 'Output can be used on any
   -- object to save its value to the given stream. This routine should be
   -- written so that data is written to the stream in the same order that it will
   -- be read back.
   -------------------------------------------------------------------------------
   procedure Save
     ( An_Instance : in out Instance;
       To_Stream   : access Ada.Streams.Root_Stream_Type'Class)
   is
   begin
         JPATS_Propeller.Container.Instance'Write
           ( To_Stream,
              JPATS_Propeller.Container.This_Subsystem.all);
   end Save;

   -------------------------------------------------------------------------------
   -- Routine to retrieve a snapshot of the instance from the given stream.
   --
   -- Note that the predefined attributes 'Read and 'Input can be used on any
   -- object to retrieve its value in the given stream. This routine should be
   -- written so that data is read from the stream in the same order it was placed
   -- into the stream.
   -------------------------------------------------------------------------------
   procedure Restore
     ( An_Instance : in out Instance;
       From_Stream : access Ada.Streams.Root_Stream_Type'Class )
   is

   begin
     JPATS_Propeller.Container.Instance'Read
       ( From_Stream,
         Jpats_Propeller.Container.Next_Subsystem.all);
     JPATS_Propeller.Container.This_Subsystem.all := Jpats_Propeller.Container.Next_Subsystem.all;
     --     JPATS_Propeller.Container.Instance'Read
     --       ( From_Stream,
     --         JPATS_Propeller.Container.This_Subsystem.all);
   end Restore;

   -------------------------------------------------------------------------------
   -- Returns the maximum amount of *bytes* that a snapshot takes up. This is
   -- used by Create_Streams to help size some interneral buffers.
   --
   -- By default, this will return the size of Instance in bytes (not counting the
   -- Save_Stream and Restore_Stream fields below). But you can override this to
   -- return a different value. You should do this if you wrote a custom Save
   -- routine which writes out data that is not contained directly in your
   -- instance (ie: in an object pointed to by your instance, or in a package body
   -- somewhere).
   -------------------------------------------------------------------------------
   function Snapshot_Size (An_Instance : Instance) return Natural is
   begin
      return JPATS_Propeller.Container.Next_Subsystem.all'Size;
   end Snapshot_Size;

   This_Scheduler : aliased Instance;

begin

--   Container.Next_Subsystem := Buffer2'Access;
--   Container.This_Subsystem := Buffer1'Access;

--   Next_Subsystem : Instance_Ptr;  -- current pass
--   This_Subsystem : Instance_Ptr;  -- n-1 pass
   Scheduler_Collection.Register
     ( This_Scheduler'Access );

end JPATS_Propeller.Scheduler;

