-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0
with Ada.Streams.Stream_Io;
with Jpats_Propeller.Container;
with Mass_Types;
with Force_Types;
with Length_Types;
with Angle_Types;
with Normalized_Types;

private package JPATS_Propeller.Controller is

   --------------------------------------------------------------------
   -- Reference: Flight Manual USAF/USN Series T-6A Aircraft,
   --            Air Force TO 1T-6A-1
   --            Navy (NAVAIR) A1-T6AAA-NFM-100
   --            CVV Draft December 1998
   --------------------------------------------------------------------
   -- Reference: Kimball, D., "Flight Simulation Mathematical Model of
   --            the Beech MkII Joint Primary Aircraft Training System
   --            (JPATS)", Document 133E794 Rev. A, 18 February, 1998,
   --            FSI-SSD # 50181, pg 66.
   --
   -- Variable calculated elsewhere in the math model and used in this
   -- section are: BLcg, FScg, WLcg, P, Q, R, RPM, qbar, Vtas, alpha,
   -- beta75R, rho.
   --
   --
   --------------------------------------------------------------------

   -- Method Update
--   procedure Update
--     (Next_Subsystem : in out Jpats_Propeller.Container.Instance_ptr;
--      This_Subsystem : in     Jpats_Propeller.Container.Instance_ptr;
--      Iconst         : in     Float);

  procedure Update
    (Integration_Constant : in Float);

   -- Method Initialize
   procedure Initialize;
--     (A_Subsystem : in out Jpats_Propeller.Container.Instance_Ptr);

   -- Method Read Tables
--   procedure Read_Tables;

  procedure Start_Recording_Debug_Output
    (A_Subsystem  : in JPATS_Propeller.Container.Instance_Ptr;
     Debug_Stream : in out Ada.Streams.Stream_Io.Stream_Access);

  procedure Stop_Recording_Debug_Output
    (A_Subsystem : in JPATS_Propeller.Container.Instance_Ptr);

  procedure Reset;

  Aircraft_Auto_Driven                    : Boolean;
  Aircraft_Cg                             : Jpats_Propeller_Types.Coordinate_Type.Instance;
  Aircraft_Angular_Rate                   : Jpats_Propeller_Types.Angular_Rate_Vector_Type.Instance;
  Mach                                    : Length_Types.Mach;
  Atmosphere_Auto_Driven                  : Boolean;
  Ambient_Temperature_Ratio               : Normalized_Types.Normalize;
  Ambient_Pressure_Ratio                  : Normalized_Types.Normalize;
  Ambient_Temperature                     : Temperature_Types.Celsius;
  Ambient_Pressure                        : Force_Types.Pounds_Per_Sq_Feet;
  Aircraft_Angle_Of_Attack                : Angle_Types.Radians;
  Aircraft_Sideslip_Angle                 : Angle_Types.Radians;
  Air_Density                             : Mass_Types.Slugs_Per_Cubic_Feet;
  Aircraft_True_Airspeed                  : Length_Types.Feet_Per_Sec;
  Dynamic_Pressure                        : Force_Types.Pounds_Per_Sq_Feet;
  Pressure_Altitude                       : Length_Types.Feet;

end JPATS_Propeller.Controller;



