-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- PROPELLER CONTAINER
--
-- FUNCTION
-- The function of the propeller subsystem container is to provide
-- an instance of all of the components or domain classes which compose
-- a subsystem.
--
-- DESCRIPTION
-- The instance type contains an instance of a Propeller_Interface_Unit
-- and an instance of a Hartzell_4_Blade_Propeller.
--
-------------------------------------------------------------------------------
-- Reference: Kimball, D., "Flight Simulation Mathematical Model of
--            the Beech MkII Joint Primary Aircraft Training System
--            (JPATS)", Document 133E794 Rev. A, 18 February, 1998,
--            FSI-SSD # 50181, pg 66.
--
--------------------------------------------------------------------
-- Reference: Flight Manual USAF/USN Series T-6A Aircraft,
--            Air Force TO 1T-6A-1
--            Navy (NAVAIR) A1-T6AAA-NFM-100
--            CVV Draft December 1998
-------------------------------------------------------------------


with Propeller_Interface_Unit;
with Hartzell_4_Blade_Propeller;
with Hartzell_4_Blade_Propeller_Geometry;
with Geometry;

private package JPATS_Propeller.Container is


   type Instance is record
     The_Piu : Propeller_Interface_Unit.Instance;
     The_Propeller :  Hartzell_4_Blade_Propeller.Instance;
     The_Propeller_Geometry : Hartzell_4_Blade_Propeller_Geometry.Instance;
     The_Propeller_Installation_Geometry : Geometry.Instance;
   end record;

   type Instance_Ptr is access all Instance;
   Buffer1 : aliased Instance;
   Buffer2 : aliased Instance;

   Next_Subsystem : Instance_Ptr := Buffer2'Access;
   This_Subsystem : Instance_Ptr := Buffer1'Access;
   Swap_Ptr       : Instance_Ptr := Buffer1'Access;


end JPATS_Propeller.Container;

















