-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Mass_Types;
with Length_Types;
with Angle_Types;

package Hartzell_4_Blade_Propeller_Geometry is

   type Instance is private;

   -- Propeller_Inertia_Ipgyro Accessor
   function Propeller_Inertia_Ipgyro
     (An_Instance : in Instance)
      return Mass_Types.Slugs_Feet_Sq;
   procedure Propeller_Inertia_Ipgyro
     (An_Instance : in out Instance;
      Propeller_Inertia_Ipgyro   : in     Mass_Types.Slugs_Feet_Sq);

   -- Propeller_Diameter Accessor
   function Propeller_Diameter
     (An_Instance : in Instance)
      return Length_Types.Feet;
   procedure Propeller_Diameter
     (An_Instance : in out Instance;
      Propeller_Diameter    : in     Length_Types.Feet);

   -- Wetted_Surface_Area Accessor
   function Wetted_Surface_Area
     (An_Instance : in Instance)
      return Length_Types.Sq_Feet;
   procedure Wetted_Surface_Area
     (An_Instance : in out Instance;
      Wetted_Surface_Area        : in     Length_Types.Sq_Feet);

   -- Low_Pitch_Stop Accessor
   function Low_Pitch_Stop
     (An_Instance : in Instance)
      return Angle_Types.Degrees;
   procedure Low_Pitch_Stop
     (An_Instance : in out Instance;
      Low_Pitch_Stop    : in      Angle_Types.Degrees);

   -- High_Pitch_Stop Accessor
   function High_Pitch_Stop
     (An_Instance : in Instance)
      return Angle_Types.Degrees;
   procedure High_Pitch_Stop
     (An_Instance : in out Instance;
      High_Pitch_Stop : in     Angle_Types.Degrees);

   procedure Initialize
     (An_Instance : in out Instance);

private

   -- Flight test data indicates some variation in the setting of the low
   -- blade pitch stop on PT-3 with the pre-production engine compared to
   -- the aircraft with the production engine installation.  The
   -- difference is small - within the 1% tolerance permitted.
   -- Nevertheless it results in a difference in propeller speed (on the
   -- order of 100 RPM) between ships during approaches to landings and
   -- stall entries, and will be taken into account in the proof of match
   -- effort.
   -- Symbol                   Description             Value           Where Used
   -- Beta075r     Propeller low pitch stop (degrees)
   --                         for SHIP  2             10.5            prop&Engine
   --                         for SHIP > 3              9.9            prop&engine

   type Instance is record
      Propeller_Inertia_Ipgyro  : Mass_Types.Slugs_Feet_Sq;
      Propeller_Diameter        : Length_Types.Feet;
      Wetted_Surface_Area       : Length_Types.Sq_Feet; -- wing wetted surface area
      Low_Pitch_Stop            : Angle_Types.Degrees; -- degrees
      High_Pitch_Stop           : Angle_Types.Degrees; -- degrees
   end record;

end Hartzell_4_Blade_Propeller_Geometry;
