-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Ada.Text_Io;

package body Hartzell_4_Blade_Propeller_Geometry is

   -- Propeller_Inertia_Ipgyro Accessor
   function Propeller_Inertia_Ipgyro
     (An_Instance : in Instance)
      return Mass_Types.Slugs_Feet_Sq is
   begin
      return An_Instance.Propeller_Inertia_Ipgyro;
   end Propeller_Inertia_Ipgyro;

   procedure Propeller_Inertia_Ipgyro
     (An_Instance : in out Instance;
      Propeller_Inertia_Ipgyro     : in     Mass_Types.Slugs_Feet_Sq) is
   begin
      An_Instance.Propeller_Inertia_Ipgyro := Propeller_Inertia_Ipgyro;
   end Propeller_Inertia_Ipgyro;

   -- Propeller_Diameter Accessor
   function Propeller_Diameter
     (An_Instance : in Instance)
      return Length_Types.Feet is
   begin
      return An_Instance.Propeller_Diameter;
   end Propeller_Diameter;

   procedure Propeller_Diameter
     (An_Instance : in out Instance;
      Propeller_Diameter    : in     Length_Types.Feet) is
   begin
     An_Instance.Propeller_Diameter := Propeller_Diameter;
   end Propeller_Diameter;

   -- Wetted_Surface_Area Accessor
   function Wetted_Surface_Area
     (An_Instance : in Instance)
      return Length_Types.Sq_Feet is
   begin
      return An_Instance.Wetted_Surface_Area;
   end Wetted_Surface_Area;

   procedure Wetted_Surface_Area
     (An_Instance : in out Instance;
      Wetted_Surface_Area        : in     Length_Types.Sq_Feet) is
   begin
      An_Instance.Wetted_Surface_Area := Wetted_Surface_Area;
   end Wetted_Surface_Area;

   -- Low_Pitch_Stop Accessor
   function Low_Pitch_Stop
     (An_Instance : in Instance)
      return Angle_Types.Degrees is
   begin
      return An_Instance.Low_Pitch_Stop;
   end Low_Pitch_Stop;

   procedure Low_Pitch_Stop
     (An_Instance : in out Instance;
      Low_Pitch_Stop : in     Angle_Types.Degrees) is
   begin
      An_Instance.Low_Pitch_Stop := Low_Pitch_Stop;
   end Low_Pitch_Stop;

   function High_Pitch_Stop
     (An_Instance : in Instance)
      return Angle_Types.Degrees is
   begin
      return An_Instance.High_Pitch_Stop;
   end High_Pitch_Stop;

   -- High_Pitch_Stop Accessor
   procedure High_Pitch_Stop
     (An_Instance : in out Instance;
      High_Pitch_Stop : in     Angle_Types.Degrees) is
   begin
      An_Instance.High_Pitch_Stop := High_Pitch_Stop;
   end High_Pitch_Stop;

   procedure Initialize
     (An_Instance : in out Instance) is
   begin
     An_Instance.Propeller_Inertia_Ipgyro  := Mass_Types.Slugs_Feet_Sq(8.97);
     An_Instance.Propeller_Diameter        := Length_Types.Feet(8.083);
     An_Instance.Wetted_Surface_Area       := Length_Types.Sq_Feet(175.3); -- wing wetted surface area
     An_Instance.Low_Pitch_Stop            := Angle_Types.Degrees(9.9); -- degrees
     An_Instance.High_Pitch_Stop           := Angle_Types.Degrees(84.0); -- degrees
--     Ada.Text_Io.Put_Line("Init Hartzell geometry");
--     Ada.Text_Io.Put ("Low_Pitch_Stop := ");
--     Ada.Text_Io.Put_Line (Float'Image(An_Instance.Low_Pitch_Stop));
--     Ada.Text_Io.Put ("Propeller_Diameter := ");
--     Ada.Text_Io.Put_Line (Float'Image(An_Instance.Propeller_Diameter));
--     Ada.Text_Io.Put ("Wetted_Surface_Area := ");
--     Ada.Text_Io.Put_Line (Float'Image(An_Instance.Wetted_Surface_Area));


   end Initialize;

end Hartzell_4_Blade_Propeller_Geometry;



