-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer: Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0

with Ordered_Tuple;
with Length_Types;
with Torque_Types;
with Force_Types;
with Angle_Types;
with Mass_Types;
with Jpats_Propeller_Types;
use  Jpats_Propeller_Types;
with Vector_Types;
use  Vector_Types;
package Geometry is

-- Reference: Kimball, D., "Flight Simulation Mathematical Model of
--            the Beech MkII Joint Primary Aircraft Training System
--            (JPATS)", Document 133E794 Rev. A, 18 February, 1998,
--            FSI-SSD # 50181, pg 66.
--
-- The input constants for Propeller_Cat are FSprop, WLprop, Blprop

  type Instance is private;


-- Access Thrust_Reference_Point
   function  Thrust_Reference_Point
     (An_Instance : in Instance)
      return Jpats_Propeller_Types.Coordinate_Type.Instance;
   procedure Set_Thrust_Reference_Point
     (An_Instance : in out Instance;
      Reference_Point : in    Jpats_Propeller_Types.Coordinate_Type.Instance);

-- Access Rotational_Orientation
   function  Rotational_Orientation
     (An_Instance : in Instance)
      return Jpats_Propeller_Types.Coordinate_Rotation_Type.Instance;
   procedure Set_Rotational_Orientation
     (An_Instance : in out Instance;
      Rotate      : in     Jpats_Propeller_Types.Coordinate_Rotation_Type.Instance);

-- Access Moment_Arm
   function  Moment_Arm
     (An_Instance : in Instance)
      return Jpats_Propeller_Types.Coordinate_Type.Instance;
   procedure Set_Moment_Arm
     (An_Instance : in out Instance;
      Moment_Arm  : in     Jpats_Propeller_Types.Coordinate_Type.Instance);

-- Access Moment_Tensor
   function  Moment_Tensor
     (An_Instance : in Instance)
      return Jpats_Propeller_Types.Torque_Vector_Type.Instance;
   procedure Set_Moment_Tensor
     (An_Instance   : in out Instance;
      Moment_Tensor : in     Jpats_Propeller_Types.Torque_Vector_Type.Instance);

-- Access Force_Tensor
   function  Force_Tensor
     (An_Instance : in Instance)
      return Jpats_Propeller_Types.Force_Vector_Type.Instance;
   procedure Set_Force_Tensor
     (An_Instance : in out Instance;
      Force       : in     Jpats_Propeller_Types.Force_Vector_Type.Instance);

-- Access Gyroscopic_Moments_Tensor
   function  Gyroscopic_Moment_Tensor
     (An_Instance : in Instance)
      return Jpats_Propeller_Types.Torque_Vector_Type.Instance;
   procedure Set_Gyroscopic_Moment_Tensor
     (An_Instance              : in out Instance;
      Gyroscopic_Moment_Tensor : in     Jpats_Propeller_Types.Torque_Vector_Type.Instance);

-- Method Update
   procedure Update
     (An_Instance           : in out Instance;
      Axial_Thrust          : in     Jpats_Propeller_Types.Force_Vector_Type.Instance;
      Axial_Torque          : in     Jpats_Propeller_Types.Torque_Vector_Type.Instance;
      Inertia               : in     Mass_Types.Slugs_Feet_Sq;
      Rpm                   : in     Jpats_Propeller_Types.Propeller_Angular_Rate_Vector_Type.Instance;
      Aircraft_Angular_Rate : in     Jpats_Propeller_Types.Angular_Rate_Vector_Type.Instance;
      Aircraft_Cg           : in     Jpats_Propeller_Types.Coordinate_Type.Instance);

-- Method Initialize
   procedure Initialize
     (An_Instance : in out Instance);

private

   type Instance is record

      --| Propeller Coordinate System.
      --| Origination of Coordinate System in Body Axis Coordinates.
      Reference_Point    :  Jpats_Propeller_Types.Coordinate_Type.Instance;

      --| Propeller Coordinate System rotation from Body Axis Coordinate system.
      --| The propeller shaft in the Beech MkII is 2 degrees to the
      --| right and 1.5 degrees downwards, relative to the body axes.
      Coordinate_Rotation : Jpats_Propeller_Types.Coordinate_Rotation_Type.Instance;

      --| Propeller Coordinate System Translation from Body Axis Coordinate system.
      Coordinate_Translation : Jpats_Propeller_Types.Coordinate_Translation_Type.Instance;

      Moment_Arm                : Jpats_Propeller_Types.Coordinate_Type.Instance;
      Moment_Tensor             : Jpats_Propeller_Types.Torque_Vector_Type.Instance;
      Force_Tensor              : Jpats_Propeller_Types.Force_Vector_Type.Instance;
      Gyroscopic_Moment_Tensor  : Jpats_Propeller_Types.Torque_Vector_Type.Instance;
   end record;

--   -- Method Coordinate_System_Transform
--   function Coordinate_System_Transform
--     (Cs        : in Jpats_Propeller_Types.Force_Vector_Type.Instance;
--      Rotate    : in Jpats_Propeller_Types.Coordinate_Rotation_Type.Instance;
--      Translate : in Jpats_Propeller_Types.Coordinate_Translation_Type.Instance)
--     return Jpats_Propeller_Types.Force_Vector_Type.Instance;

   -- Method Calculate_Body_Force
   function Calculate_Body_Force
     (An_Instance : in Instance;
      Axial_Thrust: in Jpats_Propeller_Types.Force_Vector_Type.Instance )
     return Jpats_Propeller_Types.Force_Vector_Type.Instance;

-- Method Calculate_Moment_Arms
   function Calculate_Moment_Arms
     (An_Instance : in Instance;
      Aircraft_Cg : in Jpats_Propeller_Types.Coordinate_Type.Instance)
     return Jpats_Propeller_Types.Coordinate_Type.Instance;

-- Method Calculate_Body_Moment
      function Calculate_Body_Moment
        (An_Instance : in Instance;
         Axial_Torque : in Jpats_Propeller_Types.Torque_Vector_Type.Instance)
      return Jpats_Propeller_Types.Torque_Vector_Type.Instance;

 -- Method Calculate_Gyro_Moment
   function Calculate_Gyro_Moment
     (An_Instance           : in Instance;
      Inertia               : in Mass_Types.Slugs_Feet_Sq;
      Rpm                   : in Jpats_Propeller_Types.Propeller_Angular_Rate_Vector_Type.Instance;
      Aircraft_Angular_Rate : in Jpats_Propeller_Types.Angular_Rate_Vector_Type.Instance)
     return Jpats_Propeller_Types.Torque_Vector_Type.Instance;

end Geometry;













