-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Stepper_Motor is

-- Access Position
  function Position
    ( An_Instance : in Instance) return Step_Type is
  begin
     return An_Instance.Position;
  end Position;

 -- Update
  procedure Update
    ( Next_Instance                    : in out Instance;
      This_Instance                    : in     Instance;
      Iconst                           : in     Float;
      Position_Requested               : in     Step_Type ) is

  begin

--| Apply travel limits to the requested stepper motor request from
--| the PMU to obtain the stepper motor position.  Note that the
--| action of the FMU stepper motor reset servos is included in the
--| SMP request from Step 20 of section 11.3.1:
--|
      Next_Instance.Position :=
        Step_Type'Max(Step_Type'First,Step_Type'Min(Step_Type'Last,
                                Position_Requested));

  end Update;

-- Initialize
  procedure Initialize
    ( An_Instance : in out Instance) is
  begin
     An_Instance.Position := Step_Type'First;
  end Initialize;

end Stepper_Motor;
