-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0
with Temperature_Types;
with Jpats_Propeller_Types;
with Mass_Types;
with Torque_Types;
with Normalized_Types;
with Force_Types;
with Angle_Types;
with Length_Types;
with Electrical_Units_Types;
with Coordinate_Types;
with Bc.Containers;
with Bc.Containers.Queues;
with Bc.Containers.Queues.Bounded;
with Bc.Support.Unmanaged_Storage;
with Ada.Streams.Stream_Io;
with Electrical_Units_Types;
with Jpats_Powerplant_Types;

package Pratt_Whitney_Pt6a_68_Gas_Generator is


  --| 11.2   ENGINE MODEL

  --| The equations in this section model the static and dynamic
  --| performance of the engine.  The model is driven by fuel flow
  --| (calculated by the fuel metering unit model in section 11.3.2).
  --| Fuel flow drives the gas generator speed, including realistic rates
  --| of acceleration and deceleration.  Gas generator speed then drives
  --| power output and interstage turbine temperature.  Exhaust thrust is
  --| a function of power.  The model includes effects of ambient
  --| conditions, flight Mach number, power turbine speed, accessory
  --| load, and bleed level.

  --| The basis for the model is extensive flight test data provided by
  --| the engine manufacture, as well as installed performance obtained
  --| from the flight test aircraft.  The modeling extends through the
  --| full approved engine operating range, including starts, shutdowns
  --| and in-flight windmilling.  Gas generator acceleration and
  --| deceleration dynamics are modeled, including starter operation and
  --| shutdown.  Interstage turbine temperature dynamics are also
  --| modeled, including the temperature decay following shutdown.  These
  --| dynamic models utilize first order lags (providing realistic
  --| exponential rise and decay behaviors); time constants are defined
  --| in the equations

  --| A "hot start" model is also included, based on data obtained from
  --| an inadvertent hot start occurrence during flight test.
  --| "Malfunction factors" are included to facilitate simulation of Ng
  --| overspeed and ITT overtemp malfunctions

  --| The variables exported from this section are: ITT, Mex, Ng,
  --| Qeng, RPM, RpmDot, Xex, Zex, Beta75R, delta_t, Delta_Shp_C_NP,
  --| theta_t, Pengine_oil, Delta_ITT_C_Acc, Delta_ITT_C_Bleed,
  --| Delta_Ng_c_acc, Delta_Ng_c_bleed, Delta_SHP_C_acc, Delta_SHP_C_bleed,
  --| IGNITORS_ON.

  --| Variables calculated elsewhere and used in this section are:
  --| FScg, Hp, Mach, Qprop, WLcg, Wfdot, delta_amb, theta_amb, AIR_COND_ON,
  --| AUTO_IGNITORS_ON, AUTO_STARTER_ON, IGNITION_SWITCH, STARTER_SWITCH,
  --| SHPacc, wbleed_dot, DELTA_SHP_Hyd, NO_LIGHT_REQUEST.

  --| The input constants used in this section are: FSex, Ipaccel, WLex,
  --| and Delta_time_eng

  --| Name          Description

  --| DITTHOT       Additional ITT applied during a hot start event, vs. Ng
  --| DSHPCNPNGC    Corrected shaft horsepower sensitivity to Np, vs. corrected Ng
  --| FNCSHPC       Corrected exhaust thrust vs. corrected shaft horsepower and Mach number
  --| ITTCNGC       Corrected ITT vs. Corrected, adjusted gas generator speed and Mach
  --| KITTNG_ACC    Delta ITT per delta accessory load, vs. Ng
  --| KITTNG_BLD    Delta ITT per delta compressor bleed, vs. Ng
  --| KNGFF_ACC     Delta Ng per delta accessory load, vs. fuel flow
  --| KNGFF _BLD    Delta Ng per delta compressor bleed, vs. fuel flow
  --| KSHPCNP       Factor for Np effect on power, vs. Np
  --| KSHPNG_ACC    Delta horsepower output per delta accessory load, vs. Ng
  --| KSHPNG_BLD    Delta horsepower output per delta compressor bleed, vs. Ng
  --| NGCFFC        Corrected gas generator speed versus corrected fuel flow and Mach
  --| PENGOIL       Normal engine oil pressure as a function of Ng
  --| SHPCNGC       Corrected shaft horsepower vs. corrected gas generator speed and Mach
  --| TACCNG        Gas generator acceleration time constant vs. Ng and pressure altitude
  --| TDECNG        Gas generator deceleration time constant vs. Ng
  --| TITTNGC       Time constant for dynamic ITT model vs. corrected gas generator speed


  --| Contents of data tables are list in Appendix A, and plotted in Appendix B
  --| of Raytheon Math Model, Doc. 133E794  Rev. C.

  type Instance is private;

  -- Access Torque_Sensor
  function  Torque_Sensor
    (An_Instance : in Instance)
    return Torque_Types.Ft_Lbf;

  -- Access Engine_Torque_Pct
  function  Engine_Torque_Pct
    (An_Instance : in Instance)
    return Normalized_Types.Normalize;

  -- Access Internal Turbine Temperature_Sensor
  function  Internal_Turbine_Temperature_Sensor
    (An_Instance : in Instance)
    return Temperature_Types.Celsius;

  -- Access Gas_Generator_Rpm_Sensor
  function  Gas_Generator_Rpm_Sensor
    (An_Instance : in Instance)
    return Angle_Types.Rpm;

  -- Access Gas_Generator_Rpm
  function  Gas_Generator_Rpm
    (An_Instance : in Instance)
    return Angle_Types.Rpm;

  -- Access Gas_Generator_Rpm
  function  Gas_Generator_Speed_Pct
    (An_Instance : in Instance)
    return Normalized_Types.Normalize;

  -- Access Power_Turbine_Rpm_Sensor
  function Power_Turbine_Rpm_Sensor
    (An_Instance : in Instance)
    return Angle_Types.Rpm;

  -- Access Power_Turbine_Rpm
  function  Power_Turbine_Rpm
    (An_Instance : in Instance)
    return Angle_Types.Rpm;

  -- Access Power_Turbine_Rpm
  function  Power_Turbine_Speed_Pct
    (An_Instance : in Instance)
    return Normalized_Types.Normalize;

  -- Access Boost_Pump_Shaft Rpm
  function  Boost_Pump_Shaft_Rpm
    (An_Instance : in Instance)
    return Angle_Types.Rpm;

  -- Access Fcu_Shaft_Rpm
  function  Fcu_Shaft_Rpm
    (An_Instance : in Instance)
    return Angle_Types.Rpm;

  -- Engine Generator Shaft Rpm
  function Generator_Shaft_Rpm
    (An_Instance : in Instance)
    return Angle_Types.Rpm;

  -- Engine Hydraulic Pump Shaft Rpm
  function Hyd_Shaft_Rpm
    (An_Instance : in Instance)
    return Angle_Types.Rpm;

  -- Access Exhaust_Thrust
  function  Exhaust_Thrust
    (An_Instance : in Instance)
    return Force_Types.Lbf;
  procedure Set_Exhaust_Thrust
    (An_Instance : in out Instance);

  -- Access Bleed_Pressure
  function  Bleed_Pressure
    (An_Instance : in Instance)
    return Force_Types.Psi;
  procedure Set_Bleed_Pressure
    (An_Instance    : in out Instance;
     Bleed_Pressure : in     Force_Types.Psi);

  -- Access Bleed_Temperature
  function  Bleed_Temperature
    (An_Instance : in Instance)
    return Temperature_Types.Celsius;
  procedure Set_Bleed_Temperature
    (An_Instance       : in out Instance;
     Bleed_Temperature : in     Temperature_Types.Celsius);

  -- Access Delta_Shp_C_Acc
  function  Delta_Shp_C_Acc
    (An_Instance : in Instance)
    return Torque_Types.Horsepower;

  -- Access Delta_Shp_C_Bleed
  function  Delta_Shp_C_Bleed
    (An_Instance : in Instance)
    return Torque_Types.Horsepower;

-- Access Delta_Shp_C_Np
  function  Delta_Shp_C_Np
    (An_Instance : in Instance)
    return Torque_Types.Horsepower;

  -- Access Delta_Itt_C_Acc
  function  Delta_Itt_C_Acc
    (An_Instance : in Instance)
    return Temperature_Types.Kelvin;

  -- Access Delta_Itt_C_Bleed
  function  Delta_Itt_C_Bleed
    (An_Instance : in Instance)
    return Temperature_Types.Kelvin;

  -- Access Delta_Ng_C_Acc
  function  Delta_Ng_C_Acc
    (An_Instance : in Instance)
    return Angle_Types.Rpm;

  -- Access Delta_Ng_C_Bleed
  function  Delta_Ng_C_Bleed
    (An_Instance : in Instance)
    return Angle_Types.Rpm;

  -- Access Delta_Ng_Seizure
  function  Delta_Ng_Seizure
    (An_Instance : in Instance)
    return Angle_Types.Rpm;

  -- Access Shp
  function  Shp
    (An_Instance : in Instance)
    return Torque_Types.Horsepower;

  -- Access Ignition_Exciter_Load
  function Ignition_Exciter_Load
    (An_Instance : in Instance)
    return Electrical_Units_Types.Amps;

  -- Access Engine_oil_pressure
  function Engine_Oil_Pressure
    (An_Instance : in Instance)
    return Force_Types.Psi;

  -- Access Engine_oil_temperature
  function Engine_Oil_Temperature
    (An_Instance : in Instance)
    return Temperature_Types.Celsius;

  -- Access Chip Detect
  function Chip_Sensor
    (An_Instance : in Instance)
    return Boolean;

  -- Access Fired
  function Fired
    (An_Instance : in Instance)
    return Boolean;

  -- Set Rotor_Reset
  procedure Rotor_Reset
    (An_Instance : in out Instance);
  -- Set Rotor_Reset

  procedure Cold_Soak_Reset
    (An_Instance : in out Instance);

  -- Set Quick Start
  procedure Quick_Start
    (An_Instance : in out Instance);

  -- Set Record_Test
  procedure Start_Recording
    (An_Instance : in out Instance;
     Debug_Stream : in out Ada.Streams.Stream_Io.Stream_Access);

  procedure Stop_Recording
    (An_Instance  : in out Instance);

  procedure Set_Engine_Test_Case
    (An_Instance : in out Instance;
     Engine_Test_Case : in Integer);

  function Inlet_Temperature_Sensor
    (An_Instance : in Instance)
    return Temperature_Types.Celsius;

  -- Method Update
  procedure Update
    (Next_Instance                   : in out Instance;
     This_Instance                   : in     Instance;
     Iconst                          : in     Float;
     Ambient_Temperature_Ratio       : in     Normalized_Types.Normalize;
     Ambient_Pressure_Ratio          : in     Normalized_Types.Normalize;
     Mach_Number                     : in     Length_Types.Mach;
     Fuel_Flow_Rate                  : in     Mass_Types.Pph; -- lbm/hr
     Bleed_Flow_Rate                 : in     Mass_Types.Ppm; -- lbm/min
     Propeller_Torque_Absorbed       : in     Jpats_Propeller_Types.Torque_Vector_Type.Instance;
     Accessory_Torque_Absorbed       : in     Jpats_Propeller_Types.Torque_Vector_Type.Instance;
     Air_Conditioner_Torque_Absorbed : in     Jpats_Propeller_Types.Torque_Vector_Type.Instance;
     Accessory_Horsepower            : in     Torque_Types.Horsepower;
     Ignition_Exciter                : in     Boolean;
     Hot_Start                       : in     Boolean;
     No_Light_Request                : in     Boolean;
     Engine_Seizure                  : in     Boolean;
     Itt_Sensor_Malfunction          : in     Boolean;
     Overtemp                        : in     Boolean;
     Oil_Leak                        : in     Boolean;
     Oil_Pressure_Failure            : in     Jpats_Powerplant_Types.Oil_Pressure_Failure_Type;
     High_Oil_Temperature            : in     Boolean;
     Load_Factor                     : in     Coordinate_Types.Cartesian;
     Voltage                         : in     Electrical_Units_Types.Volts_Dc;
     Chip                            : in     Boolean;
     Flameout_Malfunction            : in     Boolean;
     Torque_Auto_Driven              : in     Boolean;
     Auto_Driven_Torque              : in     Torque_Types.Ft_lbf);


  -- Method Initialize
  procedure Initialize (An_Instance : in out Instance);

  -- Method Read_Tables
  procedure Read_Tables;

  -- Function Itt_Start_Mode for IOS
  function Itt_Start_Mode
    (An_Instance : in Instance)
    return Boolean;

private
  Lag_Time : constant Float := 1.0;    -- secs
  Frequency : constant Float := 30.0;  -- Hz
  Max_Queue_Size  : constant Positive := (Integer(Lag_Time*Frequency)+1);

  package Float_Container is new Bc.Containers
    (Item => Float,
     "="  => "=" );
  package Float_Queue is new Float_Container.Queues;
  package One_Second_Queue is new Float_Queue.Bounded
    ( Maximum_Size  => Max_Queue_Size);
  type Pratt_Queue is new One_Second_Queue.Bounded_Queue with null record;

  type Pratt_Stream_Type is new Ada.Streams.Stream_IO.Stream_Access;

  procedure Nulloutput
    (Stream : access Ada.Streams.Root_Stream_Type'Class;
     Item   : in     Pratt_Stream_Type);

  procedure Nullread
    (Stream : access Ada.Streams.Root_Stream_Type'Class;
     Item   : out    Pratt_Stream_Type);

  function Nullinput
    (Stream : access Ada.Streams.Root_Stream_Type'Class) return Pratt_Stream_Type;

  for Pratt_Stream_Type'Write  use Nulloutput;
  for Pratt_Stream_Type'Read   use Nullread;
  for Pratt_Stream_Type'Output use Nulloutput;
  for Pratt_Stream_Type'Input  use Nullinput;

  procedure Pratt_Queue_Write
    (Stream : access Ada.Streams.Root_Stream_Type'Class;
     Item   : in     Pratt_Queue);

  procedure Pratt_Queue_Read
     (Stream : access Ada.Streams.Root_Stream_Type'Class;
     Item   : out    Pratt_Queue);

  procedure Pratt_Queue_Output
    (Stream : access Ada.Streams.Root_Stream_Type'Class;
     Item   : in     Pratt_Queue);

  function Pratt_Queue_Input
    (Stream : access Ada.Streams.Root_Stream_Type'Class) return Pratt_Queue;

  for Pratt_Queue'Write  use Pratt_Queue_Write;
  for Pratt_Queue'Read   use Pratt_Queue_Read;
  for Pratt_Queue'Output use Pratt_Queue_Output;
  for Pratt_Queue'Input  use Pratt_Queue_Input;

  type Instance is record
     -- Commented out by T.E.D. to get replay to work.
     --
     -- No Access type should *ever* be saved to a stream. One possible solution would be
     -- to write a custom 'Write routine for Instance that manually calls 'Write on all its
     -- other subfields. Probably an easier solution would be to just pass Debug_Stream into
     -- Update as a parameter. Its got 27 parameters already; what's one more? :-)
     --
    Debug_Stream                          : Pratt_Stream_Type := null; -- Ada.Streams.Stream_Io.Stream_Access := null;
    Engine_Test_Case                      : Integer;
    Record_Debug_Information              : Boolean;
    Fuel_Flow_Corrected                   : Mass_Types.Pph;
    Gas_Generator_Rpm                     : Angle_Types.Rpm;
    Gas_Generator_Rpm_Corrected           : Angle_Types.Rpm;
    Gas_Generator_Rpm_In_Percent          : Normalized_Types.Normalize;
    Gas_Generator_Acceleration            : Angle_Types.Rpm_Per_Sec;
    Power_Turbine_Rpm                     : Angle_Types.Rpm;
    Power_Turbine_Rpm_Corrected           : Angle_Types.Rpm;
    Power_Turbine_Rpm_In_Percent          : Normalized_Types.Normalize;
    Power_Turbine_Acceleration            : Angle_Types.Rpm_Per_Sec;
    Internal_Turbine_Temperature          : Temperature_Types.Celsius;
    Internal_Turbine_Temperature_Lead_Lag : Temperature_Types.Celsius;
    Torque                                : Jpats_Propeller_Types.Torque_Vector_Type.Instance;
    Shaft_Horsepower                      : Torque_Types.Horsepower;
    Propeller_Rpm                         : Angle_Types.Rpm;
    Power_Turbine_Inertia                 : Mass_Types.Slugs_Feet_Sq := 17.02; -- slug-ft**2
    Exhaust_Thrust                        : Force_Types.Lbf;
    Fired                                 : Boolean;
    Bleed_Pressure                        : Force_Types.Psi;
    Bleed_Temperature                     : Temperature_Types.Celsius;
    Delta_Shp_C_Acc                       : Torque_Types.Horsepower;
    Delta_Shp_C_Bleed                     : Torque_Types.Horsepower;
    Delta_Shp_C_Np                        : Torque_Types.Horsepower;
    Delta_Itt_C_Acc                       : Temperature_Types.Kelvin;  -- ext.
    Delta_Itt_C_Bleed                     : Temperature_Types.Kelvin;
    Delta_Ng_C_Acc                        : Angle_Types.Rpm;
    Delta_Ng_C_Bleed                      : Angle_Types.Rpm;
    Delta_Ng_Seizure                      : Angle_Types.Rpm;
    Ignition_Exciter_Load                 : Electrical_Units_Types.Amps;
    Oil_Pressure                          : Force_Types.Psi;
    Oil_Temperature                       : Temperature_Types.Celsius;
    Oil_Temperature_Steady_State          : Temperature_Types.Celsius;
    Chip_Sensor                           : Boolean;
    P_Engine_Oil_Ng                       : Force_Types.Psi;
    P_Engine_Oil_Nz_Prime                 : Force_Types.Psi;
    P_Engine_Oil_Nz                       : Force_Types.Psi;
    P_Engine_Oil_Loss                     : Force_Types.Psi;
    Engine_Oil_Pressure_Lag               : Pratt_Queue;
    Q_Pt                                  : Jpats_Propeller_Types.Torque_Vector_Type.Instance;
    Seizure_Time                          : Float;
    Oil_Leak_Timer                        : Float;
    T1                                    : Temperature_Types.Celsius;
    T1_Prime                              : Temperature_Types.Celsius;
    Rotor_Reset                           : Boolean;
    Cold_Soak_Reset                       : Boolean;
    Quick_Start                           : Boolean;
    Time_Since_Fired                      : Float;
    Wf_Dot                                : Mass_Types.Pph;
    Flameout_Timer                        : Float;
    Itt_Start_Mode                        : Boolean;
    Itt_Queue                             : Pratt_Queue;
    Itt_Trigger_Signal                    : Boolean;
    Starter_Min_Voltage                   : Float;
  end record;


end Pratt_Whitney_Pt6a_68_Gas_Generator;


