-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer: Steven D. Roberts
--            Keith H. Rehm
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0
with Arinc_429_Bnr;
with Arinc_429_Types;

package Power_Management_Unit_Arinc_Labels is

    type Edm_Bnr_Sdi_Type is
    ( Not_Used, Channel_A, Channel_B, Not_Used_3);

  -- Engine Torque
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi
  -- Bit 11 - 14 Pad
  -- Bit 17 - 28 Engine Torque / 0.0625 % Torque
  -- Bit 29      Sign Bit (Always Positive)
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

--  type Label_336_Discrete_Type is record
--    Pad_11 : Boolean := False;
--    Pad_12 : Boolean := False;
--    Pad_13 : Boolean := False;
--    Pad_14 : Boolean := False;
--    Pad_15 : Boolean := False;
--    Pad_16 : Boolean := False;
--  end record;
--
--  for Label_336_Discrete_Type use record
--    Pad_11 at 000 range 0 .. 0;
--    Pad_12 at 000 range 1 .. 1;
--    Pad_13 at 000 range 2 .. 2;
--    Pad_14 at 000 range 3 .. 3;
--    Pad_15 at 000 range 4 .. 4;
--    Pad_16 at 000 range 5 .. 5;
--  end record;
--
--  for Label_336_Discrete_Type'Size use 6;

  package Label_336 is new Arinc_429_Bnr
    ( Label              => 8#336#,
      Value_Type         => Float,
      Scale              => 256.0,
      Significant_Digits => 12,
      Sdi_Type           => Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_Types.No_Discretes_Type);

  ----------------------------------------------------------------
  -- Engine Rpm - N1
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi
  -- Bit 11 - 14 Pad
  -- Bit 15 - 28 Engine Rpm / 0.015625 % rpm
  -- Bit 29      Sign Bit (Always Positive)
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

--  type Label_344_Discrete_Type is record
--    Pad_11 : Boolean := False;
--    Pad_12 : Boolean := False;
--    Pad_13 : Boolean := False;
--    Pad_14 : Boolean := False;
--  end record;
--
--  for Label_344_Discrete_Type use record
--    Pad_11 at 000 range 0 .. 0;
--    Pad_12 at 000 range 1 .. 1;
--    Pad_13 at 000 range 2 .. 2;
--    Pad_14 at 000 range 3 .. 3;
--  end record;
--
--  for Label_344_Discrete_Type'Size use 4;

  package Label_344 is new Arinc_429_Bnr
    ( Label              => 8#344#,
      Value_Type         => Float,
      Scale              => 256.0,
      Significant_Digits => 14,
      Sdi_Type           => Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_Types.No_Discretes_Type);

  ----------------------------------------------------------------
  -- Interstage Turbine Temperature
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi
  -- Bit 11 - 16 Pad
  -- Bit 17 - 28 Itt / 0.5 deg C
  -- Bit 29      Sign Bit (Always Positive)
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

--  type Label_345_Discrete_Type is record
--    Pad_11 : Boolean := False;
--    Pad_12 : Boolean := False;
--    Pad_13 : Boolean := False;
--    Pad_14 : Boolean := False;
--    Pad_15 : Boolean := False;
--    Pad_16 : Boolean := False;
--  end record;
--
--  for Label_345_Discrete_Type use record
--    Pad_11 at 000 range 0 .. 0;
--    Pad_12 at 000 range 1 .. 1;
--    Pad_13 at 000 range 2 .. 2;
--    Pad_14 at 000 range 3 .. 3;
--    Pad_15 at 000 range 4 .. 4;
--    Pad_16 at 000 range 5 .. 5;
--  end record;
--  for Label_345_Discrete_Type'Size use 6;

  package Label_345 is new Arinc_429_Bnr
    ( Label              => 8#345#,
      Value_Type         => Float,
      Scale              => 2048.0,
      Significant_Digits => 12,
      Sdi_Type           => Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_Types.No_Discretes_Type);

  ----------------------------------------------------------------
  -- Propeller RPM - Np
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi
  -- Bit 11 - 14 Pad
  -- Bit 15 - 28 Prop rpm  / 0.015625  % rpm
  -- Bit 29      Sign Bit (Always Positive)
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

--  type Label_346_Discrete_Type is record
--    Pad_11 : Boolean := False;
--    Pad_12 : Boolean := False;
--    Pad_13 : Boolean := False;
--    Pad_14 : Boolean := False;
--  end record;
--
--  for Label_346_Discrete_Type use record
--    Pad_11 at 000 range 0 .. 0;
--    Pad_12 at 000 range 1 .. 1;
--    Pad_13 at 000 range 2 .. 2;
--    Pad_14 at 000 range 3 .. 3;
--  end record;
--
--  for Label_346_Discrete_Type'Size use 4;
  package Label_346 is new Arinc_429_Bnr
    ( Label              => 8#346#,
      Value_Type         => Float,
      Scale              => 256.0,
      Significant_Digits => 14,
      Sdi_Type           => Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_Types.No_Discretes_Type);

  ----------------------------------------------------------------
  -- Outside Air Temperature
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi
  -- Bit 11 - 16 Pad
  -- Bit 17 - 28 OAT/0.03125 Degrees C
  -- Bit 29      Sign Bit
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

--  type Label_130_Discrete_Type is record
--    Pad_11 : Boolean := False;
--    Pad_12 : Boolean := False;
--    Pad_13 : Boolean := False;
--    Pad_14 : Boolean := False;
--    Pad_15 : Boolean := False;
--    Pad_16 : Boolean := False;
--  end record;
--
--  for Label_130_Discrete_Type use record
--    Pad_11 at 000 range 0 .. 0;
--    Pad_12 at 000 range 1 .. 1;
--    Pad_13 at 000 range 2 .. 2;
--    Pad_14 at 000 range 3 .. 3;
--    Pad_15 at 000 range 4 .. 4;
--    Pad_16 at 000 range 5 .. 5;
--  end record;
--
--  for Label_130_Discrete_Type'Size use 6;
  package Label_130 is new Arinc_429_Bnr
    ( Label              => 8#130#,
      Value_Type         => Float,
      Scale              => 128.0,
      Significant_Digits => 12,
      Sdi_Type           => Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_Types.No_Discretes_Type);

  ----------------------------------------------------------------
  -- Power Lever Angle
  -- Bit  0 -  8 Octal Label
  -- Bit  9 - 10 Sdi
  -- Bit 11 - 16 Pad
  -- Bit 17 - 28 Power Lever Angle/0.04395 Degrees
  -- Bit 29      Sign Bit (2's complement)
  -- Bit 30 - 31 SSM (Signed Status Matrix)
  -- Bit 32      Parity (Odd)

--  type Label_134_Discrete_Type is record
--    Pad_11 : Boolean := False;
--    Pad_12 : Boolean := False;
--    Pad_13 : Boolean := False;
--    Pad_14 : Boolean := False;
--    Pad_15 : Boolean := False;
--    Pad_16 : Boolean := False;
--  end record;
--
--  for Label_134_Discrete_Type use record
--    Pad_11 at 000 range 0 .. 0;
--    Pad_12 at 000 range 1 .. 1;
--    Pad_13 at 000 range 2 .. 2;
--    Pad_14 at 000 range 3 .. 3;
--    Pad_15 at 000 range 4 .. 4;
--    Pad_16 at 000 range 5 .. 5;
--  end record;
--
--  for Label_134_Discrete_Type'Size use 6;
  package Label_134 is new Arinc_429_Bnr
    ( Label              => 8#134#,
      Value_Type         => Float,
      Scale              => 180.0,
      Significant_Digits => 12,
      Sdi_Type           => Edm_Bnr_Sdi_Type,
      Ssm_Type           => Arinc_429_Types.Bnr_Ssm_Type,
      Discretes_Type     => Arinc_429_Types.No_Discretes_Type);

end Power_Management_Unit_Arinc_Labels;







