-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0


-------------------------------------------------------------------------------
--|
--|  POWER MANAGEMENT UNIT (PMU)
--|  The aircraft is equipped with a power management unit
--|  (PMU). The PMU is a computer which, in conjunction with
--|  movement of the PCL provides automatic control of the
--|  engine and propeller, to develop the power requested while
--|  keeping the engine and propeller within operating limita-tions.
--|  The PMU provides two operating modes, ground and
--|  flight, which are controlled by the weight-on-wheels
--|  (WOW) switches on the main gear. Ground idle (weight-on-wheels)
--|  is 60% N 1 . When in flight mode (no weight-on-wheels),
--|  idle is 67% N 1 , and N P is maintained at or above
--|  80% when above 10,000 feet MSL.
--|  During normal operation, the PMU adjusts fuel delivery and
--|  propeller RPM to provide a near linear power response. The
--|  PMU determines power available based on the inlet plenum
--|  pressure (determined from static pressure and airspeed),
--|  temperature conditions, accessory and bleed air require-ments,
--|  and weight-on-wheels switch indications. Available
--|  power is then scheduled linearly between the PCL Idle
--|  and MAX positions, while providing automatic ITT, torque
--|  and RPM limitations. As an example, if the maximum
--|  power available in a given condition is 1000 shaft horse-power
--|  (SHP), the PMU will schedule 1000 SHP at PCL
--|  MAX, and 500 SHP when the PCL is 50% of the way
--|  between PCL IDLE and PCL MAX. A cable connects the
--|  PCL to a three dimensional fuel scheduling cam in the fuel
--|  management unit (FMU), and moves the cam forward and
--|  aft.
--|  If the PMU switch is set to OFF, or if the PMU fails, manual
--|  control of the fuel delivery schedule is maintained through
--|  the mechanical connection between the PCL and the FMU.
--|  The cam in the FMU is then actuated only by movement of
--|  the PCL. When the PMU is off or has failed, the cam reverts
--|  to the backup condition. There may be a step change in
--|  engine power as the cam reverts to the backup condition.
--|  Above 10,000 feet MSL, the step change will always be to a
--|  slightly lower power level. Below 10,000 feet MSL, the step
--|  change may be to a higher or lower power level and an over-torque
--|  condition may occur. When operating in the backup
--|  condition above 10,000 feet MSL, the engine may lose up to
--|  40% of rated power due to lower fuel flow schedules pro-vided.
--|  The backup condition provides sufficient fuel flow
--|  for continued safe operation.
--|
--|  CAUTION
--|  Retard PCL as required to maintain engine
--|  within limits during the transition from auto-matic
--|  to backup condition.
--|
--|
--|  Two annunciators provide PMU status. An amber PMU
--|  STATUS annunciator will illuminate one minute after
--|  touchdown if the PMU has accommodated an inflight fail-ure
--|  and requires maintenance attention, or while airborn to
--|  indicate a weight-on-wheels switch failure. A red PMU
--|  FAIL annunciator illuminates in flight or on the ground to
--|  indicate the PMU system is nonfunctional. Power for the
--|  PMU is provided through a circuit breaker placarded PMU,
--|  located on the battery bus circuit breaker panel in the front
--|  cockpit.
--|  The PMU is normally powered by a dedicated permanent
--|  magnet alternator (PMA) mounted on the reduction gear-box.
--|  The PMA supplies 32 VAC, which the PMU converts
--|  to DC. If the PMA fails, the PMU automatically switches to
--|  the 28 VDC battery bus.
--|  OPERATION
--|  To begin an automatic start, the PCL is positioned at the
--|  auto start position by advancing out of OFF until the green
--|  ST READY annunciator illuminates (approximately two-thirds
--|  of the way to IDLE). Momentarily selecting the
--|  STARTER switch (Figure 1-10) to AUTO/RESET while the
--|  ST RDY annunciator remains illuminated initiates the fully
--|  automatic start sequence. The PMU activates the starter,
--|  boost pump and igniters, and adds fuel at the proper gas
--|  generator speed (N 1 ). The fuel is ignited by the electrical
--|  igniters and, with starter assistance, the engine accelerates.
--|  At 50% N 1 , the starter and igniters are de-energized and the
--|  boost pump is deactivated if fuel pressure is above 5 psi.
--|  The engine continues to accelerate to idle speed (60% N 1 ).
--|  The propeller automatically unfeathers during the start as
--|  engine oil pressure rises. The PCL may be advanced to
--|  IDLE any time N 1 is at or above 60%.
--|  During a normal (auto) start, the PMU continuously moni-tors
--|  N 1 , ITT, and fuel flow. The PMU can automatically
--|  stop fuel flow and deactivate the igniters and starter at any
--|  time to abort the start if necessary to avoid a hung or hot
--|  start or if any engine start parameter is exceeded.
--|  After the PCL has been advanced past the start ready posi-tion,
--|  the PMU cannot cut off fuel to terminate a start. The
--|  start may be manually aborted either by moving the PCL
--|  back to OFF, or, if the PCL has not been moved past the
--|  IDLE gate, by reselecting the STARTER switch to AUTO/
--|  RESET. Either action resets the PMU and aborts the auto-start.
--|  If the PCL has been moved past the IDLE gate, the
--|  PCL must be moved to OFF to abort the start.
--|  If a start attempt is automatically or manually aborted after
--|  fuel has been introduced, the engine must be manually
--|  motored for 15 seconds to clear any residual fuel from the
--|  engine. Manual motoring of the engine is accomplished by
--|  holding the starter switch to MANUAL for 15 seconds with
--|  the PCL in OFF.
--|
--|  CAUTION
--|  When shutting the engine down, verify the
--|  PCL is fully in the OFF position to preclude
--|  engine damage. If the PCL is left in an inter-mediate
--|  position, fuel flow may continue and
--|  cause serious engine damage due to over
--|  temperature.

--|  Model Text
--|  During Auto mode operation the PMU protects against engine limit
--|  exceedance and schedules power to achieve a linear response to
--|  power lever motion.  It also schedules acceleration to provide a
--|  "jet-like" thrust rise and to ensure stable and surge-free
--|  operation, and schedules deceleration to protect against
--|  flame-out.  To assert this control the PMU modulates fuel flow by
--|  commanding the angle of the 3D cam in the FMU via a stepper motor.
--|  The PMU also acts through the PIU to control propeller pitch.  The
--|  model currently simulates the operating characteristics of the
--|  unit for the power range of ground idle through maximum rated
--|  power, including operation in Auto mode and Manual mode, and
--|  transition between modes.  The model controls the stepper motor
--|  position in the FMU model (section 11.3.2) whether in Auto or
--|  Manual mode.  Steps 1 and 20 of this section should be executed
--|  when the PMU is off (Manual mode), while all steps are required
--|  for simulation of PMU operation in Auto mode.
--|
--|  Ref.  AIR FORCE TO 1T-6A-1
--|        NAVY (NAVAIR) A1-T6AAA-NFM-100
--|        Page. 1-15 - 1-17 CVV DRAFT DECEMBER 1998
-------------------------------------------------------------------------------
--|
--|
--| Raytheon Math Model
--| Section 11.3.1 Power Management Unit
--|
--| During Auto mode operation the PMU protects against engine limit
--| exceedance and schedules power to achieve a linear response to power
--| lever motion. It also schedules acceleration to provide a
--| "jet-like" thrust rise and to ensure stable and surge-free
--| operation, and schedules deceleration to protect against flame-out. To
--| assert this control the PMU modulates fuel flow by commanding the angle
--| of the 3D cam in the FMU via a stepper motor. The PMU also acts through
--| the PIU to control propeller pitch. This PMU model simulates the
--| operating characteristics of the unit for the power range of ground idle
--| through maximum rated power, including operation in Auto or Manual mode,
--| and transition between modes. Particular attention has been paid to
--| matching the PMU ON power response dynamics, which vary widely with
--| operating condition. The modeling also extends to starts and shutdowns,
--| including auto-starts (with auto-abort logic), pilot-monitored starts
--| and Manual mode starts. Note that the PMU model implements engine limit
--| protection differently from the actual PMU unit. Whereas the actual PMU
--| unit utilizes feedback loops to guard against torque, temperature and
--| gas generator speed exceedances, the PMU model takes advantage of the
--| known characteristics of the modeled engine to schedule power within all
--| limits without resort to feedback loops. This approach yields a simpler
--| and more robust PMU model. All known relevant functional PMU interfaces
--| with the airframe and engine have been incorporated into the model,
--| including cockpit switches, status annunciation, fuel and electrical
--| power availability, etc. The model reacts appropriately to a number of
--| failure modes including: fuel starvation, a failed PMU fault flag, a
--| noncritical fault flag, an uncommanded propeller-to-feather, and
--| excessive temperature during startup. The model controls the stepper
--| motor position in the FMU model (section 11.3.2) whether in Auto or
--| Manual mode. Thus this PMU module should be executed regardless of PMU
--| status. Figure 11.3.1a depicts the rules to be followed for proper PMU
--| execution.
--|
--| Raythean Doc. 133E794
--| Revision B
--| Page 102
----------------------------------------------------------------------------
with Ada.Streams.Stream_Io;
with Fuel_Metering_Unit;
with Normalized_Types;
with Angle_Types;
with Length_Types;
with Force_Types;
with Torque_Types;
with Temperature_Types;
with Jpats_Powerplant_Types;
with Mass_Types;
with Temperature_Types;
with Electrical_Units_Types;
with Arinc_429_Types;
with Power_Management_Unit_Arinc_Labels;

package Power_Management_Unit is

  package A429 renames Power_Management_Unit_Arinc_Labels;

   type Instance is private;
 -- Access A429_TX_PMU_A_336_Torque
   function  A429_TX_PMU_A_336_Torque (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
   procedure Set_A429_TX_PMU_A_336_Torque (An_Instance : in out Instance);

-- Access A429_TX_PMU_A_344_N1
   function  A429_TX_PMU_A_344_N1 (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
   procedure Set_A429_TX_PMU_A_344_N1 (An_Instance : in out Instance);

-- Access A429_TX_PMU_A_345_Itt
   function  A429_TX_PMU_A_345_Itt (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
   procedure Set_A429_TX_PMU_A_345_Itt (An_Instance : in out Instance);

-- Access A429_TX_PMU_A_346_Np
   function  A429_TX_PMU_A_346_Np (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
   procedure Set_A429_TX_PMU_A_346_Np (An_Instance : in out Instance);

-- Access A429_TX_PMU_A_134_Pla
   function  A429_TX_PMU_A_134_Pla (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
   procedure Set_A429_TX_PMU_A_134_Pla (An_Instance : in out Instance);

-- Access A429_TX_PMU_A_130_Outside_Air_Temperature
   function  A429_TX_PMU_A_130_Outside_Air_Temperature (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
   procedure Set_A429_TX_PMU_A_130_Outside_Air_Temperature (An_Instance : in out Instance);

-- Access A429_TX_PMU_B_336_Torque
   function  A429_TX_PMU_B_336_Torque (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
   procedure Set_A429_TX_PMU_B_336_Torque (An_Instance : in out Instance);

-- Access A429_TX_PMU_B_344_N1
   function  A429_TX_PMU_B_344_N1 (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
   procedure Set_A429_TX_PMU_B_344_N1 (An_Instance : in out Instance);

-- Access A429_TX_PMU_B_345_Itt
   function  A429_TX_PMU_B_345_Itt (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
   procedure Set_A429_TX_PMU_B_345_Itt (An_Instance : in out Instance);

-- Access A429_TX_PMU_B_346_Np
   function  A429_TX_PMU_B_346_Np (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
   procedure Set_A429_TX_PMU_B_346_Np (An_Instance : in out Instance);

-- Access A429_TX_PMU_B_134_Pla
   function  A429_TX_PMU_B_134_Pla (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
   procedure Set_A429_TX_PMU_B_134_Pla (An_Instance : in out Instance);

-- Access A429_TX_PMU_B_130_Outside_Air_Temperature
   function  A429_TX_PMU_B_130_Outside_Air_Temperature (An_Instance : in Instance) return Arinc_429_Types.Message_Type;
   procedure Set_A429_TX_PMU_B_130_Outside_Air_Temperature (An_Instance : in out Instance);

-- Access Shutdown Solenoid signal
   function Shutdown_Solenoid (An_Instance : in Instance) return Boolean;

-- Access Start Pin S*
   function Start (An_Instance : in Instance) return Boolean;

-- Access Ignitor Pin D
   function Ignition (An_Instance : in Instance) return Boolean;

-- Access Feather
   function Feather (An_Instance : in Instance) return Boolean;

-- Access Stepper_Motor_Power
   function Stepper_Motor_Power (An_Instance : in Instance) return Boolean;

-- Access Pla_At_20_Degrees for Start_Ready
   function Pla_At_20_Degrees (An_Instance : in Instance) return Boolean;

-- Access Stepper_Motor_Position_demanded
   function  Stepper_Motor_Position_Demanded
     (An_Instance : in Instance)
     return Jpats_Powerplant_Types.Step_Type;
   procedure Set_Stepper_Motor_Position_Demanded
     (An_Instance : in out Instance);

-- Access PMU_load
   function  PMU_Electrical_Load
     (An_Instance : in Instance)
     return Electrical_Units_Types.Amps;

-- Access Pmu_Fail
   function Pmu_Fail
     (An_Instance : in Instance)
     return Boolean;

-- Access Pmu_Status
   function Pmu_Status (An_Instance : in Instance) return Boolean;

-- Access PMU_Blade_Angle_Rate
   function PMU_Blade_Angle_Rate (An_Instance : in Instance) return Angle_Types.Degrees_Per_Sec;

-- Set Record_Test
   procedure Start_Recording
     (An_Instance : in out Instance;
      Debug_Stream : in out Ada.Streams.Stream_Io.Stream_Access);

-- Stop recording
   procedure Stop_Recording
     (An_Instance  : in out Instance);

-- Access Over Speed Governor Reset Solenoid
   function Overspeed_Governor_Reset_Solenoid
     (An_Instance : in Instance) return Boolean;

-- Access Pmu Reset feature
   procedure Pmu_Reset
     (An_Instance : in out Instance);


  -- Method Update
   procedure Update
    (Next_Instance                             : in out Instance;
     This_Instance                             : in     Instance;
     Iconst                                    : in     Float;
     Bleed_Air_On                              : in     Boolean;                               -- Pin Y   -- Cabin_Bleed            Interface_J2_Pin_Y;
     Left_Weight_On_Wheels                     : in     Boolean;                               -- Pin_FF  -- Wow_Left               Interface_J2_Pin_F*;
     PMA_A                                     : in     Boolean;                               -- Pin_A   -- Pma_A                  Interface_J1_Pin_A;
     PMA_B                                     : in     Boolean;                               -- Pin_S   -- Pma_B                  Interface_J1_Pin_S;
     PMA_C                                     : in     Boolean;                               -- Pin_T   -- Pma_C                  Interface_J1_Pin_T;
     Pmu_Switch                                : in     Boolean;                               -- Pin B*  -- Manual_Sel             Interface_J2_Pin_LB;
     Power_28vdc2                              : in     Boolean;                               -- Pin P   -- Power_28VDC            Interface_J2_Pin_P;
     Right_Weight_On_Wheels                    : in     Boolean;                               -- Pin BB  -- Wow_Right              Interface_J2_Pin_B*;
     Start_Enable                              : in     Boolean;                               -- Pin U*  -- Start                  Interface_J2_Pin_LU;
     Engine_Rpm_Sensor_Fault                   : in     Boolean;                               -- Malfunction
     Arinc_Airspeed_Fault                      : in     Boolean;                               -- Malfunction
     Arinc_Hp_Fault                            : in     Boolean;                               -- Malfunction
     Fuel_Flow_Sensor_Fault                    : in     Boolean;                               -- Malfunction
     Prop_Speed_Sensor_Fault                   : in     Boolean;                               -- Malfunction
     Pcl_Sensor_Fault                          : in     Boolean;                               -- Malfunction
--   Pma_Fault                                 : in     Boolean;                               -- Malfunction
     torque_sensor_fault                       : in     Boolean;                               -- Malfunction
     OAT_Sensor_Fault                          : in     Boolean;                               -- Malfunction
     Wow_Fault                                 : in     Boolean;                               -- Malfunction
     Hot_Start                                 : in     Boolean;                               -- Malfunction
     Voltage                                   : in     Electrical_Units_Types.Volts_Dc;       -- Malfunction
     PMU_Critical_Fault                        : in     Boolean;                               -- Malfunction
     PMU_Noncritical_Fault                     : in     Boolean;                               -- Malfunction
     Slow_Start_Request                        : in     Boolean;                               -- Malfunction
     Loss_Of_Useful_Power                      : in     Boolean;                               -- Malfunction
     Auto_Start_Switch_Off                     : in     Boolean;                               -- Malfunction
     Itt_Sensor_Malfunction                    : in     Boolean;                               -- Malfunction
     Overtemp                                  : in     Boolean;                               -- Malfunction
     Ambient_Pressure_Ratio                    : in     Normalized_Types.Normalize;            -- Static Pressure Transducer within the PMU itself Ps1
     Engine_Rpm                                : in     Angle_Types.Rpm;                       -- Pin_LB  -- Ng_Sig                 Interface_J1_Pin_LB;  -- Should actually read rpm from sensor instead of percent.
     Internal_Turbine_Temperature_T5_Pos       : in     Temperature_Types.Celsius;             -- Pin_LZ  -- T5_Pos                 Interface_J1_Pin_LZ;
     Mach_Number                               : in     Length_Types.Mach;
     ADC_Mach_Number                           : in     Length_Types.Mach;                     -- Air data computer input over Arinc 429 on aircraft
     Power_Control_Lever_Angle_LVDT            : in     Angle_Types.Degrees;                   -- Pin_LN  -- BA_FB_E2               Interface_J1_Pin_LN;
     Power_Control_Lever_Angle_RVDT            : in     Angle_Types.Degrees;                   -- Pin CC  -- Excitation_Hi          Interface_J2_Pin_C*;
     Power_Turbine_Rpm                         : in     Angle_Types.Rpm;                       -- Pin_LV  -- Q_Npt_Stg              Interface_J1_Pin_LV;
     Power_Turbine_Torque                      : in     Torque_Types.Ft_Lbf;                   -- Pin_LG  -- To_Hi                  Interface_J1_Pin_LG;
     ADC_Pressure_Altitude                     : in     Length_Types.Feet;                     -- Air data computer input over Arinc 429 on aircraft
     Total_Inlet_Temperature_T1_Hi             : in     Temperature_Types.Celsius;             -- Pin_LH  -- T1_Hi                  Interface_J1_Pin_LH;
     Delta_Shp_C_Acc                           : in     Torque_Types.Horsepower;               --  direct from gas generator
     Delta_Shp_C_Bleed                         : in     Torque_Types.Horsepower;               --  direct from gas generator
     Delta_Shp_C_Np                            : in     Torque_Types.Horsepower;               --  direct from gas generator
     Delta_Itt_C_Acc                           : in     Temperature_Types.Kelvin;              --  direct from gas generator
     Delta_Itt_C_Bleed                         : in     Temperature_Types.Kelvin;              --  direct from gas generator
     Delta_Ng_C_Acc                            : in     Angle_Types.Rpm;                       --  direct from gas generator
     Delta_Ng_C_Bleed                          : in     Angle_Types.Rpm;                       --  direct from gas generator
     Shp                                       : in     Torque_Types.Horsepower;               --  direct from gas generator
     K_Fmv_Delta                               : in     Normalized_Types.Normalize;            --  direct from gas generator
     Delta_Ng_Seizure                          : in     Normalized_Types.Normalize;            --  direct from gas generator
     Fired                                     : in     Boolean;                               --  direct from gas generator
     Ambient_Temperature_Ratio                 : in     Normalized_Types.Normalize);
--   Alternate_Ng_Signal                       : in     Boolean;                               -- Pin_V   -- Spare_Speed_Sig        Interface_J1_Pin_V;
--   Alternate_Ng_Signal_Rtn                   : in     Boolean;                               -- Pin_C   -- Spare_Speed_Rtn        Interface_J1_Pin_C;
--   Ambient_Pressure_Ratio                    : in     Normalized_Types.Normalize;            -- Air data computer input over Arinc 429 on aircraft
--   Ambient_Temperature_Ratio                 : in     Normalized_Types.Normalize;            -- Air data computer input over Arinc 429 on aircraft
--   Auto_Rigg                                 : in     Boolean;                               -- Pin C*  -- Auto_Rigging           Interface_J2_Pin_LC;
--   BA_FB_Com                                 : in     Integer;                               -- Pin_A*  -- BA_FB_Com              Interface_J1_Pin_A*;
--   BA_FB_E1                                  : in     Integer;                               -- Pin_LM  -- BA_FB_E1               Interface_J1_Pin_LM;
--   BA_FB_Exc                                 : in     Integer;                               -- Pin_P   -- BA_FB_Exc              Interface_J1_Pin_P;
--   BA_FB_Rtn                                 : in     Integer;                               -- Pin_R   -- BA_FB_Rtn              Interface_J1_Pin_R;
--   Internal_Turbine_Temperature_T5_Neg       : in     Tepmerature_Types.Celsius;             -- Pin_LY  -- T5_Neg                 Interface_J1_Pin_LY;
--   Mv_Fb_Com                                 : in     Boolean;                               -- Pin_K   -- Mv_Fb_Com              Interface_J1_Pin_K;
--   Mv_Fb_E2                                  : in     Boolean;                               -- Pin_LE  -- Mv_Fb_E2               Interface_J1_Pin_LE;
--   Mv_Fb_Exc                                 : in     Boolean;                               -- Pin_LF  -- Mv_Fb_Exc              Interface_J1_Pin_LF;
--   Mv_Fb_Exc_Rtn                             : in     Boolean;                               -- Pin_LX  -- Mv_Fb_Exc_Rtn          Interface_J1_Pin_LX;
--   Ng_Signal_Return                          : in     Angle_Types.Rpm;                       -- Pin_LU  -- Ng_Rtn                 Interface_J1_Pin_LU;
--   Os_Sol_Exc                                : in     Boolean;                               -- Pin_LQ  -- Os_Sol_Exc             Interface_J1_Pin_LQ;
--   Os_Sol_Lss                                : in     Boolean;                               -- Pin_B*  -- Os_Sol_Lss             Interface_J1_Pin_B*;
--   Osg_Reset_Exc                             : in     Boolean;                               -- Pin_LR  -- Osg_Reset_Exc          Interface_J1_Pin_LR;
--   Osg_Reset_Lss                             : in     Boolean;                               -- Pin_W   -- Osg_Reset_Lss          Interface_J1_Pin_W;
--   PCL_Com                                   : in     Angle_Types.Degrees;                   -- Pin E   -- PCL_Com                Interface_J2_Pin_E;
--   PCL_E1                                    : in     Angle_Types.Degrees;                   -- Pin R*  -- PCL_E_1                Interface_J2_Pin_LR;
--   PCL_E2                                    : in     Angle_Types.Degrees;                   -- Pin X   -- PCL_E_2                Interface_J2_Pin_X;
--   PCL_Excitation_Lo                         : in     Angle_Types.Degrees;                   -- Pin DD  -- Excitation_Lo          Interface_J2_Pin_D*;
--   Pin_D_Star                                : in     Boolean;                               -- Pin D*  -- Auto_Pilot_Monitored   Interface_J2_Pin_LD;
--   Pin_F_Star                                : in     Boolean;                               -- Pin F*  -- Itt_Sig_Analog         Interface_J2_Pin_LF;
--   Pin_G_Star                                : in     Boolean;                               -- Pin G*  -- Sv_Ref                 Interface_J2_Pin_LG;
--   Pin_H_Star                                : in     Boolean;                               -- Pin H*  -- Itt_Rtn_Analog         Interface_J2_Pin_LH;
--   Pin_X_Star                                : in     Boolean;                               -- Pin X*  -- Torque_Sig             Interface_J2_Pin_LX;
--   Piu_Tm_Rtn                                : in     Boolean;                               -- Pin_LW  -- Piu_Tm_Rtn             Interface_J1_Pin_LW;
--   Power_28vdc1                              : in     Boolean;                               -- Pin R   -- Power_28VDC            Interface_J2_Pin_R;
--   Q_Npt_Rtn                                 : in     Boolean;                               -- Pin_LC  -- Q_Npt_Rtn              Interface_J1_Pin_LC;
--   Reset_Exc                                 : in     Boolean;                               -- Pin_LS  -- Reset_Exc              Interface_J1_Pin_LS;
--   Reset_Lss                                 : in     Boolean;                               -- Pin_LT  -- Reset_Lss              Interface_J1_Pin_LT;
--   Sm_B_Lss                                  : in     Boolean;                               -- Pin_X   -- Sm_B_Lss               Interface_J1_Pin_X;
--   Sm_C_Lss                                  : in     Boolean;                               -- Pin_F   -- Sm_C_Lss               Interface_J1_Pin_F;
--   Sm_D_Lss                                  : in     Boolean;                               -- Pin_D   -- Sm_D_Lss               Interface_J1_Pin_D;
--   Spare_Sol_Exc                             : in     Boolean;                               -- Pin_U   -- Spare_Sol_Exc          Interface_J1_Pin_U;
--   Spare_Sol_Lss                             : in     Boolean;                               -- Pin_LP  -- Spare_Sol_Lss          Interface_J1_Pin_LP;
--   To_Lo                                     : in     Boolean;                               -- Pin_M   -- To_Lo                  Interface_J1_Pin_M;
--   To_Rtn                                    : in     Boolean;                               -- Pin_L   -- To_Rtn                 Interface_J1_Pin_L;
--   Total_Pressure_Ratio                      : in     Normalized_Types.Normalize;            -- Air data computer input over Arinc 429 on aircraft
--   Total_Temperature_Ratio                   : in     Normalized_Types.Normalize;            -- Air data computer input over Arinc 429 on aircraft
--   Boot_Application                          : in     Boolean;                               -- Pin Q*  -- Boot_Application       Interface_J2_Pin_LQ;
--   Comm_Mode                                 : in     Boolean;                               -- Pin U   -- Comm_Mode              Interface_J2_Pin_U;
--   DCU_Rs422_In_Hi                           : in     Integer;                               -- Pin_H   -- RS422_In_Hi            Interface_J1_Pin_H;
--   DCU_Rs422_In_Lo                           : in     Integer;                               -- Pin_LA  -- RS422_In_Lo            Interface_J1_Pin_LA;
--   DCU_Rs422_Out_Hi                          : in     Integer;                               -- Pin_G   -- RS422_Out_Hi           Interface_J1_Pin_G;
--   DCU_Rs422_Out_Lo                          : in     Integer;                               -- Pin_Z   -- RS422_Out_Lo           Interface_J1_Pin_Z;
--   DCU_VDC_28_Rtn                            : in     Boolean;                               -- Pin_H*  -- VDC_28_Rtn             Interface_J1_Pin_H*;
--   Discrete_Return                           : in     Boolean;                               -- Pin V*  -- Discrete_Rtn           Interface_J2_Pin_LV;
--   Discrete_Return_Wow_Control               : in     Boolean;                               -- Pin_GG  -- Discrete_Rtn           Interface_J2_Pin_G*;
--   Pin_AA                                    : in     Boolean;                               -- Pin AA  -- Discrete_Rtn           Interface_J2_Pin_A*;
--   Pin_A_Star                                : in     Boolean;                               -- Pin A*  -- Spare                  Interface_J2_Pin_LA;
--   Pin_B                                     : in     Boolean;                               -- Pin B   -- RS422_Lo_Out           Interface_J2_Pin_B;
--   Pin_C                                     : in     Boolean;                               -- Pin C   -- RS422_Hi_Out           Interface_J2_Pin_C;
--   Pin_EE                                    : in     Boolean;                               -- Pin EE  -- Spare                  Interface_J2_Pin_E*;
--   Pin_E_Star                                : in     Boolean;                               -- Pin E*  -- Arinc_429_Lo_In        Interface_J2_Pin_LE;
--   Pin_F                                     : in     Boolean;                               -- Pin F   -- Spare                  Interface_J2_Pin_F;
--   Pin_G                                     : in     Boolean;                               -- Pin G   -- Spare                  Interface_J2_Pin_G;
--   Pin_H                                     : in     Boolean;                               -- Pin H   -- Discrete_Rtn           Interface_J2_Pin_H;
--   Pin_J                                     : in     Boolean;                               -- Pin J   -- Arinc_429_Hi_In        Interface_J2_Pin_J;
--   Pin_K                                     : in     Boolean;                               -- Pin K   -- Arinc_429_Lo_Out       Interface_J2_Pin_K;
--   Pin_K_Star                                : in     Boolean;                               -- Pin K*  -- RS422_Hi_Out           Interface_J2_Pin_LK;
--   Pin_L                                     : in     Boolean;                               -- Pin L   -- Arinc_429_Hi_Out       Interface_J2_Pin_L;
--   Pin_M_Star                                : in     Boolean;                               -- Pin M*  -- RS422_Lo_Out           Interface_J2_Pin_LM;
--   Pin_S                                     : in     Boolean;                               -- Pin S   -- Power_Rtn              Interface_J2_Pin_S;
--   Pin_T                                     : in     Boolean;                               -- Pin T   -- Spare                  Interface_J2_Pin_T;
--   Pin_V                                     : in     Boolean;                               -- Pin V   -- Discrete_Rtn           Interface_J2_Pin_V;
--   Pin_W                                     : in     Boolean;                               -- Pin W   -- Spare                  Interface_J2_Pin_W;
--   Pin_Y_Star                                : in     Boolean;                               -- Pin Y*  -- RS422_Lo_In            Interface_J2_Pin_LY;
--   Pin_Z_Star                                : in     Boolean;                               -- Pin Z*  -- RS422_Hi_In            Interface_J2_Pin_LZ;
--   Power_Rtn                                 : in     Boolean;                               -- Pin A   -- Power_Rtn              Interface_J2_Pin_A;
--   Total_Inlet_Temperature_T1_Low            : in     Temperature_Types.Celsius;             -- Pin_LK  -- T1_Low                 Interface_J1_Pin_LK;
--   Total_Inlet_Temperature_T1_Rtn            : in     Temperature_Types.Celsius;             -- Pin_N   -- T1_Rtn                 Interface_J1_Pin_N;

-- Method Initialize
  procedure Initialize (An_Instance : in out Instance);

  -- Method Read_Tables
  procedure Read_Tables;

private

  type Arinc_Array_Type is array (A429.Edm_Bnr_Sdi_Type range A429.Channel_A .. A429.Channel_B) of Arinc_429_Types.Message_Type;

  type Pmu_Stream_Type is new Ada.Streams.Stream_IO.Stream_Access;

  procedure Nulloutput
    (Stream : access Ada.Streams.Root_Stream_Type'Class;
     Item   : in     Pmu_Stream_Type);

  function Nullinput
    (Stream : access Ada.Streams.Root_Stream_Type'Class) return Pmu_Stream_Type;

  procedure Nullread
    (Stream : access Ada.Streams.Root_Stream_Type'Class;
     Item   : out    Pmu_Stream_Type);

  for Pmu_Stream_Type'Write use Nulloutput;

  for Pmu_Stream_Type'Read use Nullread;

  for Pmu_Stream_Type'Output use Nulloutput;

  for Pmu_Stream_Type'Input use Nullinput;




  type Instance is record
    A429_TX_PMU_130_Outside_Air_Temperature   : Arinc_Array_Type;
    A429_TX_PMU_134_Pla                       : Arinc_Array_Type;
    A429_TX_PMU_336_Torque                    : Arinc_Array_Type;
    A429_TX_PMU_344_N1                        : Arinc_Array_Type;
    A429_TX_PMU_345_Itt                       : Arinc_Array_Type;
    A429_TX_PMU_346_Np                        : Arinc_Array_Type;
    Arinc_Engine_Torque                       : Normalized_Types.Normalize;
    Auto_Shutdown                             : Boolean;
    Auto_Start                                : Boolean;
    Auto_Start_Ready                          : Boolean;
    Auto_Start_Timer                          : Float;
    Low_Accel_Timer                           : Float;
    DCU_VDC_28                                : Boolean;
    Debug_Stream                              : Pmu_Stream_Type := null; -- Ada.Streams.Stream_Io.Stream_Access := null;
    Delta_Ng                                  : Float;
    Delta_Ng_Dyn                              : Float;
    Delta_Pla_Transition_On                   : Angle_Types.Degrees;
    Feather                                   : Boolean;
    Flight_Mode                               : Boolean;
    Flight_Mode_Timer                         : Float;
    Fuel_On_Timer                             : Float;
    Ignition                                  : Boolean;
    In_Air_Timer                              : Float;
    Itt_818_Timer                             : Float;
    Itt_820_Timer                             : Float;
    Itt_820_Fired_Timer                       : Float;
    Itt_870_Timer                             : Float;
    Itt_940_Timer                             : Float;
    Itt_Limit                                 : Temperature_Types.Celsius;
    Itt_Start_Peak                            : Float;
    Min_Rpm_Loop_Arm                          : Boolean;
    Monitored_Start                           : Boolean;
    Monitored_Start_Ready                     : Boolean;
    Monitored_Start_Timer                     : Float;
    Ng                                        : Normalized_Types.Normalize;
    Ng_33_Hp_Sec_Dot                          : Float;
    Ng_Decel_Timer                            : Float;
    Ng_Limit_Timer                            : Float;
    Ng_Req                                    : Float;
    Ng_Req_Hot                                : Float;
    Ng_Req_Norm                               : Float;
    Ng_Req_Prime                              : Float;
    Ng_Spd                                    : Float;
    No_Light                                  : Boolean;
    Np                                        : Normalized_Types.Normalize;
    Np_Dot                                    : Normalized_Types.Normalize;
    Np_Last_Pass                              : Normalized_Types.Normalize;
    On_Ground_Timer                           : Float;
    PMU_Blade_Angle_Rate                      : Angle_Types.Degrees_Per_Sec;
    Pla_At_20_Degrees                         : Boolean;
    Pmu_Arinc_Fail                            : Boolean;
    Pmu_Bit_Test_Timer                        : Float;
    Pmu_Electrical_Load                       : Electrical_Units_Types.Amps;
    Pmu_Fail                                  : Boolean;
    Pmu_Mode_Switch                           : Boolean;
    Pmu_Mode_Switch_Toggle                    : Boolean;
    Pmu_Off_Timer                             : Float;
    Pmu_On                                    : Boolean;
    Pmu_Status                                : Boolean;
    Pmu_Status_Light_On                       : Boolean;
    Pmu_Test                                  : Boolean;
    Pmu_Transition_Off                        : Boolean;
    Pmu_Transition_On                         : Boolean;
    Power_Turbine_Rpm_Limit_Timer             : Float;
    Record_Debug_Information                  : Boolean;
    Rpm_Req                                   : Float;
    Ship                                      : Integer;
    Shp_Mrp_Prime                             : Torque_Types.Horsepower;
    Shutdown                                  : Boolean;
    Slow_Start                                : Boolean;
    Smp_Req                                   : Float;
    Smp_Req_Ss                                : Float;
    Smp_Req_Timer                             : Float;
    Start                                     : Boolean;
    Start_Abort                               : Boolean;
    Start_Enable                              : Boolean;
    Stepper_Motor_Position_Demanded           : Jpats_Powerplant_Types.Step_Type;
    Stepper_Motor_Power                       : Boolean;
    Unfeather_Control_Timer                   : Float;
    Wow_Fail                                  : Boolean;
    Wow_Fault_Timer                           : Float;
    Pmu_Reset                                 : Boolean;
  end record;


end Power_Management_Unit;






























