-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0
with Power_Management_Unit_Arinc_Labels;
with Ada.Numerics.Elementary_Functions;
use  Ada.Numerics.Elementary_Functions;
with Interpolation_Table.Singly_Indexed;
with Interpolation_Table.Doubly_Indexed;
with Simulation_Dictionary;
with Electrical_Units_Types;
with Jpats_Ios_Interface;
with Jpats_Electrical;
-- with JPATS_Powerplant.Ios_Interface; -- debug purposes

with Stethoscope;
with Ada.Text_IO;
with Log;

package body Power_Management_Unit is

  PLAPCL_Table     : aliased Interpolation_Table.Singly_Indexed.Instance;
  FF3DCAM_Table    : aliased Interpolation_Table.Doubly_Indexed.Instance;
  FFCNGC_Table     : aliased Interpolation_Table.Doubly_Indexed.Instance;
  FNGDMACH_Table   : aliased Interpolation_Table.Doubly_Indexed.Instance;
  FNGDNGC_Table    : aliased Interpolation_Table.Doubly_Indexed.Instance;
  FSHPPLA_Table    : aliased Interpolation_Table.Singly_Indexed.Instance;
  NGDDECLIM_Table  : aliased Interpolation_Table.Singly_Indexed.Instance;
  SHPCNGC_Table    : aliased Interpolation_Table.Doubly_Indexed.Instance;
  NGCITTC_Table    : aliased Interpolation_Table.Doubly_Indexed.Instance;
  NGCSHPC_Table    : aliased Interpolation_Table.Doubly_Indexed.Instance;
  NGCGIDLE_Table   : aliased Interpolation_Table.Singly_Indexed.Instance;
  NGCFIDLE_Table   : aliased Interpolation_Table.Doubly_Indexed.Instance;
  FNGPWR_Table     : aliased Interpolation_Table.Singly_Indexed.Instance;
  DFNGDNPLO_Table  : aliased Interpolation_Table.Singly_Indexed.Instance;
  NGCFFC_Table     : aliased Interpolation_Table.Doubly_Indexed.Instance;
  SHPMRP0L_Table   : aliased Interpolation_Table.Doubly_Indexed.Instance;
  SHPMRP0H_Table   : aliased Interpolation_Table.Doubly_Indexed.Instance;
  SHPMRP2L_Table   : aliased Interpolation_Table.Doubly_Indexed.Instance;
  SHPMRP2H_Table   : aliased Interpolation_Table.Doubly_Indexed.Instance;
  SHPMRP3L_Table   : aliased Interpolation_Table.Doubly_Indexed.Instance;
  SHPMRP3H_Table   : aliased Interpolation_Table.Doubly_Indexed.Instance;
  SHPMRP4L_Table   : aliased Interpolation_Table.Doubly_Indexed.Instance;
  SHPMRP4H_Table   : aliased Interpolation_Table.Doubly_Indexed.Instance;
  SHPMRP5L_Table   : aliased Interpolation_Table.Doubly_Indexed.Instance;
  SHPMRP5H_Table   : aliased Interpolation_Table.Doubly_Indexed.Instance;
  SHPMRP7L_Table   : aliased Interpolation_Table.Doubly_Indexed.Instance;
  SHPMRP7H_Table   : aliased Interpolation_Table.Doubly_Indexed.Instance;
  DNPDWF_Table     : aliased Interpolation_Table.Singly_Indexed.Instance;

  No_Discretes : Arinc_429_Types.No_Discretes_Type;

  procedure Nulloutput
    (Stream : access Ada.Streams.Root_Stream_Type'Class;
     Item   : in     Pmu_Stream_Type) is
  begin
    Integer'Write(Stream, 1);
  end Nulloutput;

  procedure Nullread
    (Stream : access Ada.Streams.Root_Stream_Type'Class;
     Item   : out    Pmu_Stream_Type) is
    Dropped_Data : Integer;
  begin
    Integer'Read(Stream, Dropped_Data);
    Item := null;
  end Nullread;

  function Nullinput
    (Stream : access Ada.Streams.Root_Stream_Type'Class)
      return Pmu_Stream_Type is
    Dropped_Data : Integer;
  begin
    Integer'Read(Stream, Dropped_Data);
    return null;
  end Nullinput;

  -- Access A429_TX_PMU_A_336_Torque
  function  A429_TX_PMU_A_336_Torque
    (An_Instance : in Instance)
    return Arinc_429_Types.Message_Type is
  begin
    return An_Instance.A429_TX_PMU_336_Torque(A429.Channel_A);
  end A429_TX_PMU_A_336_Torque;

  procedure Set_A429_TX_PMU_A_336_Torque
    (An_Instance : in out Instance) is
  begin
    null;
  end Set_A429_TX_PMU_A_336_Torque;

  -- Access A429_TX_PMU_A_344_N1
  function  A429_TX_PMU_A_344_N1
    (An_Instance : in Instance)
    return Arinc_429_Types.Message_Type is
  begin
    return An_Instance.A429_TX_PMU_344_N1(A429.Channel_A);
  end A429_TX_PMU_A_344_N1;

  procedure Set_A429_TX_PMU_A_344_N1
    (An_Instance : in out Instance) is
  begin
    null;
  end Set_A429_TX_PMU_A_344_N1;

  -- Access A429_TX_PMU_A_345_Itt
  function  A429_TX_PMU_A_345_Itt
    (An_Instance : in Instance)
    return Arinc_429_Types.Message_Type is
  begin
    return An_Instance.A429_TX_PMU_345_Itt(A429.Channel_A);
  end A429_TX_PMU_A_345_Itt;

  procedure Set_A429_TX_PMU_A_345_Itt
    (An_Instance : in out Instance) is
  begin
    null;
  end Set_A429_TX_PMU_A_345_Itt;

  -- Access A429_TX_PMU_A_346_Np
  function  A429_TX_PMU_A_346_Np
    (An_Instance : in Instance)
    return Arinc_429_Types.Message_Type is
  begin
    return An_Instance.A429_TX_PMU_346_Np(A429.Channel_A);
  end A429_TX_PMU_A_346_Np;

  procedure Set_A429_TX_PMU_A_346_Np
    (An_Instance : in out Instance) is
  begin
    null;
  end Set_A429_TX_PMU_A_346_Np;

  -- Access A429_TX_PMU_A_134_Pla
  function  A429_TX_PMU_A_134_Pla
    (An_Instance : in Instance)
    return Arinc_429_Types.Message_Type is
  begin
    return An_Instance.A429_TX_PMU_134_Pla(A429.Channel_A);
  end A429_TX_PMU_A_134_Pla;

  procedure Set_A429_TX_PMU_A_134_Pla
    (An_Instance : in out Instance) is
  begin
    null;
  end Set_A429_TX_PMU_A_134_Pla;

  -- Access A429_TX_PMU_A_130_Outside_Air_Temperature
  function  A429_TX_PMU_A_130_Outside_Air_Temperature
    (An_Instance : in Instance)
    return Arinc_429_Types.Message_Type is
  begin
    return An_Instance.A429_TX_PMU_130_Outside_Air_Temperature(A429.Channel_A);
  end A429_TX_PMU_A_130_Outside_Air_Temperature;

  procedure Set_A429_TX_PMU_A_130_Outside_Air_Temperature
    (An_Instance : in out Instance) is
  begin
    null;
  end Set_A429_TX_PMU_A_130_Outside_Air_Temperature;

  -- Access A429_TX_PMU_B_336_Torque
  function  A429_TX_PMU_B_336_Torque
    (An_Instance : in Instance)
    return Arinc_429_Types.Message_Type is
  begin
    return An_Instance.A429_TX_PMU_336_Torque(A429.Channel_B);
  end A429_TX_PMU_B_336_Torque;

  procedure Set_A429_TX_PMU_B_336_Torque
    (An_Instance : in out Instance) is
  begin
    null;
  end Set_A429_TX_PMU_B_336_Torque;

  -- Access A429_TX_PMU_B_344_N1
  function  A429_TX_PMU_B_344_N1
    (An_Instance : in Instance)
    return Arinc_429_Types.Message_Type is
  begin
    return An_Instance.A429_TX_PMU_344_N1(A429.Channel_B);
  end A429_TX_PMU_B_344_N1;

  procedure Set_A429_TX_PMU_B_344_N1
    (An_Instance : in out Instance) is
  begin
    null;
  end Set_A429_TX_PMU_B_344_N1;

  -- Access A429_TX_PMU_B_345_Itt
  function  A429_TX_PMU_B_345_Itt
    (An_Instance : in Instance)
    return Arinc_429_Types.Message_Type is
  begin
    return An_Instance.A429_TX_PMU_345_Itt(A429.Channel_B);
  end A429_TX_PMU_B_345_Itt;

  procedure Set_A429_TX_PMU_B_345_Itt
    (An_Instance : in out Instance) is
  begin
    null;
  end Set_A429_TX_PMU_B_345_Itt;

  -- Access A429_TX_PMU_B_346_Np
  function  A429_TX_PMU_B_346_Np
    (An_Instance : in Instance)
    return Arinc_429_Types.Message_Type is
  begin
    return An_Instance.A429_TX_PMU_346_Np(A429.Channel_B);
  end A429_TX_PMU_B_346_Np;

  procedure Set_A429_TX_PMU_B_346_Np
    (An_Instance : in out Instance) is
  begin
    null;
  end Set_A429_TX_PMU_B_346_Np;

  -- Access A429_TX_PMU_B_134_Pla
  function  A429_TX_PMU_B_134_Pla
    (An_Instance : in Instance)
    return Arinc_429_Types.Message_Type is
  begin
    return An_Instance.A429_TX_PMU_134_Pla(A429.Channel_B);
  end A429_TX_PMU_B_134_Pla;

  procedure Set_A429_TX_PMU_B_134_Pla
    (An_Instance : in out Instance) is
  begin
    null;
  end Set_A429_TX_PMU_B_134_Pla;

  -- Access A429_TX_PMU_B_130_Outside_Air_Temperature
  function  A429_TX_PMU_B_130_Outside_Air_Temperature
    (An_Instance : in Instance)
    return Arinc_429_Types.Message_Type is
  begin
    return An_Instance.A429_TX_PMU_130_Outside_Air_Temperature(A429.Channel_B);
  end A429_TX_PMU_B_130_Outside_Air_Temperature;

  procedure Set_A429_TX_PMU_B_130_Outside_Air_Temperature
    (An_Instance : in out Instance) is
  begin
    null;
  end Set_A429_TX_PMU_B_130_Outside_Air_Temperature;

  -- Access Shutdown Solenoid signal
  function Shutdown_Solenoid (An_Instance : in Instance) return Boolean is
  begin
    return An_Instance.Shutdown;
  end Shutdown_Solenoid;

  -- Access Start Pin S*
  function Start (An_Instance : in Instance) return Boolean is
  begin
    return An_Instance.Start;
  end Start;

  -- Access Ignition Pin D
  function Ignition (An_Instance : in Instance) return Boolean is
  begin
    return An_Instance.Ignition;
  end Ignition;

  -- Access Feather
  function Feather (An_Instance : in Instance) return Boolean is
  begin
    return An_Instance.Feather;
  end Feather;

  -- Access Stepper_Motor_Power
  function Stepper_Motor_Power (An_Instance : in Instance) return Boolean is
  begin
    return An_Instance.Stepper_Motor_Power;
  end Stepper_Motor_Power;

  -- Access Pla_At_20_Degrees for Start_Ready
  function Pla_At_20_Degrees (An_Instance : in Instance) return Boolean is
  begin
    return An_Instance.Pla_At_20_Degrees;
  end Pla_At_20_Degrees;

  -- Access Stepper_Motor_Position_demanded
  function  Stepper_Motor_Position_Demanded
    (An_Instance : in Instance)
    return Jpats_Powerplant_Types.Step_Type is
  begin
    return An_Instance.Stepper_Motor_Position_Demanded;
  end Stepper_Motor_Position_Demanded;

  procedure Set_Stepper_Motor_Position_Demanded
    (An_Instance : in out Instance) is
  begin
    --     An_Instance.Stepper_Motor_Position_Demanded;
    null;
  end Set_Stepper_Motor_Position_Demanded;

  -- Access Pmu_Fail
  function Pmu_Fail
    (An_Instance : in Instance)
    return Boolean is
  begin
    return An_Instance.Pmu_Fail;
  end Pmu_Fail;

  -- Access Pmu_Status
  function Pmu_Status
    (An_Instance : in Instance)
    return Boolean is
  begin
    return An_Instance.Pmu_Status;
  end Pmu_Status;

  -- Access PMU_Blade_Angle_Rate
  function PMU_Blade_Angle_Rate
    (An_Instance : in Instance)
    return Angle_Types.Degrees_Per_Sec is
  begin
    return An_Instance.PMU_Blade_Angle_Rate;
  end PMU_Blade_Angle_Rate;

  -- Access PMU_load
  function  PMU_Electrical_Load
    (An_Instance : in Instance)
    return Electrical_Units_Types.Amps is
  begin
    return An_Instance.Pmu_Electrical_Load;
  end Pmu_Electrical_Load;

  procedure Start_Recording
    (An_Instance  : in out Instance;
     Debug_Stream : in out Ada.Streams.Stream_Io.Stream_Access ) is

  begin
    An_Instance.Record_Debug_Information := True;
    An_Instance.Debug_Stream := Pmu_Stream_Type(Debug_Stream);
  end Start_Recording;

  procedure Stop_Recording
    (An_Instance : in out Instance) is
  begin
    An_Instance.Record_Debug_Information := False;
  end Stop_Recording;

  function Overspeed_Governor_Reset_Solenoid
    (An_Instance : in Instance) return Boolean
  is
  begin
    return An_Instance.Pmu_Off_Timer > 0.0;
  end Overspeed_Governor_Reset_Solenoid;

  procedure Pmu_Reset
    (An_Instance : in out Instance) is
  begin
    An_Instance.Pmu_Reset := True;
  end Pmu_Reset;

  procedure Unpowered_Update
    (Next_Instance                             : in out Instance;
     Power_Turbine_Rpm                         : in Angle_Types.Rpm) is
     Table_Np                         : Float;
  begin
    if Power_Turbine_Rpm < 750.0 then
       Table_Np := Float'Min(100.0,(Interpolation_Table.Singly_Indexed.Interpolate
           ( Input => Power_Turbine_Rpm,
             Table => DNPDWF_Table'Access)));
       Next_Instance.Np := Normalized_Types.Normalize(Table_Np);
    else
       Next_Instance.Np := Normalized_Types.Normalize(Power_Turbine_Rpm/20.0);
    end if;
    Next_Instance.Arinc_Engine_Torque                       := Normalized_Types.Normalize(0.0);
    Next_Instance.Auto_Start                                := False;
    Next_Instance.Auto_Start_Ready                          := False;
    Next_Instance.DCU_VDC_28                                := False;
    Next_Instance.Delta_Ng                                  := 0.0;
    Next_Instance.Delta_Ng_Dyn                              := 0.0;
    Next_Instance.Feather                                   := False;
    Next_Instance.Flight_Mode                               := False;
    Next_Instance.Flight_Mode_Timer                         := 0.0;
    Next_Instance.Fuel_On_Timer                             := 0.0;
    Next_Instance.Ignition                                  := False;
    Next_Instance.In_Air_Timer                              := 0.0;
    Next_Instance.Itt_820_Timer                             := 0.0;
    Next_Instance.Itt_820_Fired_Timer                       := 0.0;
    Next_Instance.Itt_870_Timer                             := 0.0;
    Next_Instance.Itt_940_Timer                             := 0.0;
    Next_Instance.Itt_Start_Peak                            := 0.0;
    Next_Instance.Min_Rpm_Loop_Arm                          := False;
    Next_Instance.Monitored_Start                           := False;
    Next_Instance.Monitored_Start_Ready                     := False;
    Next_Instance.Ng                                        := 0.0;
    Next_Instance.Ng_33_Hp_Sec_Dot                          := 0.0;
    Next_Instance.Ng_Decel_Timer                            := 0.0;
    Next_Instance.Ng_Limit_Timer                            := 0.0;
    Next_Instance.Ng_Req                                    := 0.0;
    Next_Instance.Ng_Req_Hot                                := 0.0;
    Next_Instance.Ng_Req_Norm                               := 0.0;
    Next_Instance.Ng_Req_Prime                              := 0.0;
    Next_Instance.Ng_Spd                                    := 0.0;
    Next_Instance.No_Light                                  := False;
--    Next_Instance.Np                                        := 0.0;
    Next_Instance.On_Ground_Timer                           := 0.0;
    Next_Instance.PMU_Blade_Angle_Rate                      := Angle_Types.Degrees_Per_Sec(0.0);
    Next_Instance.Pla_At_20_Degrees                         := False;
    Next_Instance.Pmu_Arinc_Fail                            := False;
    Next_Instance.Pmu_Fail                                  := True;
--    Next_Instance.Pmu_Fail_Light_On                         := True;
    Next_Instance.Pmu_Mode_Switch_Toggle                    := False;
    Next_Instance.Pmu_Off_Timer                             := 0.0;
    Next_Instance.Pmu_On                                    := False;
    Next_Instance.Pmu_Status                                := true;
--    Next_Instance.Pmu_Status_Light_On                       := True;
    Next_Instance.Pmu_Test                                  := False;
    Next_Instance.Pmu_Transition_Off                        := False;
    Next_Instance.Pmu_Transition_On                         := False;
    Next_Instance.Power_Turbine_Rpm_Limit_Timer             := 0.0;
    Next_Instance.Rpm_Req                                   := 0.0;
    Next_Instance.Auto_Shutdown                             := False;
    Next_Instance.Shutdown                                  := False;
    Next_Instance.Slow_Start                                := False;
    Next_Instance.Smp_Req                                   := 169.0;
    Next_Instance.Smp_Req_Ss                                := 169.0;
    Next_Instance.Start                                     := False;
    Next_Instance.Start_Abort                               := False;
    Next_Instance.Start_Enable                              := False;
    Next_Instance.Monitored_Start_Timer                     := 0.0;
    Next_Instance.Auto_Start_Timer                          := 0.0;
    Next_Instance.Stepper_Motor_Position_Demanded           := Jpats_Powerplant_Types.Step_Type(0);
    Next_Instance.Stepper_Motor_Power                       := False;
    Next_Instance.Wow_Fail                                  := False;
    Next_Instance.Wow_Fault_Timer                           := 0.0;
    Next_Instance.PMU_Bit_Test_Timer                        := 0.0;
    Next_Instance.Delta_Pla_Transition_On                   := 0.0;

    for Channel in A429.Channel_A .. A429.Channel_B loop
            -- Np
        Label_346 :
          declare
            Output                 : Normalized_Types.Normalize;
            Ssm                    : Arinc_429_Types.Bnr_Ssm_Type;
          begin
            -- Set Ouput label
            if Next_Instance.Np >= 255.4844 then
              Output := 255.9844;
            elsif Next_Instance.Np  <= 0.0 then
              Output := 0.0;
            else
              Output := Next_Instance.Np + 0.5;
            end if;

            -- set SSM bits
            if Next_Instance.Pmu_Arinc_Fail then
              Ssm := Arinc_429_Types.Failure;
            elsif Next_Instance.Pmu_Test then
              Ssm := Arinc_429_Types.Functional_Test;
            elsif Next_Instance.Np > 255.9844 or Next_Instance.Np < 0.0 then
              Ssm := Arinc_429_Types.No_Computed_Data;
            else
              Ssm := Arinc_429_Types.Normal;
            end if;

            Next_Instance.A429_TX_PMU_346_Np(Channel) :=
              A429.Label_346.Pack
              ( A_Value           => Output,
                A_Sdi             => Channel,
                A_Ssm             => Ssm,
                A_Discretes_Value => No_Discretes);
          end Label_346;
    end loop;
  end Unpowered_Update;
  Ng_Spd                           : Float;
  Smp_Req                          : Float;
  Smp_Req_Ss                       : Float;
  Pmu_On                           : Boolean;
  Ng_Req_Prime                     : Float;
  Pmu_Off_Prop_Gain                : Normalized_Types.Normalize := 0.145;
  Pmu_On_Prop_Proportional_Gain    : Normalized_Types.Normalize := 0.8;
  Pmu_On_Prop_Differential_Gain    : Normalized_Types.Normalize := 0.05;
  Delta_Pla_Prime                  : Angle_Types.Degrees;
--    Itt                          : Temperature_Types.Celsius   renames Internal_Turbine_Temperature_T5_Pos;
--    Auto_Feather                 : Boolean                     renames Next_Instance.Feather;
--    Auto_Ignitors_On             : Boolean                     renames Next_Instance.Ignition;

--   Internal
--    Np_Dot                       : Normalized_Types.Normalize := 0.0;
  Ng_Dot                           : Normalized_Types.Normalize := 0.0;
  Delta_F_Ng_Np_Lo                 : Normalized_Types.Normalize;
  Delta_Ng_Min_Rpm                 : Normalized_Types.Normalize;
  Delta_Pla                        : Angle_Types.Degrees;
  Delta_T                          : Normalized_Types.Normalize;
  F_Ng_Dot_Ng_C                    : Normalized_Types.Normalize;
  F_Ng_Dyn                         : Normalized_Types.Normalize;
  F_Ng_Mach_Dot                    : Normalized_Types.Normalize;
  F_Ng_Pwr                         : Normalized_Types.Normalize;
  F_Ng_Spd                         : Normalized_Types.Normalize;
  F_Shp_Delta_Pla                  : Normalized_Types.Normalize;
  Itt_C_Lim                        : Normalized_Types.Normalize;
  K_Epsilon_Ng                     : Normalized_Types.Normalize; --   renames This_Instance.Piu_Rpm_Error_Feedback_Gain;
  K_Epsilon_Ng_Dot                 : Normalized_Types.Normalize; --   renames This_Instance.Piu_Rpm_Rate_Error_Feedback_Gain;
  K_Wf_Dot_Malfunction             : Normalized_Types.Normalize := 1.0;
  K_Ng_Malfunction                 : Normalized_Types.Normalize := 1.0;
  Mach_Pmu                         : Normalized_Types.Normalize;
--    Monitored_Start              : Boolean := False;
--    Monitored_Start_Ready        : Boolean := False;
  Ng_Acc_Lim_Dot                   : Normalized_Types.Normalize;
  Ng_C_F_Idle                      : Normalized_Types.Normalize;
  Ng_C_F_Spd                       : Normalized_Types.Normalize;
  Ng_C_G_Idle                      : Normalized_Types.Normalize;
  Ng_C_G_Spd                       : Normalized_Types.Normalize;
  Ng_C_Itt_Lim                     : Normalized_Types.Normalize;
  Ng_C_Pwr                         : Normalized_Types.Normalize;
  Ng_C_Req_Adjusted                : Normalized_Types.Normalize;
  Ng_Dec_Lim_Dot                   : Normalized_Types.Normalize;
  Ng_Dec_Lim_Dot_Prime             : Normalized_Types.Normalize;
  Ng_F_Idle                        : Normalized_Types.Normalize;
  Ng_F_Spd                         : Normalized_Types.Normalize;
  Ng_G_Idle                        : Normalized_Types.Normalize;
  Ng_G_Spd                         : Normalized_Types.Normalize;
  Ng_Pwr                           : Normalized_Types.Normalize := 0.0;
  Ng_Req_Dot                       : Normalized_Types.Normalize;
  Ng_Req_Dot_Prime                 : Normalized_Types.Normalize;
  Ng_Req_Double_Prime              : Normalized_Types.Normalize := 0.0;
  Ng_Req_Hot_Dot                   : Normalized_Types.Normalize;
  Ng_Req_Itt_Lim                   : Normalized_Types.Normalize;
  Ng_Req_Ng_Lim                    : Normalized_Types.Normalize;
  Ng_Req_Norm_Dot                  : Normalized_Types.Normalize;
  Ng_Req_Q_Lim                     : Normalized_Types.Normalize;
  Ng_Req_Triple_Prime              : Normalized_Types.Normalize := Normalized_Types.Normalize(0.0);
  Ng_Spd_Dyn                       : Normalized_Types.Normalize;
  Pla_At_20                        : Boolean := false;
  Pla_To_18                        : Boolean := false;
--    Pmu_Transition_Off           : Boolean;
--    Pmu_Transition_On            : Boolean := False;
  Rpm_Req_Prime                    : Angle_Types.Rpm;
  Shp_C_Itt_Lim                    : Normalized_Types.Normalize;
  Shp_C_Ng_Lim                     : Normalized_Types.Normalize;  -- Dshp_C/DNg limited
  Shp_C_Pwr                        : Normalized_Types.Normalize;
  Shp_Itt_Lim                      : Normalized_Types.Normalize;
  Shp_Mrp                          : Normalized_Types.Normalize := 0.0;
  Shp_Ng_Lim                       : Normalized_Types.Normalize := 0.0;
  Shp_Pwr                          : Normalized_Types.Normalize := 0.0;
  Shp_Q_Lim                        : Float;
  Shp_Mrp_L                        : Normalized_Types.Normalize;
  Shp_Mrp_H                        : Normalized_Types.Normalize;
  Shp_Mrp_Hi_L                     : Normalized_Types.Normalize;
  Shp_Mrp_Hi_H                     : Normalized_Types.Normalize;
  Shp_Mrp_Lo_L                     : Normalized_Types.Normalize;
  Shp_Mrp_Lo_H                     : Normalized_Types.Normalize;
  Smp_Req_Dot                      : Float;
  Start_Toggle                     : Boolean;
  Theta_T                          : Normalized_Types.Normalize;
  Wf_C_3d_0_Dot                    : Normalized_Types.Normalize;
  Wf_C_3d_169_Dot                  : Normalized_Types.Normalize;
  Wf_C_3d_338_Dot                  : Normalized_Types.Normalize;
  Wf_C_3d_Req_Dot                  : Normalized_Types.Normalize;
  Wf_C_Ng_C_Dot                    : Normalized_Types.Normalize;
  Wf_Req_Dot                       : Mass_Types.Pph;
  Power_Turbine_Torque_Percent     : Torque_Types.Ft_Lbf;
--    Wbleed_Dot                   : Mass_Types.Pph;
--    Itt_Limit                    : Temperature_Types.Celsius;
  K_Itt_Malfunction                : Normalized_Types.Normalize := 1.0;
  Ng_C_Req_Itt_Lim                 : Normalized_Types.Normalize;
  Ng_C_Req_Q_Lim                   : Normalized_Types.Normalize;
  Shp_C_Q_Lim                      : Torque_Types.Horsepower;
  Adc_Pressure_Altitude_Corrected  : Length_Types.Feet;

  -- Method Powered_Update
  procedure Powered_Update
    (Next_Instance                             : in out Instance;
     This_Instance                             : in     Instance;
     Iconst                                    : in     Float;
     Bleed_Air_On                              : in     Boolean;                               -- Pin Y   -- Cabin_Bleed            Interface_J2_Pin_Y;
     Left_Weight_On_Wheels                     : in     Boolean;                               -- Pin_FF  -- Wow_Left               Interface_J2_Pin_F*;
--   PMA_A                                     : in     Boolean;                               -- Pin_A   -- Pma_A                  Interface_J1_Pin_A;
--   PMA_B                                     : in     Boolean;                               -- Pin_S   -- Pma_B                  Interface_J1_Pin_S;
--   PMA_C                                     : in     Boolean;                               -- Pin_T   -- Pma_C                  Interface_J1_Pin_T;
     Power_28vdc2                              : in     Boolean;                               -- Pin P   -- Power_28VDC            Interface_J2_Pin_P;
     Right_Weight_On_Wheels                    : in     Boolean;                               -- Pin BB  -- Wow_Right              Interface_J2_Pin_B*;
     Start_Enable                              : in     Boolean;                               -- Pin U*  -- Start                  Interface_J2_Pin_LU;
     Engine_Rpm_Sensor_Fault                   : in     Boolean;                               -- Malfunction
     Arinc_Airspeed_Fault                      : in     Boolean;                               -- Malfunction
     Arinc_Hp_Fault                            : in     Boolean;                               -- Malfunction
     Fuel_Flow_Sensor_Fault                    : in     Boolean;                               -- Malfunction
     Prop_Speed_Sensor_Fault                   : in     Boolean;                               -- Malfunction
     Pcl_Sensor_Fault                          : in     Boolean;                               -- Malfunction
--   Pma_Fault                                 : in     Boolean;                               -- Malfunction
     torque_sensor_fault                       : in     Boolean;                               -- Malfunction
     OAT_Sensor_Fault                          : in     Boolean;                               -- Malfunction
     Wow_Fault                                 : in     Boolean;                               -- Malfunction
     Hot_Start                                 : in     Boolean;                               -- Malfunction
     Voltage                                   : in     Electrical_Units_Types.Volts_Dc;       -- Malfunction
     PMU_Critical_Fault                        : in     Boolean;                               -- Malfunction
     PMU_Noncritical_Fault                     : in     Boolean;                               -- Malfunction
     Slow_Start_Request                        : in     Boolean;                               -- Malfunction
     Loss_Of_Useful_Power                      : in     Boolean;                               -- Malfunction
     Auto_Start_Switch_Off                     : in     Boolean;                               -- Malfunction
     Itt_Sensor_Malfunction                    : in     Boolean;                               -- Malfunction
     Overtemp                                  : in     Boolean;                               -- Malfunction
     Ambient_Pressure_Ratio                    : in     Normalized_Types.Normalize;            -- Static Pressure Transducer within the PMU itself Ps1
     Engine_Rpm                                : in     Angle_Types.Rpm;                       -- Pin_LB  -- Ng_Sig                 Interface_J1_Pin_LB;  -- Should actually read rpm from sensor instead of percent.
     Internal_Turbine_Temperature_T5_Pos       : in     Temperature_Types.Celsius;             -- Pin_LZ  -- T5_Pos                 Interface_J1_Pin_LZ;
     Mach_Number                               : in     Length_Types.Mach;
     ADC_Mach_Number                           : in     Length_Types.Mach;                     -- Air data computer input over Arinc 429 on aircraft
     Power_Control_Lever_Angle_LVDT            : in     Angle_Types.Degrees;                       -- Pin_LN  -- BA_FB_E2               Interface_J1_Pin_LN;
     Power_Control_Lever_Angle_RVDT            : in     Angle_Types.Degrees;                   -- Pin CC  -- Excitation_Hi          Interface_J2_Pin_C*;
     Power_Turbine_Rpm                         : in     Angle_Types.Rpm;                       -- Pin_LV  -- Q_Npt_Stg              Interface_J1_Pin_LV;
     Power_Turbine_Torque                      : in     Torque_Types.Ft_Lbf;                   -- Pin_LG  -- To_Hi                  Interface_J1_Pin_LG;
     ADC_Pressure_Altitude                     : in     Length_Types.Feet;                     -- Air data computer input over Arinc 429 on aircraft
     Total_Inlet_Temperature_T1_Hi             : in     Temperature_Types.Celsius;             -- Pin_LH  -- T1_Hi                  Interface_J1_Pin_LH;
     Delta_Shp_C_Acc                           : in     Torque_Types.Horsepower;               -- direct from gas generator
     Delta_Shp_C_Bleed                         : in     Torque_Types.Horsepower;               -- direct from gas generator
     Delta_Shp_C_Np                            : in     Torque_Types.Horsepower;               -- direct from gas generator
     Delta_Itt_C_Acc                           : in     Temperature_Types.Kelvin;              -- direct from gas generator
     Delta_Itt_C_Bleed                         : in     Temperature_Types.Kelvin;              -- direct from gas generator
     Delta_Ng_C_Acc                            : in     Angle_Types.Rpm;                       -- direct from gas generator
     Delta_Ng_C_Bleed                          : in     Angle_Types.Rpm;                       -- direct from gas generator
     Shp                                       : in     Torque_Types.Horsepower;               -- direct from gas generator
     K_Fmv_Delta                               : in     Normalized_Types.Normalize;            -- direct from gas generator
     Delta_Ng_Seizure                          : in     Normalized_Types.Normalize;            -- direct from gas generator
     Fired                                     : in     Boolean;
     Ambient_Temperature_Ratio                 : in     Normalized_Types.Normalize)
--   DCU_VDC_28                                :    out Boolean;                               -- Pin_E*  -- VDC_28                 Interface_J1_Pin_E*;
--   Feather_Signal                            :    out Boolean;                               -- Pin_J   -- Mv_Fb_E1               Interface_J1_Pin_J;
--   Ignition                                  :    out Boolean;                               -- Pin D   -- Igniter_Lss            Interface_J2_Pin_D;
--   Pla_At_20_Degrees                         :    out Boolean;                               -- Pin HH  -- PCL_At_20_Lss          Interface_J2_Pin_H*;
--   Pmu_Fail_Light_On                         :    out Boolean;                               -- Pin T*  -- Pms_Fail               Interface_J2_Pin_LT;
--   Pmu_Status_Light_On                       :    out Boolean;                               -- Pin Z   -- Pms_Warning            Interface_J2_Pin_Z;
--   Shutdown_Solenoid                         :    out Boolean;                               -- Pin_D*  -- Sd_Sol_Lss             Interface_J1_Pin_D*;
--   Start                                     :    out Boolean;                               -- Pin S*  -- Start_Lss              Interface_J2_Pin_LS;
--   Stepper_Motor_Power                       :    out Boolean;                               -- Pin_Y   -- Sm_Pwr                 Interface_J1_Pin_Y;
--   PMU_Blade_Angle_Rate                      :    out Angle_Types.Degrees_Per_Sec;           -- Pin_LD  -- Piu_Tm_Pwr             Interface_J1_Pin_LD;
--   Stepper_Motor_Position_Demanded           :    out Jpats_Powerplant_Types.Step_Type;      -- Pin_E   -- Sm_A_Lss               Interface_J1_Pin_E;
--   A429_TX_PMU_130_Outside_Air_Temperature   :    out Arinc_Array_Type;
--   A429_TX_PMU_134_Pla                       :    out Arinc_Array_Type;
--   A429_TX_PMU_336_Torque                    :    out Arinc_Array_Type;
--   A429_TX_PMU_344_N1                        :    out Arinc_Array_Type;
--   A429_TX_PMU_345_Itt                       :    out Arinc_Array_Type;
--   A429_TX_PMU_346_Np                        :    out Arinc_Array_Type
--   Alternate_Ng_Signal                       : in     Boolean;                               -- Pin_V   -- Spare_Speed_Sig        Interface_J1_Pin_V;
--   Alternate_Ng_Signal_Rtn                   : in     Boolean;                               -- Pin_C   -- Spare_Speed_Rtn        Interface_J1_Pin_C;
--   Ambient_Pressure_Ratio                    : in     Normalized_Types.Normalize;            -- Air data computer input over Arinc 429 on aircraft
--   Ambient_Temperature_Ratio                 : in     Normalized_Types.Normalize;            -- Air data computer input over Arinc 429 on aircraft
--   Auto_Rigg                                 : in     Boolean;                               -- Pin C*  -- Auto_Rigging           Interface_J2_Pin_LC;
--   BA_FB_Com                                 : in     Integer;                               -- Pin_A*  -- BA_FB_Com              Interface_J1_Pin_A*;
--   BA_FB_E1                                  : in     Integer;                               -- Pin_LM  -- BA_FB_E1               Interface_J1_Pin_LM;
--   BA_FB_Exc                                 : in     Integer;                               -- Pin_P   -- BA_FB_Exc              Interface_J1_Pin_P;
--   BA_FB_Rtn                                 : in     Integer;                               -- Pin_R   -- BA_FB_Rtn              Interface_J1_Pin_R;
--   Internal_Turbine_Temperature_T5_Neg       : in     Tepmerature_Types.Celsius;             -- Pin_LY  -- T5_Neg                 Interface_J1_Pin_LY;
--   Mv_Fb_Com                                 : in     Boolean;                               -- Pin_K   -- Mv_Fb_Com              Interface_J1_Pin_K;
--   Mv_Fb_E2                                  : in     Boolean;                               -- Pin_LE  -- Mv_Fb_E2               Interface_J1_Pin_LE;
--   Mv_Fb_Exc                                 : in     Boolean;                               -- Pin_LF  -- Mv_Fb_Exc              Interface_J1_Pin_LF;
--   Mv_Fb_Exc_Rtn                             : in     Boolean;                               -- Pin_LX  -- Mv_Fb_Exc_Rtn          Interface_J1_Pin_LX;
--   Ng_Signal_Return                          : in     Angle_Types.Rpm;                       -- Pin_LU  -- Ng_Rtn                 Interface_J1_Pin_LU;
--   Os_Sol_Exc                                : in     Boolean;                               -- Pin_LQ  -- Os_Sol_Exc             Interface_J1_Pin_LQ;
--   Os_Sol_Lss                                : in     Boolean;                               -- Pin_B*  -- Os_Sol_Lss             Interface_J1_Pin_B*;
--   Osg_Reset_Exc                             : in     Boolean;                               -- Pin_LR  -- Osg_Reset_Exc          Interface_J1_Pin_LR;
--   Osg_Reset_Lss                             : in     Boolean;                               -- Pin_W   -- Osg_Reset_Lss          Interface_J1_Pin_W;
--   PCL_Com                                   : in     Angle_Types.Degrees;                   -- Pin E   -- PCL_Com                Interface_J2_Pin_E;
--   PCL_E1                                    : in     Angle_Types.Degrees;                   -- Pin R*  -- PCL_E_1                Interface_J2_Pin_LR;
--   PCL_E2                                    : in     Angle_Types.Degrees;                   -- Pin X   -- PCL_E_2                Interface_J2_Pin_X;
--   PCL_Excitation_Lo                         : in     Angle_Types.Degrees;                   -- Pin DD  -- Excitation_Lo          Interface_J2_Pin_D*;
--   Pin_D_Star                                : in     Boolean;                               -- Pin D*  -- Auto_Pilot_Monitored   Interface_J2_Pin_LD;
--   Pin_F_Star                                : in     Boolean;                               -- Pin F*  -- Itt_Sig_Analog         Interface_J2_Pin_LF;
--   Pin_G_Star                                : in     Boolean;                               -- Pin G*  -- Sv_Ref                 Interface_J2_Pin_LG;
--   Pin_H_Star                                : in     Boolean;                               -- Pin H*  -- Itt_Rtn_Analog         Interface_J2_Pin_LH;
--   Pin_X_Star                                : in     Boolean;                               -- Pin X*  -- Torque_Sig             Interface_J2_Pin_LX;
--   Piu_Tm_Rtn                                : in     Boolean;                               -- Pin_LW  -- Piu_Tm_Rtn             Interface_J1_Pin_LW;
--   Power_28vdc1                              : in     Boolean;                               -- Pin R   -- Power_28VDC            Interface_J2_Pin_R;
--   Q_Npt_Rtn                                 : in     Boolean;                               -- Pin_LC  -- Q_Npt_Rtn              Interface_J1_Pin_LC;
--   Reset_Exc                                 : in     Boolean;                               -- Pin_LS  -- Reset_Exc              Interface_J1_Pin_LS;
--   Reset_Lss                                 : in     Boolean;                               -- Pin_LT  -- Reset_Lss              Interface_J1_Pin_LT;
--   Sm_B_Lss                                  : in     Boolean;                               -- Pin_X   -- Sm_B_Lss               Interface_J1_Pin_X;
--   Sm_C_Lss                                  : in     Boolean;                               -- Pin_F   -- Sm_C_Lss               Interface_J1_Pin_F;
--   Sm_D_Lss                                  : in     Boolean;                               -- Pin_D   -- Sm_D_Lss               Interface_J1_Pin_D;
--   Spare_Sol_Exc                             : in     Boolean;                               -- Pin_U   -- Spare_Sol_Exc          Interface_J1_Pin_U;
--   Spare_Sol_Lss                             : in     Boolean;                               -- Pin_LP  -- Spare_Sol_Lss          Interface_J1_Pin_LP;
--   To_Lo                                     : in     Boolean;                               -- Pin_M   -- To_Lo                  Interface_J1_Pin_M;
--   To_Rtn                                    : in     Boolean;                               -- Pin_L   -- To_Rtn                 Interface_J1_Pin_L;
--   Total_Pressure_Ratio                      : in     Normalized_Types.Normalize;            -- Air data computer input over Arinc 429 on aircraft
--   Total_Temperature_Ratio                   : in     Normalized_Types.Normalize;            -- Air data computer input over Arinc 429 on aircraft
--   Boot_Application                          : in     Boolean;                               -- Pin Q*  -- Boot_Application       Interface_J2_Pin_LQ;
--   Comm_Mode                                 : in     Boolean;                               -- Pin U   -- Comm_Mode              Interface_J2_Pin_U;
--   DCU_Rs422_In_Hi                           : in     Integer;                               -- Pin_H   -- RS422_In_Hi            Interface_J1_Pin_H;
--   DCU_Rs422_In_Lo                           : in     Integer;                               -- Pin_LA  -- RS422_In_Lo            Interface_J1_Pin_LA;
--   DCU_Rs422_Out_Hi                          : in     Integer;                               -- Pin_G   -- RS422_Out_Hi           Interface_J1_Pin_G;
--   DCU_Rs422_Out_Lo                          : in     Integer;                               -- Pin_Z   -- RS422_Out_Lo           Interface_J1_Pin_Z;
--   DCU_VDC_28_Rtn                            : in     Boolean;                               -- Pin_H*  -- VDC_28_Rtn             Interface_J1_Pin_H*;
--   Discrete_Return                           : in     Boolean;                               -- Pin V*  -- Discrete_Rtn           Interface_J2_Pin_LV;
--   Discrete_Return_Wow_Control               : in     Boolean;                               -- Pin_GG  -- Discrete_Rtn           Interface_J2_Pin_G*;
--   Pin_AA                                    : in     Boolean;                               -- Pin AA  -- Discrete_Rtn           Interface_J2_Pin_A*;
--   Pin_A_Star                                : in     Boolean;                               -- Pin A*  -- Spare                  Interface_J2_Pin_LA;
--   Pin_B                                     : in     Boolean;                               -- Pin B   -- RS422_Lo_Out           Interface_J2_Pin_B;
--   Pin_C                                     : in     Boolean;                               -- Pin C   -- RS422_Hi_Out           Interface_J2_Pin_C;
--   Pin_EE                                    : in     Boolean;                               -- Pin EE  -- Spare                  Interface_J2_Pin_E*;
--   Pin_E_Star                                : in     Boolean;                               -- Pin E*  -- Arinc_429_Lo_In        Interface_J2_Pin_LE;
--   Pin_F                                     : in     Boolean;                               -- Pin F   -- Spare                  Interface_J2_Pin_F;
--   Pin_G                                     : in     Boolean;                               -- Pin G   -- Spare                  Interface_J2_Pin_G;
--   Pin_H                                     : in     Boolean;                               -- Pin H   -- Discrete_Rtn           Interface_J2_Pin_H;
--   Pin_J                                     : in     Boolean;                               -- Pin J   -- Arinc_429_Hi_In        Interface_J2_Pin_J;
--   Pin_K                                     : in     Boolean;                               -- Pin K   -- Arinc_429_Lo_Out       Interface_J2_Pin_K;
--   Pin_K_Star                                : in     Boolean;                               -- Pin K*  -- RS422_Hi_Out           Interface_J2_Pin_LK;
--   Pin_L                                     : in     Boolean;                               -- Pin L   -- Arinc_429_Hi_Out       Interface_J2_Pin_L;
--   Pin_M_Star                                : in     Boolean;                               -- Pin M*  -- RS422_Lo_Out           Interface_J2_Pin_LM;
--   Pin_S                                     : in     Boolean;                               -- Pin S   -- Power_Rtn              Interface_J2_Pin_S;
--   Pin_T                                     : in     Boolean;                               -- Pin T   -- Spare                  Interface_J2_Pin_T;
--   Pin_V                                     : in     Boolean;                               -- Pin V   -- Discrete_Rtn           Interface_J2_Pin_V;
--   Pin_W                                     : in     Boolean;                               -- Pin W   -- Spare                  Interface_J2_Pin_W;
--   Pin_Y_Star                                : in     Boolean;                               -- Pin Y*  -- RS422_Lo_In            Interface_J2_Pin_LY;
--   Pin_Z_Star                                : in     Boolean;                               -- Pin Z*  -- RS422_Hi_In            Interface_J2_Pin_LZ;
--   Power_Rtn                                 : in     Boolean;                               -- Pin A   -- Power_Rtn              Interface_J2_Pin_A;
--   Total_Inlet_Temperature_T1_Low            : in     Temperature_Types.Celsius;             -- Pin_LK  -- T1_Low                 Interface_J1_Pin_LK;
--   Total_Inlet_Temperature_T1_Rtn            : in     Temperature_Types.Celsius;             -- Pin_N   -- T1_Rtn                 Interface_J1_Pin_N;

  is
      Pullback                         : Boolean := False;
--    External
--    Delta_Pla_Prime                  : Angle_Types.Degrees         renames Power_Control_Lever_Angle_LVDT;
      Itt                              : Temperature_Types.Celsius   renames Internal_Turbine_Temperature_T5_Pos;
      Auto_Feather                     : Boolean                     renames Next_Instance.Feather;
      Auto_Ignitors_On                 : Boolean                     renames Next_Instance.Ignition;
      Ng_Req_Norm_Temp                 : Normalized_Types.Normalize;
      Table_Np                         : Float;
--
--    Internal
--    Adc_pressure_altitude_corrected  : length_types.feet;
--    Np_Dot                           : Normalized_Types.Normalize := 0.0;
--    Ng_Dot                           : Normalized_Types.Normalize := 0.0;
--    Delta_F_Ng_Np_Lo                 : Normalized_Types.Normalize;
--    Delta_Ng_Min_Rpm                 : Normalized_Types.Normalize;
--    Delta_Pla                        : Angle_Types.Degrees;
--    Delta_T                          : Normalized_Types.Normalize;
--    F_Ng_Dot_Ng_C                    : Normalized_Types.Normalize;
--    F_Ng_Dyn                         : Normalized_Types.Normalize;
--    F_Ng_Mach_Dot                    : Normalized_Types.Normalize;
--    F_Ng_Pwr                         : Normalized_Types.Normalize;
--    F_Ng_Spd                         : Normalized_Types.Normalize;
--    F_Shp_Delta_Pla                  : Normalized_Types.Normalize;
--    Itt_C_Lim                        : Normalized_Types.Normalize;
--    K_Epsilon_Ng                     : Normalized_Types.Normalize; --   renames This_Instance.Piu_Rpm_Error_Feedback_Gain;
--    K_Epsilon_Ng_Dot                 : Normalized_Types.Normalize; --   renames This_Instance.Piu_Rpm_Rate_Error_Feedback_Gain;
--    K_Wf_Dot_Malfunction             : Normalized_Types.Normalize := 1.0;
--    K_Ng_Malfunction                 : Normalized_Types.Normalize := 1.0;
--    Mach_Pmu                         : Normalized_Types.Normalize;
--    Monitored_Start                  : Boolean := False;
--    Monitored_Start_Ready            : Boolean := False;
--    Ng_Acc_Lim_Dot                   : Normalized_Types.Normalize;
--    Ng_C_F_Idle                      : Normalized_Types.Normalize;
--    Ng_C_F_Spd                       : Normalized_Types.Normalize;
--    Ng_C_G_Idle                      : Normalized_Types.Normalize;
--    Ng_C_G_Spd                       : Normalized_Types.Normalize;
--    Ng_C_Itt_Lim                     : Normalized_Types.Normalize;
--    Ng_C_Pwr                         : Normalized_Types.Normalize;
--    Ng_C_Req_Adjusted                : Normalized_Types.Normalize;
--    Ng_Dec_Lim_Dot                   : Normalized_Types.Normalize;
--    Ng_Dec_Lim_Dot_Prime             : Normalized_Types.Normalize;
--    Ng_F_Idle                        : Normalized_Types.Normalize;
--    Ng_F_Spd                         : Normalized_Types.Normalize;
--    Ng_G_Idle                        : Normalized_Types.Normalize;
--    Ng_G_Spd                         : Normalized_Types.Normalize;
--    Ng_Pwr                           : Normalized_Types.Normalize := 0.0;
--    Ng_Req_Dot                       : Normalized_Types.Normalize;
--    Ng_Req_Dot_Prime                 : Normalized_Types.Normalize;
--    Ng_Req_Double_Prime              : Normalized_Types.Normalize := 0.0;
--    Ng_Req_Hot_Dot                   : Normalized_Types.Normalize;
--    Ng_Req_Itt_Lim                   : Normalized_Types.Normalize;
--    Ng_Req_Ng_Lim                    : Normalized_Types.Normalize;
--    Ng_Req_Norm_Dot                  : Normalized_Types.Normalize;
--    Ng_Req_Q_Lim                     : Normalized_Types.Normalize;
--    Ng_Req_Triple_Prime              : Normalized_Types.Normalize := Normalized_Types.Normalize(0.0);
--    Ng_Spd_Dyn                       : Normalized_Types.Normalize;
--    Pla_At_20                        : Boolean := false;
--    Pla_To_18                        : Boolean := false;
--    Pmu_Transition_Off               : Boolean;
--    Pmu_Transition_On                : Boolean := False;
--    Rpm_Req_Prime                    : Angle_Types.Rpm;
--    Shp_C_Itt_Lim                    : Normalized_Types.Normalize;
--    Shp_C_Ng_Lim                     : Normalized_Types.Normalize;  -- Dshp_C/DNg limited
--    Shp_C_Pwr                        : Normalized_Types.Normalize;
--    Shp_Itt_Lim                      : Normalized_Types.Normalize;
--    Shp_Mrp                          : Normalized_Types.Normalize := 0.0;
--    Shp_Ng_Lim                       : Normalized_Types.Normalize := 0.0;
--    Shp_Pwr                          : Normalized_Types.Normalize := 0.0;
--    Shp_Q_Lim                        : Float;
--    Shp_Mrp_L                        : Normalized_Types.Normalize;
--    Shp_Mrp_H                        : Normalized_Types.Normalize;
--    Shp_Mrp_Hi_L                     : Normalized_Types.Normalize;
--    Shp_Mrp_Hi_H                     : Normalized_Types.Normalize;
--    Shp_Mrp_Lo_L                     : Normalized_Types.Normalize;
--    Shp_Mrp_Lo_H                     : Normalized_Types.Normalize;
--    Smp_Req_Dot                      : Float;
--    Start_Toggle                     : Boolean;
--    Theta_T                          : Normalized_Types.Normalize;
--    Wf_C_3d_0_Dot                    : Normalized_Types.Normalize;
--    Wf_C_3d_169_Dot                  : Normalized_Types.Normalize;
--    Wf_C_3d_338_Dot                  : Normalized_Types.Normalize;
--    Wf_C_3d_Req_Dot                  : Normalized_Types.Normalize;
--    Wf_C_Ng_C_Dot                    : Normalized_Types.Normalize;
--    Wf_Req_Dot                       : Mass_Types.Pph;
--    Delta_T1_Mach                    : Normalized_Types.Normalize;
--    Power_Turbine_Torque_Percent     : Torque_Types.Ft_Lbf;
--    Wbleed_Dot                       : Mass_Types.Pph;
--    Itt_Limit                        : Temperature_Types.Celsius;
--    K_Itt_Malfunction                : Normalized_Types.Normalize := 1.0;
--    Ng_C_Req_Itt_Lim                 : Normalized_Types.Normalize;
--    Ng_C_Req_Q_Lim                   : Normalized_Types.Normalize;
--    Shp_C_Q_Lim                      : Torque_Types.Horsepower;
  begin

    --    Next_Instance.Power_Turbine_Rpm := Power_Turbine_Rpm;  -- Needed because differential is calculated
    Next_Instance.Stepper_Motor_Power := Power_28vdc2;

    Next_Instance.Ng := Normalized_Types.Normalize(Engine_Rpm/374.680);
    if Power_Turbine_Rpm < 750.0 then
       Table_Np := Float'Min(100.0,(Interpolation_Table.Singly_Indexed.Interpolate
           ( Input => Power_Turbine_Rpm,
             Table => DNPDWF_Table'Access)));
       Next_Instance.Np := Normalized_Types.Normalize(Table_Np);
    else
       Next_Instance.Np := Normalized_Types.Normalize(Power_Turbine_Rpm/20.0);
    end if;
    Ng_Req_Norm_Temp := This_Instance.Ng_Req_Norm;
    -- Determine Health Status of PMU
    --
    Next_Instance.DCU_VDC_28 := True;


    Delta_T := Ambient_Pressure_Ratio*(1.0 + 0.2*Mach_Number**2.0)**3.5;
    Theta_T := Ambient_Temperature_Ratio*(1.0 + 0.2*Mach_Number**2.0);

    -- The pmu model is based on actual pressure altitude for ease of developement; however,
    -- this is not what the interface requires.  So, develope actual pressure altitude from ambient pressure
    -- ratio and Adc_pressure_altitude.  adc_pressure_altitude is calculated by flight instruments category
    -- in the air data computer class.
    -- Change all occurrances of adc_pressure_altitude to adc_pressure_altitude_corrected.
    -- Essentially Adc_Pressure_altitude_corrected is the same as local pressure altitude.
    -- Nomenclature kept for clarity for interface.

    declare
      Local_Pressure_Altitude : Length_Types.Feet;
    begin
      Local_Pressure_Altitude := (1.0 - Ambient_Pressure_Ratio** 0.19018) * 145447.0;
      Adc_Pressure_Altitude_Corrected := Adc_Pressure_Altitude - (Adc_Pressure_Altitude - Local_Pressure_Altitude);
    end;

    -- Step 1.
    -- Power Control Lever Angle to Power Lever Angle Conversion
    --
    -- Note:  The actual PMU does not need this function.  All
    --        information based on PLA in this model is actually
    --        based on PCL in the real hardware judging by the
    --        wiring diagrams.  Data from Raytheon was given versus
    --        pla.
    --
    -- Lookup the power lever angle, a funtion of the cockpit
    -- power control lever angle:

    Delta_Pla := Interpolation_Table.Singly_Indexed.Interpolate
      ( Input => Float(Power_Control_Lever_Angle_RVDT),
        Table => PLAPCL_Table'Access );

    Delta_Pla_Prime := Interpolation_Table.Singly_Indexed.Interpolate
      ( Input => Float(Power_Control_Lever_Angle_LVDT),
        Table => PLAPCL_Table'Access );

    -- Step 1.a.
    -- Starter Switch Logic
    -- Also determing whether the cockpit starter switch has been
    -- toggled to the auto_reset position.  Note that the logical
    -- Start_Toggle is true only immediately following such a toggle
    -- (i.e. true for one pass only.)
    Next_Instance.Start_Enable := Start_Enable; -- read the switch
    Start_Toggle := Next_Instance.Start_Enable and not This_Instance.Start_Enable;


    -- Step 2. PMU fault and engagement logic.
    --
    -- Test for weight on wheels or permanent magnate alternator failures:
    -- If a WOW fault (Wow_Fault = true) persists for more than 60 seconds
    -- since the last PMU reset then:

    if Wow_Fault then
      Next_Instance.Wow_Fault_Timer := Float'Min(This_Instance.Wow_Fault_Timer + Iconst,61.0);
    else
      Next_Instance.Wow_Fault_Timer := 0.0;
    end if;

    Next_Instance.Wow_Fail := Next_Instance.Wow_Fault_Timer > 60.0;



    -- Pmu Fail Logic
    --
    if Next_Instance.Np > 106.0 and not This_Instance.Pmu_Reset then
      Next_Instance.Power_Turbine_Rpm_Limit_Timer := Float'Min(3.1,This_Instance.Power_Turbine_Rpm_Limit_Timer + Iconst);
    else
      Next_Instance.Power_Turbine_Rpm_Limit_Timer := 0.0;
    end if;

    if Next_Instance.Ng > 106.0 and not This_Instance.Pmu_Reset then
      Next_Instance.Ng_Limit_Timer := Float'Min(3.1,This_Instance.Ng_Limit_Timer + Iconst);
    else
      Next_Instance.Ng_Limit_Timer := 0.0;
    end if;

    -- Check for switch toggle
    Next_Instance.Pmu_Mode_Switch_Toggle := Next_Instance.Pmu_Mode_Switch
                                            and not This_Instance.Pmu_Mode_Switch;

    if ((This_Instance.Smp_Req >= 338.0 or This_Instance.Smp_Req <= 0.0 ) and not This_Instance.Pmu_Reset) then
      Next_Instance.Smp_Req_Timer := This_Instance.Smp_Req_Timer + Iconst;
    else
      Next_Instance.Smp_Req_Timer := 0.0;
    end if;

    Next_Instance.Pmu_Fail :=
      ( This_Instance.Pmu_Fail
        or (not Next_Instance.Pmu_Mode_Switch and not This_Instance.Pmu_Reset)
        or Engine_Rpm_Sensor_Fault
        or Prop_Speed_Sensor_Fault
        or Torque_Sensor_Fault
        or Fuel_Flow_Sensor_Fault
        or OAT_Sensor_Fault
        or (Next_Instance.Np > 120.0 or Next_Instance.Power_Turbine_Rpm_Limit_Timer > 3.0)
        or (Next_Instance.Ng > 115.0 or Next_Instance.Ng_Limit_Timer > 3.0)
        or Pmu_Critical_Fault
        or (This_Instance.Min_Rpm_Loop_Arm and (Next_Instance.Np  < 302.0/20.0))
        or (Total_Inlet_Temperature_T1_Hi > 96.0)
        or (Itt > Temperature_Types.Celsius(1250.0)))
      and (not Next_Instance.Pmu_Mode_Switch_Toggle)
      and not This_Instance.Pmu_Reset;

    -- End of Pmu Fail Logic

    -- According the Pratt Whitney Canada, this is the only fault that would cause
    -- manual reversion to occur following an in-flight "uncommanded
    -- feather" failure as described on page 3-13 on the T-6A flight
    -- manual.  It involves the propeller speed dropping below the
    -- lower range limit of 302 RPM while the engine should still be
    -- making power.  The torque limit added in item 13 (below) will
    -- also function during the uncommanded feather failure, resulting
    -- in power rollback to protect the 106% torque limit.

    -- Note: The PMU_Fail state is reset to false by toggling the
    --       PMU_SWITCH from NORM to OFF and back to NORM.
    --


    -- Step 2.a. Determine whether PMU is engaged.  To be engaged the
    -- cockpit PMU switch must be in the NORM position; there must be
    -- no critical PMU fault, and there must be electrical power
    -- available either from the aircraft bus or from the dedicated
    -- permanent magnate alternator while the engine output shaft
    -- speed is sufficiently high.  The PMU_FAIL_LIGHT_ON logical
    -- controls illumination of the red PMU FAIL light in the cockpit,
    -- indicating a non-functional PMU.
      Next_Instance.Pmu_On := not Next_Instance.Pmu_Fail;
      Pmu_On := Next_Instance.Pmu_On;
    -- if PMU_On is True and Airframe Voltage Supplied To PMU Has Been Below 10
    -- Volts for 60 Seconds or Longer then Low_Voltage = true else it is false

    -- NOTE :  Low voltage logic is include below. Search on word Voltage.

    -- Step 3.
    -- Determine whether PMU Flight mode is activated.
    -- If not, the unit is in the Ground Handling/Taxi mode.
    -- The mode toggling logic is as follows:
    -- Flight_Mode becomes true when both WOW(1) and WOW(2)
    -- have been false (i.e., weight off wheels) for more
    -- than 0.5 seconds.
    --

    if not Left_Weight_On_Wheels and not Right_Weight_On_Wheels  then
      if This_Instance.Pmu_Reset then
        Next_Instance.In_Air_Timer := 0.5;
      else
        Next_Instance.In_Air_Timer := Float'Min(This_Instance.In_Air_Timer + Iconst, 0.5);
      end if;
    else
      Next_Instance.In_Air_Timer := 0.0;
    end if;

    -- Flight_Mode becomes false when either WOW(1) or WOW(2)
    -- is true (i.e., weight on wheel) for more than 2.0 seconds.
    -- Timer Code

    if Left_Weight_On_Wheels or Right_Weight_On_Wheels then
      if This_Instance.Pmu_Reset then
        Next_Instance.On_Ground_Timer := 2.0;
      else
        Next_Instance.On_Ground_Timer := Float'Min((This_Instance.On_Ground_Timer + Iconst),2.0);
      end if;
    else
      Next_Instance.On_Ground_Timer := 0.0;
    end if;

    Next_Instance.Flight_Mode := ((Next_Instance.Wow_Fail or (Next_Instance.In_Air_Timer >= 0.5))
                                  and not (not Next_Instance.Wow_Fail and (Next_Instance.On_Ground_Timer >= 2.0)));

    if not Next_Instance.Flight_Mode then
      if This_Instance.Pmu_Reset then
        Next_Instance.Flight_Mode_Timer := 61.0;
      else
        Next_Instance.Flight_Mode_Timer := Float'Min(This_Instance.Flight_Mode_Timer + Iconst, 61.0);
      end if;
    else
      Next_Instance.Flight_Mode_Timer := 0.0;
    end if;


    -- Define PMU derived Mach number
    if Arinc_Airspeed_Fault then
      if Next_Instance.Flight_Mode then
        Mach_Pmu := 0.4;
      else
        Mach_Pmu := 0.0;
      end if;
    else
      Mach_Pmu := ADC_Mach_Number;
    end if;


    -- The amber PMU status light in the cockpit is illuminated by the
    -- following conditions:


    Next_Instance.Pmu_Status :=
      (This_Instance.Pmu_Status
       or
       (not Power_28vdc2)
       or
       (Next_Instance.Pmu_Fail or Next_Instance.Wow_Fail)
       or
       ((Next_Instance.Flight_Mode_Timer > 60.0)
        and
        (Arinc_Hp_Fault
         or Arinc_Airspeed_Fault
         or Pmu_Noncritical_Fault)))
      and (not Next_Instance.Pmu_Mode_Switch_Toggle);

    -- Note: The Pmu_Status state is reset to false to toggling the
    -- PMU_SWITCH from NORM to OFF and back to NORM.

--    Next_Instance.Pmu_Status_Light_On := --(Next_Instance.Pmu_Status and not Next_Instance.Flight_Mode )
      -- or
--      (Next_Instance.Pmu_Status and
--       Next_Instance.Flight_Mode_Timer >= 60.0);



        -- Bit test upon power up
    if This_Instance.PMU_Bit_Test_Timer <= 6.0 then
      if This_Instance.PMu_Bit_Test_Timer < 2.0 then
        Next_Instance.Pmu_Fail :=  True;     -- brown out mode
        Next_Instance.Pmu_Status := True;    -- brown out mode
      elsif This_Instance.PMU_Bit_Test_Timer < 3.0 then
        Next_Instance.Pmu_Fail := False;     -- turn fail off
        Next_Instance.Pmu_Status := True;    -- brown out mode
      elsif This_Instance.PMU_Bit_Test_Timer < 4.0 then
        Next_Instance.Pmu_Status := False;   -- turn status off
        Next_Instance.Pmu_Fail   := True;    -- Circulate Fail Test
      elsif This_Instance.Pmu_Bit_Test_Timer < 5.0 then
        Next_Instance.Pmu_Fail := False;     -- End Fail Test
        Next_Instance.Pmu_Status := False;   -- Clear Status State
      end if;
      if This_Instance.Pmu_Reset then
        Next_Instance.Pmu_Fail   := False;
        Next_Instance.Pmu_Status := False;
        Next_Instance.Pmu_Bit_Test_Timer := 7.0;
      else
        Next_Instance.PMU_Bit_Test_Timer := float'min(7.0,This_Instance.PMU_Bit_Test_Timer + Iconst);
      end if;
    end if;

    -- Step 4. Determine the requested gas generator speeds on the PMU
    -- "speed schedules", for the cases of Flight_Mode false
    -- (subscripted "G" for Ground) and Flight_Mode true
    -- (subscripted "F" for Flight).  These requests are relevant
    -- at near-idle conditions where the PMU is in a gas generator
    -- speed-governing mode:

    Ng_C_G_Spd := Interpolation_Table.Singly_Indexed.Interpolate
      ( Input   => Float(Delta_Pla),
        Table   => NGCGIDLE_Table'Access );
    Ng_C_F_Spd := Interpolation_Table.Doubly_Indexed.Interpolate
      ( X => Float(Delta_Pla),
        Y => Float(Adc_Pressure_Altitude_Corrected),
        Table   => NGCFIDLE_Table'Access );
    -- theta_t removed post rev C as per comment
    -- of Dwayne Kimball 5/23/2000
    Ng_G_Spd := Ng_C_G_Spd; -- * (Theta_T)**0.5;
    Ng_F_Spd := Ng_C_F_Spd * (Theta_T)**0.5;

    -- Also in this step determine the ground and flight idle speeds
    -- (Commanded if power lever angle is at the 30 degrees idle stop)
    -- for later use:

    Ng_C_G_Idle := Interpolation_Table.Singly_Indexed.Interpolate
      ( Input   => 30.0,
        Table   => NGCGIDLE_Table'Access );
    Ng_C_F_Idle := Interpolation_Table.Doubly_Indexed.Interpolate
      ( X => 30.0,
        Y => Float(Adc_Pressure_Altitude_Corrected),
        Table   => NGCFIDLE_Table'Access );
    -- theta_t removed post rev C as per comment
    -- of Dwayne Kimball 5/23/2000
    Ng_G_Idle := Ng_C_G_Idle; -- * (Theta_T)**0.5;
    Ng_F_Idle := Ng_C_F_Idle * (Theta_T)**0.5;

    -- Step 5. Determine the appropriate speed-governed request,
    -- including a transition rate imposed following a Flight_Mode
    -- toggle:

    if Next_Instance.Flight_Mode then
--    if This_Instance.Flight_Mode or This_Instance.Ng_Spd >= Ng_F_Spd then
--    if This_Instance.Ng_Spd >= Ng_F_Spd then
--      Next_Instance.Ng_Spd := Ng_F_Spd;
--    else
      Next_Instance.Ng_Spd := Float'Min((This_Instance.Ng_Spd +  3.0*Iconst),Ng_F_Spd);
--    end if;
      -- following transition from N g Gspd at a rate of 3% /sec starting from
      -- when Flight_Mode switched from false.
      if This_Instance.Pmu_Reset then
        Next_Instance.Ng_Spd := Ng_F_Spd;
      end if;
    else


--    if not This_Instance.Flight_Mode or This_Instance.Ng_Spd <= Ng_G_Spd then
--    if This_Instance.Ng_Spd <= Ng_G_Spd then
--      Next_Instance.Ng_Spd := Ng_G_Spd;
--    else
      Next_Instance.Ng_Spd := Float'Max((This_Instance.Ng_Spd  - 3.0*Iconst),Ng_G_Spd);
--    end if;
      if This_Instance.Pmu_Reset then
          Next_Instance.Ng_Spd := Ng_G_Spd;
      end if;
    end if;

    Ng_Spd := Next_Instance.Ng_Spd;

    -- Determine if the pla is in the autostart range: (The logical
    -- PLA_AT_20 is used downstream to enable the auto start mode, and
    -- also controls illumination of the cockpit "start ready" light.

    Next_Instance.Pla_At_20_Degrees := ((Delta_Pla >= 16.0 and Delta_Pla <= 22.0)
                                        and (not Auto_Start_Switch_Off or Next_Instance.Ng < 21.0)
                                        and Next_Instance.Auto_Start_Ready) and Next_Instance.Pmu_On;

    -- Overshooting the "start ready" PLA position or entering
    -- flight mode disable the autostart capability ( until reset by
    -- retarding PLA to less than 10 degrees once again):

    if Delta_Pla < 28.0 or Next_Instance.Ng < 50.0 then  -- Below idle loop
        if Next_Instance.Pmu_On then

          -- Step 6.
          -- Start and Shutdown
          -- Implement the logic that enables
          -- the PMU-controlled engine start and shutdown operations.  The
          -- order of the logic in this and subsequent steps is important to
          -- proper operation.  This entire step is executed only if
          -- (delta_pla < 28. or Ng < 50.) and pmu_On=true.  First, if the
          -- power lever angle is pulled below 10., ensure that a shutdown
          -- command is send to the FMU model, initialize the governing
          -- speed request to zero, and se the PMU start ready flags.

          if Delta_Pla < Angle_Types.Degrees(10.0) then
            Next_Instance.Shutdown := True;
            Ng_Req_Triple_Prime := 0.0;
            -- if Pmu_Af_Elect_Pwr then
            Next_Instance.Monitored_Start_Ready :=True;
            if not Next_Instance.Flight_Mode then
              Next_Instance.Auto_Start_Ready := True;
            end if;
            -- end if;
          end if;

          if Delta_Pla > 22.0 or Next_Instance.Flight_Mode  then
            Next_Instance.Auto_Start_Ready := False;
          end if;

          -- If an autostart is underway, any of the following actions will
          -- arrest it and initiate an auto shutdown: re-toggling the start
          -- switch, pulling the PLA below 10 degrees, or detection of a
          -- prolonged ITT overtemp condition.  Conversely, an autostart is
          -- initiated if the ready flag has been set by previous actions, and
          -- the PLA is properly positioned, and the start switch is toggled:


          if (Itt > 820.0 ) and not Pcl_Sensor_Fault then
            if This_Instance.Pmu_Reset then
              Next_Instance.Itt_820_Timer := Float'Last - 100.0*Iconst;
            else
              Next_Instance.Itt_820_Timer := Float'Min(Float'Last - 100.0*iconst,This_Instance.Itt_820_Timer + Iconst);
            end if;
          else
            Next_Instance.Itt_820_Timer := 0.0;
          end if;

          if (Itt > 870.0 ) and not Pcl_Sensor_Fault then
            if This_Instance.Pmu_Reset then
              Next_Instance.Itt_870_Timer := Float'Last - 100.0*Iconst;
            else
              Next_Instance.Itt_870_Timer := Float'Min(Float'Last-100.0*iconst,This_Instance.Itt_870_Timer + Iconst);
            end if;
          else
            Next_Instance.Itt_870_Timer := 0.0;
          end if;

          if (Itt > 940.0) and not Pcl_Sensor_Fault then
            if This_Instance.Pmu_Reset then
              Next_Instance.Itt_940_Timer := Float'Last - 100.0*Iconst;
            else
              Next_Instance.Itt_940_Timer := Float'Min(Float'Last-100.0*Iconst,This_Instance.Itt_940_Timer + Iconst);
            end if;
          else
            Next_Instance.Itt_940_Timer := 0.0;
          end if;

          if This_Instance.Auto_Start then
            if Start_Toggle or Delta_Pla < 10.0 then
              Next_Instance.auto_shutdown := True;  -- this sets auto_start = false indirectly
            elsif  (Next_Instance.Itt_820_Timer > 19.0) or

              -- Changed per Dwayne Kimball note 9/20/2000
              --
              -- After talking with Jim DeGarmo about an MOT&E comment
              -- on the autostart overtemp malfunction, we propose
              -- reducing the time threshold for overtemp limits
              -- during the autostart. The PMU model will react to
              -- the high ITT sooner and result in a lower peak ITT
              -- for the malfunction.
              --
              (Next_Instance.Itt_870_Timer > 2.0) or  -- was 4.0
              (Next_Instance.Itt_940_Timer > 0.0) or  -- was 2.0
              Next_Instance.No_Light or Next_Instance.Slow_Start or
              (Voltage < 17.0 and not Jpats_Electrical.Batt_Bus_Light_Start) then -- Allow start on low voltage when EP active.
                Next_Instance.Auto_Shutdown := True;  -- this sets auto_start = false indirectly
                Next_Instance.Start_Abort := True;
--                Log.Report ("Auto Start Abort due to Temp limit or Volts < 17.0");
            elsif ((Delta_Pla > 22.0) or (Auto_Start_Switch_Off and Next_Instance.Ng >= 19.0)) then
              -- Note that the value of Ng at 19.0 must be set so that the switch over occurs before
              -- any possibility of an auto abort. An auto abort is a function of itt which can depend
              -- on the Itt at the time the start was initiated and the voltage of the battery at that point.

              Next_Instance.Auto_Start := False;
              Next_Instance.Monitored_Start := True;
              Pla_To_18 := True;
--              Log.Report("Auto Start Abort due to auto_start_switch_off");
--              Log.Report("Monitored Start = " & Boolean'Image(Next_Instance.Monitored_Start));
            end if;
          else
            if Next_Instance.Auto_Start_Ready and Next_Instance.Pla_At_20_Degrees and Start_Toggle then
              Next_Instance.Auto_Start := True;
              Next_Instance.Start_Abort := False;
            end if;
          end if;

          -- If a monitored start is underway, either of the following actions
          -- will arrest it and initiate an auto shutdown: re-toggling the
          -- start switch, or pulling the PLA below 10 after it has been
          -- advanced to The idle position during the start attempt.
          -- Conversely, a monitored start is initiated if the ready
          -- flag has been set by previous actions, and an autostart is not
          -- underway, and the PLA is at the idle setting or below, and the
          -- start switch is toggled:

          if Next_Instance.Monitored_Start then
            if Delta_Pla > 18.0 then
              Pla_To_18 := True;
            end if;
            if (Delta_Pla < 10.0 and Pla_To_18) or
              (Start_Toggle and Delta_Pla <= 22.0) then
              Next_Instance.Auto_Shutdown := True;
--              Log.Report("Auto_Shutdown set true here");
--              Log.Report("delta_pla" & Float'Image(Delta_Pla));
--              Log.Report("pla_to_18" & Boolean'Image(Pla_To_18));
--              Log.Report("start_toggle" & Boolean'Image(Start_Toggle));
--              Log.Report("((delta_pla < 10 and pla_to_18) or (start_toggle and delta_pla <=22.0))");
            end if;
            if This_Instance.Pmu_Reset then
              Next_Instance.Monitored_Start_Timer := 0.0;
            else
              Next_Instance.Monitored_Start_Timer := Float'Min(This_Instance.Monitored_Start_Timer + Iconst,30.0);
            end if;
          elsif This_Instance.Monitored_Start_Ready and not Next_Instance.Auto_Start
            and Delta_Pla <= 10.0 and Start_Toggle  then
            Next_Instance.Monitored_Start := True;
            Pla_To_18 := False;
            Next_Instance.Monitored_Start_Timer := 0.0;
            Next_Instance.Start_Abort := False;
          else
            Next_Instance.Monitored_Start_Timer := 0.0;
          end if;

          -- Step 7. Set various flags and the gas generator speed request
          -- during the PMU-controlled engine start and shutdown
          -- operations.
          -- Note: This entire step is executed only if ( delta_pla <
          -- 28 deg or Ng < 50% ) and if PMU_ON = true. If an auto shutdown is
          -- commanded by the logic in Step 6 or by the logic in this step as
          -- executed on the previous pass, command fuel SHUTDOWN to the FMU,
          -- deactivate the starter and ignitors, and reconfigure the PMU
          -- logic appropriately:

          if Next_Instance.Auto_Shutdown then
            Next_Instance.Shutdown := True;
            Next_Instance.Start  := False;
            Next_Instance.Auto_Start := False;
            Next_Instance.Monitored_Start := False;
            Ng_Req_Triple_Prime := 0.0;
            Next_Instance.Auto_Shutdown := False; --(reset)
            Next_Instance.No_Light := False;
            Next_Instance.Slow_Start := False;
          end if;

          -- If an auto or monitored start is commanded by the logic in Step
          -- 6, command the starter, ignitors, fuel flow and propeller pitch,
          -- and reconfigure the PMU logic appropriately :
          if Next_Instance.Auto_Start or Next_Instance.Monitored_Start then
            if This_Instance.Pmu_Reset then
              Next_Instance.Auto_Start_Timer := 2.0;
            else
              Next_Instance.Auto_Start_Timer := Float'Min(2.0, This_Instance.Auto_Start_Timer + Iconst);
            end if;
            Next_Instance.Start :=  Next_Instance.Auto_Start_Timer > 1.5 and  Next_Instance.Ng < 50.0;
            Auto_Feather := True;
            Next_Instance.Auto_Shutdown := False;
            if This_Instance.Pmu_Reset then
              Next_Instance.Low_Accel_Timer := 0.0;
            else
              Next_Instance.Low_Accel_Timer := Float'Min(This_Instance.Low_Accel_Timer + Iconst, 25.0);
            end if;
            -- zero the stepper motor and fuel flow if Ng is below 10 percent or shutdown is commanded
            if ((Next_Instance.Ng < 10.0) or (Next_Instance.Monitored_Start and Delta_Pla < 10.0)) then
               Ng_Req_Triple_Prime := 0.0;
               Next_Instance.Shutdown := True;
               Next_Instance.Itt_Start_Peak := Itt;
               Next_Instance.Fuel_On_Timer := 0.0;
               if Next_Instance.Monitored_Start and (Next_Instance.Monitored_Start_Timer) > 20.0 then
                  Next_Instance.Auto_Shutdown := True;
--                   Log.Report("Monitored_start_timer expired");
               end if;
               if Next_Instance.Low_Accel_Timer > 20.0 then
                  Next_Instance.No_Light := True;
--                   Log.Report("Low_Accel");
               end if;
            else -- (Ng is equal to or above 10 percent and delta_pla <= 28.0)
              Next_Instance.Shutdown := False;
              if This_Instance.Pmu_Reset then
                Next_Instance.Fuel_On_Timer := 0.0;
              else
                Next_Instance.Fuel_On_Timer := Float'Min(This_Instance.Fuel_On_Timer + Iconst, 25.0);
              end if;
              if Next_Instance.Fuel_On_Timer > 10.0 and not Fired then
                Next_Instance.No_Light := True;
              end if;
              if Next_Instance.Fuel_On_Timer > 20.0 and ( Slow_Start_Request or Voltage < 18.0) then
                Next_Instance.Slow_Start := True;
              end if;
              Next_Instance.Itt_Start_Peak := Float'Max(Itt, This_Instance.Itt_Start_Peak);
              if ((Itt >= Next_Instance.Itt_Start_Peak - 5.0) or (This_Instance.Ng < 26.0)) then -- Set Ng Request To Obtain 80pph Fuel Flow;
                  Ng_Req_Triple_Prime := Interpolation_Table.Doubly_Indexed.Interpolate
                    ( X => ((85.0 - 0.00065*Adc_Pressure_Altitude_Corrected)/(Delta_T*Theta_T**0.1)),
                      Y => Float(Mach_Pmu),
                      Table => Ngcffc_Table'Access);
                  -- Next_Instance.Ng_Req_Norm := Ng_Req_Triple_Prime;
                  Ng_Req_Norm_Temp := Ng_Req_Triple_Prime;
              else
                Next_Instance.Itt_Start_Peak := 9999.0;
                if Next_Instance.Flight_Mode then
                  Ng_Req_Triple_Prime := Ng_F_Idle;
                else
                  Ng_Req_Triple_Prime := Ng_G_Idle;
                end if;
              end if;
            end if;
          else
            Next_Instance.Low_Accel_Timer := 0.0;
            Next_Instance.Auto_Start_Timer := 0.0;
            Next_Instance.Monitored_Start_Timer := 0.0;
          end if;

          -- Finally, set the adjusted speed request equal to the
          -- governing speed request and disarm the minimum RPM control
          -- loop of the PMU:
          Ng_Req_Double_Prime := Ng_Req_Triple_Prime;
          Next_Instance.Min_Rpm_Loop_Arm := False;
          Next_Instance.Pmu_Transition_On := False;
        else  -- Pmu On = false

          -- Step 8.  Configure PMU logic for the case of the PMU in
          -- manual mode in the start/shutdown regine.  Control fuel
          -- flow and propeller feathering based on power lever angle.
          --
          -- This entire step is executed only if  (delta_pla < 28.0 deg
          -- or Ng < 50.0%) and if PMU_ON =false.

          --          if not Next_Instance.Pmu_On then
--          Next_Instance.Pmu_Transition_Off := False;
--          Next_Instance.Smp_Req := 169.0;
          Auto_Feather := False;
          Next_Instance.Auto_Start_Ready := False;
          Next_Instance.Monitored_Start_Ready := False;
          Next_Instance.Auto_Start := False;
          Next_Instance.Monitored_Start := False;
          Next_Instance.Start := False;
          Next_Instance.Min_Rpm_Loop_Arm := False;
          Next_Instance.No_Light := False;
          Next_Instance.Slow_Start := False;
          Next_Instance.Shutdown := Delta_Pla < 7.0;
          --          end if;
        end if;  -- end of Pmu On if loop

    else  -- Below Idle = false below.

      -- Step 9. Configure PMU logic for the normal engine operating regime.
      -- Note: This entire step is executed only if ( delta_pla >= 28 deg  and Ng >= 50% ).

      if This_Instance.Pmu_Reset then
        Next_Instance.Shutdown := False;
      end if;
      Next_Instance.Auto_Start := False;
      Next_Instance.Monitored_Start := False;
      Next_Instance.Start := False;
--      Auto_Ignitors_On := False;
      Next_Instance.Auto_Shutdown := False;
      if Next_Instance.Np > 1625.0/20.0 then
        Next_Instance.Min_Rpm_Loop_Arm := True;
      end if;

      -- Step 10. Calculate the engine shaft horsepower at the 104% Ng
      -- engine limit, for use in acceleration scheduling.  This calculation
      -- makes use of one engine model table and two engine model calculations:
      -- Note: This entire step is executed only if ( delta_pla >= 28 deg and Ng >= 50% ).
      -- This is the same as not (delta_pla < 28 deg or Ng < 50.0%).

      Shp_C_Ng_Lim := Interpolation_Table.Doubly_Indexed.Interpolate
        ( X => Float(104.0/Theta_T**0.5),
          Y => Float(Mach_Number),
          Table   => SHPCNGC_Table'Access );

      Shp_Ng_Lim := (Shp_C_Ng_Lim + Delta_Shp_C_Acc +
                     Delta_Shp_C_Bleed)*Delta_T*Theta_T**0.5;

      -- where: SHP_c_Ng_lim := f(104/(theta_total**0.5* Mach)
      -- from engine table SHPCNGC
      -- Delta_SHP_c_acc  was calculated in Step 8 of section 11.2
      -- Delta_SHP_c_bleed was calculated in Step 8 of section 11.2

      -- Step 11. Calculate the engine shaft horsepower at the ITT
      -- limit, for use in the maximum rated power determination for
      -- the pre-production PMU. This calculation makes use of one
      -- engine model table and two engine model calculations:

      -- Note: This entire step is executed only
      -- if ( delta_pla >= 28 degrees and Ng >= 50% and SHIP < 3).

      if Next_Instance.Ship < 3 then
        Itt_C_Lim := 1093.0 / (Theta_T)**0.4 - Delta_ITT_C_Acc - Delta_ITT_C_Bleed;

        Ng_C_Itt_Lim := Interpolation_Table.Doubly_Indexed.Interpolate
          ( X => Float(Itt_C_Lim),
            Y => Float(Mach_Number),
            Table   => NGCITTC_Table'Access );

        Shp_C_Itt_Lim := Interpolation_Table.Doubly_Indexed.Interpolate
          ( X => Float(Ng_C_Itt_Lim),
            Y => Float(Mach_Number),
            Table   => SHPCNGC_Table'Access );

        Shp_Itt_Lim := (Shp_C_Itt_Lim + Delta_Shp_C_Acc +
                        Delta_Shp_C_Bleed ) * Delta_T* Theta_T**0.5;
      end if;

      -- where: SHP_C_Itt_lim := f(Ng_c_ITT_lim , Mach) from engine table SHPCNGC
      -- where: Ng_c_itt_lim := f(ITT_c_lim, Mach) from table NGCITTC
      -- ITT_c_lim := 1093. / theta_total**0.4 - delta_itt_c_acc - delta_itt_c_bleed
      -- Delta_Itt_c_acc was calculated in Step 7 of section 11.2
      -- Delta_Itt_c_bleed was calculated in Step 7 of section 11.2

      -- Step 12. Calculate the maximum rated power for the current
      -- conditions.  Also, calculte Ng request values corresponding to the
      -- Ng, Itt, and torque limits for use in simulating the PMU limit
      -- loops.
      --
      -- Note: This entire step is executed only if
      -- (delta_pla >= 28 degrees and Ng >= 50%).
      --
      -- If ship <= 2 then the pre-production PMU is being simulated and
      -- the max rated power is based on the limit calculated in Steps 10
      -- and 11:

      if Next_Instance.Ship < 3 then
        Shp_Q_Lim := 1100.0 - (Delta_Shp_C_Acc + Delta_Shp_C_Bleed)*Delta_T*Theta_T**0.5;
        Shp_Mrp := Float'Min(Shp_Q_Lim, Float'Min( Shp_Ng_Lim, Shp_Itt_Lim ));

        Ng_Req_Ng_Lim := 120.0;   -- (Limit loop is not simulated for pre-production PMU)
        Ng_Req_Itt_Lim := 120.0;  -- (Limit loop is not simulated for pre-production PMU)
        Ng_Req_Q_Lim := 120.0;    -- (Limit loop is not simulated for pre-production PMU)
      else

        -- Else the production PMU is being simulated, and the maximum rated
        -- power is determined by a programmed schedule based on Mach number,
        -- pressure altitude, sensed inlet air temperature and bleed level:


        if Mach_Pmu < 0.0 then
          Shp_Mrp_L := Interpolation_Table.Doubly_Indexed.Interpolate
            ( X     => Float(Adc_Pressure_Altitude_Corrected),
              Y     => Float(Total_Inlet_Temperature_T1_Hi),
              Table => SHPMRP0L_Table'Access);
          Shp_Mrp_H := Interpolation_Table.Doubly_Indexed.Interpolate
            ( X     => Float(Adc_Pressure_Altitude_Corrected),
              Y     => Float(Total_Inlet_Temperature_T1_Hi),
              Table => SHPMRP0H_Table'Access);
        elsif Mach_Pmu < 0.2 then
          Shp_Mrp_Lo_L  := Interpolation_Table.Doubly_Indexed.Interpolate
            ( X     => Float(Adc_Pressure_Altitude_Corrected),
              Y     => Float(Total_Inlet_Temperature_T1_Hi),
              Table => SHPMRP0L_Table'Access);
          Shp_Mrp_Hi_L := Interpolation_Table.Doubly_Indexed.Interpolate
            ( X     => Float(Adc_Pressure_Altitude_Corrected),
              Y     => Float(Total_Inlet_Temperature_T1_Hi),
              Table => SHPMRP2L_Table'Access);
          Shp_Mrp_L := (Mach_Pmu -0.0)/(0.2 - 0.0)*(Shp_Mrp_Hi_L - Shp_Mrp_Lo_L)+Shp_Mrp_Lo_L;
          Shp_Mrp_Lo_H := Interpolation_Table.Doubly_Indexed.Interpolate
            ( X     => Float(Adc_Pressure_Altitude_Corrected),
              Y     => Float(Total_Inlet_Temperature_T1_Hi),
              Table => SHPMRP0H_Table'Access);
          Shp_Mrp_Hi_H := Interpolation_Table.Doubly_Indexed.Interpolate
            ( X     => Float(Adc_Pressure_Altitude_Corrected),
              Y     => Float(Total_Inlet_Temperature_T1_Hi),
              Table => SHPMRP2H_Table'Access);
          Shp_Mrp_H := (Mach_Pmu -0.0)/(0.2 - 0.0)*(Shp_Mrp_Hi_H - Shp_Mrp_Lo_H)+Shp_Mrp_Lo_H;
        elsif Mach_Pmu < 0.3 then
          Shp_Mrp_Lo_L  := Interpolation_Table.Doubly_Indexed.Interpolate
            ( X     => Float(Adc_Pressure_Altitude_Corrected),
              Y     => Float(Total_Inlet_Temperature_T1_Hi),
              Table => SHPMRP2L_Table'Access);
          Shp_Mrp_Hi_L := Interpolation_Table.Doubly_Indexed.Interpolate
            ( X     => Float(Adc_Pressure_Altitude_Corrected),
              Y     => Float(Total_Inlet_Temperature_T1_Hi),
              Table => SHPMRP3L_Table'Access);
          Shp_Mrp_L := (Mach_Pmu -0.2)/(0.3 - 0.2)*(Shp_Mrp_Hi_L - Shp_Mrp_Lo_L)+Shp_Mrp_Lo_L;
          Shp_Mrp_Lo_H := Interpolation_Table.Doubly_Indexed.Interpolate
            ( X     => Float(Adc_Pressure_Altitude_Corrected),
              Y     => Float(Total_Inlet_Temperature_T1_Hi),
              Table => SHPMRP2H_Table'Access);
          Shp_Mrp_Hi_H := Interpolation_Table.Doubly_Indexed.Interpolate
            ( X     => Float(Adc_Pressure_Altitude_Corrected),
              Y     => Float(Total_Inlet_Temperature_T1_Hi),
              Table => SHPMRP3H_Table'Access);
          Shp_Mrp_H := (Mach_Pmu -0.2)/(0.3 - 0.2)*(Shp_Mrp_Hi_H - Shp_Mrp_Lo_H)+Shp_Mrp_Lo_H;
        elsif Mach_Pmu < 0.4 then
          Shp_Mrp_Lo_L  := Interpolation_Table.Doubly_Indexed.Interpolate
            ( X     => Float(Adc_Pressure_Altitude_Corrected),
              Y     => Float(Total_Inlet_Temperature_T1_Hi),
              Table => SHPMRP3L_Table'Access);
          Shp_Mrp_Hi_L := Interpolation_Table.Doubly_Indexed.Interpolate
            ( X     => Float(Adc_Pressure_Altitude_Corrected),
              Y     => Float(Total_Inlet_Temperature_T1_Hi),
              Table => SHPMRP4L_Table'Access);
          Shp_Mrp_L := (Mach_Pmu -0.3)/(0.4 - 0.3)*(Shp_Mrp_Hi_L - Shp_Mrp_Lo_L)+Shp_Mrp_Lo_L;
          Shp_Mrp_Lo_H := Interpolation_Table.Doubly_Indexed.Interpolate
            ( X     => Float(Adc_Pressure_Altitude_Corrected),
              Y     => Float(Total_Inlet_Temperature_T1_Hi),
              Table => SHPMRP3H_Table'Access);
          Shp_Mrp_Hi_H := Interpolation_Table.Doubly_Indexed.Interpolate
            ( X     => Float(Adc_Pressure_Altitude_Corrected),
              Y     => Float(Total_Inlet_Temperature_T1_Hi),
              Table => SHPMRP4H_Table'Access);
          Shp_Mrp_H := (Mach_Pmu -0.3)/(0.4 - 0.3)*(Shp_Mrp_Hi_H - Shp_Mrp_Lo_H)+Shp_Mrp_Lo_H;
        elsif Mach_Pmu < 0.5 then
          Shp_Mrp_Lo_L  := Interpolation_Table.Doubly_Indexed.Interpolate
            ( X     => Float(Adc_Pressure_Altitude_Corrected),
              Y     => Float(Total_Inlet_Temperature_T1_Hi),
              Table => SHPMRP4L_Table'Access);
          Shp_Mrp_Hi_L := Interpolation_Table.Doubly_Indexed.Interpolate
            ( X     => Float(Adc_Pressure_Altitude_Corrected),
              Y     => Float(Total_Inlet_Temperature_T1_Hi),
              Table => SHPMRP5L_Table'Access);
          Shp_Mrp_L := (Mach_Pmu -0.4)/(0.5 - 0.4)*(Shp_Mrp_Hi_L - Shp_Mrp_Lo_L)+Shp_Mrp_Lo_L;
          Shp_Mrp_Lo_H := Interpolation_Table.Doubly_Indexed.Interpolate
            ( X     => Float(Adc_Pressure_Altitude_Corrected),
              Y     => Float(Total_Inlet_Temperature_T1_Hi),
              Table => SHPMRP4H_Table'Access);
          Shp_Mrp_Hi_H := Interpolation_Table.Doubly_Indexed.Interpolate
            ( X     => Float(Adc_Pressure_Altitude_Corrected),
              Y     => Float(Total_Inlet_Temperature_T1_Hi),
              Table => SHPMRP5H_Table'Access);
          Shp_Mrp_H := (Mach_Pmu -0.4)/(0.5 - 0.4)*(Shp_Mrp_Hi_H - Shp_Mrp_Lo_H)+Shp_Mrp_Lo_H;
        elsif Mach_Pmu < 0.7 then
          Shp_Mrp_Lo_L  := Interpolation_Table.Doubly_Indexed.Interpolate
            ( X     => Float(Adc_Pressure_Altitude_Corrected),
              Y     => Float(Total_Inlet_Temperature_T1_Hi),
              Table => SHPMRP5L_Table'Access);
          Shp_Mrp_Hi_L := Interpolation_Table.Doubly_Indexed.Interpolate
            ( X     => Float(Adc_Pressure_Altitude_Corrected),
              Y     => Float(Total_Inlet_Temperature_T1_Hi),
              Table => SHPMRP7L_Table'Access);
          Shp_Mrp_L := (Mach_Pmu -0.5)/(0.7 - 0.5)*(Shp_Mrp_Hi_L - Shp_Mrp_Lo_L)+Shp_Mrp_Lo_L;
          Shp_Mrp_Lo_H := Interpolation_Table.Doubly_Indexed.Interpolate
            ( X     => Float(Adc_Pressure_Altitude_Corrected),
              Y     => Float(Total_Inlet_Temperature_T1_Hi),
              Table => SHPMRP5H_Table'Access);
          Shp_Mrp_Hi_H := Interpolation_Table.Doubly_Indexed.Interpolate
            ( X     => Float(Adc_Pressure_Altitude_Corrected),
              Y     => Float(Total_Inlet_Temperature_T1_Hi),
              Table => SHPMRP7H_Table'Access);
          Shp_Mrp_H := (Mach_Pmu -0.5)/(0.7 - 0.5)*(Shp_Mrp_Hi_H - Shp_Mrp_Lo_H)+Shp_Mrp_Lo_H;
        elsif Mach_Pmu >= 0.7 then
          Shp_Mrp_L := Interpolation_Table.Doubly_Indexed.Interpolate
            ( X     => Float(Adc_Pressure_Altitude_Corrected),
              Y     => Float(Total_Inlet_Temperature_T1_Hi),
              Table => SHPMRP7L_Table'Access);
          Shp_Mrp_H := Interpolation_Table.Doubly_Indexed.Interpolate
            ( X     => Float(Adc_Pressure_Altitude_Corrected),
              Y     => Float(Total_Inlet_Temperature_T1_Hi),
              Table => SHPMRP7H_Table'Access);
        end if;

        -- But note that power should ramp between shp_mrp_l and
        -- shp_mrp_h at the rate of 3%/sec when the bleed discrete
        -- changes.  Instead of integrating at 3.0*iconst this should
        -- be 0.03*1100 shp * iconst
        --        if Wbleed_Dot < 5.2 then
        if Bleed_Air_On then
          if This_Instance.Pmu_Reset then
            Next_Instance.Shp_Mrp_Prime := Shp_Mrp_H;
          else
            Next_Instance.Shp_Mrp_Prime := Float'Min(Shp_Mrp_H, This_Instance.Shp_Mrp_Prime + 33.0*Iconst);
          end if;
        else
          if this_instance.pmu_reset then
            Next_Instance.Shp_Mrp_Prime := Shp_Mrp_L;
          else
            Next_Instance.Shp_Mrp_Prime := Float'Max(Shp_Mrp_L, This_Instance.Shp_Mrp_Prime - 33.0*Iconst);
          end if;
        end if;

        -- Test
        -- Next_Instance.Shp_Mrp_Prime := 1485.57;

        -- Finally, add the 1100 shp flat rating limit and adjust the
        -- power for the engine model accessory and bleed power deltas
        -- to obtain the adjusted maximum rated power for use in
        -- determining the requested Ng and fuel flow.
        Shp_Mrp := Float'Min(1101.0, Next_Instance.Shp_Mrp_Prime) - (Delta_Shp_C_Acc + Delta_Shp_C_Bleed)*Delta_T*Theta_T**0.5;

        -- Calculated the requested Ng corresponding to the PMU Ng
        -- limit.  This request, if limiting, will be imposed in Step
        -- 20 and will not be effected by acceleration and
        -- deceleration limits:
        Ng_Req_Ng_Lim := Float'Min(104.0,(113.43*Theta_T**0.5))/K_Ng_Malfunction;

        -- Calculated the Itt limit, which is initially at 850"c but
        -- ramps down to 820"c after a 19 second exceedance.  Then,
        -- when Itt has been below 818'c for more than 19 seconds the
        -- ITT limit ramps back up to 848"c
        if Itt > 820.0 then
          if This_Instance.Pmu_Reset then
            Next_Instance.Itt_820_Fired_Timer := 20.0;
          else
            Next_Instance.Itt_820_Fired_Timer := Float'Min(20.0, This_Instance.Itt_820_Fired_Timer + Iconst);
          end if;
        else
          Next_Instance.Itt_820_Fired_Timer := 0.0;
        end if;

        if Itt < 818.0 then
          if This_Instance.Pmu_Reset then
            Next_Instance.Itt_818_Timer := 20.0;
          else
            Next_Instance.Itt_818_Timer := Float'Min(20.0, This_Instance.Itt_818_Timer + Iconst);
          end if;
        else
          Next_Instance.Itt_818_Timer := 0.0;
        end if;

        if Next_Instance.Itt_820_Fired_Timer > 19.0 then
          if This_Instance.Pmu_Reset then
            Next_Instance.Itt_Limit := 820.0;
          else
            Next_Instance.Itt_Limit := Float'Max(820.0, This_Instance.Itt_Limit - 30.0*Iconst);
          end if;
        end if;

        if Next_Instance.Itt_818_Timer > 19.0 then
          if This_Instance.Pmu_Reset then
            Next_Instance.Itt_Limit := 850.0;
          elsif not Itt_Sensor_Malfunction then
            Next_Instance.Itt_Limit := Float'Min(850.0,This_Instance.Itt_Limit + 30.0*Iconst);
          end if;

        end if;
--        Log.Report("itt_limit := " & Float'Image(Next_Instance.Itt_Limit));

--        JPATS_Powerplant.Ios_Interface.This_Ios_Interface.Sr1 := Next_Instance.Itt_Limit;

        -- Calculate the requested Ng corresponding to the PMU ITT
        -- limit.  This request, if limiting, will be imposed in Step
        -- 20 and will not be effected by acceleration and
        -- deceleration limits.

        if Itt_Sensor_Malfunction and Next_Instance.Itt_Limit < 850.0 then
           -- K_Itt_Malfunction := 1.5;
           if Itt > Next_Instance.Itt_Limit and not Pullback then  -- This mechanism permits an overtemp and pullback delay.
              Pullback := True;
           end if;

           if (Pullback ) then
              K_Itt_Malfunction := Float'Max(1.0,Float'Min(1.5,K_Itt_Malfunction
                                                           + 0.0004*(Itt - Next_Instance.Itt_Limit)*Iconst));
             -- K_Itt_Malfunction := Float'Max(1.5,Float'Min(1.0,1.0 + (0.5*(This_Instance.Smp_Req - 85.0)/253.0));
           end if;
        elsif Overtemp then
           K_Itt_Malfunction := 2.2;
        else
           K_Itt_Malfunction := 1.0;
           if Pullback then
              Pullback := False;
              Next_Instance.Itt_Limit := 850.0;
              Next_Instance.Itt_820_Fired_Timer := 20.0;
              Next_Instance.Itt_818_Timer := 20.0;
           end if;
        end if;
        if Itt_Sensor_Malfunction then
           Itt_C_Lim := ((Next_Instance.Itt_Limit/K_Itt_Malfunction)+273.15)/Theta_T**0.4;
        else
           Itt_C_Lim := ((Next_Instance.Itt_Limit/K_Itt_Malfunction)+273.15)/Theta_T**0.4 - Delta_Itt_C_Acc - Delta_Itt_C_Bleed;
        end if;
--        Log.Report("itt_C_lim := " & Float'Image(Itt_C_Lim));
--        JPATS_Powerplant.Ios_Interface.This_Ios_Interface.Sr2 := Itt_C_Lim;

        Ng_C_Req_Itt_Lim := Interpolation_Table.Doubly_Indexed.Interpolate
          ( X => Float(Itt_C_Lim),
            Y => Float(Mach_Number),
            Table => NGCITTC_Table'Access);
        Ng_Req_Itt_Lim := Ng_C_Req_Itt_Lim*Theta_T**0.5;
--        Log.Report("ng_req_itt_lim := " & Float'Image(Ng_Req_Itt_Lim));
--        JPATS_Powerplant.Ios_Interface.This_Ios_Interface.Sr3 := Ng_Req_Itt_Lim;

        -- Calculate the requested Ng corresponding to the torque
        -- limit.  This request, if limiting, will be imposed in Step
        -- 20 and will not be effected by acceleration and
        -- deceleration limits.
        Shp_C_Q_Lim := 11.59*Next_Instance.Np/Delta_T/Theta_T**0.5 - Delta_Shp_C_Acc - Delta_Shp_C_Bleed - Delta_Shp_C_Np;
        Ng_C_Req_Q_Lim := Interpolation_Table.Doubly_Indexed.Interpolate
          ( X => Float(Shp_C_Q_Lim),
            Y => Float(Mach_Number),
            Table => NGCSHPC_Table'Access);
        Ng_Req_Q_Lim := Ng_C_Req_Q_Lim*Theta_T**0.5;
--        Log.Report("ng_req_q_lim := " & Float'Image(Ng_Req_q_Lim));
--        JPATS_Powerplant.Ios_Interface.This_Ios_Interface.Sr4 := Ng_Req_q_Lim;

      end if;

      -- Step 13. Using a schedule based on power lever angle, scale
      -- the maximum rated power to obtain the power request for the
      -- power-governed mode of operation. This request is relevant at
      -- mid and high power levels:
      --
      -- Note: This entire step is executed only if
      -- (delta_pla >= 28 degrees and Ng >= 50%).

      F_Shp_Delta_Pla := Interpolation_Table.Singly_Indexed.Interpolate
        ( Input => Float(Delta_Pla),
          Table => FSHPPLA_Table'Access );

      Shp_Pwr := F_Shp_Delta_Pla * Shp_Mrp;
      -- where: F_Shp_delta_pla := (delta_pla) from table FSHPPLA

      -- Step 14. Translate the power request into the corresponding
      -- power-governed gas generator speed request. Note that the
      -- power-governed request is not permitted to drop below the
      -- speed-governed request from Step 5, so that subsequent
      -- blending between the two requests will not produce an
      -- erronesous result:
      --
      -- Note: This entire step is executed only if
      -- (delta_pla >= 28 degrees and Ng >= 50%).

      Shp_C_Pwr := Shp_Pwr/(Delta_T * Theta_T**0.5);

      -- Ng_C_Pwr := F(Shp_C_Pwr, Mach) From Table Ngcshpc;
      Ng_C_Pwr := Interpolation_Table.Doubly_Indexed.Interpolate
        ( X => Float(Shp_C_Pwr),
          Y => Float(Mach_Number),  -- Should be mach number instead of Mach_Pmu since it is inverse gas generator table lookup.
          Table   => NGCSHPC_Table'Access );

      Ng_Pwr := Float'Max( Next_Instance.Ng_Spd, Ng_C_Pwr*Theta_T**0.5);

      -- Step 15.  Gas generator speeds for the speed-governed an
      -- power-governed modes have now been calculated.  At power lever
      -- angles above 48 degrees, the PMU modulates fuel flow to obtain the
      -- power-governed value.  At a power lever angle of 30 degrees (which is the
      -- idle gate) the PMU modulates fuel flow to obtain the
      -- speed-governed value.  In between 30 degrees and 48 degrees, a dynamic
      -- transition occurs between the two governing modes.  The transition
      -- logic is simulated by the following equations:
      --
      -- Note: This entire step is executed only if
      -- (delta_pla >= 28 degrees and Ng >= 50%).
      --
      if Next_Instance.Np < 1950.0/20.0 then
        Next_Instance.Delta_Ng := 0.0;
      else
        Next_Instance.Delta_Ng := (Ng_Pwr - Next_Instance.Ng_Spd); -- (%)
      end if;

      if Delta_Pla  > 48.0 or Next_Instance.Np < 1950.0/20.0 or This_Instance.Pmu_Reset then
        Next_Instance.Delta_Ng_Dyn := Next_Instance.Delta_Ng;   -- (%)
      else
        Next_Instance.Delta_Ng_Dyn := This_Instance.Delta_Ng_Dyn +
          (This_Instance.Delta_Ng - This_Instance.Delta_Ng_Dyn)*Iconst/4.8;  -- (%)
      end if;
      -- where: the "This_Instance." prefix refers to last pass values of
      -- variables, and the last equation implements a lag on the delta
      -- between the power-governed and speed-governed values.  Note that
      -- the equations reset the lag whenever the power lever angle is
      -- greater than 48 degrees.
      --
      -- Next, calculate three ramping factors:

      F_Ng_Dyn := Float'Max(0.0,Float'Min(1.0,0.2*Delta_Pla - 6.0));
      --           (Ramps from 0 to 1 between 30 degrees and 35 degrees.)
      F_Ng_Pwr := Interpolation_Table.Singly_Indexed.Interpolate
        ( Input => Float(Delta_Pla),
          Table => Fngpwr_Table'Access);
      --      F_Ng_Pwr := Float'Max(0.0,Float'Min(1.0,0.125*Delta_Pla - 5.0));
      --           (Ramps from 0 to 1 between 40 degrees and 48 degrees.)
      F_Ng_Spd := 1.0 - F_Ng_Pwr;
      --      F_Ng_Spd := Float'Max(0.0,Float'Min(1.0,6.0 - 0.125*Delta_Pla));
      --           (Ramps from 1 to 0 between 40 degrees and 48 degrees.)


      -- Ramp the dynamic delta onto the speed-governed value between
      -- power lever angles of 30degrees and 35degrees to produce a dynamic
      -- speed-governed value:

      Ng_Spd_Dyn := Next_Instance.Ng_Spd + F_Ng_Dyn * Next_Instance.Delta_Ng_Dyn; -- (%)


      -- Finally, blend between the dynamic speed-governed value and the
      -- power-governed value in the power lever range of 40 degrees and
      -- 48 degrees to obtain the governing speed request:
      --

      if not Loss_Of_Useful_Power then
        Ng_Req_Triple_Prime := F_Ng_Spd * Ng_Spd_Dyn + F_Ng_Pwr*Ng_Pwr;  -- (%)
      else
        Ng_Req_Triple_Prime := Next_Instance.Ng_Spd;
      end if;

      -- Step 16. Implement the minimum RPM loop, which limits the
      -- speed request to a level which will maintain a minimum
      -- propeller RPM of 1625 at altitudes above 9,500 ft. This loop
      -- is active at low flight speeds when the propeller is on its
      -- low blade stop.
      --
      -- Note: This entire step is executed only if
      -- (delta_pla >= 28 degrees and Ng >= 50%).

      -- Calculated Rpm Dot to keep from kludging interface.
      if Iconst < 0.0001 or This_Instance.Pmu_Reset then
        Next_Instance.Np_Dot := 0.0;
      else
          Next_Instance.Np_Dot := ((Next_Instance.Np - This_Instance.Np)/Iconst + 0.5*This_Instance.Np_Dot)/1.5;
      end if;
      --      Next_Instance.Np_Last_Pass := This_Instance.Np;

      if (Next_Instance.Min_Rpm_Loop_Arm and Adc_Pressure_Altitude_Corrected > 9500.0 and Next_Instance.Np < 1625.0/20.0) then -- note that H is FHP not FHG
        Delta_Ng_Min_Rpm := (2.0*Float'Max(0.0,(1625.0/20.0 - Next_Instance.Np)) - 8.0*Next_Instance.Np_Dot)*20.0;  -- convert back to rpm by mult. by 20.0
      else
        Delta_Ng_Min_Rpm := 0.0;
      end if;

      -- Step 17.  Sum the minimum RPM loop delta into the governing speed
      -- request from Step 15.


      -- Also calculate an alternate speed request
      -- that will, in response to large power demands under "flat rated"
      -- (i.e., transmission limited) conditions, be invoked to accelerate
      -- the engine more rapidly than on the normal schedule.  This
      -- parallel speed request is denoted by the subscript "hot":

      Ng_Req_Double_Prime := Ng_Req_Triple_Prime + Delta_Ng_Min_Rpm; -- (%)
      --    Ng_Req_Hot_Double_Prime := (Shp_Ng_Lim/Shp_Mrp)*Ng_Req_Double_Prime; -- (%)

    end if;  -- End of Below idle if loop

    -- Step 18.  Calculate the PMU-imposed gas generator
    -- acceleration and deceleration limits.  The acceleration limit
    -- is modeled as a function of the corrected speed request,
    -- pressure altitude and Mach number and propeller speed, and is
    -- proportional to the operating speed range at the prevailing
    -- conditions.

    --   Ng_acc_lim_dot = F_Ng_ach_dot * F_Ng_Dot_Ng_C*(104.0 - Ng_F_idle) (% /sec)
    --     where: F_ng_Mach_dot = f(Mach, H)  from table set FNGDMACH
    --            F_Ng_Dot_Ng_C = f(Ng_req_last'/fsqtt2, H) from table set FNGDNGC
    --            Ng_req_last' is the last pass value of  from Step 15 below.
    --

    F_Ng_Mach_Dot := Interpolation_Table.Doubly_Indexed.Interpolate
      ( X => Float(Mach_Pmu),
        Y => Float(Adc_Pressure_Altitude_Corrected),
        Table   => FNGDMACH_Table'Access );
    F_Ng_Dot_Ng_C := Interpolation_Table.Doubly_Indexed.Interpolate
      ( X => Float(This_Instance.Ng_Req_Prime/Theta_T**0.5),
        Y => Float(Adc_Pressure_Altitude_Corrected),
        Table   => FNGDNGC_Table'Access );

    if Next_Instance.Np < 1950.0/20.0 then
      Delta_F_Ng_Np_Lo := Interpolation_Table.Singly_Indexed.Interpolate
        ( Input => Float(This_Instance.Ng_Req_Prime/Theta_T**0.5),
          Table => DFNGDNPLO_Table'Access );
    else
      Delta_F_Ng_Np_Lo :=  0.0;
    end if;

    Ng_Acc_Lim_Dot := (F_Ng_Mach_Dot * F_Ng_Dot_Ng_C +
                       Delta_F_Ng_Np_Lo)* (104.0 - Ng_F_Idle);

    -- During a simulated hot start ( with turbine temperature
    -- exceedance), the above acceleration rate limit is doubled in
    -- a specific requested speed range.  This increases fuel flow
    -- and engine accelereation to levels encountered in a
    -- documented hot start on the aircraft during the flight test
    -- program.

    --
    -- Malfunctions are changing. Leave for documentation of original Rev C. Model
    --
    --    if Hot_Start and (This_Instance.Ng_Req_Prime > 27.0 and This_Instance.Ng_Req_Prime < 40.0) then
    --      Ng_Acc_Lim_Dot := 2.0*Ng_Acc_Lim_dot;
    --    elsif Slow_Start_Request and This_Instance.Ng_Req_Prime < 50.0 then
    --      Ng_Acc_Lim_Dot := 0.5*Ng_Acc_Lim_Dot;
    --    end if;


    -- The deceleration limit is modeled as a function of the requested speed:
    -- Ngdeclimdot = f(Ngreqnormlast) from table NGDDECLIM           (% /sec)
    -- where: Ngreqnormlast is the last pass value of Ngreqnorm from Step 19 below.

    Ng_Dec_Lim_Dot := Interpolation_Table.Singly_Indexed.Interpolate
--      ( Input => This_Instance.Ng_Req_Norm,
      ( Input => Ng_Req_Norm_Temp,
        Table => NGDDECLIM_Table'Access );

    -- The deceleration limit is modified somewhat during operation
    -- on the ground, to decelerate faster than the airborne
    -- schedule within a specific speed range:

    if Next_Instance.Flight_Mode then
      Ng_Dec_Lim_Dot_Prime := Ng_Dec_Lim_Dot;
    else
      Ng_Dec_Lim_Dot_Prime := Float'Min(-7.5,Ng_Dec_Lim_Dot);
    end if;


    -- Step 19.  Determine the rate of change of the speed request, including
    -- acceleration and deceleration limits from Step 18:

--    if Ng_Req_Double_Prime >= This_Instance.Ng_Req_Norm then
    if Ng_Req_Double_Prime >= Ng_Req_Norm_Temp then
      Ng_Req_Norm_Dot := Float'Min(Ng_Acc_Lim_Dot,
--                                   (Ng_Req_Double_Prime - This_Instance.Ng_Req_Norm)/Iconst); -- (%/sec)
                                   (Ng_Req_Double_Prime - Ng_Req_Norm_Temp)/Iconst); -- (%/sec)
    else
      Ng_Req_Norm_Dot := Float'Max(Ng_Dec_Lim_Dot_Prime,
--                                   (Ng_Req_Double_Prime - This_Instance.Ng_Req_Norm)/Iconst); -- (%/sec)
                                   (Ng_Req_Double_Prime - Ng_Req_Norm_Temp)/Iconst); -- (%/sec)
    end if;

    -- Then, integrate to obtain the "normal" rate-limited speed request:
    -- Ng_Req_Norm := Ng_Req_Norm_Last + Ng_Req_Norm_Dot * Iconst;  -- (%)
    --                where: Ng_req_norm_last is the last pass value of Ng_req_norm

--    Next_Instance.Ng_Req_Norm := This_Instance.Ng_Req_Norm + Ng_Req_Norm_Dot * Iconst;
    if This_Instance.Pmu_Reset then
      Next_Instance.Ng_Req_Norm := Ng_Req_Double_Prime;
    else
      Next_Instance.Ng_Req_Norm := Ng_Req_Norm_Temp + Ng_Req_Norm_Dot * Iconst;
    end if;

    -- Step 20.  Also calculate the "hot" rate-limited speed request,
    -- which rises faster and higher than the normal request during a
    -- large, sudden power demand under flat-rated conditions but is
    -- abruptly reset to the normal speed request as the engine power
    -- converges to within 1% of the requested gas generator speed.  Also
    -- select between the "hot" and "normal" requests to output the
    -- rate-limited gas generator speed request, Ng_req_prime :

    if (Ng_Req_Double_Prime - Next_Instance.Ng/K_Ng_Malfunction ) > 1.0 and Next_Instance.Ng >= 60.0 and Delta_Pla >=28.0  then
      Ng_Req_Hot_Dot := Float'Min(((Shp_Ng_Lim/Shp_Mrp)*Ng_Acc_Lim_Dot),
                                  ((Ng_Req_Double_Prime - This_Instance.Ng_Req_Hot)/Iconst)); --(%)
     if This_Instance.Pmu_Reset then
       Next_Instance.Ng_Req_Hot := Ng_Req_Double_Prime;
     else
       Next_Instance.Ng_Req_Hot := This_Instance.Ng_Req_Hot + Ng_Req_Hot_Dot*Iconst;
     end if;
     Next_Instance.Ng_Req_Prime := Next_Instance.Ng_Req_Hot;
    else
      Next_Instance.Ng_Req_Prime := Next_Instance.Ng_Req_Norm; -- (from Step 19) (%)
      Next_Instance.Ng_Req_Hot := Next_Instance.Ng_Req_Norm;
    end if;

    --   where: Ng_req_hot_last is the last pass value of Ng_req_hot

    -- Next, set the request to the lessor of the rate-limited
    -- value or the various limt values calculated in Step 12.

    if (Delta_Pla >= 28.0 and Next_Instance.Ng >= 50.0) then
      Next_Instance.Ng_Req_Prime := Float'Min(Next_Instance.Ng_Req_Prime, Float'Min(Ng_Req_Ng_Lim, Float'Min(Ng_Req_Itt_Lim, Ng_Req_Q_Lim))) - Delta_Ng_Seizure;
      Ng_Req_Prime := Next_Instance.Ng_Req_Prime;
--      Ada.Text_IO.Put("ng_req_prime = " & Float'Image(Next_Instance.Ng_Req_Prime));
--      Ada.Text_IO.Put("ng_req_ng_lim = " & Float'Image(Ng_Req_Ng_Lim));
--      Ada.Text_IO.Put("ng_req_itt_lim = " & Float'Image(Ng_Req_itt_lim));
--      Ada.Text_IO.Put("ng_req_q_lim = " & Float'Image(Ng_Req_q_lim));
    end if;

    -- Step 21.  Calculate the effective rate of change of the
    -- rate-limited speed request:
    if Iconst < 0.0001 then
      Ng_Req_Dot_Prime := 0.0;
    else
      Ng_Req_Dot_Prime := (Next_Instance.Ng_Req_Prime  - This_Instance.Ng_Req_Prime)/Iconst; --  (% / sec)
    end if;

    if Next_Instance.Pmu_On then

      -- Step 22.  Determine the effective PMU speed request, Ng_req,
      -- which differs from Ng_req_prime when the PMU has recently
      -- been switched on (the Manual to Auto mode transition) in
      -- order to ramp in the PMU power correction at a rate of 33.0
      -- shp/sec.  Also determine the effective gas generator
      -- acceleration request Ng_req_dot:
      --
      if This_Instance.Pmu_Reset then
        Next_Instance.Pmu_Transition_On := False;
      end if;

      if This_Instance.PMU_Transition_On then
        if not This_Instance.Pmu_On then
          Next_Instance.Delta_Pla_Transition_On := Delta_Pla;
        end if;

        if Shp_Pwr /= Shp then
          Next_Instance.Ng_33_Hp_Sec_Dot := 33.0* (Ng_Pwr - Next_Instance.Ng)/(Shp_Pwr - Shp); -- (% / sec)
        else
          Next_Instance.Ng_33_Hp_Sec_Dot := This_Instance.Ng_33_Hp_Sec_Dot;
        end if;

        -- ( Note: calculate only if SHP_pwr |= Shp; else use last calculated value.)

        if ((((Iconst * Next_Instance.Ng_33_Hp_Sec_Dot) < abs(Next_Instance.Ng_Req_Prime - This_Instance.Ng_Req))
            and (abs(Delta_Pla - Next_Instance.Delta_Pla_Transition_On) < 5.0)) ) then -- and not This_Instance.Pmu_Reset) then
          if ((Next_Instance.Ng_Req_Prime -
              This_Instance.Ng_Req)/Iconst) < 0.0 then
            Ng_Req_Dot := -1.0*Next_Instance.Ng_33_Hp_Sec_Dot;
          else
            Ng_Req_Dot := Next_Instance.Ng_33_Hp_Sec_Dot;
          end if;
          if This_Instance.Pmu_Reset then
            Next_Instance.Ng_Req := Ng_Req_Prime;
          else
            Next_Instance.Ng_Req := This_Instance.Ng_Req + Ng_Req_Dot * Iconst;  -- (%)
          end if;
        else
          Ng_Req_Dot := Ng_Req_Dot_Prime;
          Next_Instance.Ng_Req := Next_Instance.Ng_Req_Prime; -- (%)
          Next_Instance.PMU_Transition_On := False;
        end if;
      else
        Ng_Req_Dot := Ng_Req_Dot_Prime; --  (% / sec)
        Next_Instance.Ng_Req := Next_Instance.Ng_Req_Prime; --   (%)
      end if;

      -- Also arm the PMU transition off logical while the PMU_ON is
      -- in the true state.
      Next_Instance.PMU_Transition_Off := True;

      -- Step 23.  Calculate the steady state stepper motor position
      -- (SMP) request corresponding to the PMU speed request.  This
      -- SMP value yields the exact fuel flow required to achieve the
      -- PMU speed request under steady state conditions.  The
      -- calculation uses an engine model table, and the fuel metering
      -- valve table and the 3D cam table from the FMU model in section
      -- 11.3.2:
      --
      -- First, calculate the requested steady state fuel flow:

      Ng_C_Req_Adjusted := Next_Instance.Ng_Req / Theta_T**0.5 - Delta_Ng_C_Acc - Delta_Ng_C_Bleed;

      -- wf_c_ng_c_dot := table FFCNGC = f( Ng_c_req, Mach_pmu)
      Wf_C_Ng_C_Dot := Interpolation_Table.Doubly_Indexed.Interpolate
        ( X     => Float(Ng_C_Req_Adjusted),
          Y     => Float(Mach_Number),
          Table => FFCNGC_Table'Access );

      --      --   delta_wf_c_mach_dot := table DFFCMACH = f(Mach, Ng_c_req);
      --      Delta_Wf_C_Mach_Dot := Interpolation_Table.Doubly_Indexed.Interpolate
      --        ( X => Mach_Pmu,
      --          Y => Ng_C_Req,
      --          Table   => DFFCMACH_Table'Access );

      Wf_Req_Dot :=  Wf_C_Ng_C_Dot*Delta_T*Theta_T**0.1; -- (pph)

      -- Next calculate the corrected fuel flow commanded at the 3D
      -- cam in the fuel metering unit:

      Wf_C_3d_Req_Dot := (Wf_Req_Dot/K_Wf_Dot_Malfunction - 65.0)/K_Fmv_Delta;

      -- where:  K_Fmv_Delta is the most recent value calculated in Step 4 of section 11.3.2

      -- Finally, determine the stepper motor position that will, in
      -- combination with the power lever angle, yield the steady state
      -- requested fuel flow:

      --  Wf_C_3d_169_Dot := Table FF3DCAM at SMP=169;

      Wf_C_3d_169_Dot := Interpolation_Table.Doubly_Indexed.Interpolate
        ( X => Float(Delta_Pla_Prime),
          Y => Float(169.0),
          Table   => FF3DCAM_Table'Access );


      if Wf_C_3d_Req_Dot <= Wf_C_3d_169_Dot then

        Wf_C_3d_0_Dot := Interpolation_Table.Doubly_Indexed.Interpolate
          ( X => Float(Delta_Pla_Prime),
            Y => Float(0.0),
            Table   => FF3DCAM_Table'Access );

        Next_Instance.Smp_Req_Ss := Float'Max(0.0,Float'Min(338.0,(169.0 * (Wf_C_3d_Req_Dot - Wf_C_3d_0_Dot)/
          (Wf_C_3d_169_Dot - Wf_C_3d_0_Dot))));
        -- wf_c_3d_0_dot  from Fuel Metering Unit table FF3DCAM
      else
        Wf_C_3d_338_Dot := Interpolation_Table.Doubly_Indexed.Interpolate
          ( X => Float(Delta_Pla_Prime),
            Y => Float(338.0),
            Table   => FF3DCAM_Table'Access );

        Next_Instance.Smp_Req_Ss := Float'Max(0.0, Float'Min(338.0,(169.0 + 169.0 * (Wf_C_3d_Req_Dot - Wf_C_3d_169_Dot)/
          (Wf_C_3d_338_Dot - Wf_C_3d_169_Dot))));

        -- wf_c_3d_338_dot  from Fuel Metering Unit table FF3DCAM
      end if;

      -- Step 24.  Calculate the stepper motor position request
      -- for Auto mode (PMU_ON true) operation.  During gas
      -- generator acceleration or deceleration, this position
      -- is generated by feedback of the error between
      -- requested and actual gas generator speeds and
      -- accelerations.  Otherwise, the position reverts to the
      -- exact steady state position generated in Step 23:

      K_Epsilon_Ng := Float'Min(7.0, Float'Max(3.0,0.0004*Adc_Pressure_Altitude_Corrected - 1.0));
      K_Epsilon_Ng_Dot := Float'Min(7.0, Float'Max(3.0,(26.75 - 0.25*Next_Instance.Ng_Req)));
      Ng_Dot := (Next_Instance.Ng - This_Instance.Ng)/Iconst;

      if Delta_Pla < 10.0 then
        Next_Instance.Smp_Req := 0.0;
      elsif abs(Ng_Req_Dot) > 1.0  then
        Smp_Req_Dot := K_Epsilon_Ng * (Next_Instance.Ng_Req - Next_Instance.Ng/K_Ng_malfunction)
          + K_Epsilon_Ng_Dot * (Ng_Req_Dot - Ng_Dot);
        Next_Instance.Smp_Req := This_Instance.Smp_Req + Smp_Req_Dot*Iconst;
      elsif (Next_Instance.Ng_Req > Next_Instance.Ng) and (Next_Instance.Ng_Req >= 70.0) then
        Next_Instance.Smp_Req := Float'Min(Next_Instance.Smp_Req_Ss,This_Instance.Smp_Req + (This_Instance.Smp_Req_Ss - This_Instance.Smp_Req) * Iconst/2.0);
      else
        Next_Instance.Smp_Req := Next_Instance.Smp_Req_Ss;
      end if;

      Next_Instance.Smp_Req := Float'Max(0.0, Float'Min(338.0, Next_Instance.Smp_Req));

      Next_Instance.Pmu_Off_Timer := 0.0;
    else -- Pmu On = false below

      -- This step actually should be in the cam_reset loop of the
      -- fuel metering unit.  If implemented in the fmu the cam
      -- reset solenoid activatesWhen Pmu_On is false then cam_reset solenoid
      -- is deenergized and this code executes.

      -- Step 25. Calculate the stepper motor position request for
      -- the Manual mode (PMU_ON = false) state.  The transition from
      -- Auto mode to Manual mode operation is characterized by a
      -- delay of approximately one second, following which the
      -- stepper motor ramps to a final value of 169 at the rate of
      -- approximately 100 steps/sec:
      -- Note:  This entire step is executed only if PMU_ON = false.
      if This_Instance.Pmu_Reset then
        Next_Instance.Pmu_Off_Timer := 1000.0;
      else
        Next_Instance.Pmu_Off_Timer := Float'Min(1000.0,This_Instance.Pmu_Off_Timer + Iconst);
      end if;

      if This_Instance.PMU_Transition_Off then
        if Next_Instance.Pmu_Off_Timer < 1.0 then
          Smp_Req_Dot := 0.0;
        else
          if (100.0*Iconst) < abs(Next_Instance.Smp_Req - 169.0) then
            if (169.0 - Next_Instance.Smp_Req)/Iconst > 0.0 then
              Smp_Req_Dot := 100.0;
            else
              Smp_Req_Dot := -100.0;
            end if;
          else
            Smp_Req_Dot := (169.0 - Next_Instance.Smp_Req)/Iconst;
            Next_Instance.PMU_Transition_Off := False;  -- (transition is complete)
          end if;
        end if;
      else
        Smp_Req_Dot := 0.0;
      end if;
      if This_Instance.Pmu_Reset then
        Next_Instance.Smp_Req := 169.0;
      else
        Next_Instance.Smp_Req :=  This_Instance.Smp_Req + Smp_Req_Dot*Iconst;
      end if;
      Next_Instance.Smp_Req := Float'Max(0.0, Float'Min(338.0, Next_Instance.Smp_Req));

      -- Also arm the PMU transition on logical while the PMU_ON is
      -- in the false state and set the requested gas generator
      -- speed equal to the current speed to achieve a smooth
      -- transition when the PMU is switched back on:
      Next_Instance.PMU_Transition_On := True;
      Next_Instance.Ng_Req := Next_Instance.Ng;

    end if;  -- End of Pmu On logic starting at step 22.

    -- Write the smp_req out to the interface.  Smp_req is a float
    -- while stepper_motor_position_demanded is a sub_type of integer.
    Next_Instance.Stepper_Motor_Position_Demanded := Jpats_Powerplant_Types.Step_Type(Next_Instance.Smp_Req);
    Smp_Req := Next_Instance.Smp_Req;
    Smp_Req_Ss := Next_Instance.Smp_Req_Ss;

    -- Step 26.  Calculate the propeller RPM request to the Propeller
    -- Interface Unit.  This request is normally 2000 RPM.  But,
    -- during certain conditions of rapid engine acceleration while
    -- RPM control is restricted by the low pitch blade stop, the PMU
    -- acts through the RPM request to advance blade pitch sooner and
    -- so provide a more jet-like thrust rise while limiting RPM
    -- overshoots.  This Rpm request is also used to command the
    -- propeller out of feather and control Rpm rise following
    -- startup with the Pmu operative.  This PMU control function is
    -- simulated as follows:

    -- This_Instance.Rpm_Req is the last pass value of Rpm_Req
    if Next_Instance.Np < 1500.0/20.0 then
      if Next_Instance.Ng >= 58.0 and Delta_Pla > 8.0 then -- control the prop out of feather;
          Auto_Feather := False;
          if This_Instance.Pmu_Reset then
            Next_Instance.Unfeather_Control_Timer := 15.0;
          else
            Next_Instance.Unfeather_Control_Timer := Float'Min(15.0,(This_Instance.Unfeather_Control_Timer + Iconst));
          end if;
          if Next_Instance.Flight_Mode then
            if This_Instance.Pmu_Reset then
              Next_Instance.Rpm_Req := 2000.0;
            else
              Next_Instance.Rpm_Req := Float'Min (2000.0,(Next_Instance.Rpm_Req + 100.0* Iconst));
            end if;
          else
            if Next_Instance.Unfeather_Control_Timer > 10.0 or This_Instance.Pmu_Reset then
              Next_Instance.Rpm_Req := 2000.0;
            else
              Next_Instance.Rpm_Req := Float'Min (2000.0, (Next_Instance.Rpm_Req + 30.0*Iconst));
            end if;
          end if;
      else
        Next_Instance.Unfeather_Control_Timer := 0.0;
        Next_Instance.Rpm_Req := Next_Instance.Np*20.0;
      end if;
    elsif Next_Instance.Np < 1950.0/20.0 then
      Rpm_Req_Prime := 2000.0 - 28.0*(Next_Instance.Ng_Req_Hot - Next_Instance.Ng_Req_Norm);
      if (Next_Instance.Np > Rpm_Req_Prime/20.0 or
        ((Rpm_Req_Prime - This_Instance.Rpm_Req)/Iconst) >= 200.0) and not This_Instance.Pmu_Reset then
        Next_Instance.Rpm_Req := This_Instance.Rpm_Req + 200.0*Iconst;
      else
        Next_Instance.Rpm_Req := Rpm_Req_Prime;
      end if;
    else
      if This_Instance.Pmu_Reset then
        Next_Instance.Rpm_Req := 2000.0;
      else
        Next_Instance.Rpm_Req := Float'Min(2000.0,This_Instance.Rpm_Req + 100.0*Iconst); -- (rev/min)
      end if;
    end if;
--    if Quick_Start then
--      Next_Instance.Rpm_Req := Rpm_Req_Prime;
--      Auto_Feather := False;
--      Next_Instance.Unfeather_Control_Timer := 15.0;
--    end if;

    -- Step 27.  When ON, the PMU control activation of the ignition
    -- system.  During normal PMU On operation, when a rate of gas
    -- generator deceleration of 2.67% /sec ( 1000 rpm/sec) or
    -- greater is sensed for 0.05 seconds or longer, the ignition
    -- system is activated as a precaution against flame out.  When
    -- starting, the ignition system is activated at the
    -- commencement of the start and is deactivated when Ng exceeds
    -- 49%.  During normal shutdowns, the ignitors are activated
    -- above 39% Ng to burn purged fuel unless the start is
    -- automatically aborted, in which case the ignition if Off.
    if not Next_Instance.Pmu_On then
      Auto_Ignitors_On := False;
    else

      if Ng_Dot < -2.67 then  -- %/sec
        if This_Instance.Pmu_Reset then
          Next_Instance.Ng_Decel_Timer := 0.0;
        else
          Next_Instance.Ng_Decel_Timer := Float'Min(1.0,This_Instance.Ng_Decel_Timer + Iconst);
        end if;
      else
        Next_Instance.Ng_Decel_Timer := 0.0;
      end if;

      if Next_Instance.Auto_Shutdown or (Delta_Pla < 10.0 and not This_Instance.Monitored_Start) then
        Auto_Ignitors_On :=  Next_Instance.Ng > 39.0 and not Next_Instance.Start_Abort;
      elsif Next_Instance.Auto_Start or This_Instance.Monitored_Start then
        if Next_Instance.Ng < 47.0 then
          Auto_Ignitors_On := True;
        elsif Next_Instance.Ng > 50.0 then -- bump up from 49.0 to 50.0 based on pilot comment
          Auto_Ignitors_On := False;
        end if;
      else
        Auto_Ignitors_On := Next_Instance.Ng_Decel_Timer > 0.05;
      end if;
    end if;

    -- The equation in comments should be the actual finished
    -- equation for blade angle if PIU had a transfer function of
    -- unity.  According to PMU non engaged conditions the PIU
    -- essentially has a transfer function corresponding to
    -- 0.145(Prop_rpm - Prop_Rpm_req).  So, this amount is
    -- subtracted from the equation below.  Then the same amount
    -- is added back in the PIU code.  This successfully decouples the
    -- PMU from the PIU operation making the PMU and PIU code more
    -- reusable.

    -- Blade_Angle_Rate_Req := 0.8*(Prop_Rpm(Vector_Types.X) - Rep_Req)
    --      + 0.05*Prop_Rpm_Dot; -- (deg/sec)

    -- When the power control lever commands a shutdown by moving
    -- the power control lever from idle to cutoff, the pmu send a
    -- feather signal via the trim motor to the Piu.  This has the effect
    -- of feathering the prop eventhough the Manual Feather Circuit is
    -- disabled by pulling the Prop_Sys circuit breaker.
    if Delta_Pla < 10.0 then
       Auto_Feather := True;
    end if;

    if Auto_Feather then
        Next_Instance.Pmu_Blade_Angle_Rate := 25.0; --  - 0.145 * (Next_Instance.Np*20.0 - Next_Instance.Rpm_Req);
      else
--        if this_instance.pmu_reset then
--          Next_Instance.Pmu_Blade_Angle_Rate := 0.0;
--        else
          Next_Instance.PMU_Blade_Angle_Rate := (Pmu_On_Prop_Proportional_Gain*(Next_Instance.Np*20.0 - Next_Instance.Rpm_Req)
                                                 + Pmu_On_Prop_Differential_Gain*Next_Instance.Np_Dot*20.0)*Float'Min(1.0,(1.42-1.2*Mach_Number)); -- (deg/sec)
--        end if;
      end if;
--    else
--      Next_Instance.Pmu_Blade_Angle_Rate := pmu_off_prop_gain*(Next_Instance.Np*20.0 - Next_Instance.Rpm_Req);
--    end if;



    -- Next, The blade pitch rate is limited.  the minimum limit provides
     -- a realistic unfeathering rate for both automatic (i.e. pmu
     -- controlled) unfeathering and for natural (i.e. following manual
     -- mode starts with pmu off) unfeathering as rising piu oil pressure
     -- overcomes the feathering spring:

    Next_Instance.Pmu_Blade_Angle_Rate :=
      Angle_Types.Degrees_Per_Sec'Max(-6.7, Angle_Types.Degrees_Per_Sec'Min
                                      ( 25.0, Next_Instance.Pmu_Blade_Angle_Rate));


    if This_Instance.Pmu_Reset then
      Next_Instance.Pmu_Reset := False;
    end if;

    for Channel in A429.Channel_A .. A429.Channel_B loop

      -- Torque
  Label_336:
             declare
               Output                 : Torque_Types.Ft_Lbf;
               SSM                    : Arinc_429_Types.Bnr_Ssm_Type;
             begin
               Power_Turbine_Torque_Percent := Power_Turbine_Torque/28.89;  -- 2889 ft-lbs = 100%
               -- Set Ouput label
               if Power_Turbine_Torque_Percent >= 256.0 then
                 Output := 256.0;
               elsif Power_Turbine_Torque_Percent <= 0.0 then
                 Output := 0.0;
               else
                 if Power_Turbine_Torque_Percent > 99.0 and Power_Turbine_Torque_Percent < 101.0 then
                   Output := 100.0;
                 else
                   Output := Power_Turbine_Torque_Percent;
                 end if;
               end if;

               -- set SSM bits
               if Next_Instance.PMU_Arinc_Fail then
                 Ssm := Arinc_429_Types.Failure;
               elsif Next_Instance.PMU_Test then
                 Ssm := Arinc_429_Types.Functional_Test;
               elsif Power_Turbine_Torque_Percent > 256.0 or Power_Turbine_Torque_Percent < -256.0 then
                 Ssm := Arinc_429_Types.No_Computed_Data;
               else
                 Ssm := Arinc_429_Types.Normal;
               end if;

               Next_Instance.A429_TX_PMU_336_Torque(Channel) :=
                 A429.Label_336.Pack
                 ( A_Value           => Output,
                   A_Sdi             => Channel,
                   A_Ssm             => Ssm,
                   A_Discretes_Value => No_Discretes);

             end Label_336;
             ----------------------------------------
             -- N1
         Label_344 :
             declare
               Output                 : Normalized_Types.Normalize;
               Ssm                    : Arinc_429_Types.Bnr_Ssm_Type;
             begin
               -- Set Ouput label
               if Next_Instance.Ng >= 255.9844 then
                 Output := 255.9844;
               elsif Next_Instance.Ng <= 8.0 then
                 Output := 0.0;
               else
                 --              Output := 86.0;
                  if Next_Instance.Ng < 60.5 and Next_Instance.Ng >=59.6 then
                     Output := 60.0;
                  else
                     Output := Next_Instance.Ng;
                  end if;
               end if;

               -- set SSM bits
               if Next_Instance.Pmu_Arinc_Fail then
                 Ssm := Arinc_429_Types.Failure;
               elsif Next_Instance.PMU_Test then
                 Ssm := Arinc_429_Types.Functional_Test;
               elsif Next_Instance.Ng > 255.9844 or Next_Instance.Ng < 0.0 then
                 Ssm := Arinc_429_Types.No_Computed_Data;
               else
                 Ssm := Arinc_429_Types.Normal;
               end if;

               Next_Instance.A429_TX_PMU_344_N1(Channel) :=
                 A429.Label_344.Pack
                 ( A_Value           => Output,
                   A_Sdi             => Channel,
                   A_Ssm             => Ssm,
                   A_Discretes_Value => No_Discretes);

             end Label_344;
             ----------------------------------------
             -- ITT
         Label_345 :
            declare
              Output                 : Temperature_Types.Celsius;
              Ssm                    : Arinc_429_Types.Bnr_Ssm_Type;
            begin
              -- Set Ouput label
              if Itt >= 2047.5 then
                Output := Temperature_Types.Celsius(2047.5);
              elsif Itt <= 0.0 then
                Output := Temperature_Types.Celsius(0.0);
              else
                Output := Itt;
              end if;

              --            Output := Temperature_Types.Celsius(100.0);
              -- set SSM bits
              if Next_Instance.Pmu_Arinc_Fail then
                Ssm := Arinc_429_Types.Failure;
              elsif Next_Instance.Pmu_Test then
                Ssm := Arinc_429_Types.Functional_Test;
              elsif Itt > 2047.5 or Itt < 0.0 then
                Ssm := Arinc_429_Types.No_Computed_Data;
              else
                Ssm := Arinc_429_Types.Normal;
              end if;

              Next_Instance.A429_TX_PMU_345_Itt(Channel) :=
                A429.Label_345.Pack
                ( A_Value           => Output,
                  A_Sdi             => Channel,
                  A_Ssm             => Ssm,
                  A_Discretes_Value => No_Discretes);

            end Label_345;
            ----------------------------------------
            -- Np
        Label_346 :
          declare
            Output                 : Normalized_Types.Normalize;
            Ssm                    : Arinc_429_Types.Bnr_Ssm_Type;
          begin
            -- Set Ouput label
            if Next_Instance.Np >= 255.4844 then
              Output := 255.9844;
            elsif Next_Instance.Np  <= 0.0 then
              Output := 0.0;
            else
              Output := Next_Instance.Np + 0.5;
            end if;

            -- set SSM bits
            if Next_Instance.Pmu_Arinc_Fail then
              Ssm := Arinc_429_Types.Failure;
            elsif Next_Instance.Pmu_Test then
              Ssm := Arinc_429_Types.Functional_Test;
            elsif Next_Instance.Np > 255.9844 or Next_Instance.Np < 0.0 then
              Ssm := Arinc_429_Types.No_Computed_Data;
            else
              Ssm := Arinc_429_Types.Normal;
            end if;

            Next_Instance.A429_TX_PMU_346_Np(Channel) :=
              A429.Label_346.Pack
              ( A_Value           => Output,
                A_Sdi             => Channel,
                A_Ssm             => Ssm,
                A_Discretes_Value => No_Discretes);
          end Label_346;
          ----------------------------------------
          -- PLA
      Label_134 :
          declare
            Output                 : Angle_Types.Degrees;
            Ssm                    : Arinc_429_Types.Bnr_Ssm_Type;
          begin
            -- Set Ouput label
            if Delta_Pla >= 120.0  then
              Output := 120.0;
            elsif Delta_pla <= 0.0 then
              Output := 0.0;
            else
              Output := Delta_Pla;
            end if;

            -- set SSM bits
            if Next_Instance.Pmu_Arinc_Fail then
              Ssm := Arinc_429_Types.Failure;
            elsif Next_Instance.Pmu_Test then
              Ssm := Arinc_429_Types.Functional_Test;
            elsif Delta_Pla > 150.0 or Delta_Pla < -5.0 then
              Ssm := Arinc_429_Types.No_Computed_Data;
            else
              Ssm := Arinc_429_Types.Normal;
            end if;

            Next_Instance.A429_TX_PMU_134_Pla(Channel) :=
              A429.Label_134.Pack
              ( A_Value           => Output,
                A_Sdi             => Channel,
                A_Ssm             => Ssm,
                A_Discretes_Value => No_Discretes);

          end Label_134;
          ----------------------------------------
          -- Outside Air Temperature
      Label_130 :
          declare
            Output                 : Temperature_Types.Celsius;
            Ssm                    : Arinc_429_Types.Bnr_Ssm_Type;
          begin
            -- Set Ouput label
            if Total_Inlet_Temperature_T1_Hi >= 127.9688 then
              Output := 127.9688;
            elsif Total_Inlet_Temperature_T1_Hi <= -128.0 then
              Output := -128.0;
            else
              Output := Total_Inlet_Temperature_T1_Hi;
            end if;

            -- set SSM bits
            if Next_Instance.Pmu_Arinc_Fail then
              Ssm := Arinc_429_Types.Failure;
            elsif Next_Instance.Pmu_Test then
              Ssm := Arinc_429_Types.Functional_Test;
            elsif Total_Inlet_Temperature_T1_Hi > 128.0 or Total_Inlet_Temperature_T1_Hi < -128.0 then
              Ssm := Arinc_429_Types.No_Computed_Data;
            else
              Ssm := Arinc_429_Types.Normal;
            end if;

            Next_Instance.A429_TX_PMU_130_Outside_Air_Temperature(Channel) :=
              A429.Label_130.Pack
              ( A_Value           => Output,
                A_Sdi             => Channel,
                A_Ssm             => Ssm,
                A_Discretes_Value => No_Discretes);
          end Label_130;

    end loop;
    if Next_Instance.Record_Debug_Information then
      declare
        Pmu_On_Label : String := "pmu_on";
        Left_Weight_On_Wheels_Label : String := "Left_Weight_On_Wheels";
        Right_Weight_On_Wheels_Label : String := "Right_Weight_On_Wheels";
        Flight_Mode_Label : String := "flight_mode";
        Start_Toggle_Label : String := "start_toggle";
        Pla_At_20_Label    : String := "pla_at_20";
        Pla_To_18_Label    : String := "pla_to_18";
        Auto_start_Ready_Label : String := "auto_start_ready";
        Monitored_start_Ready_Label : String := "monitored_start_ready";
        Auto_start_Label : String := "auto_start";
        Monitored_start_Label : String := "monitored_start";
        Auto_Starter_On_Label : String := "auto_starter_on";
        Auto_Ignitors_On_Label : String := "auto_ignitors_on";
        Shutdown_Label : String := "shutdown";
        Auto_Shutdown_Label : String := "auto_shutdown";
        Auto_feather_Label : String := "auto_feather";
        Min_Rpm_Loop_Arm_Label : String := "Min_rpm_loop_arm";
        Pmu_Transition_On_Label   : String := "pmu_transition_on";
        Pmu_Transition_Off_Label  : String := "pmu_transition_off";
        Hot_Start_Label  : String := "hot_start";
        Mach_Pmu_Label : String := "mach_pmu";
        Ng_G_Spd_Label : String := "ng_g_spd";
        Ng_F_Spd_Label : String := "ng_f_spd";
        Ng_Spd_Label : String := "ng_spd";
        Ng_G_idle_Label : String := "ng_g_idle";
        Ng_F_idle_Label : String := "ng_f_idle";
        Shp_Ng_Lim_Label : String := "shp_ng_lim";
        Shp_itt_Lim_Label : String := "shp_itt_lim";
        Shp_q_Lim_Label : String := "shp_q_lim";
        Shp_mrp_Label : String := "shp_mrp";
        Shp_pwr_Label : String := "shp_pwr";
        Ng_pwr_Label : String := "ng_pwr";
        Delta_Ng_Label : String := "delta_ng";
        Delta_Ng_Dyn_Label : String := "delta_ng_dyn";
        Ng_Spd_Dyn_Label : String := "ng_spd_dyn";
        Ng_Req_Triple_Prime_Label : String := "Ng_Req_Triple_Prime";
        Delta_Ng_Min_Rpm_Label : String := "Delta_Ng_Min_Rpm";
        Ng_Req_Double_prime_Label : String := "Ng_req_double_prime";
        Ng_Req_Hot_Double_prime_Label : String := "Ng_req_hot_double_prime";
        Ng_Dot_Acc_Lim_Label : String := "Ng_dot_acc_lim";
        Ng_Dot_Dec_Lim_Prime_Label : String := "Ng_dot_dec_lim_prime";
        Ng_Dot_Req_Norm_Label : String := "Ng_dot_req_norm";
        Ng_Req_Norm_Label : String := "Ng_req_norm";
        Ng_Dot_Req_Hot_Label : String := "Ng_dot_req_hot";
        Ng_Req_Hot_Label : String := "Ng_req_hot";
        Ng_Req_prime_Label : String := "Ng_req_prime";
        Ng_dot_req_Label : String := "Ng_dot_req";
        Ng_req_Label : String := "Ng_req";
        Wf_Dot_Req_Label : String := "wf_dot_req";
        Smp_Req_Ss_Label : String := "smp_req_ss";
        Smp_Req_Label : String := "smp_req";
        Rpm_Req_Label : String := "rpm_req";
        Pmu_Blade_Angle_Rate_Label : String := "pmu_blade_angle_rate";
        Delta_Pla_Prime_Label : String := "Delta_Pla_Prime";
        Delta_Pla_Label : String := "Delta_Pla";
        Np_Dot_Label    : String := "Np_Dot_from_Pmu*20.0";
        Temp : Float;

      begin
        String'Output(Next_Instance.Debug_Stream, Pmu_On_Label);
        Temp := Float(Boolean'Pos(Next_Instance.Pmu_On));
        Float'Output(Next_Instance.Debug_Stream, Temp);

        String'Output(Next_Instance.Debug_Stream, Left_Weight_On_Wheels_Label);
        Temp := Float(Boolean'Pos(Left_Weight_On_Wheels));
        Float'Output(Next_Instance.Debug_Stream, Temp);

        String'Output(Next_Instance.Debug_Stream, Right_Weight_On_Wheels_Label);
        Temp := Float(Boolean'Pos( Right_Weight_On_Wheels));
        Float'Output(Next_Instance.Debug_Stream, Temp);

        String'Output(Next_Instance.Debug_Stream, Flight_Mode_Label);
        Temp := Float(Boolean'Pos(Next_Instance.Flight_Mode ));
        Float'Output(Next_Instance.Debug_Stream, Temp);

        String'Output(Next_Instance.Debug_Stream, Start_Toggle_Label);
        Temp := Float(Boolean'Pos(Start_Toggle));
        Float'Output(Next_Instance.Debug_Stream, Temp);

        String'Output(Next_Instance.Debug_Stream, Pla_At_20_Label);
        Temp := Float(Boolean'Pos(Next_Instance.Pla_At_20_Degrees ));
        Float'Output(Next_Instance.Debug_Stream, Temp);

        String'Output(Next_Instance.Debug_Stream, Pla_To_18_Label);
        Temp := Float(Boolean'Pos(Pla_to_18));
        Float'Output(Next_Instance.Debug_Stream, Temp);

        String'Output(Next_Instance.Debug_Stream, Auto_Start_Ready_Label);
        Temp := Float(Boolean'Pos(Next_Instance.Auto_start_Ready ));
        Float'Output(Next_Instance.Debug_Stream, Temp);

        String'Output(Next_Instance.Debug_Stream, Monitored_start_Ready_Label);
        Temp := Float(Boolean'Pos(Next_Instance.monitored_start_Ready ));
        Float'Output(Next_Instance.Debug_Stream, Temp);

        String'Output(Next_Instance.Debug_Stream, Auto_start_Label);
        Temp := Float(Boolean'Pos(Next_Instance.Auto_start ));
        Float'Output(Next_Instance.Debug_Stream, Temp);

        String'Output(Next_Instance.Debug_Stream, Monitored_start_Label);
        Temp := Float(Boolean'Pos(Next_Instance.monitored_start ));
        Float'Output(Next_Instance.Debug_Stream, Temp);

        String'Output(Next_Instance.Debug_Stream, Auto_Starter_On_Label);
        Temp := Float(Boolean'Pos(Next_Instance.Start ));
        Float'Output(Next_Instance.Debug_Stream, Temp);

        String'Output(Next_Instance.Debug_Stream, Auto_Ignitors_On_Label);
        Temp := Float(Boolean'Pos(Auto_Ignitors_on));
        Float'Output(Next_Instance.Debug_Stream, Temp);

        String'Output(Next_Instance.Debug_Stream, Auto_Shutdown_Label );
        Temp := Float(Boolean'Pos(Next_Instance.auto_shutdown));
        Float'Output(Next_Instance.Debug_Stream, Temp);

        String'Output(Next_Instance.Debug_Stream, Shutdown_Label);
        Temp := Float(Boolean'Pos(Next_Instance.Shutdown));
        Float'Output(Next_Instance.Debug_Stream, Temp);

        String'Output(Next_Instance.Debug_Stream, Auto_Feather_Label);
        Temp := Float(Boolean'Pos(Auto_Feather));
        Float'Output(Next_Instance.Debug_Stream, Temp);

        String'Output(Next_Instance.Debug_Stream, Min_Rpm_Loop_Arm_Label);
        Temp := Float(Boolean'Pos(Next_Instance.Min_Rpm_Loop_Arm ));
        Float'Output(Next_Instance.Debug_Stream, Temp);

        String'Output(Next_Instance.Debug_Stream, Pmu_Transition_On_Label);
        Temp := Float(Boolean'Pos(Next_Instance.Pmu_Transition_on ));
        Float'Output(Next_Instance.Debug_Stream, Temp);

        String'Output(Next_Instance.Debug_Stream, Pmu_Transition_Off_Label);
        Temp := Float(Boolean'Pos(Next_Instance.Pmu_Transition_Off ));
        Float'Output(Next_Instance.Debug_Stream, Temp);

        String'Output(Next_Instance.Debug_Stream, Hot_Start_Label);
        Temp := Float(Boolean'Pos(Hot_Start));
        Float'Output(Next_Instance.Debug_Stream, Temp);

        String'Output(Next_Instance.Debug_Stream, Mach_pmu_Label);
        float'Output(Next_Instance.Debug_Stream, Mach_pmu);
        String'Output(Next_Instance.Debug_Stream, Ng_G_Spd_Label);
        Float'Output(Next_Instance.Debug_Stream, Ng_G_Spd);
        String'Output(Next_Instance.Debug_Stream, Ng_F_Spd_Label);
        Float'Output(Next_Instance.Debug_Stream, Ng_F_Spd);
        String'Output(Next_Instance.Debug_Stream, Ng_Spd_Label);
        Float'Output(Next_Instance.Debug_Stream, Next_Instance.Ng_Spd);
        String'Output(Next_Instance.Debug_Stream, Ng_G_Idle_Label);
        Float'Output(Next_Instance.Debug_Stream, Ng_G_Idle);
        String'Output(Next_Instance.Debug_Stream, Ng_F_Idle_Label);
        Float'Output(Next_Instance.Debug_Stream, Ng_F_Idle);
        String'Output(Next_Instance.Debug_Stream, Shp_Ng_lim_Label);
        Float'Output(Next_Instance.Debug_Stream, Shp_Ng_lim);
        String'Output(Next_Instance.Debug_Stream, Shp_itt_lim_Label);
        Float'Output(Next_Instance.Debug_Stream, Shp_itt_lim);
        String'Output(Next_Instance.Debug_Stream, Shp_q_lim_Label);
        Float'Output(Next_Instance.Debug_Stream, Shp_q_lim);
        String'Output(Next_Instance.Debug_Stream, Shp_Mrp_Label);
        Float'Output(Next_Instance.Debug_Stream, Shp_Mrp);
        String'Output(Next_Instance.Debug_Stream, Shp_pwr_Label);
        Float'Output(Next_Instance.Debug_Stream, Shp_pwr);
        String'Output(Next_Instance.Debug_Stream, ng_pwr_Label);
        Float'Output(Next_Instance.Debug_Stream, ng_pwr);
        String'Output(Next_Instance.Debug_Stream, Delta_ng_Label);
        Float'Output(Next_Instance.Debug_Stream, Next_Instance.Delta_Ng);
        String'Output(Next_Instance.Debug_Stream, Delta_Ng_Dyn_Label);
        Float'Output(Next_Instance.Debug_Stream, Next_Instance.Delta_Ng_Dyn);
        String'Output(Next_Instance.Debug_Stream, Ng_Spd_Dyn_Label);
        Float'Output(Next_Instance.Debug_Stream, Ng_Spd_Dyn);
        String'Output(Next_Instance.Debug_Stream, Ng_Req_Triple_Prime_Label);
        Float'Output(Next_Instance.Debug_Stream, Ng_Req_Triple_Prime);
        String'Output(Next_Instance.Debug_Stream, Delta_Ng_Min_Rpm_Label);
        Float'Output(Next_Instance.Debug_Stream, Delta_Ng_Min_Rpm);
        String'Output(Next_Instance.Debug_Stream, Ng_Req_Double_prime_Label);
        Float'Output(Next_Instance.Debug_Stream, Ng_Req_Double_Prime);
--      String'Output(Next_Instance.Debug_Stream, Ng_Req_Hot_Double_prime_Label);
--      Float'Output(Next_Instance.Debug_Stream, Ng_Req_Hot_Double_prime);
        String'Output(Next_Instance.Debug_Stream, Ng_Dot_Acc_lim_Label);
        Float'Output(Next_Instance.Debug_Stream, Ng_Acc_Lim_Dot);
        String'Output(Next_Instance.Debug_Stream, Ng_Dot_Dec_Lim_Prime_Label);
        Float'Output(Next_Instance.Debug_Stream, Ng_Dec_Lim_Dot_Prime);
        String'Output(Next_Instance.Debug_Stream, Ng_Dot_Req_Norm_Label);
        Float'Output(Next_Instance.Debug_Stream, Ng_req_norm_dot);
        String'Output(Next_Instance.Debug_Stream, Ng_Req_Norm_Label);
        Float'Output(Next_Instance.Debug_Stream, Next_Instance.Ng_req_norm);
        String'Output(Next_Instance.Debug_Stream, Ng_dot_Req_Hot_Label);
        Float'Output(Next_Instance.Debug_Stream, Ng_req_hot_dot);
        String'Output(Next_Instance.Debug_Stream, Ng_Req_Hot_Label);
        Float'Output(Next_Instance.Debug_Stream, Next_Instance.Ng_req_hot);
        String'Output(Next_Instance.Debug_Stream, Ng_Req_prime_Label);
        Float'Output(Next_Instance.Debug_Stream, Next_Instance.Ng_req_prime);
        String'Output(Next_Instance.Debug_Stream, Ng_dot_Req_Label);
        Float'Output(Next_Instance.Debug_Stream, Ng_Req_Dot);
        String'Output(Next_Instance.Debug_Stream, Ng_Req_Label);
        Float'Output(Next_Instance.Debug_Stream, Next_Instance.Ng_Req);
        String'Output(Next_Instance.Debug_Stream, wf_dot_Req_Label);
        Float'Output(Next_Instance.Debug_Stream, wf_req_dot);
        String'Output(Next_Instance.Debug_Stream, Smp_Req_Ss_Label);
        Float'Output(Next_Instance.Debug_Stream, Next_Instance.smp_req_ss);
        String'Output(Next_Instance.Debug_Stream, Smp_Req_Label);
        Float'Output(Next_Instance.Debug_Stream, Next_Instance.Smp_req);
        String'Output(Next_Instance.Debug_Stream, rpm_Req_Label);
        Float'Output(Next_Instance.Debug_Stream, Next_Instance.rpm_req);
        String'Output(Next_Instance.Debug_Stream, pmu_blade_angle_rate_Label);
        Float'Output(Next_Instance.Debug_Stream, Next_Instance.Pmu_Blade_Angle_Rate);
        String'Output(Next_Instance.Debug_Stream, Delta_Pla_Label);
        Float'Output(Next_Instance.Debug_Stream, Delta_Pla);
        String'Output(Next_Instance.Debug_Stream, Delta_Pla_Prime_Label);
        Float'Output(Next_Instance.Debug_Stream, Delta_Pla_Prime);
        String'Output(Next_Instance.Debug_Stream, Np_Dot_Label);
        Temp := Next_Instance.Np_Dot*20.0;
        Float'Output(Next_Instance.Debug_Stream, Temp);

     end;
    end if;
  end Powered_Update;

  -- Method Update
  procedure Update
    (Next_Instance                             : in out Instance;
     This_Instance                             : in     Instance;
     Iconst                                    : in     Float;
     Bleed_Air_On                              : in     Boolean;                               -- Pin Y   -- Cabin_Bleed            Interface_J2_Pin_Y;
     Left_Weight_On_Wheels                     : in     Boolean;                               -- Pin_FF  -- Wow_Left               Interface_J2_Pin_F*;
     PMA_A                                     : in     Boolean;                               -- Pin_A   -- Pma_A                  Interface_J1_Pin_A;
     PMA_B                                     : in     Boolean;                               -- Pin_S   -- Pma_B                  Interface_J1_Pin_S;
     PMA_C                                     : in     Boolean;                               -- Pin_T   -- Pma_C                  Interface_J1_Pin_T;
     Pmu_Switch                                : in     Boolean;                               -- Pin B*  -- Manual_Sel             Interface_J2_Pin_LB;
     Power_28vdc2                              : in     Boolean;                               -- Pin P   -- Power_28VDC            Interface_J2_Pin_P;
     Right_Weight_On_Wheels                    : in     Boolean;                               -- Pin BB  -- Wow_Right              Interface_J2_Pin_B*;
     Start_Enable                              : in     Boolean;                               -- Pin U*  -- Start                  Interface_J2_Pin_LU;
     Engine_Rpm_Sensor_Fault                   : in     Boolean;                               -- Malfunction
     Arinc_Airspeed_Fault                      : in     Boolean;                               -- Malfunction
     Arinc_Hp_Fault                            : in     Boolean;                               -- Malfunction
     Fuel_Flow_Sensor_Fault                    : in     Boolean;                               -- Malfunction
     Prop_Speed_Sensor_Fault                   : in     Boolean;                               -- Malfunction
     Pcl_Sensor_Fault                          : in     Boolean;                               -- Malfunction
     --   Pma_Fault                                 : in     Boolean;                               -- Malfunction
     torque_sensor_fault                       : in     Boolean;                               -- Malfunction
     OAT_Sensor_Fault                          : in     Boolean;                               -- Malfunction
     Wow_Fault                                 : in     Boolean;                               -- Malfunction
     Hot_Start                                 : in     Boolean;                               -- Malfunction
     Voltage                                   : in     Electrical_Units_Types.Volts_Dc;       -- Malfunction
     PMU_Critical_Fault                        : in     Boolean;                               -- Malfunction
     PMU_Noncritical_Fault                     : in     Boolean;                               -- Malfunction
     Slow_Start_Request                        : in     Boolean;                               -- Malfunction
     Loss_Of_Useful_Power                      : in     Boolean;                               -- Malfunction
     Auto_Start_Switch_Off                     : in     Boolean;                               -- Malfunction
     Itt_Sensor_Malfunction                    : in     Boolean;                               -- Malfunction
     Overtemp                                  : in     Boolean;                               -- Malfunction
     Ambient_Pressure_Ratio                    : in     Normalized_Types.Normalize;            -- Static Pressure Transducer within the PMU itself Ps1
     Engine_Rpm                                : in     Angle_Types.Rpm;                       -- Pin_LB  -- Ng_Sig                 Interface_J1_Pin_LB;
     Internal_Turbine_Temperature_T5_Pos       : in     Temperature_Types.Celsius;             -- Pin_LZ  -- T5_Pos                 Interface_J1_Pin_LZ;
     Mach_Number                               : in     Length_Types.Mach;
     ADC_Mach_Number                           : in     Length_Types.Mach;                     -- Air data computer input over Arinc 429 on aircraft
     Power_Control_Lever_Angle_LVDT            : in     Angle_Types.degrees;                   -- Pin_LN  -- BA_FB_E2               Interface_J1_Pin_LN;
     Power_Control_Lever_Angle_RVDT            : in     Angle_Types.Degrees;                   -- Pin CC  -- Excitation_Hi          Interface_J2_Pin_C*;
     Power_Turbine_Rpm                         : in     Angle_Types.Rpm;                       -- Pin_LV  -- Q_Npt_Stg              Interface_J1_Pin_LV;
     Power_Turbine_Torque                      : in     Torque_Types.Ft_Lbf;                   -- Pin_LG  -- To_Hi                  Interface_J1_Pin_LG;
     ADC_Pressure_Altitude                     : in     Length_Types.Feet;                     -- Air data computer input over Arinc 429 on aircraft
     Total_Inlet_Temperature_T1_Hi             : in     Temperature_Types.Celsius;             -- Pin_LH  -- T1_Hi                  Interface_J1_Pin_LH;
     Delta_Shp_C_Acc                           : in     Torque_Types.Horsepower;               -- direct from gas generator
     Delta_Shp_C_Bleed                         : in     Torque_Types.Horsepower;               -- direct from gas generator
     Delta_Shp_C_Np                            : in     Torque_Types.Horsepower;               -- direct from gas generator
     Delta_Itt_C_Acc                           : in     Temperature_Types.Kelvin;              -- direct from gas generator
     Delta_Itt_C_Bleed                         : in     Temperature_Types.Kelvin;              -- direct from gas generator
     Delta_Ng_C_Acc                            : in     Angle_Types.Rpm;                       -- direct from gas generator
     Delta_Ng_C_Bleed                          : in     Angle_Types.Rpm;                       -- direct from gas generator
     Shp                                       : in     Torque_Types.Horsepower;               -- direct from gas generator
     K_Fmv_Delta                               : in     Normalized_Types.Normalize;            -- direct from gas generator
     Delta_Ng_Seizure                          : in     Normalized_Types.Normalize;            -- direct from gas generator
     Fired                                     : in     Boolean;
     Ambient_Temperature_Ratio                 : in     Normalized_Types.Normalize) is
--   Alternate_Ng_Signal                       : in     Boolean;                               -- Pin_V   -- Spare_Speed_Sig        Interface_J1_Pin_V;
--   Alternate_Ng_Signal_Rtn                   : in     Boolean;                               -- Pin_C   -- Spare_Speed_Rtn        Interface_J1_Pin_C;
--   Auto_Rigg                                 : in     Boolean;                               -- Pin C*  -- Auto_Rigging           Interface_J2_Pin_LC;
--   BA_FB_Com                                 : in     Integer;                               -- Pin_A*  -- BA_FB_Com              Interface_J1_Pin_A*;
--   BA_FB_E1                                  : in     Integer;                               -- Pin_LM  -- BA_FB_E1               Interface_J1_Pin_LM;
--   BA_FB_Exc                                 : in     Integer;                               -- Pin_P   -- BA_FB_Exc              Interface_J1_Pin_P;
--   BA_FB_Rtn                                 : in     Integer;                               -- Pin_R   -- BA_FB_Rtn              Interface_J1_Pin_R;
--   Internal_Turbine_Temperature_T5_Neg       : in     Tepmerature_Types.Celsius;             -- Pin_LY  -- T5_Neg                 Interface_J1_Pin_LY;
--   Mv_Fb_Com                                 : in     Boolean;                               -- Pin_K   -- Mv_Fb_Com              Interface_J1_Pin_K;
--   Mv_Fb_E2                                  : in     Boolean;                               -- Pin_LE  -- Mv_Fb_E2               Interface_J1_Pin_LE;
--   Mv_Fb_Exc                                 : in     Boolean;                               -- Pin_LF  -- Mv_Fb_Exc              Interface_J1_Pin_LF;
--   Mv_Fb_Exc_Rtn                             : in     Boolean;                               -- Pin_LX  -- Mv_Fb_Exc_Rtn          Interface_J1_Pin_LX;
--   Ng_Signal_Return                          : in     Angle_Types.Rpm;                       -- Pin_LU  -- Ng_Rtn                 Interface_J1_Pin_LU;
--   Os_Sol_Exc                                : in     Boolean;                               -- Pin_LQ  -- Os_Sol_Exc             Interface_J1_Pin_LQ;
--   Os_Sol_Lss                                : in     Boolean;                               -- Pin_B*  -- Os_Sol_Lss             Interface_J1_Pin_B*;
--   Osg_Reset_Exc                             : in     Boolean;                               -- Pin_LR  -- Osg_Reset_Exc          Interface_J1_Pin_LR;
--   Osg_Reset_Lss                             : in     Boolean;                               -- Pin_W   -- Osg_Reset_Lss          Interface_J1_Pin_W;
--   PCL_Com                                   : in     Angle_Types.Degrees;                   -- Pin E   -- PCL_Com                Interface_J2_Pin_E;
--   PCL_E1                                    : in     Angle_Types.Degrees;                   -- Pin R*  -- PCL_E_1                Interface_J2_Pin_LR;
--   PCL_E2                                    : in     Angle_Types.Degrees;                   -- Pin X   -- PCL_E_2                Interface_J2_Pin_X;
--   PCL_Excitation_Lo                         : in     Angle_Types.Degrees;                   -- Pin DD  -- Excitation_Lo          Interface_J2_Pin_D*;
--   Pin_D_Star                                : in     Boolean;                               -- Pin D*  -- Auto_Pilot_Monitored   Interface_J2_Pin_LD;
--   Pin_F_Star                                : in     Boolean;                               -- Pin F*  -- Itt_Sig_Analog         Interface_J2_Pin_LF;
--   Pin_G_Star                                : in     Boolean;                               -- Pin G*  -- Sv_Ref                 Interface_J2_Pin_LG;
--   Pin_H_Star                                : in     Boolean;                               -- Pin H*  -- Itt_Rtn_Analog         Interface_J2_Pin_LH;
--   Pin_X_Star                                : in     Boolean;                               -- Pin X*  -- Torque_Sig             Interface_J2_Pin_LX;
--   Piu_Tm_Rtn                                : in     Boolean;                               -- Pin_LW  -- Piu_Tm_Rtn             Interface_J1_Pin_LW;
--   Power_28vdc1                              : in     Boolean;                               -- Pin R   -- Power_28VDC            Interface_J2_Pin_R;
--   Q_Npt_Rtn                                 : in     Boolean;                               -- Pin_LC  -- Q_Npt_Rtn              Interface_J1_Pin_LC;
--   Reset_Exc                                 : in     Boolean;                               -- Pin_LS  -- Reset_Exc              Interface_J1_Pin_LS;
--   Reset_Lss                                 : in     Boolean;                               -- Pin_LT  -- Reset_Lss              Interface_J1_Pin_LT;
--   Sm_B_Lss                                  : in     Boolean;                               -- Pin_X   -- Sm_B_Lss               Interface_J1_Pin_X;
--   Sm_C_Lss                                  : in     Boolean;                               -- Pin_F   -- Sm_C_Lss               Interface_J1_Pin_F;
--   Sm_D_Lss                                  : in     Boolean;                               -- Pin_D   -- Sm_D_Lss               Interface_J1_Pin_D;
--   Spare_Sol_Exc                             : in     Boolean;                               -- Pin_U   -- Spare_Sol_Exc          Interface_J1_Pin_U;
--   Spare_Sol_Lss                             : in     Boolean;                               -- Pin_LP  -- Spare_Sol_Lss          Interface_J1_Pin_LP;
--   To_Lo                                     : in     Boolean;                               -- Pin_M   -- To_Lo                  Interface_J1_Pin_M;
--   To_Rtn                                    : in     Boolean;                               -- Pin_L   -- To_Rtn                 Interface_J1_Pin_L;
--   Total_Pressure_Ratio                      : in     Normalized_Types.Normalize;            -- Air data computer input over Arinc 429 on aircraft
--   Total_Temperature_Ratio                   : in     Normalized_Types.Normalize;            -- Air data computer input over Arinc 429 on aircraft
--   Boot_Application                          : in     Boolean;                               -- Pin Q*  -- Boot_Application       Interface_J2_Pin_LQ;
--   Comm_Mode                                 : in     Boolean;                               -- Pin U   -- Comm_Mode              Interface_J2_Pin_U;
--   DCU_Rs422_In_Hi                           : in     Integer;                               -- Pin_H   -- RS422_In_Hi            Interface_J1_Pin_H;
--   DCU_Rs422_In_Lo                           : in     Integer;                               -- Pin_LA  -- RS422_In_Lo            Interface_J1_Pin_LA;
--   DCU_Rs422_Out_Hi                          : in     Integer;                               -- Pin_G   -- RS422_Out_Hi           Interface_J1_Pin_G;
--   DCU_Rs422_Out_Lo                          : in     Integer;                               -- Pin_Z   -- RS422_Out_Lo           Interface_J1_Pin_Z;
--   DCU_VDC_28_Rtn                            : in     Boolean;                               -- Pin_H*  -- VDC_28_Rtn             Interface_J1_Pin_H*;
--   Discrete_Return                           : in     Boolean;                               -- Pin V*  -- Discrete_Rtn           Interface_J2_Pin_LV;
--   Discrete_Return_Wow_Control               : in     Boolean;                               -- Pin_GG  -- Discrete_Rtn           Interface_J2_Pin_G*;
--   Pin_AA                                    : in     Boolean;                               -- Pin AA  -- Discrete_Rtn           Interface_J2_Pin_A*;
--   Pin_A_Star                                : in     Boolean;                               -- Pin A*  -- Spare                  Interface_J2_Pin_LA;
--   Pin_B                                     : in     Boolean;                               -- Pin B   -- RS422_Lo_Out           Interface_J2_Pin_B;
--   Pin_C                                     : in     Boolean;                               -- Pin C   -- RS422_Hi_Out           Interface_J2_Pin_C;
--   Pin_EE                                    : in     Boolean;                               -- Pin EE  -- Spare                  Interface_J2_Pin_E*;
--   Pin_E_Star                                : in     Boolean;                               -- Pin E*  -- Arinc_429_Lo_In        Interface_J2_Pin_LE;
--   Pin_F                                     : in     Boolean;                               -- Pin F   -- Spare                  Interface_J2_Pin_F;
--   Pin_G                                     : in     Boolean;                               -- Pin G   -- Spare                  Interface_J2_Pin_G;
--   Pin_H                                     : in     Boolean;                               -- Pin H   -- Discrete_Rtn           Interface_J2_Pin_H;
--   Pin_J                                     : in     Boolean;                               -- Pin J   -- Arinc_429_Hi_In        Interface_J2_Pin_J;
--   Pin_K                                     : in     Boolean;                               -- Pin K   -- Arinc_429_Lo_Out       Interface_J2_Pin_K;
--   Pin_K_Star                                : in     Boolean;                               -- Pin K*  -- RS422_Hi_Out           Interface_J2_Pin_LK;
--   Pin_L                                     : in     Boolean;                               -- Pin L   -- Arinc_429_Hi_Out       Interface_J2_Pin_L;
--   Pin_M_Star                                : in     Boolean;                               -- Pin M*  -- RS422_Lo_Out           Interface_J2_Pin_LM;
--   Pin_S                                     : in     Boolean;                               -- Pin S   -- Power_Rtn              Interface_J2_Pin_S;
--   Pin_T                                     : in     Boolean;                               -- Pin T   -- Spare                  Interface_J2_Pin_T;
--   Pin_V                                     : in     Boolean;                               -- Pin V   -- Discrete_Rtn           Interface_J2_Pin_V;
--   Pin_W                                     : in     Boolean;                               -- Pin W   -- Spare                  Interface_J2_Pin_W;
--   Pin_Y_Star                                : in     Boolean;                               -- Pin Y*  -- RS422_Lo_In            Interface_J2_Pin_LY;
--   Pin_Z_Star                                : in     Boolean;                               -- Pin Z*  -- RS422_Hi_In            Interface_J2_Pin_LZ;
--   Power_Rtn                                 : in     Boolean;                               -- Pin A   -- Power_Rtn              Interface_J2_Pin_A;
--   Total_Inlet_Temperature_T1_Low            : in     Temperature_Types.Celsius;             -- Pin_LK  -- T1_Low                 Interface_J1_Pin_LK;
--   Total_Inlet_Temperature_T1_Rtn            : in     Temperature_Types.Celsius;             -- Pin_N   -- T1_Rtn                 Interface_J1_Pin_N;


    Alternator_Power : Boolean := False;

  begin
    Next_Instance.Pmu_Mode_Switch := Pmu_Switch;
    Alternator_Power :=  (Pma_A or Pma_B or Pma_C);
    if (Power_28vdc2) or Alternator_Power then
      Next_Instance.Pmu_Electrical_Load := 1.0;
      Powered_Update
        (Next_Instance                                    => Next_Instance,
         This_Instance                                    => This_Instance,
         Iconst                                           => Iconst,
         Bleed_Air_On                                     => Bleed_Air_On,                                   -- Pin Y   -- Cabin_Bleed            Interface_J2_Pin_Y;
         Left_Weight_On_Wheels                            => Left_Weight_On_Wheels,                          -- Pin_FF  -- Wow_Left               Interface_J2_Pin_F*;
--       PMA_A                                            => PMA_A,                                          -- Pin_A   -- Pma_A                  Interface_J1_Pin_A;
--       PMA_B                                            => PMA_B,                                          -- Pin_S   -- Pma_B                  Interface_J1_Pin_S;
--       PMA_C                                            => PMA_C,                                          -- Pin_T   -- Pma_C                  Interface_J1_Pin_T;
         Power_28vdc2                                     => Power_28vdc2,                                   -- Pin P   -- Power_28VDC            Interface_J2_Pin_P;
         Right_Weight_On_Wheels                           => Right_Weight_On_Wheels,                         -- Pin BB  -- Wow_Right              Interface_J2_Pin_B*;
         Start_Enable                                     => Start_Enable,                                   -- Pin U*  -- Start                  Interface_J2_Pin_LU;
         Engine_Rpm_Sensor_Fault                          => Engine_Rpm_Sensor_Fault,                        -- Malfunction
         Arinc_Airspeed_Fault                             => Arinc_Airspeed_Fault,                           -- Malfunction
         Arinc_Hp_Fault                                   => Arinc_Hp_Fault,                                 -- Malfunction
         Fuel_Flow_Sensor_Fault                           => Fuel_Flow_Sensor_Fault,                         -- Malfunction
         Prop_Speed_Sensor_Fault                          => Prop_Speed_Sensor_Fault,                        -- Malfunction
         Pcl_Sensor_Fault                                 => Pcl_Sensor_Fault,                               -- Malfunction
--       Pma_Fault                                        => Pma_Fault,                                      -- Malfunction
         torque_sensor_fault                              => torque_sensor_fault,                            -- Malfunction
         OAT_Sensor_Fault                                 => OAT_Sensor_Fault,                               -- Malfunction
         Wow_Fault                                        => Wow_Fault,                                      -- Malfunction
         Hot_Start                                        => Hot_Start,                                      -- Malfunction
         Voltage                                          => Voltage,                                        -- Malfunction
         PMU_Critical_Fault                               => Pmu_Critical_Fault,                             -- Malfunction
         PMU_Noncritical_Fault                            => Pmu_Noncritical_Fault,                          -- Malfunction
         Slow_Start_Request                               => Slow_Start_Request,                             -- Malfunction
         Loss_Of_Useful_Power                             => Loss_Of_Useful_Power,                           -- Malfunction
         Auto_Start_Switch_Off                            => Auto_Start_Switch_Off,                          -- Malfunction
         Itt_Sensor_Malfunction                           => Itt_Sensor_Malfunction,                         -- Malfunction
         Overtemp                                         => Overtemp,                                       -- Malfunction
         Ambient_Pressure_Ratio                           => Ambient_Pressure_Ratio,                         -- Static Pressure Transducer within the PMU itself Ps1
         Engine_Rpm                                       => Engine_Rpm,                                     -- Pin_LB  -- Ng_Sig                 Interface_J1_Pin_LB;
         Internal_Turbine_Temperature_T5_Pos              => Internal_Turbine_Temperature_T5_Pos,            -- Pin_LZ  -- T5_Pos                 Interface_J1_Pin_LZ;
         Mach_Number                                      => Mach_Number,
         ADC_Mach_Number                                  => ADC_Mach_Number,                                -- Air data computer input over Arinc 429 on aircraft
         Power_Control_Lever_Angle_LVDT                   => Power_Control_Lever_Angle_LVDT,                 -- Pin_LN  -- BA_FB_E2               Interface_J1_Pin_LN;
         Power_Control_Lever_Angle_RVDT                   => Power_Control_Lever_Angle_RVDT,                 -- Pin CC  -- Excitation_Hi          Interface_J2_Pin_C*;
         Power_Turbine_Rpm                                => Power_Turbine_Rpm,                              -- Pin_LV  -- Q_Npt_Stg              Interface_J1_Pin_LV;
         Power_Turbine_Torque                             => Power_Turbine_Torque,                           -- Pin_LG  -- To_Hi                  Interface_J1_Pin_LG;
         ADC_Pressure_Altitude                            => ADC_Pressure_Altitude,                          -- Air data computer input over Arinc 429 on aircraft
         Total_Inlet_Temperature_T1_Hi                    => Total_Inlet_Temperature_T1_Hi,                  -- Pin_LH  -- T1_Hi                  Interface_J1_Pin_LH;
         Delta_Shp_C_Acc                                  => Delta_Shp_C_Acc,                                -- direct from gas generator
         Delta_Shp_C_Bleed                                => Delta_Shp_C_Bleed,                              -- direct from gas generator
         Delta_Shp_C_Np                                   => Delta_Shp_C_Np,                                 -- direct from gas generator
         Delta_Itt_C_Acc                                  => Delta_Itt_C_Acc,                                -- direct from gas generator
         Delta_Itt_C_Bleed                                => Delta_Itt_C_Bleed,                              -- direct from gas generator
         Delta_Ng_C_Acc                                   => Delta_Ng_C_Acc,                                 -- direct from gas generator
         Delta_Ng_C_Bleed                                 => Delta_Ng_C_Bleed,                               -- direct from gas generator
         Shp                                              => Shp,                                            -- direct from gas generator
         K_Fmv_Delta                                      => K_Fmv_Delta,                                    -- direct from gas generator
         Delta_Ng_Seizure                                 => Delta_Ng_Seizure,                               -- direct from gas generator
         Fired                                            => Fired,                                          -- direct from gas generator
         Ambient_Temperature_Ratio                        => Ambient_Temperature_Ratio
--       DCU_VDC_28                                       => Next_Instance.DCU_VDC_28,                       -- Pin_E*  -- VDC_28                 Interface_J1_Pin_E*;
--       Feather_Signal                                   => Next_Instance.Feather,                          -- Pin_J   -- Mv_Fb_E1               Interface_J1_Pin_J;
--       Ignition                                         => Next_Instance.Ignition,                         -- Pin D   -- Igniter_Lss            Interface_J2_Pin_D;
--       Pla_At_20_Degrees                                => Next_Instance.Pla_At_20_Degrees,                -- Pin HH  -- PCL_At_20_Lss          Interface_J2_Pin_H*;
--       Pmu_Fail_Light_On                                => Next_Instance.Pmu_Fail_Light_On,                -- Pin T*  -- Pms_Fail               Interface_J2_Pin_LT;
--       Pmu_Status_Light_On                              => Next_Instance.Pmu_Status_Light_On,              -- Pin Z   -- Pms_Warning            Interface_J2_Pin_Z;          out
--       Shutdown_Solenoid                                => Next_Instance.Shutdown,                         -- Pin_D*  -- Sd_Sol_Lss             Interface_J1_Pin_D*;
--       Start                                            => Next_Instance.Start,                            -- Pin S*  -- Start_Lss              Interface_J2_Pin_LS;
--       Stepper_Motor_Power                              => Next_Instance.Stepper_Motor_Power,              -- Pin_Y   -- Sm_Pwr                 Interface_J1_Pin_Y;
--       PMU_Blade_Angle_Rate                             => Next_Instance.PMU_Blade_Angle_Rate,             -- Pin_LD  -- Piu_Tm_Pwr             Interface_J1_Pin_LD;
--       Stepper_Motor_Position_Demanded                  => Next_Instance.Stepper_Motor_Position_Demanded,  -- Pin_E   -- Sm_A_Lss               Interface_J1_Pin_E;
--       A429_TX_PMU_130_Outside_Air_Temperature          => Next_Instance.A429_TX_PMU_130_Outside_Air_Temperature,
--       A429_TX_PMU_134_Pla                              => Next_Instance.A429_TX_PMU_134_Pla,
--       A429_TX_PMU_336_Torque                           => Next_Instance.A429_TX_PMU_336_Torque,
--       A429_TX_PMU_344_N1                               => Next_Instance.A429_TX_PMU_344_N1,
--       A429_TX_PMU_345_Itt                              => Next_Instance.A429_TX_PMU_345_Itt,
--       A429_TX_PMU_346_Np                               => Next_Instance.A429_TX_PMU_346_Np);
         );
    else
      Next_Instance.Pmu_Electrical_Load := 0.0;
      Unpowered_Update
        (Next_Instance                                    => Next_Instance,
         Power_Turbine_Rpm                                => Power_Turbine_Rpm);
    end if;
  end Update;

  -- Method Initialize
  procedure Initialize
    (An_Instance : in out Instance) is
--  Variable_Registered : Boolean;
  begin
    --    An_Instance.Fired                                     := False;
    An_Instance.Arinc_Engine_Torque                       := Normalized_Types.Normalize(0.0);
    An_Instance.Auto_Shutdown                             := False;
    An_Instance.Auto_Start                                := False;
    An_Instance.Auto_Start_Ready                          := False;
    An_Instance.Auto_Start_Timer                          := 0.0;
    An_Instance.DCU_VDC_28                                := False;
    An_Instance.Delta_Ng                                  := 0.0;
    An_Instance.Delta_Ng_Dyn                              := 0.0;
    An_Instance.Delta_Pla_Transition_On                   := 0.0;
    An_Instance.Feather                                   := False;
    An_Instance.Flight_Mode                               := False;
    An_Instance.Flight_Mode_Timer                         := 0.0;
    An_Instance.Fuel_On_Timer                             := 0.0;
    An_Instance.Ignition                                  := False;
    An_Instance.In_Air_Timer                              := 0.0;
    An_Instance.Itt_818_Timer                             := 0.0;
    An_Instance.Itt_820_Timer                             := 0.0;
    An_Instance.Itt_820_Fired_Timer                       := 0.0;
    An_Instance.Itt_870_Timer                             := 0.0;
    An_Instance.Itt_940_Timer                             := 0.0;
    An_Instance.Itt_Limit                                 := 850.0;
    An_Instance.Itt_Start_Peak                            := 0.0;
    An_Instance.Min_Rpm_Loop_Arm                          := True;
    An_Instance.Monitored_Start                           := False;
    An_Instance.Monitored_Start_Ready                     := False;
    An_Instance.Monitored_Start_Timer                     := 0.0;
    An_Instance.Ng                                        := 0.0;
    An_Instance.Ng_33_Hp_Sec_Dot                          := 0.0;
    An_Instance.Ng_Decel_Timer                            := 0.0;
    An_Instance.Ng_Limit_Timer                            := 0.0;
    An_Instance.Ng_Req                                    := 0.0;
    An_Instance.Ng_Req_Hot                                := 0.0;
    An_Instance.Ng_Req_Norm                               := 0.0;
    An_Instance.Ng_Req_Prime                              := 0.0;
    An_Instance.Ng_Spd                                    := 0.0;
    An_Instance.No_Light                                  := False;
    An_Instance.Np                                        := 0.0;
    An_Instance.Np_Dot                                    := 0.0;
    An_Instance.Np_Last_Pass                              := 0.0;
    An_Instance.On_Ground_Timer                           := 0.0;
    An_Instance.PMU_Blade_Angle_Rate                      := Angle_Types.Degrees_Per_Sec(0.0);
    An_Instance.Pla_At_20_Degrees                         := False;
    An_Instance.Pmu_Arinc_Fail                            := False;
    An_Instance.Pmu_Bit_Test_Timer                        := 0.0;
    An_Instance.Pmu_Electrical_Load                       := 0.0;
    An_Instance.Pmu_Fail                                  := False;
    An_Instance.Pmu_Mode_Switch                           := True;
    An_Instance.Pmu_Mode_Switch_Toggle                    := False;
    An_Instance.Pmu_Off_Timer                             := 0.0;
    An_Instance.Pmu_On                                    := False;
    An_Instance.Pmu_Status                                := False;
    An_Instance.Pmu_Status_Light_On                       := False;
    An_Instance.Pmu_Test                                  := False;
    An_Instance.Pmu_Transition_Off                        := False;
    An_Instance.Pmu_Transition_On                         := False;
    An_Instance.Power_Turbine_Rpm_Limit_Timer             := 0.0;
    An_Instance.Record_Debug_Information                  := False;
    An_Instance.Rpm_Req                                   := 0.0;
    An_Instance.Ship                                      := 3;
    An_Instance.Shp_Mrp_Prime                             := 1100.0;
    An_Instance.Shutdown                                  := False;
    An_Instance.Slow_Start                                := False;
    An_Instance.Smp_Req                                   := 169.0;
    An_Instance.Smp_Req_Ss                                := 169.0;
    An_Instance.Smp_Req_Timer                             := 0.0;
    An_Instance.Start                                     := False;
    An_Instance.Start_Abort                               := False;
    An_Instance.Start_Enable                              := False;
    An_Instance.Stepper_Motor_Position_Demanded           := Jpats_Powerplant_Types.Step_Type(0);
    An_Instance.Stepper_Motor_Power                       := False;
    An_Instance.Unfeather_Control_Timer                   := 0.0;
    An_Instance.Wow_Fail                                  := False;
    An_Instance.Wow_Fault_Timer                           := 0.0;
    An_Instance.Pmu_Reset                                 := False;
    -------------------
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/A429_TX_PMU_130_Outside_Air_Temperature(A429.Channel_A)",
       Units          => "Integer",
       Object_Address => An_Instance.A429_TX_PMU_130_Outside_Air_Temperature(A429.Channel_A)'Address,
       Value_Type     => "int",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/A429_TX_PMU_130_Outside_Air_Temperature(A429.Channel_B)",
       Units          => "Integer",
       Object_Address => An_Instance.A429_TX_PMU_130_Outside_Air_Temperature(A429.Channel_B)'Address,
       Value_Type     => "int",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/A429_TX_PMU_134_Pla(A429.Channel_A)",
       Units          => "Integer",
       Object_Address => An_Instance.A429_TX_PMU_134_Pla(A429.Channel_A)'Address,
       Value_Type     => "int",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/A429_TX_PMU_134_Pla(A429.Channel_B)",
       Units          => "Integer",
       Object_Address => An_Instance.A429_TX_PMU_134_Pla(A429.Channel_B)'Address,
       Value_Type     => "int",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/A429_TX_PMU_336_Torque(A429.Channel_A)",
       Units          => "Integer",
       Object_Address => An_Instance.A429_TX_PMU_336_Torque(A429.Channel_A)'Address,
       Value_Type     => "int",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/A429_TX_PMU_336_Torque(A429.Channel_B)",
       Units          => "Integer",
       Object_Address => An_Instance.A429_TX_PMU_336_Torque(A429.Channel_B)'Address,
       Value_Type     => "int",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/A429_TX_PMU_344_N1(A429.Channel_A)",
       Units          => "Integer",
       Object_Address => An_Instance.A429_TX_PMU_344_N1(A429.Channel_A)'Address,
       Value_Type     => "int",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/A429_TX_PMU_344_N1(A429.Channel_B)",
       Units          => "Integer",
       Object_Address => An_Instance.A429_TX_PMU_344_N1(A429.Channel_B)'Address,
       Value_Type     => "int",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/A429_TX_PMU_345_Itt(A429.Channel_A)",
       Units          => "Integer",
       Object_Address => An_Instance.A429_TX_PMU_345_Itt(A429.Channel_A)'Address,
       Value_Type     => "int",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/A429_TX_PMU_345_Itt(A429.Channel_B)",
       Units          => "Integer",
       Object_Address => An_Instance.A429_TX_PMU_345_Itt(A429.Channel_B)'Address,
       Value_Type     => "int",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/A429_TX_PMU_346_Np(A429.Channel_A)",
       Units          => "Integer",
       Object_Address => An_Instance.A429_TX_PMU_346_Np(A429.Channel_A)'Address,
       Value_Type     => "int",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/A429_TX_PMU_346_Np(A429.Channel_B)",
       Units          => "Integer",
       Object_Address => An_Instance.A429_TX_PMU_346_Np(A429.Channel_B)'Address,
       Value_Type     => "int",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Arinc_Engine_Torque",
       Units          => "Normalized",
       Object_Address => An_Instance.Arinc_Engine_Torque'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Auto_Start",
       Units          => "Boolean",
       Object_Address => An_Instance.Auto_Start'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Auto_Start_Ready",
       Units          => "Boolean",
       Object_Address => An_Instance.Auto_Start_Ready'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/DCU_VDC_28",
       Units          => "Boolean",
       Object_Address => An_Instance.DCU_VDC_28'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Delta_Ng",
       Units          => "Float",
       Object_Address => An_Instance.Delta_Ng'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Delta_Ng_Dyn",
       Units          => "Float",
       Object_Address => An_Instance.Delta_Ng_Dyn'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Feather",
       Units          => "Boolean",
       Object_Address => An_Instance.Feather'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Flight_Mode",
       Units          => "Boolean",
       Object_Address => An_Instance.Flight_Mode'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Flight_Mode_Timer",
       Units          => "Float",
       Object_Address => An_Instance.Flight_Mode_Timer'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Fuel_On_Timer",
       Units          => "Float",
       Object_Address => An_Instance.Fuel_On_Timer'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Ignition",
       Units          => "Boolean",
       Object_Address => An_Instance.Ignition'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/In_Air_Timer",
       Units          => "Float",
       Object_Address => An_Instance.In_Air_Timer'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Itt_818_Timer",
       Units          => "Float",
       Object_Address => An_Instance.Itt_818_Timer'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Itt_820_Timer",
       Units          => "Float",
       Object_Address => An_Instance.Itt_820_Timer'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Itt_820_Fired_Timer",
       Units          => "Float",
       Object_Address => An_Instance.Itt_820_Fired_Timer'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Itt_870_Timer",
       Units          => "Float",
       Object_Address => An_Instance.Itt_870_Timer'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Itt_940_Timer",
       Units          => "Float",
       Object_Address => An_Instance.Itt_940_Timer'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Itt_Start_Peak",
       Units          => "Float",
       Object_Address => An_Instance.Itt_Start_Peak'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Min_Rpm_Loop_Arm",
       Units          => "Boolean",
       Object_Address => An_Instance.Min_Rpm_Loop_Arm'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Monitored_Start",
       Units          => "Boolean",
       Object_Address => An_Instance.Monitored_Start'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Monitored_Start_Ready",
       Units          => "Boolean",
       Object_Address => An_Instance.Monitored_Start_Ready'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Ng",
       Units          => "Normalized %",
       Object_Address => An_Instance.Ng'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Ng_33_Hp_Sec_Dot",
       Units          => "Float",
       Object_Address => An_Instance.Ng_33_Hp_Sec_Dot'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Ng_Decel_Timer",
       Units          => "Float",
       Object_Address => An_Instance.Ng_Decel_Timer'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Ng_Limit_Timer",
       Units          => "Float",
       Object_Address => An_Instance.Ng_Limit_Timer'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Ng_Req",
       Units          => "Float",
       Object_Address => An_Instance.Ng_Req'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Ng_Req_Hot",
       Units          => "Float",
       Object_Address => An_Instance.Ng_Req_Hot'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Ng_Req_Norm",
       Units          => "Float",
       Object_Address => An_Instance.Ng_Req_Norm'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Ng_Req_Prime",
       Units          => "Float",
       Object_Address => An_Instance.Ng_Req_Prime'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Ng_Spd",
       Units          => "Float",
       Object_Address => An_Instance.Ng_Spd'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/No_Light",
       Units          => "Boolean",
       Object_Address => An_Instance.No_Light'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Np",
       Units          => "Normalized",
       Object_Address => An_Instance.Np'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/On_Ground_Timer",
       Units          => "float",
       Object_Address => An_Instance.On_Ground_Timer'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/PMU_Blade_Angle_Rate",
       Units          => "Degrees_Per_Sec",
       Object_Address => An_Instance.PMU_Blade_Angle_Rate'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Pla_At_20_Degrees",
       Units          => "Boolean",
       Object_Address => An_Instance.Pla_At_20_Degrees'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Pmu_Arinc_Fail",
       Units          => "Boolean",
       Object_Address => An_Instance.Pmu_Arinc_Fail'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Pmu_Fail",
       Units          => "Boolean",
       Object_Address => An_Instance.Pmu_Fail'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Pmu_Off_Timer",
       Units          => "Secs",
       Object_Address => An_Instance.Pmu_Off_Timer'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Pmu_On",
       Units          => "Boolean",
       Object_Address => An_Instance.Pmu_On'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Pmu_Status",
       Units          => "Boolean",
       Object_Address => An_Instance.Pmu_Status'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Pmu_Status_Light_On",
       Units          => "Boolean",
       Object_Address => An_Instance.Pmu_Status_Light_On'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Pmu_Transition_Off",
       Units          => "Boolean",
       Object_Address => An_Instance.Pmu_Transition_Off'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Pmu_Transition_On",
       Units          => "Boolean",
       Object_Address => An_Instance.Pmu_Transition_On'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Power_Turbine_Rpm_Limit_Timer",
       Units          => "Secs",
       Object_Address => An_Instance.Power_Turbine_Rpm_Limit_Timer'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Rpm_Req",
       Units          => "float",
       Object_Address => An_Instance.Rpm_Req'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Ship",
       Units          => "Ship Number",
       Object_Address => An_Instance.Pmu_Transition_On'Address,
       Value_Type     => "int",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Shutdown",
       Units          => "Boolean",
       Object_Address => An_Instance.Shutdown'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Slow_Start",
       Units          => "Boolean",
       Object_Address => An_Instance.Slow_Start'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Smp_Req",
       Units          => "float",
       Object_Address => An_Instance.Smp_Req'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Smp_Req_SS",
       Units          => "float",
       Object_Address => An_Instance.Smp_Req_SS'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Start",
       Units          => "Boolean",
       Object_Address => An_Instance.Start'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Start_Abort",
       Units          => "Boolean",
       Object_Address => An_Instance.Start_Abort'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Start_Enable",
       Units          => "Boolean",
       Object_Address => An_Instance.Start_Enable'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
--    Stethoscope.Register_Signal
--      (Name           => "Powerplant/Pmu/Start_Timer",
--       Units          => "Secs",
--       Object_Address => An_Instance.Start_Timer'Address,
--       Value_Type     => "float",
--       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Stepper_Motor_Position_Demanded",
       Units          => "Steps",
       Object_Address => An_Instance.Stepper_Motor_Position_Demanded'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Stepper_Motor_Power",
       Units          => "Boolean",
       Object_Address => An_Instance.Stepper_Motor_Power'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Wow_Fail",
       Units          => "Boolean",
       Object_Address => An_Instance.Wow_Fail'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Wow_Fault_Timer",
       Units          => "Secs",
       Object_Address => An_Instance.Wow_Fault_Timer'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/PMU_Electrical_Load",
       Units          => "Amps",
       Object_Address => An_Instance.PMU_Electrical_Load'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
  ---------------------
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_1/Ship",
       Units          => "integer",
       Object_Address => An_Instance.Ship'Address,
       Value_Type     => "int",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_1/Delta_T",
       Units          => "float",
       Object_Address => Delta_T'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_1/Theta_T",
       Units          => "float",
       Object_Address => Theta_T'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_1/Delta_Pla",
       Units          => "float",
       Object_Address => Delta_Pla'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_1/Start_Toggle",
       Units          => "Boolean",
       Object_Address => Start_Toggle'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_2/Delta_Pla",
       Units          => "float",
       Object_Address => Delta_Pla'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_2/Pmu_Fail",
       Units          => "Boolean",
       Object_Address => An_Instance.Pmu_Fail'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_2/Pmu_On",
       Units          => "Boolean",
       Object_Address => An_Instance.Pmu_On'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_3/Flight_Mode",
       Units          => "Boolean",
       Object_Address => An_Instance.Flight_Mode'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_3/Mach_Pmu",
       Units          => "float",
       Object_Address => Mach_Pmu'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_4/Ng_g_spd",
       Units          => "float",
       Object_Address => Ng_G_Spd'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_4/Ng_f_spd",
       Units          => "float",
       Object_Address => Ng_F_Spd'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_4/Ng_C_G_Spd",
       Units          => "float",
       Object_Address => Ng_C_G_Spd'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_4/Ng_C_F_Spd",
       Units          => "float",
       Object_Address => Ng_C_F_Spd'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_4/Ng_g_idle",
       Units          => "float",
       Object_Address => Ng_G_Idle'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_4/Ng_f_idle",
       Units          => "float",
       Object_Address => Ng_F_Idle'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_4/Ng_C_G_Idle",
       Units          => "float",
       Object_Address => Ng_C_G_Idle'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_4/Ng_C_F_Idle",
       Units          => "float",
       Object_Address => Ng_C_F_Idle'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_5/Ng_Spd",
       Units          => "Float",
       Object_Address => An_Instance.Ng_Spd'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_9/Monitored_Start",
       Units          => "Boolean",
       Object_Address => An_Instance.Monitored_Start'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_9/Min_Rpm_Loop_Arm",
       Units          => "Boolean",
       Object_Address => An_Instance.Min_Rpm_Loop_Arm'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_10/Shp_Ng_Lim",
       Units          => "float",
       Object_Address => Shp_Ng_Lim'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_10/Shp_C_Ng_Lim",
       Units          => "float",
       Object_Address => Shp_C_Ng_Lim'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_11/Shp_Itt_Lim",
       Units          => "float",
       Object_Address => Shp_Itt_Lim'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_11/Shp_C_Itt_Lim",
       Units          => "float",
       Object_Address => Shp_C_Itt_Lim'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_11/Ng_C_Itt_Lim",
       Units          => "float",
       Object_Address => Ng_C_Itt_Lim'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_11/Itt_C_Lim",
       Units          => "float",
       Object_Address => Itt_C_Lim'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_12/Shp_Q_Lim",
       Units          => "float",
       Object_Address => Shp_Q_Lim'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_12/Shp_Mrp_L",
       Units          => "float",
       Object_Address => Shp_Mrp_L'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_12/Shp_Mrp_H",
       Units          => "float",
       Object_Address => Shp_Mrp_H'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_12/Shp_Mrp_Hi_L",
       Units          => "float",
       Object_Address => Shp_Mrp_Hi_L'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_12/Shp_Mrp_Hi_H",
       Units          => "float",
       Object_Address => Shp_Mrp_Hi_H'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_12/Shp_Mrp_Lo_L",
       Units          => "float",
       Object_Address => Shp_Mrp_Lo_L'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_12/Shp_Mrp_Lo_H",
       Units          => "float",
       Object_Address => Shp_Mrp_Lo_H'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_12/Shp_Mrp",
       Units          => "float",
       Object_Address => Shp_Mrp'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_12/Shp_Mrp_Prime",
       Units          => "float",
       Object_Address => An_Instance.Shp_Mrp_Prime'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_12/Ng_Req_Ng_Lim",
       Units          => "float",
       Object_Address => Ng_Req_Ng_Lim'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_12/Itt_Limit",
       Units          => "float",
       Object_Address => An_Instance.Itt_Limit'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_12/Itt_C_Lim",
       Units          => "float",
       Object_Address => Itt_C_Lim'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_12/Ng_Req_Itt_Lim",
       Units          => "float",
       Object_Address => Ng_Req_Itt_Lim'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_13/Shp_Pwr",
       Units          => "float",
       Object_Address => Shp_Pwr'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_13/F_Shp_Delta_Pla",
       Units          => "float",
       Object_Address => F_Shp_Delta_Pla'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_14/Ng_C_Pwr",
       Units          => "float",
       Object_Address => Ng_C_Pwr'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_14/Shp_C_Pwr",
       Units          => "float",
       Object_Address => Shp_C_Pwr'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_14/Ng_Pwr",
       Units          => "float",
       Object_Address => Ng_Pwr'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_15/Delta_Ng",
       Units          => "float",
       Object_Address => An_Instance.Delta_Ng'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_15/Delta_Ng_Dyn",
       Units          => "float",
       Object_Address => An_Instance.Delta_Ng_Dyn'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_15/F_Ng_Dyn",
       Units          => "float",
       Object_Address => F_Ng_Dyn'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_15/F_Ng_Spd",
       Units          => "float",
       Object_Address => F_Ng_Spd'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_15/F_Ng_Pwr",
       Units          => "float",
       Object_Address => F_Ng_Pwr'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_15/Ng_Spd_Dyn",
       Units          => "float",
       Object_Address => Ng_Spd_Dyn'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_15/Ng_Req_3p",
       Units          => "float",
       Object_Address => Ng_Req_Triple_Prime'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_16/Delta_ng_min_rpm",
       Units          => "float",
       Object_Address => Delta_Ng_Min_Rpm'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_17/Ng_Req_2p",
       Units          => "float",
       Object_Address => Ng_Req_Double_Prime'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
--    Stethoscope.Register_Signal
--      (Name           => "Powerplant/Pmu/local/Step_15/Ng_Req_Hot_2p",
--       Units          => "float",
--       Object_Address => Ng_Req_Hot_Double_Prime'Address,
--       Value_Type     => "float",
--       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_18/Ng_acc_lim_dot",
       Units          => "float",
       Object_Address => Ng_Acc_Lim_Dot'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_18/F_Ng_Mach_Dot",
       Units          => "float",
       Object_Address => F_Ng_Mach_Dot'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_18/F_Ng_Dot_Ng_C",
       Units          => "float",
       Object_Address => F_Ng_Dot_Ng_C'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_18/Delta_F_Ng_Np_Lo",
       Units          => "float",
       Object_Address => Delta_F_Ng_Np_Lo'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_18/Ng_Dec_Lim_Dot",
       Units          => "float",
       Object_Address => Ng_Dec_Lim_Dot'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_18/Ng_Dec_Lim_Dot_Prime",
       Units          => "float",
       Object_Address => Ng_Dec_Lim_Dot_Prime'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_19/Ng_Req_Norm_Dot",
       Units          => "float",
       Object_Address => Ng_Req_Norm_Dot'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_19/Ng_Req_Norm",
       Units          => "float",
       Object_Address => An_Instance.Ng_Req_Norm'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_20/Ng_Req_Hot_Dot",
       Units          => "float",
       Object_Address => Ng_Req_Hot_Dot'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_20/Ng_Req_Hot",
       Units          => "float",
       Object_Address => An_Instance.Ng_Req_Hot'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_20/Ng_Req_Prime",
       Units          => "float",
       Object_Address => An_Instance.Ng_Req_Prime'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_21/Ng_Req_Dot_Prime",
       Units          => "float",
       Object_Address => Ng_Req_Dot_Prime'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_22/PMU_Transition_On",
       Units          => "Boolean",
       Object_Address => An_Instance.PMU_Transition_On'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_22/PMU_Transition_Off",
       Units          => "Boolean",
       Object_Address => An_Instance.PMU_Transition_Off'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_22/Ng_33_Hp_Sec_Dot",
       Units          => "float",
       Object_Address => An_Instance.Ng_33_Hp_Sec_Dot'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_22/Ng_Req_Dot",
       Units          => "float",
       Object_Address => Ng_Req_Dot'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_22/Ng_Req",
       Units          => "float",
       Object_Address => An_Instance.Ng_Req'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_23/Wf_Req_Dot",
       Units          => "float",
       Object_Address => Wf_Req_Dot'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_23/Wf_C_Ng_c_Dot",
       Units          => "float",
       Object_Address => Wf_C_Ng_C_Dot'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_23/Ng_C_Req_Adjusted",
       Units          => "float",
       Object_Address => Ng_C_Req_Adjusted'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_23/Wf_C_3d_Req_Dot",
       Units          => "float",
       Object_Address => Wf_C_3d_Req_Dot'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_23/Delta_Pla_Prime",
       Units          => "float",
       Object_Address => Delta_Pla_Prime'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_23/Wf_C_3d_0_Dot",
       Units          => "float",
       Object_Address => Wf_C_3d_0_Dot'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_23/Wf_C_3d_169_Dot",
       Units          => "float",
       Object_Address => Wf_C_3d_169_Dot'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_23/Wf_C_3d_338_Dot",
       Units          => "float",
       Object_Address => Wf_C_3d_338_Dot'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_23/Smp_Req_SS",
       Units          => "float",
       Object_Address => An_Instance.Smp_Req_SS'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_24/Smp_Req",
       Units          => "float",
       Object_Address => An_Instance.Smp_Req'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_24/Smp_Req_Dot",
       Units          => "float",
       Object_Address => Smp_Req_Dot'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_26/Np",
       Units          => "float",
       Object_Address => An_Instance.Np'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Step_26/Flight_Mode",
       Units          => "Boolean",
       Object_Address => An_Instance.Flight_Mode'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_26/Auto_Feather",
       Units          => "Boolean",
       Object_Address => An_Instance.Feather'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_26/Rpm_Req",
       Units          => "float",
       Object_Address => An_Instance.Rpm_Req'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/local/Step_27/Auto_Ignitors_On",
       Units          => "Boolean",
       Object_Address => An_Instance.Ignition'Address,
       Value_Type     => "uchar",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Pmu_Off_Prop_Gain",
       Units          => "float",
       Object_Address => Pmu_Off_Prop_Gain'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Pmu_On_Prop_Proportional_Gain",
       Units          => "float",
       Object_Address => Pmu_On_Prop_Proportional_Gain'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Pmu/Pmu_On_Prop_Differential_Gain",
       Units          => "float",
       Object_Address => Pmu_On_Prop_Differential_Gain'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Jpats_Ios_Interface.Register
      ( Name        => "delta_pla",
        Variable    => delta_pla'Address
        );
    Jpats_Ios_Interface.Register
      ( Name        => "smp_req",
        Variable    => An_Instance.smp_req'Address
        );
    Jpats_Ios_Interface.Register
      ( Name        => "wf_req_dot",
        Variable    => wf_req_dot'Address
        );
    Jpats_Ios_Interface.Register
      ( Name        => "ng_req",
        Variable    => An_Instance.Ng_Req'Address
        );
    Jpats_Ios_Interface.Register
      ( Name        => "ng_req_triple_prime",
        Variable    => Ng_Req_triple_prime'Address
        );
    Jpats_Ios_Interface.Register
      ( Name        => "pmu_on",
        Variable    => An_Instance.Pmu_On'Address
        );

  end Initialize;

  procedure Read_Tables is
    Powerplant_Cat_Path : String := Simulation_Dictionary.Lookup ("Powerplant_Cat_Path");
  begin
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "plapcl.ito",
        Table     =>  PLAPCL_Table );
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "shpcngc.ito",
        Table     =>  SHPCNGC_Table );
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "fshppla.ito",
        Table     =>  FSHPPLA_Table );
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "fngdmach.ito",
        Table     =>  FNGDMACH_Table );
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "fngdngc.ito",
        Table     =>  FNGDNGC_Table );
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "ngddeclm.ito",
        Table     =>  NGDDECLIM_Table );
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "ff3dcam.ito",
        Table     =>  FF3DCAM_Table );
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "ngcittc.ito",
        Table     =>  NGCITTC_Table );
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "ngcshpc.ito",
        Table     =>  NGCSHPC_Table );
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "ngcgidle.ito",
        Table     =>  NGCGIDLE_Table );
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "ngcfidle.ito",
        Table     =>  NGCFIDLE_Table );
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "ffcngc.ito",
        Table     =>  FFCNGC_Table );
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "fngpwr.ito",
        Table     =>  FNGPWR_Table );
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "dfngdnpl.ito",
        Table     =>  DFNGDNPLO_Table );
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "ngcffc.ito",
        Table     => NGCFFC_Table );
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "shpmrp0l.ito",
        Table     => SHPMRP0L_Table);
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "shpmrp0h.ito",
        Table     => SHPMRP0H_Table);
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "shpmrp2l.ito",
        Table     => SHPMRP2L_Table);
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "shpmrp2h.ito",
        Table     => SHPMRP2H_Table);
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "shpmrp3l.ito",
        Table     => SHPMRP3L_Table);
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "shpmrp3h.ito",
        Table     => SHPMRP3H_Table);
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "shpmrp4l.ito",
        Table     => SHPMRP4L_Table );
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "shpmrp4h.ito",
        Table     => SHPMRP4H_Table );
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "shpmrp5l.ito",
        Table     => SHPMRP5L_Table);
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "shpmrp5h.ito",
        Table     => SHPMRP5H_Table);
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "shpmrp7l.ito",
        Table     => SHPMRP7L_Table);
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "shpmrp7h.ito",
        Table     => SHPMRP7H_Table);
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "ngcittc.ito",
        Table     => NGCITTC_Table );
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "ngcshpc.ito",
        Table     => NGCSHPC_Table );
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "dnpdwf.ito",
        Table     => DNPDWF_Table );

  exception
    when others =>
      Ada.Text_Io.Put_Line("There is a table problem in Power_Management_Unit.Read_Tables procedure.");
      raise;
  end Read_Tables;

end Power_Management_Unit;













