 -------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--------------------------------------------------------------------------------
-- This valve controls fuel flow between minimum and maximum.  Ported
-- sleeve actuated axially through a 3D cam and hydraulic power amplifier.
-- Downward movement (axial) causes the valve to open as a function of
-- pilot demand (PCL).  Rotates though a linear Ambient Pressure
-- compensation Bellows.  Rotational movement (CCW) causes the valve to
-- close as a function of altitude.
-------------------------------------------------------------------------------
with Angle_Types;
with Force_Types;
with Normalized_Types;
with Mass_Types;

generic
   type Degrees_Type is digits <>;
   type Step_Type is range <>;
   High_Pressure_Relief_Valve_Set_Point : Force_Types.Psi; -- := 1175.0;
   Bypass_Valve_Set_Point               : Force_Types.Psi; -- := 50.0;
   Cam_Profile_Table_Name               : String;
   Gain_Table_Name                      : String;

package Metering_Valve is


  type Instance is private;

-- Access Fuel_Output_Pressure
   function  Output_Pressure (An_Instance : in Instance) return Force_Types.Psi;
   procedure Set_Output_Pressure (An_Instance     : in out Instance;
                                  Output_Pressure : in     Force_Types.Psi);

-- Access Fuel_Flow_Rate
   function  Flow_Rate (An_Instance : in Instance) return Mass_Types.Pph;
   procedure Set_Flow_Rate (An_Instance : in out Instance;
                            Flow_Rate   : in     Mass_Types.Pph);

-- Access Fuel_Bypass_Flow_Rate
   function  Bypass_Flow_Rate (An_Instance : in Instance) return Mass_Types.Pph;
   procedure Set_Bypass_Flow_Rate (An_Instance      : in out Instance;
                                   Bypass_Flow_Rate : in     Mass_Types.Pph);

-- Access Min_Fuel_Flow_Rate
   function  Min_Flow_Rate (An_Instance : in Instance) return Mass_Types.Pph;
   procedure Set_Min_Flow_Rate (An_Instance   : in out Instance;
                                Min_Flow_Rate : in     Mass_Types.Pph);

-- Access Altitude_Gain
   function  Altitude_Gain (An_Instance : in Instance) return Normalized_Types.Normalize;
   procedure Set_Altitude_Gain (An_Instance   : in out Instance;
                                Altitude_Gain : in     Normalized_Types.Normalize);

-- Method Update
   procedure Update
     ( Next_Instance                        : in out Instance;
       This_Instance                        : in     Instance;
       Power_Lever_Angle                    : in     Angle_Types.Degrees;
       Stepper_Motor_Position               : in     Step_Type;
       Shutdown_Solenoid_Energized          : in     Boolean;
       Ambient_Pressure_Ratio               : in     Normalized_Types.Normalize;
       Return_Line_Pressure                 : in     Force_Types.psi;
       Inlet_Pressure                       : in     Force_Types.Psi;
       Inlet_Flow_Rate                      : in     Mass_Types.Pph;
       Restrain_Fuel_Flow                   : in     Boolean;
       Fmu_Malfunction                      : in     Boolean);

-- Method Initialize
   procedure Initialize (An_Instance : in out Instance);

   -- Method Read_Tables
   procedure Read_Tables;

private

  type Instance is record
    Position                             : Normalized_Types.Normalize;
    High_Pressure_Relief_Valve_State     : Boolean;
    Bypass_Valve_State                   : Boolean;
    Output_Pressure                      : Force_Types.Psi;
    Flow_Rate                            : Mass_Types.Pph;
    Bypass_Flow_Rate                     : Mass_Types.Pph;
    Min_Flow_Rate                        : Mass_Types.Pph;
    Altitude_Gain                        : Normalized_Types.Normalize;
  end record;


end Metering_Valve;

