-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0
with Ada.Streams.Stream_IO;
with Jpats_Powerplant_Types;
with Jpats_Propeller_Types;
with Angle_Types;
with Force_Types;
with Length_Types;
with Torque_Types;
with Temperature_Types;
with Mass_Types;
with Normalized_Types;
with Electrical_Units_Types;
with Arinc_429_Types;
with Coordinate_Types;

package JPATS_Powerplant is

  ------------------------------------------------------------------------------
  --|
  --|  ENGINE
  --|  The aircraft is powered by a PT6A-68 free turbine turbo-prop
  --|  engine (Figure 1-7). The PT6A-68 engine is a reverse-flow
  --|  design, with airflow entering the engine at the rear, just
  --|  forward of the oil tank, and moving forward during the com-pression
  --|  and combustion cycle. The engine includes two
  --|  independent sections: the gas generator section and the
  --|  power turbine section. The gas generator section consists of
  --|  the aft half of the engine and includes the four stage axial
  --|  flow compressor, single stage centrifugal flow compressor,
  --|  combustion chamber and single stage compressor turbine.
  --|  The power section consists of the forward half of the engine
  --|  and includes the two stage axial flow power turbine, exhaust
  --|  case, and reduction gearbox which drives the propeller. Ini-tiation
  --|  of the combustion cycle is provided through two
  --|  spark igniters. After starting, the igniters are switched off
  --|  and combustion is self-sustaining so long as the proper fuel-air
  --|  ratio is supplied.
  --|  Inlet air travels rearward through the intake duct and inertial
  --|  separator before entering the engine inlet through an annular
  --|  plenum chamber formed by the compressor inlet case.
  --|  The compressor uses a four stage axial compressor and one
  --|  centrifugal impeller to compress the air. The air moves for-ward
  --|  from the compressor through diffuser tubes, where air
  --|  velocity is converted into static pressure. The diffused air
  --|  passes through straightening vanes prior to reaching the
  --|  annulus surrounding the combustion chamber. The air is
  --|  mixed with fuel and ignited inside the combustion chamber.
  --|  The resultant expanding gases drive the single stage gas
  --|  generator turbine, which shares a common shaft to drive the
  --|  compressor impellers. The gases then impinge on the two
  --|  stage power turbine, which drives the reduction gearbox.
  --|  Exhaust gas flows out sideways and is ejected rearward into
  --|  the atmosphere through the exhaust stacks, providing thrust
  --|  which augments that produced by the propeller.
  --|
  --|  POWER
  --|  The engine has been flat rated to produce 1100 shaft horse-power
  --|  (shp) as installed in the aircraft. By flat rating the
  --|  engine, 1100 horsepower is available from sea level to
  --|  approximately 12,000 feet MSL on an ISA standard day.
  --|  Engine power output is measured by the torque produced in
  --|  the reduction gearbox. At 100% indicated torque, the Engine
  --|  is producing approximately 2889 foot/pounds of torque at
  --|  the prop shaft.
  --|
  --|  Engine Power Definitions
  --|  Power is set by positioning the power control lever (PCL)
  --|  between the idle stop (IDLE) and the max stop (MAX).
  --|  Maximum climb power and maximum cruise power settings
  --|  are determined in relation to the maximum interstage tur-bine
  --|  temperature (ITT) observed at critical altitude and full
  --|  power (MAX). For engine operating limitations, see Section
  --|  V. For information on the power management unit (PMU),
  --|  see the Power Management Unit description in this section.
  --|  ITT limit temperatures have been determined to ensure that
  --|  the engine is operated at internal temperatures that will not
  --|  shorten engine life. A normally functioning engine should
  --|  not exceed the temperatures listed in the following para-graphs.
  --|  Newer engines will typically run at a cooler ITT for
  --|  a given PCL position compared to older engines. Be aware
  --|  that higher than expected ITT, especially on newer engines,
  --|  may be indicative of a potential malfunction.
  --|
  --|  CRITICAL ALTITUDE
  --|  Critical altitude is the altitude at which ITT peaks and
  --|  begins to descend (typically about 12,000 feet MSL on an
  --|  ISA standard day, with the PMU functioning). Above this
  --|  altitude, positioning the PCL at MAX will no longer yield
  --|  100% torque or 1100 shp.
  --|
  --|  MAXIMUM POWER (MAX)
  --|  Maximum power is the amount of power available by positioning
  --|  the PCL full forward. At this PCL position, the
  --|  engine is rated to produce at least 1100 shp and indicate
  --|  100% torque below critical altitude, at a maximum sustained
  --|  ITT not to exceed 820 C. If ITT exceeds 820 degrees for
  --|  more than 20 seconds and the PMU is functioning, the PMU
  --|  will reschedule fuel flow (power) to keep ITT below 820
  --|  degrees C. When in manual mode, the pilot must position the PCL
  --|  to keep ITT below 820 degrees C.
  --|
  --|  MAXIMUM CLIMB POWER
  --|  Maximum climb power is the amount of power available
  --|  during climb when above critical altitude. This setting is the
  --|  PCL position which yields an ITT 13 degrees C below observed
  --|  maximum power ITT at critical altitude, not to exceed 807
  --|  degrees C.
  --|
  --|  MAXIMUM CRUISE POWER
  --|  Maximum cruise power is the amount of power available for
  --|  cruise flight when above critical altitude. This setting is the
  --|  PCL position which yields an ITT 40 degrees C below observed
  --|  maximum power ITT at critical altitude, not to exceed 780
  --|  degrees C.
  --|
  --|  Ref. AIR FORCE TO 1T-6A-1
  --|       NAVY (NAVAIR) A1-T6AAA-NFM-100
  --|       Page 1-4 - 1-6 CVV DRAFT DECEMBER 1998
  -------------------------------------------------------------------------------

  type Instance is null record;

  -- Outside of Powerplant_Cat, Propeller_Cat, and Engine_Data_Manager_Cat

  -- Access Qeng
  -- Engine Torque communicated in pct with 100% = 2889 ft_lbf.
  -- This is data communicated over Arinc 429 in the actual aircraft.
  -- Label 336.
  function Qeng
    return Normalized_Types.Normalize;

  -- Access Power_Control_Lever_Angle
  function Power_Control_Lever_Angle
    return Angle_Types.Degrees;

  -- Access PMU_Status_Annunciator_Request
  function PMU_Status_Annunciator_Request
    return Boolean;

  -- Access IGN_Select_Annunciator_Request
  function IGN_Select_Annunciator_Request
    return Boolean;

  -- Access Start_Ready_Annunciator_Request
  function Start_Ready_Annunciator_Request
    return Boolean;

  -- Access Ignition_Exciter_Load
  function Ignition_Exciter_Load
    return Electrical_Units_Types.Amps;

  -- Access Auto_Ignition_Relay_Load
  function Auto_Ignition_Relay_Load
    return Electrical_Units_Types.Amps;

  -- Access Engine_Oil_Pressure
  function Engine_Oil_Pressure
    return Force_Types.Psi;

  -- Access Engine_Oil_Pressure_Transducer
  function Engine_Oil_Pressure_Transducer
    return Force_Types.Psi;

  -- Access Engine_Oil_Temperature
  function Engine_Oil_Temperature
    return Temperature_Types.Celsius;

  -- Access Engine_Oil_Temperature_Transducer
  function Engine_Oil_Temperature_Transducer
    return Temperature_Types.Celsius;

  -- Oil_Pressure_Annunciator_Request is moved to the Engine_Data_Manager_Category

  -- Access Engine_Fired
  function Engine_Fired
    return Boolean;

  -- Access Ignition_Exciter
  function Ignition_Exciter
    return Boolean;

  -- Access PMU_Fail_Relay_Load
  function PMU_Fail_Relay_Load
    return Electrical_Units_Types.Amps;

  -- Access Chip_Annunciator_Request
  function Chip_Annunciator_Request
    return Boolean;

  -- Access PIU Failure Request
  function Piu_Failure_Request
    return Boolean;

  -- Access PMU_Load
  function PMU_Load
    return Electrical_Units_Types.Amps;

  -- Access Bleed_Temperature
  function Bleed_Temperature
    return Temperature_Types.Kelvin;

  -- Access Bleed_Pressure
  function Bleed_Pressure
    return Force_Types.Psi;

  -- Access Power_Turbine_Speed in Percent;  -- Ng
  function Power_Turbine_Speed_Pct
    return Normalized_Types.Normalize;

  -- Access Reduction_Gear_Box_Rpm
  function Reduction_Gear_Box_Rpm
    return Jpats_Propeller_Types.Propeller_Angular_Rate_Vector_Type.Instance;

  -- Access Overspeed_Governor_Reset_Solenoid
  function Overspeed_Governor_Reset_Solenoid
    return Boolean;

  -- Access Propeller_Feather_Signal
  function Manual_Feather_Signal
    return Boolean;

  -- Access Speed_Brake_Max_Power_Switch
  function Speed_Brake_Max_Power_Switch
    return Boolean;

  -- Access  Landing_Gear_Warn_Low_Throttle_Switch
  function  Landing_Gear_Warn_Low_Throttle_Switch
    return Boolean;

  -- Access Boost_Pump_Below_Idle_Switch
  function Boost_Pump_Below_Idle_Switch
    return Boolean;

  -- Access PMU_Blade_Angle_Rate
  function PMU_Blade_Angle_Rate
    return Angle_Types.Degrees_Per_Sec;

  -- Access Start_Relay
  function Start_Relay
    return Boolean;

  -- Access Starter_On_Relay
  function Starter_On_Relay
    return Boolean;

  -- Access PMU_Fail_Annunciator_Request
  function Pmu_Fail_Annunciator_Request
    return Boolean;

  -- Access Generator_Shaft_Rpm
  function Generator_Shaft_Rpm
    return Angle_Types.Rpm;

  -- Access Hyd_Shaft_Rpm
  function Hyd_Shaft_Rpm
    return Angle_Types.Rpm;

  -- Access Internal Turbine Temperature
  function Internal_Turbine_Temperature
    return Temperature_Types.Celsius;

  -- Access Intermediate_Fuel_Pump_Pressure
  function Intermediate_Fuel_Pump_Pressure
    return Force_Types.Psi;

  -- Access Fuel_Flow
  function Fuel_Flow
    return Mass_Types.Pph;

  -- Access Engine_Torque_Pct
  function Engine_Torque_Pct
    return Normalized_Types.Normalize;

  -- Access Gas_Generator_Speed in Percent;  -- Ng
  function Gas_Generator_Speed_Pct
    return Normalized_Types.Normalize;

  -- Access Gas_Generator_Speed_Sensor in Rpm;
  function Gas_Generator_Speed_Sensor
    return Angle_Types.Rpm;

  -- Access A429_TX_PMU_A_336_Torque
  function  A429_TX_PMU_A_336_Torque
    return Arinc_429_Types.Message_Type;

  -- Access A429_TX_PMU_A_344_N1
  function  A429_TX_PMU_A_344_N1
    return Arinc_429_Types.Message_Type;

  -- Access A429_TX_PMU_A_345_Itt
  function  A429_TX_PMU_A_345_Itt
    return Arinc_429_Types.Message_Type;

  -- Access A429_TX_PMU_A_346_Np
  function  A429_TX_PMU_A_346_Np
    return Arinc_429_Types.Message_Type;

  -- Access A429_TX_PMU_A_134_Pla
  function  A429_TX_PMU_A_134_Pla
    return Arinc_429_Types.Message_Type;

  -- Access A429_TX_PMU_A_130_Outside_Air_Temperature
  function  A429_TX_PMU_A_130_Outside_Air_Temperature
    return Arinc_429_Types.Message_Type;

  -- Access A429_TX_PMU_B_336_Torque
  function  A429_TX_PMU_B_336_Torque
    return Arinc_429_Types.Message_Type;

  -- Access A429_TX_PMU_B_344_N1
  function  A429_TX_PMU_B_344_N1
    return Arinc_429_Types.Message_Type;

  -- Access A429_TX_PMU_B_345_Itt
  function  A429_TX_PMU_B_345_Itt
    return Arinc_429_Types.Message_Type;

  -- Access A429_TX_PMU_B_346_Np
  function  A429_TX_PMU_B_346_Np
    return Arinc_429_Types.Message_Type;

  -- Access A429_TX_PMU_B_134_Pla
  function  A429_TX_PMU_B_134_Pla
    return Arinc_429_Types.Message_Type;

  -- Access A429_TX_PMU_B_130_Outside_Air_Temperature
  function  A429_TX_PMU_B_130_Outside_Air_Temperature
    return Arinc_429_Types.Message_Type;

  -- Access Exhaust_Thrust
  function Exhaust_Thrust
    return Jpats_Propeller_Types.Force_Vector_Type.Instance;

  -- Access Exhaust_Moment
  function Exhaust_Moment
    return Jpats_Propeller_Types.Torque_Vector_Type.Instance;

  -- Access Quick_Start_Mode
  procedure Quick_Start;

  -- Access Fire_Warning_Request
  function Fire_Warning_Request
    return Boolean;

  -- Access Engine_Vibration
  function Engine_Vibration
    return Float;

  -- Access Rough_Engine
  function Rough_Engine
    return Boolean;

  -- Access Compressor_Stall
  function Compressor_Stall
    return Boolean;

  -- Access Engine Failure
  function Engine_Failure
    return Boolean;

  -- Access Uncontrollable High Power Malfunction
  function Mfen29
    return Boolean;

end JPATS_Powerplant;
