-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0
with Ada.Numerics.Elementary_Functions;
use  Ada.Numerics.Elementary_Functions;
with JPATS_Powerplant.Io_Interface;
with JPATS_Powerplant.IOS_Interface;
with JPATS_Powerplant.Controller;
with JPATS_Powerplant.Container;

package body JPATS_Powerplant.Test_Controller is

  ----------------------------------
  -- Test modes auto test
  -- Note that these can control all of the inputs for the powerplant.
  -- These should not be used for anything other than auto test or
  -- debug purposes.

  -- Access Set_Prop_Feather_Cut_Off_Switch
  procedure Set_Prop_Feather_Cut_Off_Switch
    ( Position : in Boolean) is
  begin
    JPATS_Powerplant.Io_Interface.Auto_Test_Driver.Prop_Feather_Cut_Off_Switch_Auto_Driven := True;
    JPATS_Powerplant.Io_Interface.Auto_Test_Driver.Prop_Feather_Cut_Off_Switch :=  Position;
  end Set_Prop_Feather_Cut_Off_Switch;

  -- Access Set_Power_Control_Lever_Angle
  procedure Set_Power_Control_Lever_Angle
    ( Position : in Float ) is
  begin
    if not JPATS_Powerplant.Io_Interface.Auto_Test_Driver.Pcl_Position_Auto_Driven then
      JPATS_Powerplant.Io_Interface.Auto_Test_Driver.Pcl_Position_Auto_Driven := True;
    end if;
    if Position > 53.0 then
      JPATS_Powerplant.Io_Interface.Auto_Test_Driver.Pcl_Position := 53.0;
    elsif Position < 0.0 then
      JPATS_Powerplant.Io_Interface.Auto_Test_Driver.Pcl_Position := 0.0;
    else
      JPATS_Powerplant.Io_Interface.Auto_Test_Driver.Pcl_Position := Position;
    end if;
  end Set_Power_Control_Lever_Angle;

  -- Access Set_Starter_Switch
  procedure Set_Starter_Switch
    ( Position : in Jpats_Powerplant_Types.Starter_Switch_Position_Type) is
    use Jpats_Powerplant_Types;
  begin
    JPATS_Powerplant.Io_Interface.Auto_Test_Driver.Starter_Switch_Auto_Driven  :=  True;
    if Position = Auto then
      JPATS_Powerplant.Io_Interface.Auto_Test_Driver.Starter_Auto_Switch  :=  True;
      JPATS_Powerplant.Io_Interface.Auto_Test_Driver.Starter_Man_Switch  :=  False;
    elsif Position = Manual then
      JPATS_Powerplant.Io_Interface.Auto_Test_Driver.Starter_Auto_Switch  := False;
      JPATS_Powerplant.Io_Interface.Auto_Test_Driver.Starter_Man_Switch  :=  True;
    else
      JPATS_Powerplant.Io_Interface.Auto_Test_Driver.Starter_Auto_Switch  :=  False;
      JPATS_Powerplant.Io_Interface.Auto_Test_Driver.Starter_Man_Switch  :=  False;
    end if;
  end Set_Starter_Switch;

  -- Access Set_Ignition_Switch
  procedure Set_Ignition_Switch
    ( Position : in Boolean) is
  begin
    JPATS_Powerplant.Io_Interface.Auto_Test_Driver.Ignition_Switch_Auto_Driven  :=  True;
    JPATS_Powerplant.Io_Interface.Auto_Test_Driver.Ignition_On_Switch  :=  Position;
    JPATS_Powerplant.Io_Interface.Auto_Test_Driver.Ignition_Off_Switch  :=  not Position;
  end Set_Ignition_Switch;

  -- Access Set_Pmu_Mode_Off_Switch
  procedure Set_Pmu_Mode_Off_Switch
    ( Position : in Boolean) is
  begin
    JPATS_Powerplant.Io_Interface.Auto_Test_Driver.Pmu_Mode_Off_Switch_Auto_Driven  :=  True;
    JPATS_Powerplant.Io_Interface.Auto_Test_Driver.Pmu_Mode_Off_Switch  :=  Position;
  end Set_Pmu_Mode_Off_Switch;


  -- Access Start_Recording_Debug_Output
  procedure Start_Recording_Debug_Output
    (Debug_Stream : in out Ada.Streams.Stream_IO.Stream_Access) is
  begin
    JPATS_Powerplant.Controller.Start_Recording_Debug_Output
      (A_Subsystem  => JPATS_Powerplant.Container.Next_Subsystem,
       Debug_Stream => Debug_Stream);
  end Start_Recording_Debug_Output;

  -- Access Stop_Recording_Debug_Output;
  procedure Stop_Recording_Debug_Output is
  begin
    JPATS_Powerplant.Controller.Stop_Recording_Debug_Output
      (A_Subsystem  => JPATS_Powerplant.Container.Next_Subsystem);
  end Stop_Recording_Debug_Output;

  -- Access Set_Fuel_Flow
  procedure Set_Fuel_Flow
    (Fuel_Flow : in Mass_Types.Pph) is
  begin
    This_Test_Controller_Instance.Fuel_Flow_Auto_Driven := True;
    This_Test_Controller_Instance.Fuel_Flow_Burn_Rate := Fuel_Flow;
  end Set_Fuel_Flow;

  -- Access Reset_Test_Modes
  procedure Reset_Test_Modes is
  begin
    JPATS_Powerplant.Io_Interface.Auto_Test_Driver.Ignition_Switch_Auto_Driven  :=  False;
    JPATS_Powerplant.Io_Interface.Auto_Test_Driver.Starter_Switch_Auto_Driven  :=  False;
    JPATS_Powerplant.Io_Interface.Auto_Test_Driver.Pcl_Position_Auto_Driven := False;
    JPATS_Powerplant.Io_Interface.Auto_Test_Driver.Pmu_Mode_Off_Switch_Auto_Driven  :=  False;
    JPATS_Powerplant.Io_Interface.Auto_Test_Driver.Prop_Feather_Cut_Off_Switch_Auto_Driven := False;
    This_Test_Controller_Instance.Fuel_Flow_Auto_Driven := False;
    This_Test_Controller_Instance.Electrical_Auto_Driven := False;
    This_Test_Controller_Instance.Landing_Gear_Auto_Driven := False;
    This_Test_Controller_Instance.Aircraft_Auto_Driven := False;
    This_Test_Controller_Instance.Atmosphere_Auto_Driven := False;
    This_Test_Controller_Instance.Adc_Auto_Driven := False;
    This_Test_Controller_Instance.Environmental_Auto_Driven := False;
    This_Test_Controller_Instance.Accessory_Horsepower_Auto_Driven := False;
    This_Test_Controller_Instance.Fuel_Available_Auto_Driven := False;
    This_Test_Controller_Instance.Torque_Auto_Driven := False;
  end Reset_Test_Modes;

  -- Access Set_Cbs
  procedure Set_Cbs
    ( State : in Boolean) is
  begin
    This_Test_Controller_Instance.Electrical_Auto_Driven := True;
    This_Test_Controller_Instance.Edm_Batt_Cb  := State;
    This_Test_Controller_Instance.Edm_Gen_Cb   := State;
    This_Test_Controller_Instance.Ignition_Cb  := State;
    This_Test_Controller_Instance.Start_Cb     := State;
    This_Test_Controller_Instance.Oil_Trx_Cb   := State;
    This_Test_Controller_Instance.Pmu_Cb       := State;
    This_Test_Controller_Instance.Prop_Sys_Cb  := State;
  end Set_Cbs;


  -- Access Set_Weight_On_Wheels
  procedure Set_Weight_On_Wheels
    (State : in Boolean) is
  begin
    This_Test_Controller_Instance.Landing_Gear_Auto_Driven := True;
    This_Test_Controller_Instance.Left_Weight_On_Wheels := State;
    This_Test_Controller_Instance.Right_Weight_On_Wheels := State;
  end Set_Weight_On_Wheels;

  -- procedure Set_Mach_Number
  procedure Set_Mach_Number
    (Mach_Number : in Length_Types.Mach) is
  begin
    This_Test_Controller_Instance.Aircraft_Auto_Driven := True;
    This_Test_Controller_Instance.Mach_Number := Mach_Number;
  end Set_Mach_Number;

  --  procedure Set_Aircraft_Cg
  procedure Set_Aircraft_Cg
    (Aircraft_Cg : in  Jpats_Propeller_Types.Coordinate_Type.Instance) is
  begin
    This_Test_Controller_Instance.Aircraft_Auto_Driven := True;
    This_Test_Controller_Instance.Aircraft_Cg := Aircraft_Cg;
  end Set_Aircraft_Cg;

  -- Access Set_Aircraft_Angular_Rate
  procedure Set_Aircraft_Angular_Rate
    ( Aircraft_Angular_Rate : in  Jpats_Propeller_Types.Angular_Rate_Vector_Type.Instance) is
  begin
    This_Test_Controller_Instance.Aircraft_Auto_Driven := True;
    This_Test_Controller_Instance.Aircraft_Angular_Rate := Aircraft_Angular_Rate;
  end Set_Aircraft_Angular_Rate;

  -- Access Set_Load_Factor
  procedure Set_Load_Factor
    (Load_Factor : in Coordinate_Types.Cartesian) is
  begin
    This_Test_Controller_Instance.Aircraft_Auto_Driven := True;
    This_Test_Controller_Instance.Load_Factor := Load_Factor;
  end Set_Load_Factor;

  -- Access Set_Ambient_Temperature
  procedure Set_Ambient_Temperature
    (Temp : in Temperature_Types.Celsius) is
  begin
    This_Test_Controller_Instance.Atmosphere_Auto_Driven := True;
    This_Test_Controller_Instance.Ambient_Temperature := Temp;
    This_Test_Controller_Instance.Ambient_Temperature_Ratio := (Temp+273.15)/288.15;
  end Set_Ambient_Temperature;

  -- Access Set_Ambient_Temperature_Ratio
  procedure Set_Ambient_Temperature_Ratio
    (Ambient_Temperature_Ratio : in Normalized_Types.Normalize)is
  begin
    This_Test_Controller_Instance.Atmosphere_Auto_Driven := True;
    This_Test_Controller_Instance.Ambient_Temperature_Ratio := Ambient_Temperature_Ratio;
    This_Test_Controller_Instance.Ambient_Temperature :=  Ambient_Temperature_Ratio*288.15 - 273.15;
  end Set_Ambient_Temperature_Ratio;

  -- Access Set_Ambient_Pressure
  procedure Set_Ambient_Pressure
    (Ambient_Pressure : in Force_Types.Pounds_Per_Sq_Feet) is
  begin
    This_Test_Controller_Instance.Atmosphere_Auto_Driven := True;
    This_Test_Controller_Instance.Ambient_Pressure := Ambient_Pressure;
    This_Test_Controller_Instance.Ambient_Pressure_Ratio := Ambient_Pressure/2116.22;
    This_Test_Controller_Instance.Pressure_Altitude := ((1.0 - (Ambient_Pressure/2116.22)**0.19018)*145447.0);
  end Set_Ambient_Pressure;

  -- Access Set_Ambient_Pressure_Ratio
  procedure Set_Ambient_Pressure_Ratio
    (Ambient_Pressure_Ratio : in Normalized_Types.Normalize) is
  begin
    This_Test_Controller_Instance.Atmosphere_Auto_Driven := True;
    This_Test_Controller_Instance.Ambient_Pressure_Ratio := Ambient_Pressure_Ratio;
    This_Test_Controller_Instance.Ambient_Pressure := Ambient_Pressure_Ratio*2116.22;
    This_Test_Controller_Instance.Pressure_Altitude := ((1.0 - Ambient_Pressure_Ratio**0.19018)*145447.0);
  end Set_Ambient_Pressure_Ratio;

  -- Access Set_Pressure_Altitude
  procedure Set_Pressure_Altitude
    (Pressure_Altitude : in Length_Types.Feet) is
  begin
    This_Test_Controller_Instance.Atmosphere_Auto_Driven := True;
    This_Test_Controller_Instance.Pressure_Altitude := Pressure_Altitude;
    This_Test_Controller_Instance.Ambient_Pressure_Ratio := (1.0 - Pressure_Altitude/145447.0 )**(1.0/0.19018);
    This_Test_Controller_Instance.Ambient_Pressure := This_Test_Controller_Instance.Ambient_Pressure_Ratio*2116.22;
  end Set_Pressure_Altitude;

  -- Access Set_Adc_Pressure_Altitude
  procedure Set_Adc_Pressure_Altitude
    (Pressure_Altitude : in Length_Types.Feet) is
  begin
    This_Test_Controller_Instance.Adc_Auto_Driven := True;
    This_Test_Controller_Instance.Adc_Pressure_Altitude := Pressure_Altitude;
  end Set_Adc_Pressure_Altitude;

  -- Access Set_Adc_Mach_Number
  procedure Set_Adc_Mach_Number
    (Mach_Number : in Length_Types.Mach) is
  begin
    This_Test_Controller_Instance.Adc_Auto_Driven := True;
    This_Test_Controller_Instance.Adc_Mach_Number := Mach_Number;
  end Set_Adc_Mach_Number;

  -- Access Set_Bleed_Flow_Rate
  procedure Set_Bleed_Flow_Rate
    (Bleed_Flow_Rate : in Mass_Types.Ppm) is
  begin
    This_Test_Controller_Instance.Environmental_Auto_Driven := True;
    This_Test_Controller_Instance.Bleed_Flow_Rate := Bleed_Flow_Rate;
  end Set_Bleed_Flow_Rate;

  -- Access Set_Air_Conditioner_Torque_Absorbed
  procedure Set_Air_Conditioner_Torque_Absorbed
    (Air_Conditioner_Torque : in Jpats_Propeller_Types.Torque_Vector_Type.Instance) is
  begin
    This_Test_Controller_Instance.Environmental_Auto_Driven := True;
    This_Test_Controller_Instance.Air_Conditioner_Torque_Absorbed := Air_Conditioner_Torque;
  end Set_Air_Conditioner_Torque_Absorbed;

  -- Access Set_Accessory_Horsepower
  procedure Set_Accessory_Horsepower
    (Accessory_Horsepower : in Torque_Types.Horsepower) is
  begin
    This_Test_Controller_Instance.Accessory_Horsepower_Auto_Driven := True;
    This_Test_Controller_Instance.Accessory_Horsepower := Accessory_Horsepower;
  end Set_Accessory_Horsepower;

  -- Access Set_Engine_Torque
  procedure Set_Engine_Torque
    (Torque : in Torque_Types.Ft_Lbf) is
  begin
    This_Test_Controller_Instance.Torque_Auto_Driven := True;
    This_Test_Controller_Instance.Torque := Torque;
  end Set_Engine_Torque;

  -- Access Set_Fuel_Available;
  procedure Set_Fuel_Available is
  begin
    This_Test_Controller_Instance.Fuel_Available_Auto_Driven := True;
    This_Test_Controller_Instance.Fuel_Available := True;
  end Set_Fuel_Available;

  -- Access Ios text box Sr1
  function Sr1 return Float is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Sr1;
  end Sr1;

  -- Access Ios text box Sr2
  function Sr2 return Float is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Sr2;
  end Sr2;

  -- Access Ios text box Sr3
  function Sr3 return Float is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Sr3;
  end Sr3;

  -- Access Ios text box Sr4
  function Sr4 return Float is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Sr4;
  end Sr4;

  -- Access Ios text box Sr5
  function Sr5 return Float is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Sr5;
  end Sr5;

  -- Access Ios text box Sr6
  function Sr6 return Float is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Sr6;
  end Sr6;

  -- Access Ios text box Sr7
  function Sr7 return Float is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Sr7;
  end Sr7;

  -- Access Ios text box Sr8
  function Sr8 return Float is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Sr8;
  end Sr8;

  -- Access Ios text box Sr9
  function Sr9 return Float is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Sr9;
  end Sr9;

  -- Access Ios text box Sr10
  function Sr10 return Float is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Sr10;
  end Sr10;

  -- Access Ios text box Srbool1
  function Srbool1 return Boolean is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Srbool1;
  end Srbool1;

  -- Access Ios text box Srbool2
  function Srbool2 return Boolean is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Srbool2;
  end Srbool2;

  -- Access Ios text box Srbool3
  function Srbool3 return Boolean is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Srbool3;
  end Srbool3;

  -- Access Ios text box Srbool4
  function Srbool4 return Boolean is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Srbool4;
  end Srbool4;

  -- Access Ios text box Srbool5
  function Srbool5 return Boolean is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Srbool5;
  end Srbool5;

  -- Access Ios text box Srbool6
  function Srbool6 return Boolean is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Srbool6;
  end Srbool6;

  -- Access Ios text box Srbool7
  function Srbool7 return Boolean is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Srbool7;
  end Srbool7;

  -- Access Ios text box Srbool8
  function Srbool8 return Boolean is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Srbool8;
  end Srbool8;

  -- Access Ios text box Srbool9
  function Srbool9 return Boolean is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Srbool9;
  end Srbool9;

  -- Access Ios text box Srbool10
  function Srbool10 return Boolean is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Srbool10;
  end Srbool10;

  -- Access Fuel_Available
   function  Fuel_Available
      return Boolean is
   begin
      return This_Test_Controller_Instance.Fuel_Available;
   end Fuel_Available;

-- Access Fuel_Flow_Auto_Driven
   function  Fuel_Flow_Auto_Driven
      return Boolean is
   begin
      return This_Test_Controller_Instance.Fuel_Flow_Auto_Driven;
   end Fuel_Flow_Auto_Driven;

-- Access Fuel_Available_Auto_Driven
   function  Fuel_Available_Auto_Driven
      return Boolean is
   begin
      return This_Test_Controller_Instance.Fuel_Flow_Auto_Driven;
   end Fuel_Available_Auto_Driven;

-- Access Fuel_Flow_Burn_Rate
   function  Fuel_Flow_Burn_Rate
      return Mass_Types.Pph is
   begin
      return This_Test_Controller_Instance.Fuel_Flow_Burn_Rate;
   end Fuel_Flow_Burn_Rate;

-- Access Environmental_Auto_Driven
   function  Environmental_Auto_Driven
      return Boolean is
   begin
      return This_Test_Controller_Instance.Environmental_Auto_Driven;
   end Environmental_Auto_Driven;

-- Access Bleed_Air_On
   function  Bleed_Air_On
      return Boolean is
   begin
      return This_Test_Controller_Instance.Bleed_Air_On;
   end Bleed_Air_On;

-- Access Bleed_Flow_Rate
   function  Bleed_Flow_Rate
      return Mass_Types.Ppm is
   begin
      return This_Test_Controller_Instance.Bleed_Flow_Rate;
   end Bleed_Flow_Rate;

-- Access Air_conditioner_Torque_Absorbed
   function  Air_conditioner_Torque_Absorbed
      return Jpats_Propeller_Types.Torque_Vector_Type.Instance is
   begin
      return This_Test_Controller_Instance.Air_conditioner_Torque_Absorbed;
   end Air_conditioner_Torque_Absorbed;

-- Access ADC_Auto_Driven
   function  ADC_Auto_Driven
      return Boolean is
   begin
      return This_Test_Controller_Instance.ADC_Auto_Driven;
   end ADC_Auto_Driven;

-- Access Adc_Pressure_Altitude
   function  Adc_Pressure_Altitude
      return Length_Types.Feet is
   begin
      return This_Test_Controller_Instance.Adc_Pressure_Altitude;
   end Adc_Pressure_Altitude;

-- Access Adc_Mach_Number
   function  Adc_Mach_Number
      return Normalized_Types.Normalize is
   begin
      return This_Test_Controller_Instance.Adc_Mach_Number;
   end Adc_Mach_Number;

-- Access Electrical_Auto_Driven
   function  Electrical_Auto_Driven
      return Boolean is
   begin
      return This_Test_Controller_Instance.Electrical_Auto_Driven;
   end Electrical_Auto_Driven;

-- Access Edm_Batt_Cb
   function  Edm_Batt_Cb
      return Boolean is
   begin
      return This_Test_Controller_Instance.Edm_Batt_Cb;
   end Edm_Batt_Cb;

-- Access Edm_Gen_Cb
   function  Edm_Gen_Cb
      return Boolean is
   begin
      return This_Test_Controller_Instance.Edm_Gen_Cb;
   end Edm_Gen_Cb;

-- Access Ignition_Cb
   function  Ignition_Cb
      return Boolean is
   begin
      return This_Test_Controller_Instance.Ignition_Cb;
   end Ignition_Cb;

-- Access Start_Cb
   function  Start_Cb
      return Boolean is
   begin
      return This_Test_Controller_Instance.Start_Cb;
   end Start_Cb;

-- Access Oil_Trx_Cb
   function  Oil_Trx_Cb
      return Boolean is
   begin
      return This_Test_Controller_Instance.Oil_Trx_Cb;
   end Oil_Trx_Cb;

-- Access Pmu_Cb
   function  Pmu_Cb
      return Boolean is
   begin
      return This_Test_Controller_Instance.Pmu_Cb;
   end Pmu_Cb;

-- Access Prop_Sys_Cb
   function  Prop_Sys_Cb
      return Boolean is
   begin
      return This_Test_Controller_Instance.Prop_Sys_Cb;
   end Prop_Sys_Cb;

-- Access Accessory_Torque_Absorbed
   function  Accessory_Torque_Absorbed
      return Jpats_Propeller_Types.Torque_Vector_Type.Instance is
   begin
      return This_Test_Controller_Instance.Accessory_Torque_Absorbed;
   end Accessory_Torque_Absorbed;

-- Access Atmosphere_Auto_Driven
   function  Atmosphere_Auto_Driven
      return Boolean is
   begin
      return This_Test_Controller_Instance.Atmosphere_Auto_Driven;
   end Atmosphere_Auto_Driven;

-- Access Ambient_Pressure_Ratio
   function  Ambient_Pressure_Ratio
      return Normalized_Types.Normalize is
   begin
      return This_Test_Controller_Instance.Ambient_Pressure_Ratio;
   end Ambient_Pressure_Ratio;

-- Access Ambient_Temperature_Ratio
   function  Ambient_Temperature_Ratio
      return Normalized_Types.Normalize is
   begin
      return This_Test_Controller_Instance.Ambient_Temperature_Ratio;
   end Ambient_Temperature_Ratio;

-- Access Ambient_Temperature
   function  Ambient_Temperature
      return Temperature_Types.Celsius is
   begin
      return This_Test_Controller_Instance.Ambient_Temperature;
   end Ambient_Temperature;

-- Access Ambient_Pressure
   function  Ambient_Pressure
      return Force_Types.Pounds_Per_Sq_Feet is
   begin
      return This_Test_Controller_Instance.Ambient_Pressure;
   end Ambient_Pressure;

-- Access Pressure_Altitude
   function  Pressure_Altitude
      return Length_Types.Feet is
   begin
      return This_Test_Controller_Instance.Pressure_Altitude;
   end Pressure_Altitude;

-- Access Landing_Gear_Auto_Driven
   function  Landing_Gear_Auto_Driven
      return Boolean is
   begin
      return This_Test_Controller_Instance.Landing_Gear_Auto_Driven;
   end Landing_Gear_Auto_Driven;

-- Access Left_Weight_On_Wheels
   function  Left_Weight_On_Wheels
      return Boolean is
   begin
      return This_Test_Controller_Instance.Left_Weight_On_Wheels;
   end Left_Weight_On_Wheels;

-- Access Right_Weight_On_Wheels
   function  Right_Weight_On_Wheels
      return Boolean is
   begin
      return This_Test_Controller_Instance.Right_Weight_On_Wheels;
   end Right_Weight_On_Wheels;

-- Access Aircraft_Auto_Driven
   function  Aircraft_Auto_Driven
      return Boolean is
   begin
      return This_Test_Controller_Instance.Aircraft_Auto_Driven;
   end Aircraft_Auto_Driven;

-- Access Mach_Number
   function  Mach_Number
      return Length_Types.Mach is
   begin
      return This_Test_Controller_Instance.Mach_Number;
   end Mach_Number;

-- Access Aircraft_Cg
   function  Aircraft_Cg
      return Jpats_Propeller_Types.Coordinate_Type.Instance is
   begin
      return This_Test_Controller_Instance.Aircraft_Cg;
   end Aircraft_Cg;

-- Access Aircraft_Angular_Rate
   function  Aircraft_Angular_Rate
      return Jpats_Propeller_Types.Angular_Rate_Vector_Type.Instance is
   begin
      return This_Test_Controller_Instance.Aircraft_Angular_Rate;
   end Aircraft_Angular_Rate;

-- Access Load_Factor
   function  Load_Factor
      return Coordinate_Types.Cartesian is
   begin
      return This_Test_Controller_Instance.Load_Factor;
   end Load_Factor;

-- Access Ground_Speed
   function  Ground_Speed
      return Length_Types.Feet_Per_Sec is
   begin
      return This_Test_Controller_Instance.Ground_Speed;
   end Ground_Speed;

-- Access Accessory_Horsepower_Auto_Driven
   function  Accessory_Horsepower_Auto_Driven
      return Boolean is
   begin
      return This_Test_Controller_Instance.Accessory_Horsepower_Auto_Driven;
   end Accessory_Horsepower_Auto_Driven;

-- Access Accessory_Horsepower
   function  Accessory_Horsepower
      return Torque_Types.Horsepower is
   begin
      return This_Test_Controller_Instance.Accessory_Horsepower;
   end Accessory_Horsepower;

-- Access Torque_Auto_Driven
   function  Torque_Auto_Driven
      return Boolean is
   begin
      return This_Test_Controller_Instance.Torque_Auto_Driven;
   end Torque_Auto_Driven;

-- Access Torque
   function  Torque
      return Torque_Types.Ft_Lbf is
   begin
      return This_Test_Controller_Instance.Torque;
   end Torque;


end JPATS_Powerplant.Test_Controller;







