-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0

-- with Jpats_Powerplant.Container;
with Ada.Streams.Stream_IO;
with Jpats_Powerplant_Types;
with Jpats_Propeller_Types;
with Force_Types;
with Length_Types;
with Torque_Types;
with Temperature_Types;
with Mass_Types;
with Normalized_Types;
with Electrical_Units_Types;
with Coordinate_Types;


package JPATS_Powerplant.Test is


--------------------------------------------------------------------
-- Reference: Kimball, D., "Flight Simulation Mathematical Model of
--            the Beech MkII Joint Primary Aircraft Training System
--            (JPATS)", Document 133E794 Rev. A, 18 February, 1998,
--            FSI-SSD # 50181, pg 66.
--
--------------------------------------------------------------------
-- Reference: Flight Manual USAF/USN Series T-6A Aircraft,
--            Air Force TO 1T-6A-1
--            Navy (NAVAIR) A1-T6AAA-NFM-100
--            CVV Draft December 1998m or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violat
-------------------------------------------------------------------

  -- Test modes auto test
  -- Note that these can control all of the inputs for the powerplant.
  -- These should not be used for anything other than auto test or
  -- debug purposes.

  -- Access Set_Prop_Feather_Cut_Off_Switch
  procedure Set_Prop_Feather_Cut_Off_Switch
    ( Position : in Boolean);

  -- Access Set_Power_Control_Lever_Angle
  procedure Set_Power_Control_Lever_Angle
    ( Position : in Float );

  -- Access Set_Starter_Switch
  procedure Set_Starter_Switch
    ( Position : in Jpats_Powerplant_Types.Starter_Switch_Position_Type);

  -- Access Set_Ignition_Switch
  procedure Set_Ignition_Switch
    ( Position : in Boolean);

  -- Access Set_Pmu_Mode_Off_Switch
  procedure Set_Pmu_Mode_Off_Switch
    ( Position : in Boolean);

  -- Access Start_Recording_Debug_Output
  procedure Start_Recording_Debug_Output
    (Debug_Stream : in out Ada.Streams.Stream_IO.Stream_Access);

  -- Access Stop_Recording_Debug_Output;
  procedure Stop_Recording_Debug_Output;

  -- Access Set_Fuel_Flow
  procedure Set_Fuel_Flow
    (Fuel_Flow : in Mass_Types.Pph);

  -- Access Reset_Test_Modes
  procedure Reset_Test_Modes;

  -- Access Set_Cbs
  procedure Set_Cbs
    (State : in Boolean);

  -- Access Set_Weight_On_Wheels
  procedure Set_Weight_On_Wheels
    (State : in Boolean);

  -- procedure Set_Mach_Number
  procedure Set_Mach_Number
    (Mach_Number : in Length_Types.Mach);

  --  procedure Set_Aircraft_Cg
  procedure Set_Aircraft_Cg
    (Aircraft_Cg : in  Jpats_Propeller_Types.Coordinate_Type.Instance);

  -- Access Set_Aircraft_Angular_Rate
  procedure Set_Aircraft_Angular_Rate
    ( Aircraft_Angular_Rate : in  Jpats_Propeller_Types.Angular_Rate_Vector_Type.Instance);

  -- Access Set_Load_Factor
  procedure Set_Load_Factor
    (Load_Factor : in Coordinate_Types.Cartesian);

  -- Access Set_Ambient_Temperature
  procedure Set_Ambient_Temperature
    (Temp : in Temperature_Types.Celsius);

  -- Access Set_Ambient_Temperature_Ratio
  procedure Set_Ambient_Temperature_Ratio
    (Ambient_Temperature_Ratio : in Normalized_Types.Normalize);

  -- Access Set_Ambient_Pressure
  procedure Set_Ambient_Pressure
    (Ambient_Pressure : in Force_Types.Pounds_Per_Sq_Feet);

  -- Access Set_Ambient_Pressure_Ratio
  procedure Set_Ambient_Pressure_Ratio
    (Ambient_Pressure_Ratio : in Normalized_Types.Normalize);

  -- Access Set_Pressure_Altitude
  procedure Set_Pressure_Altitude
    (Pressure_Altitude : in Length_Types.Feet);

  -- Access Set_Adc_Pressure_Altitude
  procedure Set_Adc_Pressure_Altitude
    (Pressure_Altitude : in Length_Types.Feet);

  -- Access Set_Adc_Mach_Number
  procedure Set_Adc_Mach_Number
    (Mach_Number : in Length_Types.Mach);

  -- Access Set_Bleed_Flow_Rate
  procedure Set_Bleed_Flow_Rate
    (Bleed_Flow_Rate : in Mass_Types.Ppm);

  -- Access Set_Air_Conditioner_Torque_Absorbed
  procedure Set_Air_Conditioner_Torque_Absorbed
    (Air_Conditioner_Torque : in Jpats_Propeller_Types.Torque_Vector_Type.Instance);

  -- Access Set_Accessory_Horsepower
  procedure Set_Accessory_Horsepower
    (Accessory_Horsepower : in Torque_Types.Horsepower);

  -- Access Set_Engine_Torque
  procedure Set_Engine_Torque
    (Torque : in Torque_Types.Ft_Lbf);

  -- Access Set_Fuel_Available;
  procedure Set_Fuel_Available;

  -- Access Ios text box Sr1
  function Sr1  return Float;

  -- Access Ios text box Sr2
  function Sr2  return Float;

  -- Access Ios text box Sr3
  function Sr3  return Float;

  -- Access Ios text box Sr4
  function Sr4  return Float;

  -- Access Ios text box Sr5
  function Sr5  return Float;

  -- Access Ios text box Sr6
  function Sr6  return Float;

  -- Access Ios text box Sr7
  function Sr7  return Float;

  -- Access Ios text box Sr8
  function Sr8  return Float;

  -- Access Ios text box Sr9
  function Sr9  return Float;

  -- Access Ios text box Sr10
  function Sr10 return Float;

  -- Access Ios text box Srbool1
  function Srbool1  return Boolean;

  -- Access Ios text box Srbool2
  function Srbool2  return Boolean;

  -- Access Ios text box Srbool3
  function Srbool3  return Boolean;

  -- Access Ios text box Srbool4
  function Srbool4  return Boolean;

  -- Access Ios text box Srbool5
  function Srbool5  return Boolean;

  -- Access Ios text box Srbool6
  function Srbool6  return Boolean;

  -- Access Ios text box Srbool7
  function Srbool7  return Boolean;

  -- Access Ios text box Srbool8
  function Srbool8  return Boolean;

  -- Access Ios text box Srbool9
  function Srbool9  return Boolean;

  -- Access Ios text box Srbool10
  function Srbool10 return Boolean;

end JPATS_Powerplant.Test;








