-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0
with JPATS_Powerplant.Test_Controller;
with JPATS_Powerplant.IOS_Interface;

package body JPATS_Powerplant.Test is

  ----------------------------------
  -- Test modes auto test
  -- Note that these can control all of the inputs for the powerplant.
  -- These should not be used for anything other than auto test or
  -- debug purposes.

  -- Access Set_Prop_Feather_Cut_Off_Switch
  procedure Set_Prop_Feather_Cut_Off_Switch
    ( Position : in Boolean) is
  begin
    JPATS_Powerplant.Test_Controller.Set_Prop_Feather_Cut_Off_Switch
      (Position => Position);
  end Set_Prop_Feather_Cut_Off_Switch;

  -- Access Set_Power_Control_Lever_Angle
  procedure Set_Power_Control_Lever_Angle
    ( Position : in Float ) is
  begin
    JPATS_Powerplant.Test_Controller.Set_Power_Control_Lever_Angle
      (Position => Position);
  end Set_Power_Control_Lever_Angle;

  -- Access Set_Starter_Switch
  procedure Set_Starter_Switch
    ( Position : in Jpats_Powerplant_Types.Starter_Switch_Position_Type) is
  begin
    JPATS_Powerplant.Test_Controller.Set_Starter_Switch
      (Position => Position);
  end Set_Starter_Switch;

  -- Access Set_Ignition_Switch
  procedure Set_Ignition_Switch
    ( Position : in Boolean) is
  begin
    JPATS_Powerplant.Test_Controller.Set_Ignition_Switch
      (Position => Position);
  end Set_Ignition_Switch;

  -- Access Set_Pmu_Mode_Off_Switch
  procedure Set_Pmu_Mode_Off_Switch
    ( Position : in Boolean) is
  begin
    JPATS_Powerplant.Test_Controller.Set_Pmu_Mode_Off_Switch
      (Position => Position);
  end Set_Pmu_Mode_Off_Switch;


  -- Access Start_Recording_Debug_Output
  procedure Start_Recording_Debug_Output
    (Debug_Stream : in out Ada.Streams.Stream_IO.Stream_Access) is
  begin
    JPATS_Powerplant.Test_Controller.Start_Recording_Debug_Output
      (Debug_Stream => Debug_Stream);
  end Start_Recording_Debug_Output;

  -- Access Stop_Recording_Debug_Output;
  procedure Stop_Recording_Debug_Output is
  begin
    JPATS_Powerplant.Test_Controller.Stop_Recording_Debug_Output;
  end Stop_Recording_Debug_Output;

  -- Access Set_Fuel_Flow
  procedure Set_Fuel_Flow
    (Fuel_Flow : in Mass_Types.Pph) is
  begin
    JPATS_Powerplant.Test_Controller.Set_Fuel_Flow
      (Fuel_Flow => Fuel_Flow);
  end Set_Fuel_Flow;

  -- Access Reset_Test_Modes
  procedure Reset_Test_Modes is
  begin
    JPATS_Powerplant.Test_Controller.Reset_Test_Modes;
  end Reset_Test_Modes;

  -- Access Set_Cbs
  procedure Set_Cbs
    ( State : in Boolean) is
  begin
    JPATS_Powerplant.Test_Controller.Set_Cbs
      ( State => State);
  end Set_Cbs;


  -- Access Set_Weight_On_Wheels
  procedure Set_Weight_On_Wheels
    (State : in Boolean) is
  begin
    JPATS_Powerplant.Test_Controller.Set_Weight_On_Wheels
      (State => State);
  end Set_Weight_On_Wheels;

  -- procedure Set_Mach_Number
  procedure Set_Mach_Number
    (Mach_Number : in Length_Types.Mach) is
  begin
    JPATS_Powerplant.Test_Controller.Set_Mach_Number
      (Mach_Number => Mach_Number);
  end Set_Mach_Number;

  --  procedure Set_Aircraft_Cg
  procedure Set_Aircraft_Cg
    (Aircraft_Cg : in  Jpats_Propeller_Types.Coordinate_Type.Instance) is
  begin
    JPATS_Powerplant.Test_Controller.Set_Aircraft_Cg
      (Aircraft_Cg => Aircraft_Cg);
  end Set_Aircraft_Cg;

  -- Access Set_Aircraft_Angular_Rate
  procedure Set_Aircraft_Angular_Rate
    ( Aircraft_Angular_Rate : in  Jpats_Propeller_Types.Angular_Rate_Vector_Type.Instance) is
  begin
    Jpats_Powerplant.Test_Controller.Set_Aircraft_Angular_Rate
      ( Aircraft_Angular_Rate => Aircraft_Angular_Rate);
  end Set_Aircraft_Angular_Rate;

  -- Access Set_Load_Factor
  procedure Set_Load_Factor
    (Load_Factor : in Coordinate_Types.Cartesian) is
  begin
    JPATS_Powerplant.Test_Controller.Set_Load_Factor
      (Load_Factor => Load_Factor);
  end Set_Load_Factor;

  -- Access Set_Ambient_Temperature
  procedure Set_Ambient_Temperature
    (Temp : in Temperature_Types.Celsius) is
  begin
    JPATS_Powerplant.Test_Controller.Set_Ambient_Temperature
      (Temp => Temp);
  end Set_Ambient_Temperature;

  -- Access Set_Ambient_Temperature_Ratio
  procedure Set_Ambient_Temperature_Ratio
    (Ambient_Temperature_Ratio : in Normalized_Types.Normalize)is
  begin
    JPATS_Powerplant.Test_Controller.Set_Ambient_Temperature_Ratio
      (Ambient_Temperature_Ratio => Ambient_Temperature_Ratio);
  end Set_Ambient_Temperature_Ratio;

  -- Access Set_Ambient_Pressure
  procedure Set_Ambient_Pressure
    (Ambient_Pressure : in Force_Types.Pounds_Per_Sq_Feet) is
  begin
    JPATS_Powerplant.Test_Controller.Set_Ambient_Pressure
      (Ambient_Pressure => Ambient_Pressure);
  end Set_Ambient_Pressure;

  -- Access Set_Ambient_Pressure_Ratio
  procedure Set_Ambient_Pressure_Ratio
    (Ambient_Pressure_Ratio : in Normalized_Types.Normalize) is
  begin
    JPATS_Powerplant.Test_Controller.Set_Ambient_Pressure_Ratio
      (Ambient_Pressure_Ratio => Ambient_Pressure_Ratio);
  end Set_Ambient_Pressure_Ratio;

  -- Access Set_Pressure_Altitude
  procedure Set_Pressure_Altitude
    (Pressure_Altitude : in Length_Types.Feet) is
  begin
    JPATS_Powerplant.Test_Controller.Set_Pressure_Altitude
      (Pressure_Altitude => Pressure_Altitude);
  end Set_Pressure_Altitude;

  -- Access Set_Adc_Pressure_Altitude
  procedure Set_Adc_Pressure_Altitude
    (Pressure_Altitude : in Length_Types.Feet) is
  begin
    JPATS_Powerplant.Test_Controller.Set_Adc_Pressure_Altitude
      (Pressure_Altitude => Pressure_Altitude);
  end Set_Adc_Pressure_Altitude;

  -- Access Set_Adc_Mach_Number
  procedure Set_Adc_Mach_Number
    (Mach_Number : in Length_Types.Mach) is
  begin
    JPATS_Powerplant.Test_Controller.Set_Adc_Mach_Number
      (Mach_Number => Mach_Number);
  end Set_Adc_Mach_Number;

  -- Access Set_Bleed_Flow_Rate
  procedure Set_Bleed_Flow_Rate
    (Bleed_Flow_Rate : in Mass_Types.Ppm) is
  begin
    JPATS_Powerplant.Test_Controller.Set_Bleed_Flow_Rate
      (Bleed_Flow_Rate => Bleed_Flow_Rate);
  end Set_Bleed_Flow_Rate;

  -- Access Set_Air_Conditioner_Torque_Absorbed
  procedure Set_Air_Conditioner_Torque_Absorbed
    (Air_Conditioner_Torque : in Jpats_Propeller_Types.Torque_Vector_Type.Instance) is
  begin
    JPATS_Powerplant.Test_Controller.Set_Air_Conditioner_Torque_Absorbed
      (Air_Conditioner_Torque => Air_Conditioner_Torque);
  end Set_Air_Conditioner_Torque_Absorbed;

  -- Access Set_Accessory_Horsepower
  procedure Set_Accessory_Horsepower
    (Accessory_Horsepower : in Torque_Types.Horsepower) is
  begin
    JPATS_Powerplant.Test_Controller.Set_Accessory_Horsepower
      (Accessory_Horsepower => Accessory_Horsepower);
  end Set_Accessory_Horsepower;

  -- Access Set_Engine_Torque
  procedure Set_Engine_Torque
    (Torque : in Torque_Types.Ft_Lbf) is
  begin
    JPATS_Powerplant.Test_Controller.Set_Engine_Torque
      (Torque => Torque);
  end Set_Engine_Torque;

  -- Access Set_Fuel_Available;
  procedure Set_Fuel_Available is
  begin
    JPATS_Powerplant.Test_Controller.Set_Fuel_Available;
  end Set_Fuel_Available;

  -- Access Ios text box Sr1
  function Sr1 return Float is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Sr1;
  end Sr1;

  -- Access Ios text box Sr2
  function Sr2 return Float is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Sr2;
  end Sr2;

  -- Access Ios text box Sr3
  function Sr3 return Float is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Sr3;
  end Sr3;

  -- Access Ios text box Sr4
  function Sr4 return Float is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Sr4;
  end Sr4;

  -- Access Ios text box Sr5
  function Sr5 return Float is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Sr5;
  end Sr5;

  -- Access Ios text box Sr6
  function Sr6 return Float is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Sr6;
  end Sr6;

  -- Access Ios text box Sr7
  function Sr7 return Float is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Sr7;
  end Sr7;

  -- Access Ios text box Sr8
  function Sr8 return Float is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Sr8;
  end Sr8;

  -- Access Ios text box Sr9
  function Sr9 return Float is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Sr9;
  end Sr9;

  -- Access Ios text box Sr10
  function Sr10 return Float is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Sr10;
  end Sr10;

  -- Access Ios text box Srbool1
  function Srbool1 return Boolean is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Srbool1;
  end Srbool1;

  -- Access Ios text box Srbool2
  function Srbool2 return Boolean is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Srbool2;
  end Srbool2;

  -- Access Ios text box Srbool3
  function Srbool3 return Boolean is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Srbool3;
  end Srbool3;

  -- Access Ios text box Srbool4
  function Srbool4 return Boolean is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Srbool4;
  end Srbool4;

  -- Access Ios text box Srbool5
  function Srbool5 return Boolean is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Srbool5;
  end Srbool5;

  -- Access Ios text box Srbool6
  function Srbool6 return Boolean is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Srbool6;
  end Srbool6;

  -- Access Ios text box Srbool7
  function Srbool7 return Boolean is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Srbool7;
  end Srbool7;

  -- Access Ios text box Srbool8
  function Srbool8 return Boolean is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Srbool8;
  end Srbool8;

  -- Access Ios text box Srbool9
  function Srbool9 return Boolean is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Srbool9;
  end Srbool9;

  -- Access Ios text box Srbool10
  function Srbool10 return Boolean is
  begin
    return JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Srbool10;
  end Srbool10;

end JPATS_Powerplant.Test;







