-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Reference: Kimball, D., "Flight Simulation Mathematical Model of
--            the Beech MkII Joint Primary Aircraft Training System
--            (JPATS)", Document 133E794 Rev. A, 18 February, 1998,
--            FSI-SSD # 50181, pg 66.
--
--------------------------------------------------------------------
-- Reference: Flight Manual USAF/USN Series T-6A Aircraft,
--            Air Force TO 1T-6A-1
--            Navy (NAVAIR) A1-T6AAA-NFM-100
--            CVV Draft December 1998
-------------------------------------------------------------------


private package JPATS_Powerplant.Ios_Interface is

  type Instance is record
      -- Broadcast the hardware positions
      Pcl_Position                : Angle_Types.Degrees;
      Ignition_On_Switch          : Boolean;
      Ignition_Off_Switch         : Boolean;
      Starter_Man_Switch          : Boolean;
      Starter_Auto_Switch         : Boolean;
      Prop_Feather_Cut_Off_Switch : Boolean;
      Pmu_Mode_Off_Switch         : Boolean; -- FSI dwg # 6520AGF002 Pump_Sw
      Starter_Switch_Position     : Integer;


      Quick_Start_Request         : Boolean;
      Pcl_Calibrate_Request       : Boolean;
      Itt_Start_Mode              : Boolean;
      Mfen01                      : Boolean;  -- Hot Start (Auto Abort)
      Mfen02                      : Boolean;  -- Hot Start (Manual Abort)
      Mfen03                      : Boolean;  -- Hung Start
      Mfen04                      : Boolean;  -- No Start
      Mfen05                      : Boolean;  -- Fire Warning ( Normal Itt)
      Mfen06                      : Boolean;  -- Fire Warning ( High Itt )
      Mfen07                      : Boolean;  -- Engine Overheat Warning ( Bleed Air Leak)
      Mfen08                      : Boolean;  -- Engine Failure
      Mfen09                      : Boolean;  -- Engine Seizure
--    Mfen10                      : Boolean;  -- False Fire Indication (Warning_Cat)
      Mfen11                      : Boolean;  -- PMU Failure
      Mfen12                      : Boolean;  -- Loss of Useful Power
      Mfen13                      : Boolean;  -- Chip Detect
      Mfen14                      : Boolean;  -- Low Oil Pressure - Warning
      Mfen15                      : Boolean;  -- Low Oil Pressure - Caution
      Mfen16                      : Boolean;  -- High Oil Pressure
      Mfen17                      : Boolean;  -- High Oil Temperature
      Mfen18                      : Boolean;  -- Loss of oil
      Mfen19                      : Boolean;  -- Uncommanded Feather
--    mfen20                      : Boolean;  -- PIU Malfunction (Propeller_Cat)
      Mfen21                      : Boolean;  -- Oil Temp Transducer Fail
      Mfen22                      : Boolean;  -- Compressor Stall
      Mfen23                      : Boolean;  -- High Itt
      Mfen24                      : Boolean;  -- Propeller Sleeve Touchdown
      Mfen25                      : Boolean;  -- Improper Start Enable
      Mfen26                      : Boolean;  -- Flameout
      Mfen27                      : Boolean;  -- Uncontrollable High Power - PCL
      Mfen28                      : Boolean;  -- Oil/Engine/Fuel System Erratic
      Mfen29                      : Boolean;  -- Uncontrollable High Power - Firewall
      Mfen30                      : Boolean;  -- FMU Malfunction
      Mfen31                      : Boolean;  -- Fire Warning (Engine/Fuel Erratic) Malfunction

      Sr1                         : Float;
      Sr2                         : Float := 20.0;
      Sr3                         : Float;
      Sr4                         : Float;
      Sr5                         : Float;
      Sr6                         : Float;
      Sr7                         : Float;
      Sr8                         : Float;
      Sr9                         : Float;
      Sr10                        : Float;

      Srbool1                     : Boolean;
      Srbool2                     : Boolean;
      Srbool3                     : Boolean;
      Srbool4                     : Boolean;
      Srbool5                     : Boolean;
      Srbool6                     : Boolean;
      Srbool7                     : Boolean;
      Srbool8                     : Boolean;
      Srbool9                     : Boolean;
      Srbool10                    : Boolean;
  end record;

  This_Ios_Interface : Instance;

  procedure Register_Ios_Variables;

--  Write
--  Pcl
--    Systems_Reset
--    Malfs

end Jpats_Powerplant.Ios_Interface;


