-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Reference: Kimball, D., "Flight Simulation Mathematical Model of
--            the Beech MkII Joint Primary Aircraft Training System
--            (JPATS)", Document 133E794 Rev. A, 18 February, 1998,
--            FSI-SSD # 50181, pg 66.
--
--------------------------------------------------------------------
-- Reference: Flight Manual USAF/USN Series T-6A Aircraft,
--            Air Force TO 1T-6A-1
--            Navy (NAVAIR) A1-T6AAA-NFM-100
--            CVV Draft December 1998
-------------------------------------------------------------------
with Jpats_Ios_Interface;

package body JPATS_Powerplant.Ios_Interface is

   procedure Quick_Start_Request
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Quick_Start_Request := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Quick_Start_Request;

   procedure Pcl_Calibrate_Request
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Pcl_Calibrate_Request := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Pcl_Calibrate_Request;

   procedure Mfen01
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen01 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen01;

   procedure Mfen02
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen02 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen02;

   procedure Mfen03
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen03 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen03;
   procedure Mfen04
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen04 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen04;
   procedure Mfen05
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen05 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen05;
   procedure Mfen06
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen06 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen06;
   procedure Mfen07
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen07 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen07;
   procedure Mfen08
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen08 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen08;
   procedure Mfen09
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen09 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen09;
--  False Fire Detect Malfunction moved to Warning_Cat
--   procedure Mfen10
--     (PData : JPATS_IOS_Interface.Set_Value) is
--   begin
--      This_Ios_Interface.Mfen10 := Jpats_Ios_Interface.Convert_To_Bool(PData);
--   end Mfen10;
   procedure Mfen11
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen11 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen11;
   procedure Mfen12
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen12 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen12;
   procedure Mfen13
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen13 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen13;
   procedure Mfen14
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen14 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen14;
   procedure Mfen15
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen15 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen15;
   procedure Mfen16
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen16 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen16;
   procedure Mfen17
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen17 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen17;
   procedure Mfen18
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen18 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen18;
   procedure Mfen19
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
     This_Ios_Interface.Mfen19 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen19;
   procedure Mfen21
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen21 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen21;
   procedure Mfen22
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen22 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen22;
   procedure Mfen23
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen23 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen23;
   procedure Mfen24
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen24 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen24;
   procedure Mfen25
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen25 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen25;
   procedure Mfen26
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen26 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen26;
   procedure Mfen27
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen27 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen27;
   procedure Mfen28
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen28 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen28;
   procedure Mfen29
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen29 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen29;
   procedure Mfen30
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen30 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen30;
   procedure Mfen31
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Mfen31 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Mfen31;

   procedure Sr1
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Sr1 := Jpats_Ios_Interface.Convert_To_Float(PData);
   end Sr1;

   procedure Sr2
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Sr2 := Jpats_Ios_Interface.Convert_To_Float(PData);
   end Sr2;

   procedure Sr3
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
     This_Ios_Interface.Sr3 := Jpats_Ios_Interface.Convert_To_Float(PData);
   end Sr3;

   procedure Sr4
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
     This_Ios_Interface.Sr4 := Jpats_Ios_Interface.Convert_To_Float(PData);
   end Sr4;

   procedure Sr5
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
     This_Ios_Interface.Sr5 := Jpats_Ios_Interface.Convert_To_Float(PData);
   end Sr5;

   procedure Sr6
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
     This_Ios_Interface.Sr6 := Jpats_Ios_Interface.Convert_To_Float(PData);
   end Sr6;

   procedure Sr7
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
     This_Ios_Interface.Sr7 := Jpats_Ios_Interface.Convert_To_Float(PData);
   end Sr7;

   procedure Sr8
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
     This_Ios_Interface.Sr8 := Jpats_Ios_Interface.Convert_To_Float(PData);
   end Sr8;

   procedure Sr9
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
     This_Ios_Interface.Sr9 := Jpats_Ios_Interface.Convert_To_Float(PData);
   end Sr9;

   procedure Sr10
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
     This_Ios_Interface.Sr10 := Jpats_Ios_Interface.Convert_To_Float(PData);
   end Sr10;

   procedure Srbool1
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Srbool1 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Srbool1;

   procedure Srbool2
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
      This_Ios_Interface.Srbool2 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Srbool2;

   procedure Srbool3
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
     This_Ios_Interface.Srbool3 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Srbool3;

   procedure Srbool4
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
     This_Ios_Interface.Srbool4 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Srbool4;

   procedure Srbool5
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
     This_Ios_Interface.Srbool5 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Srbool5;

   procedure Srbool6
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
     This_Ios_Interface.Srbool6 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Srbool6;

   procedure Srbool7
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
     This_Ios_Interface.Srbool7 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Srbool7;

   procedure Srbool8
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
     This_Ios_Interface.Srbool8 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Srbool8;

   procedure Srbool9
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
     This_Ios_Interface.Srbool9 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Srbool9;

   procedure Srbool10
     (PData : JPATS_IOS_Interface.Set_Value) is
   begin
     This_Ios_Interface.Srbool10 := Jpats_Ios_Interface.Convert_To_Bool(PData);
   end Srbool10;

   procedure Register_Ios_Variables is

   begin

    Jpats_Ios_Interface.Register
      ( Name        => "Quick_Start",
        Variable    => This_Ios_Interface.Quick_Start_Request'Address,
        Set_Routine => Quick_Start_Request'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "Pcl_Calibrate_Request",
        Variable    => This_Ios_Interface.Pcl_Calibrate_Request'Address,
        Set_Routine => Pcl_Calibrate_Request'Access
        );

    -- Hardware Labels needed by IOS
    -- Note that in some cases these are altered by software
    -- before being sent to the IOS.  Alteration occurs in
    -- Jpats_Powerplant.Controller body in the Update procedure.

    Jpats_Ios_Interface.Register
      ( Name        => "Pcl_Position",
        Variable    => This_Ios_Interface.Pcl_Position'Address
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Ignition_On_Switch",
        Variable    => This_Ios_Interface.Ignition_On_Switch'Address
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Ignition_Off_Switch",
        Variable    => This_Ios_Interface.Ignition_Off_Switch'Address
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Starter_Man_Switch",
        Variable    => This_Ios_Interface.Starter_Man_Switch'Address
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Starter_Auto_Switch",
        Variable    => This_Ios_Interface.Starter_Auto_Switch'Address
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Prop_Feather_Cut_Off_Switch",
        Variable    => This_Ios_Interface.Prop_Feather_Cut_Off_Switch'Address
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Pmu_Mode_Switch",
        Variable    => This_Ios_Interface.Pmu_Mode_Off_Switch'Address
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Starter_Switch_Position",
        Variable    => This_Ios_Interface.Starter_Switch_Position'Address
        );

    Jpats_Ios_Interface.Register
      ( Name        => "MFEN01",
        Variable    => This_Ios_Interface.mfen01'Address,
        Set_Routine => Mfen01'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "MFEN02",
        Variable    => This_Ios_Interface.mfen02'Address,
        Set_Routine => Mfen02'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "MFEN03",
        Variable    => This_Ios_Interface.mfen03'Address,
        Set_Routine => Mfen03'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "MFEN04",
        Variable    => This_Ios_Interface.mfen04'Address,
        Set_Routine => Mfen04'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "MFEN05",
        Variable    => This_Ios_Interface.mfen05'Address,
        Set_Routine => Mfen05'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "MFEN06",
        Variable    => This_Ios_Interface.mfen06'Address,
        Set_Routine => Mfen06'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "MFEN07",
        Variable    => This_Ios_Interface.mfen07'Address,
        Set_Routine => Mfen07'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "MFEN08",
        Variable    => This_Ios_Interface.mfen08'Address,
        Set_Routine => Mfen08'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "MFEN09",
        Variable    => This_Ios_Interface.mfen09'Address,
        Set_Routine => Mfen09'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "MFEN11",
        Variable    => This_Ios_Interface.mfen11'Address,
        Set_Routine => Mfen11'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "MFEN12",
        Variable    => This_Ios_Interface.mfen12'Address,
        Set_Routine => Mfen12'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "MFEN13",
        Variable    => This_Ios_Interface.mfen13'Address,
        Set_Routine => Mfen13'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "MFEN14",
        Variable    => This_Ios_Interface.mfen14'Address,
        Set_Routine => Mfen14'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "MFEN15",
        Variable    => This_Ios_Interface.mfen15'Address,
        Set_Routine => Mfen15'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "MFEN16",
        Variable    => This_Ios_Interface.mfen16'Address,
        Set_Routine => Mfen16'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "MFEN17",
        Variable    => This_Ios_Interface.mfen17'Address,
        Set_Routine => Mfen17'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "MFEN18",
        Variable    => This_Ios_Interface.mfen18'Address,
        Set_Routine => Mfen18'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "MFEN19",
        Variable    => This_Ios_Interface.mfen19'Address,
        Set_Routine => Mfen19'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "MFEN21",
        Variable    => This_Ios_Interface.mfen21'Address,
        Set_Routine => Mfen21'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "MFEN22",
        Variable    => This_Ios_Interface.mfen22'Address,
        Set_Routine => Mfen22'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "MFEN23",
        Variable    => This_Ios_Interface.mfen23'Address,
        Set_Routine => Mfen23'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "MFEN24",
        Variable    => This_Ios_Interface.mfen24'Address,
        Set_Routine => Mfen24'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "MFEN25",
        Variable    => This_Ios_Interface.mfen25'Address,
        Set_Routine => Mfen25'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "MFEN26",
        Variable    => This_Ios_Interface.mfen26'Address,
        Set_Routine => Mfen26'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "MFEN27",
        Variable    => This_Ios_Interface.mfen27'Address,
        Set_Routine => Mfen27'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "MFEN28",
        Variable    => This_Ios_Interface.mfen28'Address,
        Set_Routine => Mfen28'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "MFEN29",
        Variable    => This_Ios_Interface.mfen29'Address,
        Set_Routine => Mfen29'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "MFEN30",
        Variable    => This_Ios_Interface.mfen30'Address,
        Set_Routine => Mfen30'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "MFEN31",
        Variable    => This_Ios_Interface.mfen31'Address,
        Set_Routine => Mfen31'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "SR1",
        Variable    => This_Ios_Interface.SR1'Address,
        Set_Routine => Sr1'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "SR2",
        Variable    => This_Ios_Interface.SR2'Address,
        Set_Routine => Sr2'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "SR3",
        Variable    => This_Ios_Interface.SR3'Address,
        Set_Routine => Sr3'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "SR4",
        Variable    => This_Ios_Interface.SR4'Address,
        Set_Routine => Sr4'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "SR5",
        Variable    => This_Ios_Interface.SR5'Address,
        Set_Routine => Sr5'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "SR6",
        Variable    => This_Ios_Interface.SR6'Address,
        Set_Routine => Sr6'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "SR7",
        Variable    => This_Ios_Interface.SR7'Address,
        Set_Routine => Sr7'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "SR8",
        Variable    => This_Ios_Interface.SR8'Address,
        Set_Routine => Sr8'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "SR9",
        Variable    => This_Ios_Interface.SR9'Address,
        Set_Routine => Sr9'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "SR10",
        Variable    => This_Ios_Interface.SR10'Address,
        Set_Routine => Sr10'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "SRBOOL1",
        Variable    => This_Ios_Interface.SRBOOL1'Address,
        Set_Routine => Srbool1'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "SRBOOL2",
        Variable    => This_Ios_Interface.SRBOOL2'Address,
        Set_Routine => Srbool2'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "SRBOOL3",
        Variable    => This_Ios_Interface.SRBOOL3'Address,
        Set_Routine => Srbool3'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "SRBOOL4",
        Variable    => This_Ios_Interface.SRBOOL4'Address,
        Set_Routine => Srbool4'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "SRBOOL5",
        Variable    => This_Ios_Interface.SRBOOL5'Address,
        Set_Routine => Srbool5'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "SRBOOL6",
        Variable    => This_Ios_Interface.SRBOOL6'Address,
        Set_Routine => Srbool6'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "SRBOOL7",
        Variable    => This_Ios_Interface.SRBOOL7'Address,
        Set_Routine => Srbool7'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "SRBOOL8",
        Variable    => This_Ios_Interface.SRBOOL8'Address,
        Set_Routine => Srbool8'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "SRBOOL9",
        Variable    => This_Ios_Interface.SRBOOL9'Address,
        Set_Routine => Srbool9'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "SRBOOL10",
        Variable    => This_Ios_Interface.SRBOOL10'Address,
        Set_Routine => Srbool10'Access
        );
    Jpats_Ios_Interface.Register
      ( Name        => "Itt_Start_Mode",
        Variable    => This_Ios_Interface.Itt_Start_Mode'Address );

   end Register_Ios_Variables;

end Jpats_Powerplant.Ios_Interface;






