-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Reference: Kimball, D., "Flight Simulation Mathematical Model of
--            the Beech MkII Joint Primary Aircraft Training System
--            (JPATS)", Document 133E794 Rev. A, 18 February, 1998,
--            FSI-SSD # 50181, pg 66.
--
--------------------------------------------------------------------
-- Reference: Flight Manual USAF/USN Series T-6A Aircraft,
--            Air Force TO 1T-6A-1
--            Navy (NAVAIR) A1-T6AAA-NFM-100
--            CVV Draft December 1998
-------------------------------------------------------------------
with Interfaces.C;

private package JPATS_Powerplant.Io_Interface is

   type Instance is record
      Pcl_Position                : Angle_Types.Degrees := Angle_Types.Degrees(20.0);
      Ignition_On_Switch          : Boolean := False;
      Ignition_Off_Switch         : Boolean := True;
      Starter_Man_Switch          : Boolean := False;
      Starter_Auto_Switch         : Boolean := False;
      Prop_Feather_Cut_Off_Switch : Boolean := False;
      Pmu_Mode_Off_Switch         : Boolean := False; -- FSI dwg # 6520AGF002 Pump_Sw
      Pcl_Driver_Position         : Angle_Types.Degrees := Angle_Types.Degrees(0.0);
      Pcl_Driver_Command          : Integer := 0;
   end record;

   Io_Size : constant := Interfaces.C.Int'Size;

   for Instance use record
     Pcl_Position                at 000*Io_Size range 0 .. 31;
     Ignition_On_Switch          at 001*Io_Size range 0 .. 31;
     Ignition_Off_Switch         at 002*Io_Size range 0 .. 31;
     Starter_Man_Switch          at 003*Io_Size range 0 .. 31;
     Starter_Auto_Switch         at 004*Io_Size range 0 .. 31;
     Prop_Feather_Cut_Off_Switch at 005*Io_Size range 0 .. 31;
     Pmu_Mode_Off_Switch         at 006*Io_Size range 0 .. 31;
     Pcl_Driver_Position         at 007*Io_Size range 0 .. 31;
     Pcl_Driver_Command          at 008*Io_Size range 0 .. 31;
   end record;

   type Auto_Test_Driver_Instance is record
      Pcl_Position                : Angle_Types.Degrees := Angle_Types.Degrees(20.0);
      Pcl_Position_Auto_Driven    : Boolean;
      Ignition_On_Switch          : Boolean := False;
      Ignition_Off_Switch         : Boolean := True;
      Ignition_Switch_Auto_Driven : Boolean;
      Starter_Man_Switch          : Boolean := False;
      Starter_Auto_Switch         : Boolean := False;
      Starter_Switch_Auto_Driven  : Boolean := False;
      Prop_Feather_Cut_Off_Switch : Boolean := False;
      Prop_Feather_Cut_Off_Switch_Auto_Driven : Boolean := False;
      Pmu_Mode_Off_Switch         : Boolean := True; -- FSI dwg # 6520AGF002 Pump_Sw
      Pmu_Mode_Off_Switch_Auto_Driven : Boolean;
   end record;

   This_Io_Interface : Instance;
   Auto_Test_Driver  : Auto_Test_Driver_Instance;

   procedure Register_Io_Variables;

end Jpats_Powerplant.Io_Interface;


