-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Reference: Kimball, D., "Flight Simulation Mathematical Model of
--            the Beech MkII Joint Primary Aircraft Training System
--            (JPATS)", Document 133E794 Rev. A, 18 February, 1998,
--            FSI-SSD # 50181, pg 66.
--
--------------------------------------------------------------------
-- Reference: Flight Manual USAF/USN Series T-6A Aircraft,
--            Air Force TO 1T-6A-1
--            Navy (NAVAIR) A1-T6AAA-NFM-100
--            CVV Draft December 1998
-------------------------------------------------------------------

with Jpats_Io;
with Jpats_Io_Types;
with Io_Types;
with Stethoscope;

package body Jpats_Powerplant.Io_Interface is

  procedure Register_Io_Variables is

--    Variable_Registered : Boolean;
  begin

    -- Map Throttle_Control
    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aici_serin_motor_position",
       A_Direction     => Io_Types.Input,
       An_Address      => This_Io_Interface.PCL_Position'Address,
       A_Size          => This_Io_Interface.PCL_Position'Size );

    Stethoscope.Register_Signal
      (Name           => "Powerplant/IO/Pcl_Position",
       Units          => "deg's",
       Object_Address => This_Io_Interface.Pcl_Position'Address,
       Value_Type     => "float",
       Scope_Index    =>  0);

    -- Map Ignition_On_Switch
    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "IGNITION_ON_SW",
       A_Direction     => Io_Types.Input,
       An_Address      => This_Io_Interface.Ignition_On_Switch'Address,
       A_Size          => This_Io_Interface.Ignition_On_Switch'Size );

    Stethoscope.Register_Signal
      (Name            => "Powerplant/IO/Ignition_On_Switch",
       Units           => "Boolean",
       Object_Address  => This_Io_Interface.Ignition_On_Switch'Address,
       Value_Type      => "uchar",
       Scope_Index     => 0);

    -- Map Ignition_Off_Switch
    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "ignition_norm_sw",
       A_Direction     => Io_Types.Input,
       An_Address      => This_Io_Interface.Ignition_Off_Switch'Address,
       A_Size          => This_Io_Interface.Ignition_Off_Switch'Size );

    Stethoscope.Register_Signal
      (Name            => "Powerplant/IO/Ignition_Off_Switch",
       Units           => "Boolean",
       Object_Address  => This_Io_Interface.Ignition_Off_Switch'address,
       Value_Type      => "uchar",
       Scope_Index     => 0);

    -- Map Starter_Man_Switch
    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "STARTER_MAN_SW",
       A_Direction     => Io_Types.Input,
       An_Address      => This_Io_Interface.Starter_Man_Switch'Address,
       A_Size          => This_Io_Interface.Starter_Man_Switch'Size );

    Stethoscope.Register_Signal
      (Name            => "Powerplant/IO/Starter_Man_Switch",
       Units           => "Boolean",
       Object_Address  => This_Io_Interface.Starter_Man_Switch'Address,
       Value_Type      => "uchar",
       Scope_Index     => 0);

    -- Map Starter_Auto_Switch
    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "STARTER_AUTO_SW",
       A_Direction     => Io_Types.Input,
       An_Address      => This_Io_Interface.Starter_Auto_Switch'Address,
       A_Size          => This_Io_Interface.Starter_Auto_Switch'Size );

    Stethoscope.Register_Signal
      (Name            => "Powerplant/IO/Starter_Auto_Switch",
       Units           => "Boolean",
       Object_Address  => This_Io_Interface.Starter_Auto_Switch'Address,
       Value_Type      => "uchar",
       Scope_Index     => 0);

    -- Map Prop_Feather_Cut_Off_Switch
--    Jpats_Io.Map_To_Icd_Mnemonic
--      (An_Interface    => Jpats_Io_Types.Flight_Deck,
--       An_Icd_Mnemonic => "PROP_FEATHER_CUT_OFF_SW",
--       A_Direction     => Io_Types.Input,
--       An_Address      => This_Io_Interface.Prop_Feather_Cut_Off_Switch'Address,
--       A_Size          => This_Io_Interface.Prop_Feather_Cut_Off_Switch'Size );

    Stethoscope.Register_Signal
      (Name            => "Powerplant/IO/Prop_Feather_Cut_Off_Switch",
       Units           => "Boolean",
       Object_Address  => This_Io_Interface.Prop_Feather_Cut_Off_Switch'Address,
       Value_Type      => "uchar",
       Scope_Index     => 0);

    -- Map Pmu_Mode_Switch
    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "PMU_MODE_SW",
       A_Direction     => Io_Types.Input,
       An_Address      => This_Io_Interface.Pmu_Mode_Off_Switch'Address,
       A_Size          => This_Io_Interface.Pmu_Mode_Off_Switch'Size );

    Stethoscope.Register_Signal
      (Name            => "Powerplant/IO/Pmu_Mode_Off_Switch",
       Units           => "Boolean",
       Object_Address  => This_Io_Interface.Pmu_Mode_Off_Switch'Address,
       Value_Type      => "uchar",
       Scope_Index     => 0);

    -- Map to throttle driver
    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_serin_motor_position",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.Pcl_Driver_Position'Address,
       A_Size          => This_Io_Interface.Pcl_Driver_Position'Size );

    -- Map to throttle driver mode command
    Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "aico_serin_motor_command",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.Pcl_Driver_Command'Address,
       A_Size          => This_Io_Interface.Pcl_Driver_Command'Size );

  end Register_Io_Variables;

end Jpats_Powerplant.Io_Interface;






