-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Reference: Kimball, D., "Flight Simulation Mathematical Model of
--            the Beech MkII Joint Primary Aircraft Training System
--            (JPATS)", Document 133E794 Rev. A, 18 February, 1998,
--            FSI-SSD # 50181, pg 66.
--
--------------------------------------------------------------------
-- Reference: Flight Manual USAF/USN Series T-6A Aircraft,
--            Air Force TO 1T-6A-1
--            Navy (NAVAIR) A1-T6AAA-NFM-100
--            CVV Draft December 1998
-------------------------------------------------------------------

with Power_Management_Unit;
with Gear_Pump;
with Centrifugal_Pump;
with Auto_Return_Relay_G;
with Fuel_Metering_Unit;
with Pratt_Whitney_Pt6a_68_Gas_Generator;
with Geometry;
with Electrical_Units_Types;
with Angle_Types;
with Length_Types;
with Mass_Types;
with Torque_Types;
with Temperature_Types;

private package JPATS_Powerplant.Container is

   package Auto_Return_Relay is
     new Auto_Return_Relay_G
           (Load_Type             => Electrical_Units_Types.Amps,
            Energized_State_Load  => 0.1 );

   package High_Pressure_Pump is new Gear_Pump
     ( Pump_Pressure_Differential_Table => "hpdiff.ito",
       Pump_Flow_Rate_Table             => "hpflow.ito",
       Bypass_Pressure_Regulating_Valve_Set_Point => Force_Types.Psi(50.0));

   package Intermediate_Pressure_Pump is new Centrifugal_Pump
     ( Pump_Pressure_Differential_Table => "ipbpump.ito",
       Bypass_Pressure_Regulating_Valve_Set_Point => Force_Types.Psi(50.0));

   type Instance is record
      The_Power_Management_Unit      : Power_Management_Unit.Instance;
      The_High_Pressure_Pump         : High_Pressure_Pump.Instance;
      The_Intermediate_Pressure_Pump : Intermediate_Pressure_Pump.Instance;
      The_Fuel_Metering_Unit         : Fuel_Metering_Unit.Instance;
      The_Auto_Start_Relay           : Auto_Return_Relay.Instance;
      The_Auto_Ignition_Relay        : Auto_Return_Relay.Instance;
      The_Start_Relay                : Auto_Return_Relay.Instance;
      The_Starter_On_Relay           : Auto_Return_Relay.Instance;
      The_Gas_Generator              : Pratt_Whitney_PT6A_68_Gas_Generator.Instance;
      The_Powerplant_Geometry        : Geometry.Instance;
      The_PMU_Fail_Relay             : Auto_Return_Relay.Instance;
      Quick_Start_Timer              : Float;
      Quick_Start                    : Boolean;
      Ignition_Exciter               : Boolean;
   end record;

   type Instance_Ptr is access all Instance;
   Buffer1 : aliased Instance;
   Buffer2 : aliased Instance;

   Next_Subsystem : Instance_Ptr := Buffer2'Access;
   This_Subsystem : Instance_Ptr := Buffer1'Access;
   Swap_Ptr       : Instance_Ptr := Buffer1'Access;

end JPATS_Powerplant.Container;




