-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0
with Ada.Text_IO;
with Ada.Streams.Stream_Io;
with Log;
with Stethoscope;
with JPATS_Powerplant;
with JPATS_Powerplant.Test;
with Jpats_Powerplant_Types;
with JPATS_Propeller;
with Jpats_Propeller_Types;
with Interpolation_Table.Singly_Indexed;
with Simulation_Dictionary;
with JPATS_Simulated_Aircraft;
with JPATS_Powerplant.Ios_Interface;

package body JPATS_Powerplant.Auto_Test_Controller is

  Test25pcl_Table     : aliased Interpolation_Table.Singly_Indexed.Instance;

  type Test_Mode_Type is ( Init, Pause, Running );
  Debug_Stream_File               : Ada.Streams.Stream_Io.File_Type;
  Debug_Stream                    : Ada.Streams.Stream_Io.Stream_Access := null;
  Test_Timer                      : Float := 0.0;
  Test_Phase                      : Natural := 0;
  Engine_Check_Case_Test          : Natural := 0;
  PMU_Check_Case_Test             : Natural := 0;
  Pcl_Position                    : Float;
  Value                           : Float;
  Reset_To_Hardware_Timer         : Float;

  function Test_Phase1 return Float is
  begin
    return Float(Test_Phase);
  end Test_Phase1;

  function Test_Number return Float is
  begin
    return Float(Pmu_Check_Case_Test);
  end Test_Number;


  procedure Open_Stream is
  begin
    begin
      Ada.Streams.Stream_Io.Open
        (File => Debug_Stream_File,
         Mode => Ada.Streams.Stream_Io.Append_File,
         Name => "/Host_Data/Debug_Stream",
         Form => "");
      Debug_Stream := Ada.Streams.Stream_Io.Stream(Debug_Stream_File);
    exception
      when Ada.Streams.Stream_Io.Name_Error =>
        Ada.Streams.Stream_Io.Create
          (File => Debug_Stream_File,
           Mode => Ada.Streams.Stream_Io.Out_File,
           Name => "/Host_Data/Debug_Stream",
           Form => "");
        Debug_Stream := Ada.Streams.Stream_Io.Stream(Debug_Stream_File);
    end;
  end Open_Stream;

  procedure Write_Output
    (Name : in String)
  is
    Eng1_Test_File                  : Ada.Text_IO.File_Type;
    Filename                        : String := ("/Host_Data/Test_Data_.xls");
  begin
    Log.Report(Filename);

    Ada.Streams.Stream_Io.Open  (File => Debug_Stream_File,
                                 Mode => Ada.Streams.Stream_Io.In_File,
                                 Name => "/Host_Data/Debug_Stream",
                                 Form => "");
    Debug_Stream := Ada.Streams.Stream_Io.Stream(File => Debug_Stream_File);
    begin
      Ada.Text_IO.Open
        (File => Eng1_Test_File,
         Mode => Ada.Text_IO.Append_File,
         Name => Filename,
         Form => "");
    exception
      when Ada.Text_IO.Name_Error =>
        Ada.Text_IO.Create
          (File => Eng1_Test_File,
           Mode => Ada.Text_IO.Out_File,
           Name => Filename,
           Form => "");
        declare
          float_Dummy : Float;
          Frame_Delimiter : String := String'Input(Debug_Stream);
        begin

          while not Ada.Streams.Stream_Io.End_Of_File(File => Debug_Stream_File) loop
            declare
              String_Dummy : String := String'Input(Debug_Stream);
            begin
              exit when String_Dummy = "|";
              Ada.Text_IO.Put(File => Eng1_Test_File,
                              Item => String_Dummy);
              Ada.Text_IO.Put(File => Eng1_Test_File,
                              Item => ",");
              float_Dummy := Float'Input(Debug_Stream);
            end;
          end loop;
          Ada.Text_IO.New_Line (File => Eng1_Test_File);
          Ada.Streams.Stream_Io.Reset(Debug_Stream_File);
          Debug_Stream := Ada.Streams.Stream_Io.Stream(File => Debug_Stream_File);
          Ada.Text_IO.Flush(File => Eng1_Test_File);
        end;
    end;

    while not Ada.Streams.Stream_Io.End_Of_File(File => Debug_Stream_File) loop
      declare
        Dummy : String := String'Input(Debug_Stream);
      begin
        if Dummy = "|" then
          declare
            Dummy1 : String := String'Input(Debug_Stream);
          begin
            Ada.Text_IO.New_Line(File => Eng1_Test_File);
          end;
        end if;
        Ada.Text_IO.Put(File => Eng1_Test_File,
                        Item => Float'Image(Float'Input(Debug_Stream)) & ",");
      end;
    end loop;
    Ada.Text_IO.Close (File => Eng1_Test_File);
    Ada.Streams.Stream_Io.Delete(File => Debug_Stream_File);
  end Write_Output;

  -- Method Update
  procedure Update
    (Next_Subsystem : in out JPATS_Powerplant.Container.Instance_Ptr;
     This_Subsystem : in     JPATS_Powerplant.Container.Instance_Ptr;
     Iconst         : in     Float) is


  begin

    if JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Srbool1 then
        Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
          (Position => JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Sr1);
    end if;
    if JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Srbool2 then
      JPATS_Powerplant.Test.Reset_Test_Modes;
      JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Srbool1 := False;
      if Reset_To_Hardware_Timer > 1.0 then
        JPATS_Powerplant.IOS_Interface.This_Ios_Interface.Srbool2 := False;
        Reset_To_Hardware_Timer := 0.0;
      else
        Reset_To_Hardware_Timer := Reset_To_Hardware_Timer + iconst;
      end if;
    end if;

    --    if Engine_Check_Case_Test = 1 then
    ----      JPATS_Powerplant.Ios_Interface.This_Ios_Interface.Quick_Start := True;
    --      Pratt_Whitney_Pt6a_68_Gas_Generator.Set_Engine_Test_Case
    --        (An_Instance => Next_Subsystem.The_Gas_Generator,
    --         Engine_Test_Case => 1);
    --      Hardware_Test := True;
    --      Prop_Feather_Cut_Off_Switch := True;
    --      Electrical_Test := True;
    --      Cbs_On := True;
    --      Atmosphere_Test := True;
    --      Drive_Pressure_Mode := 3;
    --      Pressure_Altitude := 0.0;
    --      Drive_Temperature_Mode := 1;
    --      Ambient_Temperature := 15.0;
    --      Landing_Gear_Test := True;
    --      On_Ground := True;
    --      Aircraft_Test := True;
    --      Mach_Number := 0.0;
    --      Aircraft_Cg := (169.0/12.0,0.5/12.0,90.0/12.0);
    --      Fuel_Available_Test := True;
    --      Fuel_Available := True;
    --      Environmental_Test := True;
    --      Bleed_Air_On := False;
    --      Bleed_Flow_Rate := 0.0;
    --      Adc_Test := True;
    --      Adc_Pressure_Altitude := Pressure_Altitude;
    --      Adc_Mach_Number := Mach_Number;
    --      Fuel_Flow_Debug := True;
    --      Fuel_Flow_Burn_Rate := 75.0;
    --      Accessory_Horsepower_Test := True;
    --      Accessory_Horsepower := 0.0;
    --      if Start_Test then
    --        if Test_Timer >= 0.0 and Test_Timer <= 20.0 then
    --          Open_Stream;
    --          Jpats_Powerplant.Start_Recording_Debug_Output
    --             (Debug_Stream => Debug_Stream);
    --          -- Jpats_Propeller.Start_Recording_Debug_Output
    --          --    (Debug_Stream => Debug_Stream);
    --          declare
    --            Time_Label : String := "Time";
    --          begin
    --            String'Output(Debug_Stream, Time_Label);
    --            Float'Output(Debug_Stream, Test_Timer);
    --          end;
    --
    --        else
    --          Jpats_Powerplant.Test.Stop_Recording_Debug_Output;
    --          Start_Test := False;
    --        end if;
    --
    --        if Test_Timer > 2.0 and Test_Timer <= 12.0 then
    --          Fuel_Flow_Burn_Rate := 200.0;
    --        elsif Test_Timer > 12.0 then
    --          Fuel_Flow_Burn_Rate := 0.0;
    --        end if;
    --        Test_Timer := Test_Timer + Iconst;
    --
    --      else
    --        Test_Timer := 0.0;
    --      end if;
    --
    --    elsif Engine_Check_Case_Test = 2 then
    ----      JPATS_Powerplant.Ios_Interface.This_Ios_Interface.Quick_Start := True;
    --      Pratt_Whitney_Pt6a_68_Gas_Generator.Set_Engine_Test_Case
    --        (An_Instance => Next_Subsystem.The_Gas_Generator,
    --         Engine_Test_Case => 2);
    --      Hardware_Test := True;
    --      Prop_Feather_Cut_Off_Switch := True;
    --      Electrical_Test := True;
    --      Cbs_On := True;
    --      Atmosphere_Test := True;
    --      Drive_Pressure_Mode := 3;
    --      Pressure_Altitude := 5000.0;
    --      Drive_Temperature_Mode := 1;
    --      Ambient_Temperature := 5.094452;
    --      Landing_Gear_Test := True;
    --      On_Ground := True;
    --      Aircraft_Test := True;
    --      Mach_Number := 0.3;
    --      Aircraft_Cg := (169.0/12.0,0.5/12.0,90.0/12.0);
    --      Fuel_Available_Test := True;
    --      Fuel_Available := True;
    --      Environmental_Test := True;
    --      Bleed_Air_On := False;
    --      Bleed_Flow_Rate := 5.2;
    --      Adc_Test := True;
    --      Adc_Pressure_Altitude := Pressure_Altitude;
    --      Adc_Mach_Number := Mach_Number;
    --      Fuel_Flow_Debug := True;
    --      Fuel_Flow_Burn_Rate := 160.0;
    --      Accessory_Horsepower_Test := True;
    --      Accessory_Horsepower := 7.5;
    --      if Start_Test then
    ----        JPATS_Powerplant.Ios_Interface.This_Ios_Interface.Quick_Start := False;
    --        if Test_Timer >= 0.0 and Test_Timer <= 20.0 then
    --          Open_Stream;
    --          declare
    --            Time_Label : String := "Time";
    --          begin
    --            String'Output(Debug_Stream, Time_Label);
    --          end;
    --          Float'Output(Debug_Stream, Test_Timer);
    --          Pratt_Whitney_Pt6a_68_Gas_Generator.Start_Recording
    --            (An_Instance  => Next_Subsystem.The_Gas_Generator,
    --             Debug_Stream => Debug_Stream);
    --        else
    --          Pratt_Whitney_Pt6a_68_Gas_Generator.Stop_Recording
    --            (An_Instance => Next_Subsystem.The_Gas_Generator);
    --          Start_Test := False;
    --        end if;
    --
    --        if Test_Timer > 2.0 and Test_Timer <= 12.0 then
    --          Fuel_Flow_Burn_Rate := 600.0;
    --        elsif Test_Timer > 12.0 then
    --          Fuel_Flow_Burn_Rate := 160.0;
    --        end if;
    --        Test_Timer := Test_Timer + Iconst;
    --
    --      else
    --        Test_Timer := 0.0;
    --      end if;
    --    elsif Engine_Check_Case_Test = 3 then
    ----      JPATS_Powerplant.Ios_Interface.This_Ios_Interface.Quick_Start := True;
    --      Pratt_Whitney_Pt6a_68_Gas_Generator.Set_Engine_Test_Case
    --        (An_Instance => Next_Subsystem.The_Gas_Generator,
    --         Engine_Test_Case => 3);
    --      Hardware_Test := True;
    --      Prop_Feather_Cut_Off_Switch := True;
    --      Electrical_Test := True;
    --      Cbs_On := True;
    --      Atmosphere_Test := True;
    --      Drive_Pressure_Mode := 3;
    --      Pressure_Altitude := 5000.0;
    --      Drive_Temperature_Mode := 1;
    --      Ambient_Temperature := 5.094450;
    --      Landing_Gear_Test := True;
    --      On_Ground := True;
    --      Aircraft_Test := True;
    --      Mach_Number := 0.3;
    --      Aircraft_Cg := (169.0/12.0,0.5/12.0,90.0/12.0);
    --      Fuel_Available_Test := True;
    --      Fuel_Available := True;
    --      Environmental_Test := True;
    --      Bleed_Air_On := False;
    --      Bleed_Flow_Rate := 0.0;
    --      Adc_Test := True;
    --      Adc_Pressure_Altitude := Pressure_Altitude;
    --      Adc_Mach_Number := Mach_Number;
    --      Fuel_Flow_Debug := True;
    --      Fuel_Flow_Burn_Rate := 160.0;
    --      Accessory_Horsepower_Test := True;
    --      Accessory_Horsepower := 7.5;
    --      if Start_Test then
    ----        JPATS_Powerplant.Ios_Interface.This_Ios_Interface.Quick_Start := False;
    --        if Test_Timer >= 0.0 and Test_Timer <= 20.0 then
    --          Open_Stream;
    --          declare
    --            Time_Label : String := "Time";
    --          begin
    --            String'Output(Debug_Stream, Time_Label);
    --          end;
    --          Float'Output(Debug_Stream, Test_Timer);
    --          Pratt_Whitney_Pt6a_68_Gas_Generator.Start_Recording
    --            (An_Instance  => Next_Subsystem.The_Gas_Generator,
    --             Debug_Stream => Debug_Stream);
    --        else
    --          Pratt_Whitney_Pt6a_68_Gas_Generator.Stop_Recording
    --            (An_Instance => Next_Subsystem.The_Gas_Generator);
    --          Start_Test := False;
    --        end if;
    --
    --        if Test_Timer > 2.0 and Test_Timer <= 12.0 then
    --          Fuel_Flow_Burn_Rate := 600.0;
    --        elsif Test_Timer > 12.0 then
    --          Fuel_Flow_Burn_Rate := 160.0;
    --        end if;
    --        Test_Timer := Test_Timer + Iconst;
    --
    --      else
    --        Test_Timer := 0.0;
    --      end if;
    --    elsif Engine_Check_Case_Test = 4 then
    ----      JPATS_Powerplant.Ios_Interface.This_Ios_Interface.Quick_Start := True;
    --      Pratt_Whitney_Pt6a_68_Gas_Generator.Set_Engine_Test_Case
    --        (An_Instance => Next_Subsystem.The_Gas_Generator,
    --         Engine_Test_Case => 4);
    --      Hardware_Test := True;
    --      Prop_Feather_Cut_Off_Switch := True;
    --      Electrical_Test := True;
    --      Cbs_On := True;
    --      Atmosphere_Test := True;
    --      Drive_Pressure_Mode := 3;
    --      Pressure_Altitude := 5000.0;
    --      Drive_Temperature_Mode := 1;
    --      Ambient_Temperature := 5.094450;
    --      Landing_Gear_Test := True;
    --      On_Ground := True;
    --      Aircraft_Test := True;
    --      Mach_Number := 0.3;
    --      Aircraft_Cg := (169.0/12.0,0.5/12.0,90.0/12.0);
    --      Fuel_Available_Test := True;
    --      Fuel_Available := True;
    --      Environmental_Test := True;
    --      Bleed_Air_On := False;
    --      Bleed_Flow_Rate := 5.2;
    --      Adc_Test := True;
    --      Adc_Pressure_Altitude := Pressure_Altitude;
    --      Adc_Mach_Number := Mach_Number;
    --      Fuel_Flow_Debug := True;
    --      Fuel_Flow_Burn_Rate := 160.0;
    --      Accessory_Horsepower_Test := True;
    --      Accessory_Horsepower := 0.0;
    --      if Start_Test then
    ----        JPATS_Powerplant.Ios_Interface.This_Ios_Interface.Quick_Start := False;
    --        if Test_Timer >= 0.0 and Test_Timer <= 20.0 then
    --          Open_Stream;
    --          declare
    --            Time_Label : String := "Time";
    --          begin
    --            String'Output(Debug_Stream, Time_Label);
    --          end;
    --          Float'Output(Debug_Stream, Test_Timer);
    --          Pratt_Whitney_Pt6a_68_Gas_Generator.Start_Recording
    --            (An_Instance  => Next_Subsystem.The_Gas_Generator,
    --             Debug_Stream => Debug_Stream);
    --        else
    --          Pratt_Whitney_Pt6a_68_Gas_Generator.Stop_Recording
    --            (An_Instance => Next_Subsystem.The_Gas_Generator);
    --          Start_Test := False;
    --        end if;
    --
    --        if Test_Timer > 2.0 and Test_Timer <= 12.0 then
    --          Fuel_Flow_Burn_Rate := 600.0;
    --        elsif Test_Timer > 12.0 then
    --          Fuel_Flow_Burn_Rate := 160.0;
    --        end if;
    --        Test_Timer := Test_Timer + Iconst;
    --
    --      else
    --        Test_Timer := 0.0;
    --      end if;
    --    elsif Engine_Check_Case_Test = 5 then
    ----      JPATS_Powerplant.Ios_Interface.This_Ios_Interface.Quick_Start := True;
    --      Pratt_Whitney_Pt6a_68_Gas_Generator.Set_Engine_Test_Case
    --        (An_Instance => Next_Subsystem.The_Gas_Generator,
    --         Engine_Test_Case => 5);
    --      Hardware_Test := True;
    --      Prop_Feather_Cut_Off_Switch := True;
    --      Electrical_Test := True;
    --      Cbs_On := True;
    --      Atmosphere_Test := True;
    --      Drive_Pressure_Mode := 3;
    --      Pressure_Altitude := 10000.0;
    --      Drive_Temperature_Mode := 1;
    --      Ambient_Temperature := -4.811101;
    --      Landing_Gear_Test := True;
    --      On_Ground := True;
    --      Aircraft_Test := True;
    --      Mach_Number := 0.4;
    --      Aircraft_Cg := (169.0/12.0,0.5/12.0,90.0/12.0);
    --      Fuel_Available_Test := True;
    --      Fuel_Available := True;
    --      Environmental_Test := True;
    --      Bleed_Air_On := False;
    --      Bleed_Flow_Rate := 5.2;
    --      Adc_Test := True;
    --      Adc_Pressure_Altitude := Pressure_Altitude;
    --      Adc_Mach_Number := Mach_Number;
    --      Fuel_Flow_Debug := True;
    --      Fuel_Flow_Burn_Rate := 160.0;
    --      Accessory_Horsepower_Test := True;
    --      Accessory_Horsepower := 7.5;
    --      if Start_Test then
    ----        JPATS_Powerplant.Ios_Interface.This_Ios_Interface.Quick_Start := False;
    --        if Test_Timer >= 0.0 and Test_Timer <= 20.0 then
    --          Open_Stream;
    --          declare
    --            Time_Label : String := "Time";
    --          begin
    --            String'Output(Debug_Stream, Time_Label);
    --          end;
    --          Float'Output(Debug_Stream, Test_Timer);
    --          Pratt_Whitney_Pt6a_68_Gas_Generator.Start_Recording
    --            (An_Instance  => Next_Subsystem.The_Gas_Generator,
    --             Debug_Stream => Debug_Stream);
    --        else
    --          Pratt_Whitney_Pt6a_68_Gas_Generator.Stop_Recording
    --            (An_Instance => Next_Subsystem.The_Gas_Generator);
    --          Start_Test := False;
    --        end if;
    --
    --        if Test_Timer > 2.0 and Test_Timer <= 12.0 then
    --          Fuel_Flow_Burn_Rate := 600.0;
    --        elsif Test_Timer > 12.0 then
    --          Fuel_Flow_Burn_Rate := 160.0;
    --        end if;
    --        Test_Timer := Test_Timer + Iconst;
    --
    --      else
    --        Test_Timer := 0.0;
    --      end if;
    --    elsif Engine_Check_Case_Test = 6 then
    ----      JPATS_Powerplant.Ios_Interface.This_Ios_Interface.Quick_Start := True;
    --      Pratt_Whitney_Pt6a_68_Gas_Generator.Set_Engine_Test_Case
    --        (An_Instance => Next_Subsystem.The_Gas_Generator,
    --         Engine_Test_Case => 6);
    --      Hardware_Test := True;
    --      Prop_Feather_Cut_Off_Switch := True;
    --      Electrical_Test := True;
    --      Cbs_On := True;
    --      Atmosphere_Test := True;
    --      Drive_Pressure_Mode := 3;
    --      Pressure_Altitude := 20000.0;
    --      Drive_Temperature_Mode := 1;
    --      Ambient_Temperature := -24.622200;
    --      Landing_Gear_Test := True;
    --      On_Ground := True;
    --      Aircraft_Test := True;
    --      Mach_Number := 0.5;
    --      Aircraft_Cg := (169.0/12.0,0.5/12.0,90.0/12.0);
    --      Fuel_Available_Test := True;
    --      Fuel_Available := True;
    --      Environmental_Test := True;
    --      Bleed_Air_On := False;
    --      Bleed_Flow_Rate := 5.2;
    --      Adc_Test := True;
    --      Adc_Pressure_Altitude := Pressure_Altitude;
    --      Adc_Mach_Number := Mach_Number;
    --      Fuel_Flow_Debug := True;
    --      Fuel_Flow_Burn_Rate := 160.0;
    --      Accessory_Horsepower_Test := True;
    --      Accessory_Horsepower := 7.5;
    --      if Start_Test then
    ----        JPATS_Powerplant.Ios_Interface.This_Ios_Interface.Quick_Start := False;
    --        if Test_Timer >= 0.0 and Test_Timer <= 20.0 then
    --          Open_Stream;
    --          declare
    --            Time_Label : String := "Time";
    --          begin
    --            String'Output(Debug_Stream, Time_Label);
    --          end;
    --          Float'Output(Debug_Stream, Test_Timer);
    --          Pratt_Whitney_Pt6a_68_Gas_Generator.Start_Recording
    --            (An_Instance  => Next_Subsystem.The_Gas_Generator,
    --             Debug_Stream => Debug_Stream);
    --        else
    --          Pratt_Whitney_Pt6a_68_Gas_Generator.Stop_Recording
    --            (An_Instance => Next_Subsystem.The_Gas_Generator);
    --          Start_Test := False;
    --        end if;
    --
    --        if Test_Timer > 2.0 and Test_Timer <= 12.0 then
    --          Fuel_Flow_Burn_Rate := 600.0;
    --        elsif Test_Timer > 12.0 then
    --          Fuel_Flow_Burn_Rate := 160.0;
    --        end if;
    --        Test_Timer := Test_Timer + Iconst;
    --
    --      else
    --        Test_Timer := 0.0;
    --      end if;
    --    elsif Engine_Check_Case_Test = 7 then
    ----      JPATS_Powerplant.Ios_Interface.This_Ios_Interface.Quick_Start := True;
    --      Pratt_Whitney_Pt6a_68_Gas_Generator.Set_Engine_Test_Case
    --        (An_Instance => Next_Subsystem.The_Gas_Generator,
    --         Engine_Test_Case => 7);
    --      Hardware_Test := True;
    --      Prop_Feather_Cut_Off_Switch := True;
    --      Electrical_Test := True;
    --      Cbs_On := True;
    --      Atmosphere_Test := True;
    --      Drive_Pressure_Mode := 3;
    --      Pressure_Altitude := 30000.0;
    --      Drive_Temperature_Mode := 1;
    --      Ambient_Temperature := -44.433300;
    --      Landing_Gear_Test := True;
    --      On_Ground := True;
    --      Aircraft_Test := True;
    --      Mach_Number := 0.6;
    --      Aircraft_Cg := (169.0/12.0,0.5/12.0,90.0/12.0);
    --      Fuel_Available_Test := True;
    --      Fuel_Available := True;
    --      Environmental_Test := True;
    --      Bleed_Air_On := False;
    --      Bleed_Flow_Rate := 5.2;
    --      Adc_Test := True;
    --      Adc_Pressure_Altitude := Pressure_Altitude;
    --      Adc_Mach_Number := Mach_Number;
    --      Fuel_Flow_Debug := True;
    --      Fuel_Flow_Burn_Rate := 160.0;
    --      Accessory_Horsepower_Test := True;
    --      Accessory_Horsepower := 7.5;
    --      if Start_Test then
    ----        JPATS_Powerplant.Ios_Interface.This_Ios_Interface.Quick_Start := False;
    --        if Test_Timer >= 0.0 and Test_Timer <= 20.0 then
    --          Open_Stream;
    --          declare
    --            Time_Label : String := "Time";
    --          begin
    --            String'Output(Debug_Stream, Time_Label);
    --          end;
    --          Float'Output(Debug_Stream, Test_Timer);
    --          Pratt_Whitney_Pt6a_68_Gas_Generator.Start_Recording
    --            (An_Instance  => Next_Subsystem.The_Gas_Generator,
    --             Debug_Stream => Debug_Stream);
    --        else
    --          Pratt_Whitney_Pt6a_68_Gas_Generator.Stop_Recording
    --            (An_Instance => Next_Subsystem.The_Gas_Generator);
    --          Start_Test := False;
    --        end if;
    --
    --        if Test_Timer > 2.0 and Test_Timer <= 12.0 then
    --          Fuel_Flow_Burn_Rate := 600.0;
    --        elsif Test_Timer > 12.0 then
    --          Fuel_Flow_Burn_Rate := 0.0;
    --        end if;
    --        Test_Timer := Test_Timer + Iconst;
    --
    --      else
    --        Test_Timer := 0.0;
    --      end if;
    --    end if;

--    if JPATS_Simulated_Aircraft.Bool1 then
--      Pmu_Check_Case_Test := Natural(JPATS_Simulated_Aircraft.Float1);
--    end if;
--    if JPATS_Simulated_Aircraft.Bool2 then
--      Test_Phase := Natural(JPATS_Simulated_Aircraft.Float2);
--    end if;

    if Pmu_Check_Case_Test = 1 then
      if Test_Phase = 1 then
        Test_Phase := 2;  -- pause
        Jpats_Powerplant.Test.Set_Prop_Feather_Cut_Off_Switch
          (Position => True);
        Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
          (Position => False);
        Jpats_Powerplant.Test.Set_Cbs ( State => True);
        Jpats_Powerplant.Test.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.9999953);
        JPATS_Propeller.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.9999953);
        Jpats_Powerplant.Test.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.99999090);
        JPATS_Propeller.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.99999090);
        Jpats_Powerplant.Test.Set_Weight_On_Wheels
          (State => True);
        Jpats_Powerplant.Test.Set_Mach_Number
          (Mach_Number => 0.0);
        JPATS_Propeller.Set_Mach_Number
          (Mach_Number => 0.0);

        Jpats_Powerplant.Test.Set_Aircraft_Cg
          (Aircraft_Cg => (164.7944000/12.0,0.5/12.0,90.290/12.0));
        JPATS_Propeller.Set_Aircraft_Cg
          (Aircraft_Cg => (164.7944000/12.0,0.5/12.0,90.290/12.0));
        JPATS_Propeller.Set_Aircraft_Angular_Rate
          (Aircraft_Angular_Rate => (0.0,0.0,0.0));

        JPATS_Propeller.Set_Angle_Of_Attack
          (Alpha => Angle_Types.Degrees_To_Radians(2.1411));

        JPATS_Propeller.Set_Sideslip_Angle
          ( Beta => Angle_Types.Degrees_To_Radians(0.0));
        Jpats_Powerplant.Test.Set_Fuel_Available;
        Jpats_Powerplant.Test.Set_Bleed_Flow_Rate
          (Bleed_Flow_Rate => Mass_Types.Pph(5.2));
        Jpats_Powerplant.Test.Set_Air_Conditioner_Torque_Absorbed
          (Air_Conditioner_Torque => (0.0,0.0,0.0));
        Jpats_Powerplant.Test.Set_Accessory_Horsepower
          (Accessory_Horsepower => Torque_Types.Horsepower(7.5));
        Jpats_Powerplant.Test.Set_Adc_Pressure_Altitude
          (Pressure_Altitude => 0.1310988);
        Jpats_Powerplant.Test.Set_Adc_Mach_Number
          (Mach_Number => 0.0);
        Pcl_Position := 18.0;
        Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
          (Position => Pcl_Position);

      elsif Test_Phase = 3 then -- running
        if Test_Timer >= 0.0 and Test_Timer <= 30.0 then
          if not Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            -- Log.Report("Opening stream.");
            Open_Stream;
            JPATS_Powerplant.Test.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
            JPATS_Propeller.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
          end if;

          if Test_Timer < 5.0 then
            Jpats_Powerplant.Test.Set_Weight_On_Wheels
              (State => True);
          elsif Test_Timer >= 5.0 and Test_Timer <= 15.0 then
            Jpats_Powerplant.Test.Set_Weight_On_Wheels
              (State => False);
          elsif Test_Timer > 15.0 then
            Jpats_Powerplant.Test.Set_Weight_On_Wheels
              (State => True);
          end if;
          declare
            Time_Label  : String := "Time";
            Pcl_Label : String := "Pcl_Position";
            Frame_Delimiter : String := "|";
          begin
            String'Output(Debug_Stream, Frame_Delimiter);
            String'Output(Debug_Stream, Time_Label);
            Float'Output(Debug_Stream, Test_Timer);
            String'Output(Debug_Stream, Pcl_Label);
            Float'Output(Debug_Stream, Pcl_Position);
          end;
          Test_Timer := Test_Timer + Iconst;
        else
          JPATS_Powerplant.Test.Stop_Recording_Debug_Output;
          JPATS_Propeller.Stop_Recording_Debug_Output;
          JPATS_Powerplant.Test.Reset_Test_Modes;
          JPATS_Propeller.Reset_Test_Modes;
          if Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            Ada.Streams.Stream_Io.Close(File => Debug_Stream_File);
          end if;
          Write_Output (Name => Natural'Image(Pmu_Check_Case_Test));
          Test_Phase := 1;
          Test_Timer := 0.0;
          Pmu_Check_Case_Test := 0;
        end if;
      end if;
    elsif Pmu_Check_Case_Test = 2 then
      if Test_Phase = 1 then
        Test_Phase := 2;  -- pause
        Jpats_Powerplant.Test.Set_Prop_Feather_Cut_Off_Switch
          (Position => True);
        Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
          (Position => False);
        Jpats_Powerplant.Test.Set_Cbs ( State => True);
        Jpats_Powerplant.Test.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.8320416);
        JPATS_Propeller.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.8320416);
        Jpats_Powerplant.Test.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.9656236);
        JPATS_Propeller.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.9656236);
        Jpats_Powerplant.Test.Set_Weight_On_Wheels
          (State => False);
        Jpats_Powerplant.Test.Set_Mach_Number
          (Mach_Number => 0.2);
        JPATS_Propeller.Set_Mach_Number
          (Mach_Number => 0.2);

        Jpats_Powerplant.Test.Set_Aircraft_Cg
          (Aircraft_Cg => (165.29000/12.0,0.5/12.0,91.310/12.0));
        JPATS_Propeller.Set_Aircraft_Cg
          (Aircraft_Cg => (165.29000/12.0,0.5/12.0,91.310/12.0));
        JPATS_Propeller.Set_Aircraft_Angular_Rate
          (Aircraft_Angular_Rate => (0.0,0.0,0.0));

        JPATS_Propeller.Set_Angle_Of_Attack
          (Alpha => Angle_Types.Degrees_To_Radians(0.0));

        JPATS_Propeller.Set_Sideslip_Angle
          ( Beta => Angle_Types.Degrees_To_Radians(1.5));
        Jpats_Powerplant.Test.Set_Fuel_Available;
        Jpats_Powerplant.Test.Set_Bleed_Flow_Rate
          (Bleed_Flow_Rate => Mass_Types.Pph(5.2));
        Jpats_Powerplant.Test.Set_Air_Conditioner_Torque_Absorbed
          (Air_Conditioner_Torque => (0.0,0.0,0.0));
        Jpats_Powerplant.Test.Set_Accessory_Horsepower
          (Accessory_Horsepower => Torque_Types.Horsepower(7.5));
        Jpats_Powerplant.Test.Set_Adc_Pressure_Altitude
          (Pressure_Altitude => 5000.0);
        Jpats_Powerplant.Test.Set_Adc_Mach_Number
          (Mach_Number => 0.195203);
        Pcl_Position := 18.0;
        Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
          (Position => Pcl_Position);

      elsif Test_Phase = 3 then -- running
        if Test_Timer >= 0.0 and Test_Timer <= 30.0 then
          if not Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            -- Log.Report("Opening stream.");
            Open_Stream;
            JPATS_Powerplant.Test.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
            JPATS_Propeller.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
          end if;

          if Test_Timer < 4.0 then
            value := 7.5;
          elsif Test_Timer >= 4.0 and Test_Timer <= 15.0 then
            value := 0.0;
          elsif Test_Timer > 15.0 then
            value := 7.5;
          end if;
          Jpats_Powerplant.Test.Set_Accessory_Horsepower
            (Accessory_Horsepower => Torque_Types.Horsepower(Value));

          declare
            Time_Label  : String := "Time";
            Pcl_Label : String := "Pcl_Position";
            Frame_Delimiter : String := "|";
          begin
            String'Output(Debug_Stream, Frame_Delimiter);
            String'Output(Debug_Stream, Time_Label);
            Float'Output(Debug_Stream, Test_Timer);
            String'Output(Debug_Stream, Pcl_Label);
            Float'Output(Debug_Stream, Pcl_Position);
          end;
          Test_Timer := Test_Timer + Iconst;
        else
          JPATS_Powerplant.Test.Stop_Recording_Debug_Output;
          JPATS_Propeller.Stop_Recording_Debug_Output;
          JPATS_Powerplant.Test.Reset_Test_Modes;
          JPATS_Propeller.Reset_Test_Modes;
          if Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            Ada.Streams.Stream_Io.Close(File => Debug_Stream_File);
          end if;
          Write_Output(Name => Natural'Image(Pmu_Check_Case_Test));
          Test_Phase := 1;
          Test_Timer := 0.0;
          Pmu_Check_Case_Test := 0;
        end if;
      end if;
    elsif Pmu_Check_Case_Test = 3 then
      if Test_Phase = 1 then
        Test_Phase := 2;  -- pause
        Jpats_Powerplant.Test.Set_Prop_Feather_Cut_Off_Switch
          (Position => True);
        Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
          (Position => False);
        Jpats_Powerplant.Test.Set_Cbs ( State => True);
        Jpats_Powerplant.Test.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.8320416);
        JPATS_Propeller.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.8320416);
        Jpats_Powerplant.Test.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.9656236);
        JPATS_Propeller.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.9656236);
        Jpats_Powerplant.Test.Set_Weight_On_Wheels
          (State => False);
        Jpats_Powerplant.Test.Set_Mach_Number
          (Mach_Number => 0.2);
        JPATS_Propeller.Set_Mach_Number
          (Mach_Number => 0.2);

        Jpats_Powerplant.Test.Set_Aircraft_Cg
          (Aircraft_Cg => (165.29000/12.0,0.5/12.0,91.310/12.0));
        JPATS_Propeller.Set_Aircraft_Cg
          (Aircraft_Cg => (165.29000/12.0,0.5/12.0,91.310/12.0));
        JPATS_Propeller.Set_Aircraft_Angular_Rate
          (Aircraft_Angular_Rate => (0.0,0.0,0.0));

        JPATS_Propeller.Set_Angle_Of_Attack
          (Alpha => Angle_Types.Degrees_To_Radians(0.0));

        JPATS_Propeller.Set_Sideslip_Angle
          ( Beta => Angle_Types.Degrees_To_Radians(1.5));
        Jpats_Powerplant.Test.Set_Fuel_Available;
        Jpats_Powerplant.Test.Set_Bleed_Flow_Rate
          (Bleed_Flow_Rate => Mass_Types.Pph(5.2));
        Jpats_Powerplant.Test.Set_Air_Conditioner_Torque_Absorbed
          (Air_Conditioner_Torque => (0.0,0.0,0.0));
        Jpats_Powerplant.Test.Set_Accessory_Horsepower
          (Accessory_Horsepower => Torque_Types.Horsepower(7.5));
        Jpats_Powerplant.Test.Set_Adc_Pressure_Altitude
          (Pressure_Altitude => 5000.0);
        Jpats_Powerplant.Test.Set_Adc_Mach_Number
          (Mach_Number => 0.195203);
        Pcl_Position := 18.0;
        Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
          (Position => Pcl_Position);

      elsif Test_Phase = 3 then -- running
        if Test_Timer >= 0.0 and Test_Timer <= 30.0 then
          if not Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            -- Log.Report("Opening stream.");
            Open_Stream;
            Jpats_Powerplant.Test.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
            JPATS_Propeller.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
          end if;

          if Test_Timer < 4.0 then
            value := 5.2;
          elsif Test_Timer >= 4.0 and Test_Timer <= 15.0 then
            value := 0.0;
          elsif Test_Timer > 15.0 then
            value := 5.2;
          end if;

          Jpats_Powerplant.Test.Set_Bleed_Flow_Rate
            (Bleed_Flow_Rate => Mass_Types.Pph(value));

          declare
            Time_Label  : String := "Time";
            Pcl_Label : String := "Pcl_Position";
            Frame_Delimiter : String := "|";
          begin
            String'Output(Debug_Stream, Frame_Delimiter);
            String'Output(Debug_Stream, Time_Label);
            Float'Output(Debug_Stream, Test_Timer);
            String'Output(Debug_Stream, Pcl_Label);
            Float'Output(Debug_Stream, Pcl_Position);
          end;
          Test_Timer := Test_Timer + Iconst;
        else
          if Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            Ada.Streams.Stream_Io.Close(File => Debug_Stream_File);
          end if;
          Write_Output(Name => Natural'Image(Pmu_Check_Case_Test));
          Test_Phase := 1;
          Test_Timer := 0.0;
          Pmu_Check_Case_Test := 0;
          Jpats_Powerplant.Test.Reset_Test_Modes;
          JPATS_Propeller.Reset_Test_Modes;
          Jpats_Powerplant.Test.Stop_Recording_Debug_Output;
          JPATS_Propeller.Stop_Recording_Debug_Output;
        end if;
      end if;
    elsif Pmu_Check_Case_Test = 4 then
      if Test_Phase = 1 then
        Test_Phase := 2;  -- pause
        Jpats_Powerplant.Test.Set_Prop_Feather_Cut_Off_Switch
          (Position => True);
        Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
          (Position => True);
        Jpats_Powerplant.Test.Set_Cbs ( State => True);
        Jpats_Powerplant.Test.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.9999953);
        JPATS_Propeller.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.9999953);
        Jpats_Powerplant.Test.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.99999090);
        JPATS_Propeller.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.99999090);
        Jpats_Powerplant.Test.Set_Weight_On_Wheels
          (State => True);
        Jpats_Powerplant.Test.Set_Mach_Number
          (Mach_Number => 0.0);
        JPATS_Propeller.Set_Mach_Number
          (Mach_Number => 0.0);

        Jpats_Powerplant.Test.Set_Aircraft_Cg
          (Aircraft_Cg => (164.7944000/12.0,0.5/12.0,90.290/12.0));
        JPATS_Propeller.Set_Aircraft_Cg
          (Aircraft_Cg => (164.7944000/12.0,0.5/12.0,90.290/12.0));
        JPATS_Propeller.Set_Aircraft_Angular_Rate
          (Aircraft_Angular_Rate => (0.0,0.0,0.0));

        JPATS_Propeller.Set_Angle_Of_Attack
          (Alpha => Angle_Types.Degrees_To_Radians(2.1411));

        JPATS_Propeller.Set_Sideslip_Angle
          ( Beta => Angle_Types.Degrees_To_Radians(0.0));
        Jpats_Powerplant.Test.Set_Fuel_Available;
        Jpats_Powerplant.Test.Set_Bleed_Flow_Rate
          (Bleed_Flow_Rate => Mass_Types.Pph(5.2));
        Jpats_Powerplant.Test.Set_Air_Conditioner_Torque_Absorbed
          (Air_Conditioner_Torque => (0.0,0.0,0.0));
        Jpats_Powerplant.Test.Set_Accessory_Horsepower
          (Accessory_Horsepower => Torque_Types.Horsepower(7.5));
        Jpats_Powerplant.Test.Set_Adc_Pressure_Altitude
          (Pressure_Altitude => 0.1310988);
        Jpats_Powerplant.Test.Set_Adc_Mach_Number
          (Mach_Number => 0.0);
        Pcl_Position := 18.0;
        Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
          (Position => Pcl_Position);

      elsif Test_Phase = 3 then -- running
        if Test_Timer >= 0.0 and Test_Timer <= 100.0 then
          if not Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            -- Log.Report("Opening stream.");
            Open_Stream;
            Jpats_Powerplant.Test.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
            JPATS_Propeller.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
          end if;

          if Test_Timer < 5.0 then
            Pcl_Position := 18.0;
          elsif Test_Timer >= 5.0 and Test_Timer <= 40.0 then
            pcl_position := Pcl_Position + (53.0 - 18.0)/(40.0-5.0)*Iconst;
          elsif Test_Timer > 40.0 and Test_Timer < 45.0 then
            Pcl_Position := 53.0;
          elsif Test_Timer >= 45.0 and Test_Timer <= 80.0 then
            Pcl_Position := Pcl_Position - (53.0 - 18.0)/(80.0-45.0)*Iconst;
          elsif Test_Timer > 80.0 then
            Pcl_Position := 18.0;
          end if;
          Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
            (Position => Pcl_Position);
          declare
            Time_Label  : String := "Time";
            Pcl_Label : String := "Pcl_Position";
            Frame_Delimiter : String := "|";
          begin
            String'Output(Debug_Stream, Frame_Delimiter);
            String'Output(Debug_Stream, Time_Label);
            Float'Output(Debug_Stream, Test_Timer);
            String'Output(Debug_Stream, Pcl_Label);
            Float'Output(Debug_Stream, Pcl_Position);
          end;
          Test_Timer := Test_Timer + Iconst;
        else
          if Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            Ada.Streams.Stream_Io.Close(File => Debug_Stream_File);
          end if;
          Write_Output(Name => Natural'Image(Pmu_Check_Case_Test));
          Test_Timer := 0.0;
          Pmu_Check_Case_Test := 0;
          Jpats_Powerplant.Test.Reset_Test_Modes;
          JPATS_Propeller.Reset_Test_Modes;
          Jpats_Powerplant.Test.Stop_Recording_Debug_Output;
          JPATS_Propeller.Stop_Recording_Debug_Output;
        end if;
      end if;
    elsif Pmu_Check_Case_Test = 5 then
      if Test_Phase = 1 then
        Test_Phase := 2;  -- pause
        Jpats_Powerplant.Test.Set_Prop_Feather_Cut_Off_Switch
          (Position => True);
        Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
          (Position => False);
        Jpats_Powerplant.Test.Set_Cbs ( State => True);
        Jpats_Powerplant.Test.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.9999953);
        JPATS_Propeller.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.9999953);
        Jpats_Powerplant.Test.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.99999090);
        JPATS_Propeller.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.99999090);
        Jpats_Powerplant.Test.Set_Weight_On_Wheels
          (State => True);
        Jpats_Powerplant.Test.Set_Mach_Number
          (Mach_Number => 0.0);
        JPATS_Propeller.Set_Mach_Number
          (Mach_Number => 0.0);

        Jpats_Powerplant.Test.Set_Aircraft_Cg
          (Aircraft_Cg => (164.7944000/12.0,0.5/12.0,90.290/12.0));
        JPATS_Propeller.Set_Aircraft_Cg
          (Aircraft_Cg => (164.7944000/12.0,0.5/12.0,90.290/12.0));
        JPATS_Propeller.Set_Aircraft_Angular_Rate
          (Aircraft_Angular_Rate => (0.0,0.0,0.0));

        JPATS_Propeller.Set_Angle_Of_Attack
          (Alpha => Angle_Types.Degrees_To_Radians(2.1411));

        JPATS_Propeller.Set_Sideslip_Angle
          ( Beta => Angle_Types.Degrees_To_Radians(0.0));
        Jpats_Powerplant.Test.Set_Fuel_Available;
        Jpats_Powerplant.Test.Set_Bleed_Flow_Rate
          (Bleed_Flow_Rate => Mass_Types.Pph(5.2));
        Jpats_Powerplant.Test.Set_Air_Conditioner_Torque_Absorbed
          (Air_Conditioner_Torque => (0.0,0.0,0.0));
        Jpats_Powerplant.Test.Set_Accessory_Horsepower
          (Accessory_Horsepower => Torque_Types.Horsepower(7.5));
        Jpats_Powerplant.Test.Set_Adc_Pressure_Altitude
          (Pressure_Altitude => 0.1310988);
        Jpats_Powerplant.Test.Set_Adc_Mach_Number
          (Mach_Number => 0.0);
        Pcl_Position := 18.0;
        Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
          (Position => Pcl_Position);

      elsif Test_Phase = 3 then -- running
        if Test_Timer >= 0.0 and Test_Timer <= 100.0 then
          if not Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            -- Log.Report("Opening stream.");
            Open_Stream;
            Jpats_Powerplant.Test.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
            JPATS_Propeller.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
          end if;

          if Test_Timer < 5.0 then
            Pcl_Position := 18.0;
          elsif Test_Timer >= 5.0 and Test_Timer <= 40.0 then
            pcl_position := Pcl_Position + (53.0 - 18.0)/(40.0-5.0)*Iconst;
          elsif Test_Timer >= 45.0 and Test_Timer <= 80.0 then
            Pcl_Position := Pcl_Position - (53.0 - 18.0)/(80.0-45.0)*Iconst;
          elsif Test_Timer > 80.0 then
            Pcl_Position := 18.0;
          end if;
          Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
            (Position => Pcl_Position);
          declare
            Time_Label  : String := "Time";
            Pcl_Label : String := "Pcl_Position";
            Frame_Delimiter : String := "|";
          begin
            String'Output(Debug_Stream, Frame_Delimiter);
            String'Output(Debug_Stream, Time_Label);
            Float'Output(Debug_Stream, Test_Timer);
            String'Output(Debug_Stream, Pcl_Label);
            Float'Output(Debug_Stream, Pcl_Position);
          end;
          Test_Timer := Test_Timer + Iconst;
        else
          Jpats_Powerplant.Test.Stop_Recording_Debug_Output;
          JPATS_Propeller.Stop_Recording_Debug_Output;
          Jpats_Powerplant.Test.Reset_Test_Modes;
          JPATS_Propeller.Reset_Test_Modes;
          if Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            Ada.Streams.Stream_Io.Close(File => Debug_Stream_File);
          end if;
          Write_Output (Name => Natural'Image(Pmu_Check_Case_Test));
          Test_Phase := 1;
          Test_Timer := 0.0;
          Pmu_Check_Case_Test := 0;
        end if;
      end if;
    elsif Pmu_Check_Case_Test = 6 then
      if Test_Phase = 1 then
        Test_Phase := 2;  -- pause
        Jpats_Powerplant.Test.Set_Prop_Feather_Cut_Off_Switch
          (Position => True);
        Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
          (Position => false);
        Jpats_Powerplant.Test.Set_Cbs ( State => True);
        Jpats_Powerplant.Test.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.9999953);
        JPATS_Propeller.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.9999953);
        Jpats_Powerplant.Test.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.99999090);
        JPATS_Propeller.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.99999090);
        Jpats_Powerplant.Test.Set_Weight_On_Wheels
          (State => True);
        Jpats_Powerplant.Test.Set_Mach_Number
          (Mach_Number => 0.0);
        JPATS_Propeller.Set_Mach_Number
          (Mach_Number => 0.0);
        Jpats_Powerplant.Test.Set_Aircraft_Cg
          (Aircraft_Cg => (164.7944000/12.0,0.5/12.0,90.290/12.0));
        JPATS_Propeller.Set_Aircraft_Cg
          (Aircraft_Cg => (164.7944000/12.0,0.5/12.0,90.290/12.0));
        JPATS_Propeller.Set_Aircraft_Angular_Rate
          (Aircraft_Angular_Rate => (0.0,0.0,0.0));

        JPATS_Propeller.Set_Angle_Of_Attack
          (Alpha => Angle_Types.Degrees_To_Radians(2.1411));

        JPATS_Propeller.Set_Sideslip_Angle
          ( Beta => Angle_Types.Degrees_To_Radians(0.0));
        Jpats_Powerplant.Test.Set_Fuel_Available;
        Jpats_Powerplant.Test.Set_Bleed_Flow_Rate
          (Bleed_Flow_Rate => Mass_Types.Pph(5.2));
        Jpats_Powerplant.Test.Set_Air_Conditioner_Torque_Absorbed
          (Air_Conditioner_Torque => (0.0,0.0,0.0));
        Jpats_Powerplant.Test.Set_Accessory_Horsepower
          (Accessory_Horsepower => Torque_Types.Horsepower(7.5));
        Jpats_Powerplant.Test.Set_Adc_Pressure_Altitude
          (Pressure_Altitude => 0.1310988);
        Jpats_Powerplant.Test.Set_Adc_Mach_Number
          (Mach_Number => 0.0);
        Pcl_Position := 18.0;
        Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
          (Position => Pcl_Position);

      elsif Test_Phase = 3 then -- running
        if Test_Timer >= 0.0 and Test_Timer <= 40.0 then
          if not Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            -- Log.Report("Opening stream.");
            Open_Stream;
            Jpats_Powerplant.Test.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
            JPATS_Propeller.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
          end if;

          if Test_Timer <= 5.0 then
            Pcl_Position := 18.0;
          elsif Test_Timer >= 5.0 and Test_Timer <= 15.0 then
            pcl_position := 53.0;
          elsif Test_Timer > 15.0 then
            Pcl_Position := 18.0;
          end if;
          Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
            (Position => Pcl_Position);
          declare
            Time_Label  : String := "Time";
            Pcl_Label : String := "Pcl_Position";
            Frame_Delimiter : String := "|";
          begin
            String'Output(Debug_Stream, Frame_Delimiter);
            String'Output(Debug_Stream, Time_Label);
            Float'Output(Debug_Stream, Test_Timer);
            String'Output(Debug_Stream, Pcl_Label);
            Float'Output(Debug_Stream, Pcl_Position);
          end;
          Test_Timer := Test_Timer + Iconst;
        else
          if Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            Ada.Streams.Stream_Io.Close(File => Debug_Stream_File);
          end if;
          Write_Output(Name => Natural'Image(Pmu_Check_Case_Test));
          Test_Phase := 1;
          Test_Timer := 0.0;
          Pmu_Check_Case_Test := 0;
          Jpats_Powerplant.Test.Reset_Test_Modes;
          JPATS_Propeller.Reset_Test_Modes;
          Jpats_Powerplant.Test.Stop_Recording_Debug_Output;
          JPATS_Propeller.Stop_Recording_Debug_Output;
        end if;
      end if;
    elsif Pmu_Check_Case_Test = 7 then
      if Test_Phase = 1 then
        Test_Phase := 2;  -- pause
        Jpats_Powerplant.Test.Set_Prop_Feather_Cut_Off_Switch
          (Position => True);
        Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
          (Position => False);
        Jpats_Powerplant.Test.Set_Cbs ( State => True);
        Jpats_Powerplant.Test.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.8320416);
        JPATS_Propeller.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.8320416);
        Jpats_Powerplant.Test.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.9656236);
        JPATS_Propeller.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.9656236);
        Jpats_Powerplant.Test.Set_Weight_On_Wheels
          (State => False);
        Jpats_Powerplant.Test.Set_Mach_Number
          (Mach_Number => 0.2);
        JPATS_Propeller.Set_Mach_Number
          (Mach_Number => 0.2);

        Jpats_Powerplant.Test.Set_Aircraft_Cg
          (Aircraft_Cg => (165.29000/12.0,0.5/12.0,91.310/12.0));
        JPATS_Propeller.Set_Aircraft_Cg
          (Aircraft_Cg => (165.29000/12.0,0.5/12.0,91.310/12.0));
        JPATS_Propeller.Set_Aircraft_Angular_Rate
          (Aircraft_Angular_Rate => (0.0,0.0,0.0));

        JPATS_Propeller.Set_Angle_Of_Attack
          (Alpha => Angle_Types.Degrees_To_Radians(0.0));

        JPATS_Propeller.Set_Sideslip_Angle
          ( Beta => Angle_Types.Degrees_To_Radians(1.5));
        Jpats_Powerplant.Test.Set_Fuel_Available;
        Jpats_Powerplant.Test.Set_Bleed_Flow_Rate
          (Bleed_Flow_Rate => Mass_Types.Pph(5.2));
        Jpats_Powerplant.Test.Set_Air_Conditioner_Torque_Absorbed
          (Air_Conditioner_Torque => (0.0,0.0,0.0));
        Jpats_Powerplant.Test.Set_Accessory_Horsepower
          (Accessory_Horsepower => Torque_Types.Horsepower(7.5));
        Jpats_Powerplant.Test.Set_Adc_Pressure_Altitude
          (Pressure_Altitude => 5000.0);
        Jpats_Powerplant.Test.Set_Adc_Mach_Number
          (Mach_Number => 0.195203);
        Pcl_Position := 18.0;
        Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
          (Position => Pcl_Position);

      elsif Test_Phase = 3 then -- running
        if Test_Timer >= 0.0 and Test_Timer <= 100.0 then
          if not Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            -- Log.Report("Opening stream.");
            Open_Stream;
            Jpats_Powerplant.Test.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
            JPATS_Propeller.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
          end if;

          if Test_Timer < 5.0 then
            Pcl_Position := 18.0;
          elsif Test_Timer >= 5.0 and Test_Timer <= 40.0 then
            pcl_position := Pcl_Position + (53.0 - 18.0)/(40.0-5.0)*Iconst;
          elsif Test_Timer > 40.0 and Test_Timer < 50.0 then
            Pcl_Position := 53.0;
          elsif Test_Timer >= 50.0 and Test_Timer <= 85.0 then
            Pcl_Position := Pcl_Position - (53.0 - 18.0)/(80.0-45.0)*Iconst;
          elsif Test_Timer > 85.0 then
            Pcl_Position := 18.0;
          end if;
          Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
            (Position => Pcl_Position);
          declare
            Time_Label  : String := "Time";
            Pcl_Label : String := "Pcl_Position";
            Frame_Delimiter : String := "|";
          begin
            String'Output(Debug_Stream, Frame_Delimiter);
            String'Output(Debug_Stream, Time_Label);
            Float'Output(Debug_Stream, Test_Timer);
            String'Output(Debug_Stream, Pcl_Label);
            Float'Output(Debug_Stream, Pcl_Position);
          end;
          Test_Timer := Test_Timer + Iconst;
        else
          if Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            Ada.Streams.Stream_Io.Close(File => Debug_Stream_File);
          end if;
          Write_Output(Name => Natural'Image(Pmu_Check_Case_Test));
          Test_Phase := 1;
          Test_Timer := 0.0;
          Pmu_Check_Case_Test := 0;
          Jpats_Powerplant.Test.Reset_Test_Modes;
          JPATS_Propeller.Reset_Test_Modes;
          Jpats_Powerplant.Test.Stop_Recording_Debug_Output;
          JPATS_Propeller.Stop_Recording_Debug_Output;
        end if;
      end if;
    elsif Pmu_Check_Case_Test = 8 then
      if Test_Phase = 1 then
        Test_Phase := 2;  -- pause
        Jpats_Powerplant.Test.Set_Prop_Feather_Cut_Off_Switch
          (Position => True);
        Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
          (Position => false);
        Jpats_Powerplant.Test.Set_Cbs ( State => True);
        Jpats_Powerplant.Test.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.8320416);
        JPATS_Propeller.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.8320416);
        Jpats_Powerplant.Test.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.9656236);
        JPATS_Propeller.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.9656236);
        Jpats_Powerplant.Test.Set_Weight_On_Wheels
          (State => false);
        Jpats_Powerplant.Test.Set_Mach_Number
          (Mach_Number => 0.2);
        JPATS_Propeller.Set_Mach_Number
          (Mach_Number => 0.2);
        Jpats_Powerplant.Test.Set_Aircraft_Cg
          (Aircraft_Cg => (165.2900000/12.0,0.5/12.0,91.310/12.0));
        JPATS_Propeller.Set_Aircraft_Cg
          (Aircraft_Cg => (165.2900000/12.0,0.5/12.0,91.310/12.0));
        JPATS_Propeller.Set_Aircraft_Angular_Rate
          (Aircraft_Angular_Rate => (0.0,0.0,0.0));

        JPATS_Propeller.Set_Angle_Of_Attack
          (Alpha => Angle_Types.Degrees_To_Radians(0.0));

        JPATS_Propeller.Set_Sideslip_Angle
          ( Beta => Angle_Types.Degrees_To_Radians(1.5));
        Jpats_Powerplant.Test.Set_Fuel_Available;
        Jpats_Powerplant.Test.Set_Bleed_Flow_Rate
          (Bleed_Flow_Rate => Mass_Types.Pph(5.2));
        Jpats_Powerplant.Test.Set_Air_Conditioner_Torque_Absorbed
          (Air_Conditioner_Torque => (0.0,0.0,0.0));
        Jpats_Powerplant.Test.Set_Accessory_Horsepower
          (Accessory_Horsepower => Torque_Types.Horsepower(7.5));
        Jpats_Powerplant.Test.Set_Adc_Pressure_Altitude
          (Pressure_Altitude => 5000.0);
        Jpats_Powerplant.Test.Set_Adc_Mach_Number
          (Mach_Number => 0.1952031);
        Pcl_Position := 18.0;
        Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
          (Position => Pcl_Position);

      elsif Test_Phase = 3 then -- running
        if Test_Timer >= 0.0 and Test_Timer <= 25.0 then
          if not Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            -- Log.Report("Opening stream.");
            Open_Stream;
            Jpats_Powerplant.Test.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
            JPATS_Propeller.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
          end if;

          if Test_Timer <= 5.0 then
            Pcl_Position := 18.0;
          elsif Test_Timer >= 5.0 and Test_Timer <= 15.0 then
            pcl_position := 53.0;
          elsif Test_Timer > 15.0 then
            Pcl_Position := 18.0;
          end if;
          Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
            (Position => Pcl_Position);
          declare
            Time_Label  : String := "Time";
            Pcl_Label : String := "Pcl_Position";
            Frame_Delimiter : String := "|";
          begin
            String'Output(Debug_Stream, Frame_Delimiter);
            String'Output(Debug_Stream, Time_Label);
            Float'Output(Debug_Stream, Test_Timer);
            String'Output(Debug_Stream, Pcl_Label);
            Float'Output(Debug_Stream, Pcl_Position);
          end;
          Test_Timer := Test_Timer + Iconst;
        else
          if Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            Ada.Streams.Stream_Io.Close(File => Debug_Stream_File);
          end if;
          Write_Output(Name => Natural'Image(Pmu_Check_Case_Test));
          Test_Phase := 1;
          Test_Timer := 0.0;
          Pmu_Check_Case_Test := 0;
          Jpats_Powerplant.Test.Reset_Test_Modes;
          JPATS_Propeller.Reset_Test_Modes;
          Jpats_Powerplant.Test.Stop_Recording_Debug_Output;
          JPATS_Propeller.Stop_Recording_Debug_Output;
        end if;
      end if;
    elsif Pmu_Check_Case_Test = 9 then
      if Test_Phase = 1 then
        Test_Phase := 2;  -- pause
        Jpats_Powerplant.Test.Set_Prop_Feather_Cut_Off_Switch
          (Position => True);
        Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
          (Position => False);
        Jpats_Powerplant.Test.Set_Cbs ( State => True);
        Jpats_Powerplant.Test.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.6876936);
        JPATS_Propeller.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.6876936);
        Jpats_Powerplant.Test.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.9312473);
        JPATS_Propeller.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.9312473);
        Jpats_Powerplant.Test.Set_Weight_On_Wheels
          (State => False);
        Jpats_Powerplant.Test.Set_Mach_Number
          (Mach_Number => 0.4);
        JPATS_Propeller.Set_Mach_Number
          (Mach_Number => 0.4);

        Jpats_Powerplant.Test.Set_Aircraft_Cg
          (Aircraft_Cg => (165.29000/12.0,0.5/12.0,91.310/12.0));
        JPATS_Propeller.Set_Aircraft_Cg
          (Aircraft_Cg => (165.29000/12.0,0.5/12.0,91.310/12.0));
        JPATS_Propeller.Set_Aircraft_Angular_Rate
          (Aircraft_Angular_Rate => (0.0,0.0,0.0));

        JPATS_Propeller.Set_Angle_Of_Attack
          (Alpha => Angle_Types.Degrees_To_Radians(0.0));

        JPATS_Propeller.Set_Sideslip_Angle
          ( Beta => Angle_Types.Degrees_To_Radians(1.5));
        Jpats_Powerplant.Test.Set_Fuel_Available;
        Jpats_Powerplant.Test.Set_Bleed_Flow_Rate
          (Bleed_Flow_Rate => Mass_Types.Pph(5.2));
        Jpats_Powerplant.Test.Set_Air_Conditioner_Torque_Absorbed
          (Air_Conditioner_Torque => (0.0,0.0,0.0));
        Jpats_Powerplant.Test.Set_Accessory_Horsepower
          (Accessory_Horsepower => Torque_Types.Horsepower(7.5));
        Jpats_Powerplant.Test.Set_Adc_Pressure_Altitude
          (Pressure_Altitude => 10000.0);
        Jpats_Powerplant.Test.Set_Adc_Mach_Number
          (Mach_Number => 0.3934562);
        Pcl_Position := 18.0;
        Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
          (Position => Pcl_Position);

      elsif Test_Phase = 3 then -- running
        if Test_Timer >= 0.0 and Test_Timer <= 100.0 then
          if not Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            -- Log.Report("Opening stream.");
            Open_Stream;
            Jpats_Powerplant.Test.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
            JPATS_Propeller.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
          end if;

          if Test_Timer < 5.0 then
            Pcl_Position := 19.249;
          elsif Test_Timer >= 5.0 and Test_Timer <= 40.0 then
            pcl_position := Pcl_Position + (53.0 - 18.0)/(40.0-5.0)*Iconst;
          elsif Test_Timer > 40.0 and Test_Timer < 50.0 then
            Pcl_Position := 54.249;
          elsif Test_Timer >= 50.0 and Test_Timer <= 85.0 then
            Pcl_Position := Pcl_Position - (53.0 - 18.0)/(80.0-45.0)*Iconst;
          elsif Test_Timer > 85.0 then
            Pcl_Position := 19.249;
          end if;
          Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
            (Position => Pcl_Position);
          declare
            Time_Label  : String := "Time";
            Pcl_Label : String := "Pcl_Position";
            Frame_Delimiter : String := "|";
          begin
            String'Output(Debug_Stream, Frame_Delimiter);
            String'Output(Debug_Stream, Time_Label);
            Float'Output(Debug_Stream, Test_Timer);
            String'Output(Debug_Stream, Pcl_Label);
            Float'Output(Debug_Stream, Pcl_Position);
          end;
          Test_Timer := Test_Timer + Iconst;
        else
          if Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            Ada.Streams.Stream_Io.Close(File => Debug_Stream_File);
          end if;
          Write_Output(Name => Natural'Image(Pmu_Check_Case_Test));
          Test_Phase := 1;
          Test_Timer := 0.0;
          Pmu_Check_Case_Test := 0;
          Jpats_Powerplant.Test.Reset_Test_Modes;
          JPATS_Propeller.Reset_Test_Modes;
          Jpats_Powerplant.Test.Stop_Recording_Debug_Output;
          JPATS_Propeller.Stop_Recording_Debug_Output;
        end if;
      end if;
    elsif Pmu_Check_Case_Test = 10 then
      if Test_Phase = 1 then
        Test_Phase := 2;  -- pause
        Jpats_Powerplant.Test.Set_Prop_Feather_Cut_Off_Switch
          (Position => True);
        Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
          (Position => false);
        Jpats_Powerplant.Test.Set_Cbs ( State => True);
        Jpats_Powerplant.Test.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.6876936);
        JPATS_Propeller.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.6876936);
        Jpats_Powerplant.Test.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.9312473);
        JPATS_Propeller.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.9312473);
        Jpats_Powerplant.Test.Set_Weight_On_Wheels
          (State => False);
        Jpats_Powerplant.Test.Set_Mach_Number
          (Mach_Number => 0.4);
        JPATS_Propeller.Set_Mach_Number
          (Mach_Number => 0.4);
        Jpats_Powerplant.Test.Set_Aircraft_Cg
          (Aircraft_Cg => (165.2900/12.0,0.5/12.0,91.31/12.0));
        JPATS_Propeller.Set_Aircraft_Cg
          (Aircraft_Cg => (165.2900/12.0,0.5/12.0,91.31/12.0));
        JPATS_Propeller.Set_Aircraft_Angular_Rate
          (Aircraft_Angular_Rate => (0.0,0.0,0.0));

        JPATS_Propeller.Set_Angle_Of_Attack
          (Alpha => Angle_Types.Degrees_To_Radians(0.0));

        JPATS_Propeller.Set_Sideslip_Angle
          ( Beta => Angle_Types.Degrees_To_Radians(1.5));
        Jpats_Powerplant.Test.Set_Fuel_Available;
        Jpats_Powerplant.Test.Set_Bleed_Flow_Rate
          (Bleed_Flow_Rate => Mass_Types.Pph(5.2));
        Jpats_Powerplant.Test.Set_Air_Conditioner_Torque_Absorbed
          (Air_Conditioner_Torque => (0.0,0.0,0.0));
        Jpats_Powerplant.Test.Set_Accessory_Horsepower
          (Accessory_Horsepower => Torque_Types.Horsepower(7.5));
        Jpats_Powerplant.Test.Set_Adc_Pressure_Altitude
          (Pressure_Altitude => 10000.0);
        Jpats_Powerplant.Test.Set_Adc_Mach_Number
          (Mach_Number => 0.3934532);
        Pcl_Position := 18.0;
        Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
          (Position => Pcl_Position);

      elsif Test_Phase = 3 then -- running
        if Test_Timer >= 0.0 and Test_Timer <= 25.0 then
          if not Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            -- Log.Report("Opening stream.");
            Open_Stream;
            Jpats_Powerplant.Test.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
            JPATS_Propeller.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
          end if;

          if Test_Timer <= 5.0 then
            Pcl_Position := 19.249;
          elsif Test_Timer >= 5.0 and Test_Timer <= 15.0 then
            pcl_position := 54.249;
          elsif Test_Timer > 15.0 then
            Pcl_Position := 19.249;
          end if;
          Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
            (Position => Pcl_Position);
          declare
            Time_Label  : String := "Time";
            Pcl_Label : String := "Pcl_Position";
            Frame_Delimiter : String := "|";
          begin
            String'Output(Debug_Stream, Frame_Delimiter);
            String'Output(Debug_Stream, Time_Label);
            Float'Output(Debug_Stream, Test_Timer);
            String'Output(Debug_Stream, Pcl_Label);
            Float'Output(Debug_Stream, Pcl_Position);
          end;
          Test_Timer := Test_Timer + Iconst;
        else
          Jpats_Powerplant.Test.Stop_Recording_Debug_Output;
          JPATS_Propeller.Stop_Recording_Debug_Output;
          Jpats_Powerplant.Test.Reset_Test_Modes;
          JPATS_Propeller.Reset_Test_Modes;
          if Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            Ada.Streams.Stream_Io.Close(File => Debug_Stream_File);
          end if;
          Write_Output(Name => "a" ); -- Natural'Image(Pmu_Check_Case_Test));
          Test_Phase := 1;
          Test_Timer := 0.0;
          Pmu_Check_Case_Test := 0;
        end if;
      end if;
    elsif Pmu_Check_Case_Test = 11 then
      if Test_Phase = 1 then
        Test_Phase := 2;  -- pause
        Jpats_Powerplant.Test.Set_Prop_Feather_Cut_Off_Switch
          (Position => True);
        Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
          (Position => false);
        Jpats_Powerplant.Test.Set_Cbs ( State => True);
        Jpats_Powerplant.Test.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.6876936);
        JPATS_Propeller.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.6876936);
        Jpats_Powerplant.Test.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.9312473);
        JPATS_Propeller.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.9312473);
        Jpats_Powerplant.Test.Set_Weight_On_Wheels
          (State => False);
        Jpats_Powerplant.Test.Set_Mach_Number
          (Mach_Number => 0.4);
        JPATS_Propeller.Set_Mach_Number
          (Mach_Number => 0.4);
        Jpats_Powerplant.Test.Set_Aircraft_Cg
          (Aircraft_Cg => (165.2900/12.0,0.5/12.0,91.31/12.0));
        JPATS_Propeller.Set_Aircraft_Cg
          (Aircraft_Cg => (165.2900/12.0,0.5/12.0,91.31/12.0));
        JPATS_Propeller.Set_Aircraft_Angular_Rate
          (Aircraft_Angular_Rate => (0.0,0.0,0.0));

        JPATS_Propeller.Set_Angle_Of_Attack
          (Alpha => Angle_Types.Degrees_To_Radians(0.0));

        JPATS_Propeller.Set_Sideslip_Angle
          ( Beta => Angle_Types.Degrees_To_Radians(1.5));
        Jpats_Powerplant.Test.Set_Fuel_Available;
        Jpats_Powerplant.Test.Set_Bleed_Flow_Rate
          (Bleed_Flow_Rate => Mass_Types.Pph(5.2));
        Jpats_Powerplant.Test.Set_Air_Conditioner_Torque_Absorbed
          (Air_Conditioner_Torque => (0.0,0.0,0.0));
        Jpats_Powerplant.Test.Set_Accessory_Horsepower
          (Accessory_Horsepower => Torque_Types.Horsepower(7.5));
        Jpats_Powerplant.Test.Set_Adc_Pressure_Altitude
          (Pressure_Altitude => 10000.0);
        Jpats_Powerplant.Test.Set_Adc_Mach_Number
          (Mach_Number => 0.3934532);
        Pcl_Position := 18.0;
        Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
          (Position => Pcl_Position);

      elsif Test_Phase = 3 then -- running
        if Test_Timer >= 0.0 and Test_Timer <= 80.0 then
          if not Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            -- Log.Report("Opening stream.");
            Open_Stream;
            Jpats_Powerplant.Test.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
            JPATS_Propeller.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
          end if;

          if Test_Timer <= 5.0 then
            Pcl_Position := 19.249;
          elsif Test_Timer > 5.0 and Test_Timer <= 10.0 then
            pcl_position := 24.249;
          elsif Test_Timer > 10.0 and Test_Timer <= 15.0 then
            pcl_position := 29.249;
          elsif Test_Timer > 15.0 and Test_Timer <= 20.0 then
            pcl_position := 34.249;
          elsif Test_Timer > 20.0 and Test_Timer <= 25.0 then
            pcl_position := 39.249;
          elsif Test_Timer > 25.0 and Test_Timer <= 30.0 then
            pcl_position := 44.249;
          elsif Test_Timer > 30.0 and Test_Timer <= 35.0 then
            pcl_position := 49.249;
          elsif Test_Timer > 35.0 and Test_Timer <= 40.0 then
            pcl_position := 54.249;
          elsif Test_Timer > 40.0 and Test_Timer <= 45.0 then
            pcl_position := 49.249;
          elsif Test_Timer > 45.0 and Test_Timer <= 50.0 then
            pcl_position := 44.249;
          elsif Test_Timer > 50.0 and Test_Timer <= 55.0 then
            pcl_position := 39.249;
          elsif Test_Timer > 55.0 and Test_Timer <= 60.0 then
            pcl_position := 34.249;
          elsif Test_Timer > 60.0 and Test_Timer <= 65.0 then
            pcl_position := 29.249;
          elsif Test_Timer > 65.0 and Test_Timer <= 70.0 then
            pcl_position := 24.249;
          elsif Test_Timer > 70.0 then
            Pcl_Position := 19.249;
          end if;
          Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
            (Position => Pcl_Position);
          declare
            Time_Label  : String := "Time";
            Pcl_Label : String := "Pcl_Position";
            Frame_Delimiter : String := "|";
          begin
            String'Output(Debug_Stream, Frame_Delimiter);
            String'Output(Debug_Stream, Time_Label);
            Float'Output(Debug_Stream, Test_Timer);
            String'Output(Debug_Stream, Pcl_Label);
            Float'Output(Debug_Stream, Pcl_Position);
          end;
          Test_Timer := Test_Timer + Iconst;
        else
          if Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            Ada.Streams.Stream_Io.Close(File => Debug_Stream_File);
          end if;
          Write_Output(Name => Natural'Image(Pmu_Check_Case_Test));
          Test_Phase := 1;
          Test_Timer := 0.0;
          Pmu_Check_Case_Test := 0;
          Jpats_Powerplant.Test.Reset_Test_Modes;
          JPATS_Propeller.Reset_Test_Modes;
          Jpats_Powerplant.Test.Stop_Recording_Debug_Output;
          JPATS_Propeller.Stop_Recording_Debug_Output;
        end if;
      end if;
    elsif Pmu_Check_Case_Test = 12 then
      if Test_Phase = 1 then
        Test_Phase := 2;  -- pause
        Jpats_Powerplant.Test.Set_Prop_Feather_Cut_Off_Switch
          (Position => True);
        Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
          (Position => True);
        Jpats_Powerplant.Test.Set_Cbs ( State => True);
        Jpats_Powerplant.Test.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.6876936);
        JPATS_Propeller.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.6876936);
        Jpats_Powerplant.Test.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.9312473);
        JPATS_Propeller.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.9312473);
        Jpats_Powerplant.Test.Set_Weight_On_Wheels
          (State => False);
        Jpats_Powerplant.Test.Set_Mach_Number
          (Mach_Number => 0.3999154);
        JPATS_Propeller.Set_Mach_Number
          (Mach_Number => 0.3999154);

        Jpats_Powerplant.Test.Set_Aircraft_Cg
          (Aircraft_Cg => (165.29/12.0,0.0/12.0,91.31/12.0));
        JPATS_Propeller.Set_Aircraft_Cg
          (Aircraft_Cg => (165.29/12.0,0.0/12.0,91.31/12.0));
        JPATS_Propeller.Set_Aircraft_Angular_Rate
          (Aircraft_Angular_Rate => (0.0,0.0,0.0));

        JPATS_Propeller.Set_Angle_Of_Attack
          (Alpha => Angle_Types.Degrees_To_Radians(0.0));

        JPATS_Propeller.Set_Sideslip_Angle
          ( Beta => Angle_Types.Degrees_To_Radians(1.5));
        Jpats_Powerplant.Test.Set_Fuel_Available;
        Jpats_Powerplant.Test.Set_Bleed_Flow_Rate
          (Bleed_Flow_Rate => Mass_Types.Pph(5.2));
        Jpats_Powerplant.Test.Set_Air_Conditioner_Torque_Absorbed
          (Air_Conditioner_Torque => (0.0,0.0,0.0));
        Jpats_Powerplant.Test.Set_Accessory_Horsepower
          (Accessory_Horsepower => Torque_Types.Horsepower(7.5));
        Jpats_Powerplant.Test.Set_Adc_Pressure_Altitude
          (Pressure_Altitude => 10000.0);
        Jpats_Powerplant.Test.Set_Adc_Mach_Number
          (Mach_Number => 0.393453);
        Pcl_Position := 18.0;
        Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
          (Position => Pcl_Position);

      elsif Test_Phase = 3 then -- running
        if Test_Timer >= 0.0 and Test_Timer <= 40.0 then
          if not Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            -- Log.Report("Opening stream.");
            Open_Stream;
            Jpats_Powerplant.Test.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
            JPATS_Propeller.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
          end if;

          if Test_Timer <= 5.0 then
            Pcl_Position := 18.0;
          elsif Test_Timer >= 5.0 and Test_Timer <= 15.0 then
            pcl_position := 53.0;
          elsif Test_Timer > 15.0 then
            Pcl_Position := 18.0;
          end if;
          Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
            (Position => Pcl_Position);
          declare
            Time_Label  : String := "Time";
            Pcl_Label : String := "Pcl_Position";
            Frame_Delimiter : String := "|";
          begin
            String'Output(Debug_Stream, Frame_Delimiter);
            String'Output(Debug_Stream, Time_Label);
            Float'Output(Debug_Stream, Test_Timer);
            String'Output(Debug_Stream, Pcl_Label);
            Float'Output(Debug_Stream, Pcl_Position);
          end;
          Test_Timer := Test_Timer + Iconst;
        else
          if Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            Ada.Streams.Stream_Io.Close(File => Debug_Stream_File);
          end if;
          Write_Output(Name => Natural'Image(Pmu_Check_Case_Test));
          Test_Phase := 1;
          Test_Timer := 0.0;
          Pmu_Check_Case_Test := 0;
          Jpats_Powerplant.Test.Reset_Test_Modes;
          JPATS_Propeller.Reset_Test_Modes;
          Jpats_Powerplant.Test.Stop_Recording_Debug_Output;
          JPATS_Propeller.Stop_Recording_Debug_Output;
        end if;
      end if;
    elsif Pmu_Check_Case_Test = 13 then
      if Test_Phase = 1 then
        Test_Phase := 2;  -- pause
        Jpats_Powerplant.Test.Set_Prop_Feather_Cut_Off_Switch
          (Position => True);
        Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
          (Position => false);
        Jpats_Powerplant.Test.Set_Cbs ( State => True);
        Jpats_Powerplant.Test.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.6876936);
        JPATS_Propeller.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.6876936);
        Jpats_Powerplant.Test.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.9312473);
        JPATS_Propeller.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.9312473);
        Jpats_Powerplant.Test.Set_Weight_On_Wheels
          (State => False);
        Jpats_Powerplant.Test.Set_Mach_Number
          (Mach_Number => 0.4);
        JPATS_Propeller.Set_Mach_Number
          (Mach_Number => 0.4);
        Jpats_Powerplant.Test.Set_Aircraft_Cg
          (Aircraft_Cg => (165.2900/12.0,0.5/12.0,91.31/12.0));
        JPATS_Propeller.Set_Aircraft_Cg
          (Aircraft_Cg => (165.2900/12.0,0.5/12.0,91.31/12.0));
        JPATS_Propeller.Set_Aircraft_Angular_Rate
          (Aircraft_Angular_Rate => (0.0,0.0,0.0));

        JPATS_Propeller.Set_Angle_Of_Attack
          (Alpha => Angle_Types.Degrees_To_Radians(0.0));

        JPATS_Propeller.Set_Sideslip_Angle
          ( Beta => Angle_Types.Degrees_To_Radians(1.5));
        Jpats_Powerplant.Test.Set_Fuel_Available;
        Jpats_Powerplant.Test.Set_Bleed_Flow_Rate
          (Bleed_Flow_Rate => Mass_Types.Pph(5.2));
        Jpats_Powerplant.Test.Set_Air_Conditioner_Torque_Absorbed
          (Air_Conditioner_Torque => (0.0,0.0,0.0));
        Jpats_Powerplant.Test.Set_Accessory_Horsepower
          (Accessory_Horsepower => Torque_Types.Horsepower(7.5));
        Jpats_Powerplant.Test.Set_Adc_Pressure_Altitude
          (Pressure_Altitude => 10000.0);
        Jpats_Powerplant.Test.Set_Adc_Mach_Number
          (Mach_Number => 0.3934532);
        Pcl_Position := 38.121;
        Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
          (Position => pcl_position);

      elsif Test_Phase = 3 then -- running
        if Test_Timer >= 0.0 and Test_Timer <= 25.0 then
          if not Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            -- Log.Report("Opening stream.");
            Open_Stream;
            Jpats_Powerplant.Test.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
            JPATS_Propeller.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
          end if;

          if Test_Timer <= 5.0 then
            Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
              (Position => false);
          elsif Test_Timer >= 5.0 and Test_Timer <= 15.0 then
            Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
              (Position => true);
          elsif Test_Timer > 15.0 then
            Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
              (Position => false);
          end if;
          declare
            Time_Label  : String := "Time";
            Pcl_Label : String := "Pcl_Position";
            Frame_Delimiter : String := "|";
          begin
            String'Output(Debug_Stream, Frame_Delimiter);
            String'Output(Debug_Stream, Time_Label);
            Float'Output(Debug_Stream, Test_Timer);
            String'Output(Debug_Stream, Pcl_Label);
            Float'Output(Debug_Stream, Pcl_Position);
          end;

          Test_Timer := Test_Timer + Iconst;
        else
          if Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            Ada.Streams.Stream_Io.Close(File => Debug_Stream_File);
          end if;
          Write_Output(Name => Natural'Image(Pmu_Check_Case_Test));
          Test_Phase := 1;
          Test_Timer := 0.0;
          Pmu_Check_Case_Test := 0;
          Jpats_Powerplant.Test.Reset_Test_Modes;
          JPATS_Propeller.Reset_Test_Modes;
          Jpats_Powerplant.Test.Stop_Recording_Debug_Output;
          JPATS_Propeller.Stop_Recording_Debug_Output;
        end if;
      end if;
    elsif Pmu_Check_Case_Test = 14 then
      if Test_Phase = 1 then
        Test_Phase := 2;  -- pause
        Jpats_Powerplant.Test.Set_Prop_Feather_Cut_Off_Switch
          (Position => True);
        Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
          (Position => False);
        Jpats_Powerplant.Test.Set_Cbs ( State => True);
        Jpats_Powerplant.Test.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.4595285);
        JPATS_Propeller.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.4595285);
        Jpats_Powerplant.Test.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.8624945);
        JPATS_Propeller.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.8624945);
        Jpats_Powerplant.Test.Set_Weight_On_Wheels
          (State => False);
        Jpats_Powerplant.Test.Set_Mach_Number
          (Mach_Number => 0.6);
        JPATS_Propeller.Set_Mach_Number
          (Mach_Number => 0.6);

        Jpats_Powerplant.Test.Set_Aircraft_Cg
          (Aircraft_Cg => (165.29000/12.0,0.5/12.0,91.310/12.0));
        JPATS_Propeller.Set_Aircraft_Cg
          (Aircraft_Cg => (165.29000/12.0,0.5/12.0,91.310/12.0));
        JPATS_Propeller.Set_Aircraft_Angular_Rate
          (Aircraft_Angular_Rate => (0.0,0.0,0.0));

        JPATS_Propeller.Set_Angle_Of_Attack
          (Alpha => Angle_Types.Degrees_To_Radians(0.0));

        JPATS_Propeller.Set_Sideslip_Angle
          ( Beta => Angle_Types.Degrees_To_Radians(1.5));
        Jpats_Powerplant.Test.Set_Fuel_Available;
        Jpats_Powerplant.Test.Set_Bleed_Flow_Rate
          (Bleed_Flow_Rate => Mass_Types.Pph(5.2));
        Jpats_Powerplant.Test.Set_Air_Conditioner_Torque_Absorbed
          (Air_Conditioner_Torque => (0.0,0.0,0.0));
        Jpats_Powerplant.Test.Set_Accessory_Horsepower
          (Accessory_Horsepower => Torque_Types.Horsepower(7.5));
        Jpats_Powerplant.Test.Set_Adc_Pressure_Altitude
          (Pressure_Altitude => 20000.0);
        Jpats_Powerplant.Test.Set_Adc_Mach_Number
          (Mach_Number => 0.5916557);
        Pcl_Position := 18.0;
        Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
          (Position => Pcl_Position);

      elsif Test_Phase = 3 then -- running
        if Test_Timer >= 0.0 and Test_Timer <= 100.0 then
          if not Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            -- Log.Report("Opening stream.");
            Open_Stream;
            Jpats_Powerplant.Test.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
            JPATS_Propeller.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
          end if;

          if Test_Timer < 5.0 then
            Pcl_Position := 18.0;
          elsif Test_Timer >= 5.0 and Test_Timer <= 40.0 then
            pcl_position := Pcl_Position + (53.0 - 18.0)/(40.0-5.0)*Iconst;
          elsif Test_Timer >= 50.0 and Test_Timer <= 85.0 then
            Pcl_Position := Pcl_Position - (53.0 - 18.0)/(80.0-45.0)*Iconst;
          elsif Test_Timer > 85.0 then
            Pcl_Position := 18.0;
          end if;
          Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
            (Position => Pcl_Position);
          declare
            Time_Label  : String := "Time";
            Pcl_Label : String := "Pcl_Position";
            Frame_Delimiter : String := "|";
          begin
            String'Output(Debug_Stream, Frame_Delimiter);
            String'Output(Debug_Stream, Time_Label);
            Float'Output(Debug_Stream, Test_Timer);
            String'Output(Debug_Stream, Pcl_Label);
            Float'Output(Debug_Stream, Pcl_Position);
          end;
          Test_Timer := Test_Timer + Iconst;
        else
          if Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            Ada.Streams.Stream_Io.Close(File => Debug_Stream_File);
          end if;
          Write_Output(Name => Natural'Image(Pmu_Check_Case_Test));
          Test_Phase := 1;
          Test_Timer := 0.0;
          Pmu_Check_Case_Test := 0;
          Jpats_Powerplant.Test.Reset_Test_Modes;
          JPATS_Propeller.Reset_Test_Modes;
          Jpats_Powerplant.Test.Stop_Recording_Debug_Output;
          JPATS_Propeller.Stop_Recording_Debug_Output;
        end if;
      end if;
    elsif Pmu_Check_Case_Test = 15 then
      if Test_Phase = 1 then
        Test_Phase := 2;  -- pause
        Jpats_Powerplant.Test.Set_Prop_Feather_Cut_Off_Switch
          (Position => True);
        Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
          (Position => False);
        Jpats_Powerplant.Test.Set_Cbs ( State => True);
        Jpats_Powerplant.Test.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.4595285);
        JPATS_Propeller.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.4595285);
        Jpats_Powerplant.Test.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.8624945);
        JPATS_Propeller.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.8624945);
        Jpats_Powerplant.Test.Set_Weight_On_Wheels
          (State => False);
        Jpats_Powerplant.Test.Set_Mach_Number
          (Mach_Number => 0.6);
        JPATS_Propeller.Set_Mach_Number
          (Mach_Number => 0.6);

        Jpats_Powerplant.Test.Set_Aircraft_Cg
          (Aircraft_Cg => (165.29000/12.0,0.5/12.0,91.310/12.0));
        JPATS_Propeller.Set_Aircraft_Cg
          (Aircraft_Cg => (165.29000/12.0,0.5/12.0,91.310/12.0));
        JPATS_Propeller.Set_Aircraft_Angular_Rate
          (Aircraft_Angular_Rate => (0.0,0.0,0.0));

        JPATS_Propeller.Set_Angle_Of_Attack
          (Alpha => Angle_Types.Degrees_To_Radians(0.0));

        JPATS_Propeller.Set_Sideslip_Angle
          ( Beta => Angle_Types.Degrees_To_Radians(1.5));
        Jpats_Powerplant.Test.Set_Fuel_Available;
        Jpats_Powerplant.Test.Set_Bleed_Flow_Rate
          (Bleed_Flow_Rate => Mass_Types.Pph(5.2));
        Jpats_Powerplant.Test.Set_Air_Conditioner_Torque_Absorbed
          (Air_Conditioner_Torque => (0.0,0.0,0.0));
        Jpats_Powerplant.Test.Set_Accessory_Horsepower
          (Accessory_Horsepower => Torque_Types.Horsepower(7.5));
        Jpats_Powerplant.Test.Set_Adc_Pressure_Altitude
          (Pressure_Altitude => 20000.0);
        Jpats_Powerplant.Test.Set_Adc_Mach_Number
          (Mach_Number => 0.5916557);
        Pcl_Position := 18.0;
        Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
          (Position => Pcl_Position);

      elsif Test_Phase = 3 then -- running
        if Test_Timer >= 0.0 and Test_Timer <= 25.0 then
          if not Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            -- Log.Report("Opening stream.");
            Open_Stream;
            Jpats_Powerplant.Test.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
            JPATS_Propeller.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
          end if;

          if Test_Timer <= 5.0 then
            Pcl_Position := 18.0;
          elsif Test_Timer >= 5.0 and Test_Timer <= 15.0 then
            pcl_position := 53.0;
          elsif Test_Timer > 15.0 then
            Pcl_Position := 18.0;
          end if;
          Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
            (Position => Pcl_Position);
          declare
            Time_Label  : String := "Time";
            Pcl_Label : String := "Pcl_Position";
            Frame_Delimiter : String := "|";
          begin
            String'Output(Debug_Stream, Frame_Delimiter);
            String'Output(Debug_Stream, Time_Label);
            Float'Output(Debug_Stream, Test_Timer);
            String'Output(Debug_Stream, Pcl_Label);
            Float'Output(Debug_Stream, Pcl_Position);
          end;
          Test_Timer := Test_Timer + Iconst;
        else
          if Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            Ada.Streams.Stream_Io.Close(File => Debug_Stream_File);
          end if;
          Write_Output(Name => Natural'Image(Pmu_Check_Case_Test));
          Test_Phase := 1;
          Test_Timer := 0.0;
          Pmu_Check_Case_Test := 0;
          Jpats_Powerplant.Test.Reset_Test_Modes;
          JPATS_Propeller.Reset_Test_Modes;
          Jpats_Powerplant.Test.Stop_Recording_Debug_Output;
          JPATS_Propeller.Stop_Recording_Debug_Output;
        end if;
      end if;
    elsif Pmu_Check_Case_Test = 16 then
      if Test_Phase = 1 then
        Test_Phase := 2;  -- pause
        Jpats_Powerplant.Test.Set_Prop_Feather_Cut_Off_Switch
          (Position => True);
        Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
          (Position => False);
        Jpats_Powerplant.Test.Set_Cbs ( State => True);
        Jpats_Powerplant.Test.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.4595285);
        JPATS_Propeller.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.4595285);
        Jpats_Powerplant.Test.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.8624945);
        JPATS_Propeller.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.8624945);
        Jpats_Powerplant.Test.Set_Weight_On_Wheels
          (State => False);
        Jpats_Powerplant.Test.Set_Mach_Number
          (Mach_Number => 0.6);
        JPATS_Propeller.Set_Mach_Number
          (Mach_Number => 0.6);

        Jpats_Powerplant.Test.Set_Aircraft_Cg
          (Aircraft_Cg => (165.29000/12.0,0.5/12.0,91.310/12.0));
        JPATS_Propeller.Set_Aircraft_Cg
          (Aircraft_Cg => (165.29000/12.0,0.5/12.0,91.310/12.0));
        JPATS_Propeller.Set_Aircraft_Angular_Rate
          (Aircraft_Angular_Rate => (0.0,0.0,0.0));

        JPATS_Propeller.Set_Angle_Of_Attack
          (Alpha => Angle_Types.Degrees_To_Radians(0.0));

        JPATS_Propeller.Set_Sideslip_Angle
          ( Beta => Angle_Types.Degrees_To_Radians(1.5));
        Jpats_Powerplant.Test.Set_Fuel_Available;
        Jpats_Powerplant.Test.Set_Bleed_Flow_Rate
          (Bleed_Flow_Rate => Mass_Types.Pph(5.2));
        Jpats_Powerplant.Test.Set_Air_Conditioner_Torque_Absorbed
          (Air_Conditioner_Torque => (0.0,0.0,0.0));
        Jpats_Powerplant.Test.Set_Accessory_Horsepower
          (Accessory_Horsepower => Torque_Types.Horsepower(7.5));
        Jpats_Powerplant.Test.Set_Adc_Pressure_Altitude
          (Pressure_Altitude => 20000.0);
        Jpats_Powerplant.Test.Set_Adc_Mach_Number
          (Mach_Number => 0.5916557);
        Pcl_Position := 18.0;
        Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
          (Position => Pcl_Position);

      elsif Test_Phase = 3 then -- running
        if Test_Timer >= 0.0 and Test_Timer <= 80.0 then
          if not Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            -- Log.Report("Opening stream.");
            Open_Stream;
            Jpats_Powerplant.Test.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
            JPATS_Propeller.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
          end if;

          if Test_Timer <= 5.0 then
            Pcl_Position := 18.0;
          elsif Test_Timer > 5.0 and Test_Timer <= 10.0 then
            pcl_position := 23.0;
          elsif Test_Timer > 10.0 and Test_Timer <= 15.0 then
            pcl_position := 28.0;
          elsif Test_Timer > 15.0 and Test_Timer <= 20.0 then
            pcl_position := 33.0;
          elsif Test_Timer > 20.0 and Test_Timer <= 25.0 then
            pcl_position := 38.0;
          elsif Test_Timer > 25.0 and Test_Timer <= 30.0 then
            pcl_position := 43.0;
          elsif Test_Timer > 30.0 and Test_Timer <= 35.0 then
            pcl_position := 48.0;
          elsif Test_Timer > 35.0 and Test_Timer <= 40.0 then
            pcl_position := 53.0;
          elsif Test_Timer > 40.0 and Test_Timer <= 45.0 then
            pcl_position := 48.0;
          elsif Test_Timer > 45.0 and Test_Timer <= 50.0 then
            pcl_position := 43.0;
          elsif Test_Timer > 50.0 and Test_Timer <= 55.0 then
            pcl_position := 38.00;
          elsif Test_Timer > 55.0 and Test_Timer <= 60.0 then
            pcl_position := 33.00;
          elsif Test_Timer > 60.0 and Test_Timer <= 65.0 then
            pcl_position := 28.00;
          elsif Test_Timer > 65.0 and Test_Timer <= 70.0 then
            pcl_position := 23.00;
          elsif Test_Timer > 70.0 then
            Pcl_Position := 18.0;
          end if;
          Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
            (Position => Pcl_Position);
          declare
            Time_Label  : String := "Time";
            Pcl_Label : String := "Pcl_Position";
            Frame_Delimiter : String := "|";
          begin
            String'Output(Debug_Stream, Frame_Delimiter);
            String'Output(Debug_Stream, Time_Label);
            Float'Output(Debug_Stream, Test_Timer);
            String'Output(Debug_Stream, Pcl_Label);
            Float'Output(Debug_Stream, Pcl_Position);
          end;
          Test_Timer := Test_Timer + Iconst;
        else
          if Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            Ada.Streams.Stream_Io.Close(File => Debug_Stream_File);
          end if;
          Write_Output(Name => Natural'Image(Pmu_Check_Case_Test));
          Test_Phase := 1;
          Test_Timer := 0.0;
          Pmu_Check_Case_Test := 0;
          Jpats_Powerplant.Test.Reset_Test_Modes;
          JPATS_Propeller.Reset_Test_Modes;
          Jpats_Powerplant.Test.Stop_Recording_Debug_Output;
          JPATS_Propeller.Stop_Recording_Debug_Output;
        end if;
      end if;
    elsif Pmu_Check_Case_Test = 17 then
      if Test_Phase = 1 then
        Test_Phase := 2;  -- pause
        Jpats_Powerplant.Test.Set_Prop_Feather_Cut_Off_Switch
          (Position => True);
        Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch
          (Position => True );
        Jpats_Powerplant.Test.Set_Cbs ( State => True);
        Jpats_Powerplant.Test.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.4595285);
        JPATS_Propeller.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.4595285);
        Jpats_Powerplant.Test.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.8624945);
        JPATS_Propeller.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.8624945);
        Jpats_Powerplant.Test.Set_Weight_On_Wheels
          (State => False);
        Jpats_Powerplant.Test.Set_Mach_Number
          (Mach_Number => 0.6);
        JPATS_Propeller.Set_Mach_Number
          (Mach_Number => 0.6);

        Jpats_Powerplant.Test.Set_Aircraft_Cg
          (Aircraft_Cg => (165.29000/12.0,0.5/12.0,91.310/12.0));
        JPATS_Propeller.Set_Aircraft_Cg
          (Aircraft_Cg => (165.29000/12.0,0.5/12.0,91.310/12.0));
        JPATS_Propeller.Set_Aircraft_Angular_Rate
          (Aircraft_Angular_Rate => (0.0,0.0,0.0));

        JPATS_Propeller.Set_Angle_Of_Attack
          (Alpha => Angle_Types.Degrees_To_Radians(0.0));

        JPATS_Propeller.Set_Sideslip_Angle
          ( Beta => Angle_Types.Degrees_To_Radians(1.5));
        Jpats_Powerplant.Test.Set_Fuel_Available;
        Jpats_Powerplant.Test.Set_Bleed_Flow_Rate
          (Bleed_Flow_Rate => Mass_Types.Pph(5.2));
        Jpats_Powerplant.Test.Set_Air_Conditioner_Torque_Absorbed
          (Air_Conditioner_Torque => (0.0,0.0,0.0));
        Jpats_Powerplant.Test.Set_Accessory_Horsepower
          (Accessory_Horsepower => Torque_Types.Horsepower(7.5));
        Jpats_Powerplant.Test.Set_Adc_Pressure_Altitude
          (Pressure_Altitude => 20000.0);
        Jpats_Powerplant.Test.Set_Adc_Mach_Number
          (Mach_Number => 0.5916557);
        Pcl_Position := 18.0;
        Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
          (Position => Pcl_Position);

      elsif Test_Phase = 3 then -- running
        if Test_Timer >= 0.0 and Test_Timer <= 40.0 then
          if not Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            -- Log.Report("Opening stream.");
            Open_Stream;
            Jpats_Powerplant.Test.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
            JPATS_Propeller.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
          end if;

          if Test_Timer <= 5.0 then
            Pcl_Position := 18.0;
          elsif Test_Timer >= 5.0 and Test_Timer <= 15.0 then
            pcl_position := 53.0;
          elsif Test_Timer > 15.0 then
            Pcl_Position := 18.0;
          end if;
          Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
            (Position => Pcl_Position);
          declare
            Time_Label  : String := "Time";
            Pcl_Label : String := "Pcl_Position";
            Frame_Delimiter : String := "|";
          begin
            String'Output(Debug_Stream, Frame_Delimiter);
            String'Output(Debug_Stream, Time_Label);
            Float'Output(Debug_Stream, Test_Timer);
            String'Output(Debug_Stream, Pcl_Label);
            Float'Output(Debug_Stream, Pcl_Position);
          end;
          Test_Timer := Test_Timer + Iconst;
        else
          if Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            Ada.Streams.Stream_Io.Close(File => Debug_Stream_File);
          end if;
          Write_Output(Name => Natural'Image(Pmu_Check_Case_Test));
          Test_Phase := 1;
          Test_Timer := 0.0;
          Pmu_Check_Case_Test := 0;
          Jpats_Powerplant.Test.Reset_Test_Modes;
          JPATS_Propeller.Reset_Test_Modes;
          Jpats_Powerplant.Test.Stop_Recording_Debug_Output;
          JPATS_Propeller.Stop_Recording_Debug_Output;
        end if;
      end if;
    elsif Pmu_Check_Case_Test = 18 then
      if Test_Phase = 1 then
        Test_Phase := 2;  -- pause
        Jpats_Powerplant.Test.Set_Prop_Feather_Cut_Off_Switch
          (Position => True);
        Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
          (Position => False);
        Jpats_Powerplant.Test.Set_Cbs ( State => True);
        Jpats_Powerplant.Test.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.4595285);
        JPATS_Propeller.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.4595285);
        Jpats_Powerplant.Test.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.8624945);
        JPATS_Propeller.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.8624945);
        Jpats_Powerplant.Test.Set_Weight_On_Wheels
          (State => False);
        Jpats_Powerplant.Test.Set_Mach_Number
          (Mach_Number => 0.6);
        JPATS_Propeller.Set_Mach_Number
          (Mach_Number => 0.6);

        Jpats_Powerplant.Test.Set_Aircraft_Cg
          (Aircraft_Cg => (165.29000/12.0,0.5/12.0,91.310/12.0));
        JPATS_Propeller.Set_Aircraft_Cg
          (Aircraft_Cg => (165.29000/12.0,0.5/12.0,91.310/12.0));
        JPATS_Propeller.Set_Aircraft_Angular_Rate
          (Aircraft_Angular_Rate => (0.0,0.0,0.0));

        JPATS_Propeller.Set_Angle_Of_Attack
          (Alpha => Angle_Types.Degrees_To_Radians(0.0));

        JPATS_Propeller.Set_Sideslip_Angle
          ( Beta => Angle_Types.Degrees_To_Radians(1.5));
        Jpats_Powerplant.Test.Set_Fuel_Available;
        Jpats_Powerplant.Test.Set_Bleed_Flow_Rate
          (Bleed_Flow_Rate => Mass_Types.Pph(5.2));
        Jpats_Powerplant.Test.Set_Air_Conditioner_Torque_Absorbed
          (Air_Conditioner_Torque => (0.0,0.0,0.0));
        Jpats_Powerplant.Test.Set_Accessory_Horsepower
          (Accessory_Horsepower => Torque_Types.Horsepower(7.5));
        Jpats_Powerplant.Test.Set_Adc_Pressure_Altitude
          (Pressure_Altitude => 20000.0);
        Jpats_Powerplant.Test.Set_Adc_Mach_Number
          (Mach_Number => 0.5916557);
        Pcl_Position := 38.329;
        Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
          (Position => pcl_position);

      elsif Test_Phase = 3 then -- running
        if Test_Timer >= 0.0 and Test_Timer <= 30.0 then
          if not Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            -- Log.Report("Opening stream.");
            Open_Stream;
            Jpats_Powerplant.Test.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
            JPATS_Propeller.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
          end if;

          if Test_Timer <= 5.0 then
            Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
              (Position => false);
          elsif Test_Timer >= 5.0 and Test_Timer <= 15.0 then
            Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
              (Position => true);
          elsif Test_Timer > 15.0 then
            Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
              (Position => false);
          end if;

          declare
            Time_Label  : String := "Time";
            Pcl_Label : String := "Pcl_Position";
            Frame_Delimiter : String := "|";
          begin
            String'Output(Debug_Stream, Frame_Delimiter);
            String'Output(Debug_Stream, Time_Label);
            Float'Output(Debug_Stream, Test_Timer);
            String'Output(Debug_Stream, Pcl_Label);
            Float'Output(Debug_Stream, Pcl_Position);
          end;

          Test_Timer := Test_Timer + Iconst;
        else
          if Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            Ada.Streams.Stream_Io.Close(File => Debug_Stream_File);
          end if;
          Write_Output(Name => Natural'Image(Pmu_Check_Case_Test));
          Test_Phase := 1;
          Test_Timer := 0.0;
          Pmu_Check_Case_Test := 0;
          Jpats_Powerplant.Test.Reset_Test_Modes;
          JPATS_Propeller.Reset_Test_Modes;
          Jpats_Powerplant.Test.Stop_Recording_Debug_Output;
          JPATS_Propeller.Stop_Recording_Debug_Output;
        end if;
      end if;
    elsif Pmu_Check_Case_Test = 19 then
      if Test_Phase = 1 then
        Test_Phase := 2;  -- pause
        Jpats_Powerplant.Test.Set_Prop_Feather_Cut_Off_Switch
          (Position => True);
        Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
          (Position => False);
        Jpats_Powerplant.Test.Set_Cbs ( State => True);
        Jpats_Powerplant.Test.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.9999953);
        JPATS_Propeller.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.9999953);
        Jpats_Powerplant.Test.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.99999090);
        JPATS_Propeller.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.99999090);
        Jpats_Powerplant.Test.Set_Weight_On_Wheels
          (State => True);
        Jpats_Powerplant.Test.Set_Mach_Number
          (Mach_Number => 0.0);
        JPATS_Propeller.Set_Mach_Number
          (Mach_Number => 0.0);

        Jpats_Powerplant.Test.Set_Aircraft_Cg
          (Aircraft_Cg => (164.7944000/12.0,0.5/12.0,90.290/12.0));
        JPATS_Propeller.Set_Aircraft_Cg
          (Aircraft_Cg => (164.7944000/12.0,0.5/12.0,90.290/12.0));
        JPATS_Propeller.Set_Aircraft_Angular_Rate
          (Aircraft_Angular_Rate => (0.0,0.0,0.0));

        JPATS_Propeller.Set_Angle_Of_Attack
          (Alpha => Angle_Types.Degrees_To_Radians(2.1411));
        JPATS_Propeller.Set_Sideslip_Angle
          ( Beta => Angle_Types.Degrees_To_Radians(0.0));

        Jpats_Powerplant.Test.Set_Fuel_Available;

        Jpats_Powerplant.Test.Set_Bleed_Flow_Rate
          (Bleed_Flow_Rate => Mass_Types.Pph(5.2));
        Jpats_Powerplant.Test.Set_Air_Conditioner_Torque_Absorbed
          (Air_Conditioner_Torque => (0.0,0.0,0.0));
        Jpats_Powerplant.Test.Set_Accessory_Horsepower
          (Accessory_Horsepower => Torque_Types.Horsepower(0.0));

        Jpats_Powerplant.Test.Set_Adc_Pressure_Altitude
          (Pressure_Altitude => 0.1310988);
        Jpats_Powerplant.Test.Set_Adc_Mach_Number
          (Mach_Number => 0.0);
        Pcl_Position := 0.0;
        Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
          (Position => Pcl_Position);

      elsif Test_Phase = 3 then -- running
        if Test_Timer >= 0.0 and Test_Timer <= 100.0 then
          if not Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            -- Log.Report("Opening stream.");
            Open_Stream;
            Jpats_Powerplant.Test.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
            JPATS_Propeller.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
          end if;

          if Test_Timer < 1.0 then
            Pcl_Position := 0.0;
          elsif Test_Timer >= 1.0 and Test_Timer <= 75.0 then
            pcl_position := 8.61;
            if Test_Timer > 10.0 and Test_Timer < 10.5 then
              Jpats_Powerplant.Test.Set_Starter_Switch
                (Position => Jpats_Powerplant_Types.Auto);
            else
              Jpats_Powerplant.Test.Set_Starter_Switch
                (Position => Jpats_Powerplant_Types.Off);
            end if;
          elsif Test_Timer >= 75.0 and Test_Timer <= 80.0 then
            Pcl_Position := 18.0;
          elsif Test_Timer > 80.0 then
            Pcl_Position := 0.0;
          end if;
          Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
            (Position => Pcl_Position);
          declare
            Time_Label  : String := "Time";
            Pcl_Label : String := "Pcl_Position";
            Frame_Delimiter : String := "|";
          begin
            String'Output(Debug_Stream, Frame_Delimiter);
            String'Output(Debug_Stream, Time_Label);
            Float'Output(Debug_Stream, Test_Timer);
            String'Output(Debug_Stream, Pcl_Label);
            Float'Output(Debug_Stream, Pcl_Position);
          end;
          Test_Timer := Test_Timer + Iconst;
        else
          if Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            Ada.Streams.Stream_Io.Close(File => Debug_Stream_File);
          end if;
          Write_Output(Name => Natural'Image(Pmu_Check_Case_Test));
          Test_Phase := 1;
          Test_Timer := 0.0;
          Pmu_Check_Case_Test := 0;
          Jpats_Powerplant.Test.Reset_Test_Modes;
          JPATS_Propeller.Reset_Test_Modes;
          Jpats_Powerplant.Test.Stop_Recording_Debug_Output;
          JPATS_Propeller.Stop_Recording_Debug_Output;
        end if;
      end if;
    elsif Pmu_Check_Case_Test = 20 then
      if Test_Phase = 1 then
        Test_Phase := 2;  -- pause
        Jpats_Powerplant.Test.Set_Prop_Feather_Cut_Off_Switch
          (Position => True);
        Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
          (Position => False);
        Jpats_Powerplant.Test.Set_Cbs ( State => True);
        Jpats_Powerplant.Test.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.9999953);
        JPATS_Propeller.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.9999953);
        Jpats_Powerplant.Test.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.99999090);
        JPATS_Propeller.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.99999090);
        Jpats_Powerplant.Test.Set_Weight_On_Wheels
          (State => True);
        Jpats_Powerplant.Test.Set_Mach_Number
          (Mach_Number => 0.0);
        JPATS_Propeller.Set_Mach_Number
          (Mach_Number => 0.0);

        Jpats_Powerplant.Test.Set_Aircraft_Cg
          (Aircraft_Cg => (164.7944000/12.0,0.5/12.0,90.290/12.0));
        JPATS_Propeller.Set_Aircraft_Cg
          (Aircraft_Cg => (164.7944000/12.0,0.5/12.0,90.290/12.0));
        JPATS_Propeller.Set_Aircraft_Angular_Rate
          (Aircraft_Angular_Rate => (0.0,0.0,0.0));

        JPATS_Propeller.Set_Angle_Of_Attack
          (Alpha => Angle_Types.Degrees_To_Radians(2.1411));
        JPATS_Propeller.Set_Sideslip_Angle
          ( Beta => Angle_Types.Degrees_To_Radians(0.0));

        Jpats_Powerplant.Test.Set_Fuel_Available;

        Jpats_Powerplant.Test.Set_Bleed_Flow_Rate
          (Bleed_Flow_Rate => Mass_Types.Pph(5.2));
        Jpats_Powerplant.Test.Set_Air_Conditioner_Torque_Absorbed
          (Air_Conditioner_Torque => (0.0,0.0,0.0));
        Jpats_Powerplant.Test.Set_Accessory_Horsepower
          (Accessory_Horsepower => Torque_Types.Horsepower(0.0));

        Jpats_Powerplant.Test.Set_Adc_Pressure_Altitude
          (Pressure_Altitude => 0.1310988);
        Jpats_Powerplant.Test.Set_Adc_Mach_Number
          (Mach_Number => 0.0);
        Pcl_Position := 0.0;
        Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
          (Position => Pcl_Position);

      elsif Test_Phase = 3 then -- running
        if Test_Timer >= 0.0 and Test_Timer <= 100.0 then
          if not Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            -- Log.Report("Opening stream.");
            Open_Stream;
            Jpats_Powerplant.Test.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
            JPATS_Propeller.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
          end if;

          if Test_Timer < 15.0 then
            Pcl_Position := 0.0;
          elsif Test_Timer >= 15.0 and Test_Timer <= 80.0 then
            pcl_position := 18.00;
          elsif Test_Timer > 80.0 then
            Pcl_Position := 0.0;
          end if;
          if Test_Timer > 10.0 and Test_Timer < 10.5 then
            Jpats_Powerplant.Test.Set_Starter_Switch
              (Position => Jpats_Powerplant_Types.Auto);
          else
            Jpats_Powerplant.Test.Set_Starter_Switch
              (Position => Jpats_Powerplant_Types.Off);
          end if;
          Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
            (Position => Pcl_Position);
          declare
            Time_Label  : String := "Time";
            Pcl_Label : String := "Pcl_Position";
            Frame_Delimiter : String := "|";
          begin
            String'Output(Debug_Stream, Frame_Delimiter);
            String'Output(Debug_Stream, Time_Label);
            Float'Output(Debug_Stream, Test_Timer);
            String'Output(Debug_Stream, Pcl_Label);
            Float'Output(Debug_Stream, Pcl_Position);
          end;
          Test_Timer := Test_Timer + Iconst;
        else
          if Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            Ada.Streams.Stream_Io.Close(File => Debug_Stream_File);
          end if;
          Write_Output(Name => Natural'Image(Pmu_Check_Case_Test));
          Test_Phase := 1;
          Test_Timer := 0.0;
          Pmu_Check_Case_Test := 0;
          Jpats_Powerplant.Test.Reset_Test_Modes;
          JPATS_Propeller.Reset_Test_Modes;
          Jpats_Powerplant.Test.Stop_Recording_Debug_Output;
          JPATS_Propeller.Stop_Recording_Debug_Output;
        end if;
      end if;
    elsif Pmu_Check_Case_Test = 25 then
      if Test_Phase = 1 then
        Test_Phase := 2;  -- pause
        Jpats_Powerplant.Test.Set_Ignition_Switch
          (Position => True);
        Jpats_Powerplant.Test.Set_Prop_Feather_Cut_Off_Switch
          (Position => True);
        Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
          (Position => true);
        Jpats_Powerplant.Test.Set_Cbs ( State => True);
        Jpats_Powerplant.Test.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.9999953);
        JPATS_Propeller.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.9999953);
        Jpats_Powerplant.Test.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.99999090);
        JPATS_Propeller.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.99999090);
        Jpats_Powerplant.Test.Set_Weight_On_Wheels
          (State => True);
        Jpats_Powerplant.Test.Set_Mach_Number
          (Mach_Number => 0.0);
        JPATS_Propeller.Set_Mach_Number
          (Mach_Number => 0.0);

        Jpats_Powerplant.Test.Set_Aircraft_Cg
          (Aircraft_Cg => (164.7944000/12.0,0.5/12.0,90.290/12.0));
        JPATS_Propeller.Set_Aircraft_Cg
          (Aircraft_Cg => (164.7944000/12.0,0.5/12.0,90.290/12.0));
        JPATS_Propeller.Set_Aircraft_Angular_Rate
          (Aircraft_Angular_Rate => (0.0,0.0,0.0));

        JPATS_Propeller.Set_Angle_Of_Attack
          (Alpha => Angle_Types.Degrees_To_Radians(2.1411));
        JPATS_Propeller.Set_Sideslip_Angle
          ( Beta => Angle_Types.Degrees_To_Radians(0.0));

        Jpats_Powerplant.Test.Set_Fuel_Available;

        Jpats_Powerplant.Test.Set_Bleed_Flow_Rate
          (Bleed_Flow_Rate => Mass_Types.Pph(5.2));
        Jpats_Powerplant.Test.Set_Air_Conditioner_Torque_Absorbed
          (Air_Conditioner_Torque => (0.0,0.0,0.0));
        Jpats_Powerplant.Test.Set_Accessory_Horsepower
          (Accessory_Horsepower => Torque_Types.Horsepower(0.0));

        Jpats_Powerplant.Test.Set_Adc_Pressure_Altitude
          (Pressure_Altitude => 0.1310988);
        Jpats_Powerplant.Test.Set_Adc_Mach_Number
          (Mach_Number => 0.0);
        Pcl_Position := 0.0;
        Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
          (Position => Pcl_Position);

      elsif Test_Phase = 3 then -- running
        if Test_Timer >= 0.0 and Test_Timer <= 120.0 then
          if not Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            Open_Stream;
            Jpats_Powerplant.Test.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
            JPATS_Propeller.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
          end if;

          if Test_Timer > 10.0 and Test_Timer < 42.4 then
            Jpats_Powerplant.Test.Set_Starter_Switch
              (Position => Jpats_Powerplant_Types.Manual);
          else
            Jpats_Powerplant.Test.Set_Starter_Switch
              (Position => Jpats_Powerplant_Types.Off);
          end if;

          Pcl_Position := Interpolation_Table.Singly_Indexed.Interpolate
            ( Input => Float(Test_Timer),
              Table => Test25pcl_Table'Access );

          Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
            (Position => Pcl_Position);
          declare
            Time_Label  : String := "Time";
            Pcl_Label : String := "Pcl_Position";
            Frame_Delimiter : String := "|";
          begin
            String'Output(Debug_Stream, Frame_Delimiter);
            String'Output(Debug_Stream, Time_Label);
            Float'Output(Debug_Stream, Test_Timer);
            String'Output(Debug_Stream, Pcl_Label);
            Float'Output(Debug_Stream, Pcl_Position);
          end;
          Test_Timer := Test_Timer + Iconst;
        else
          if Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            Ada.Streams.Stream_Io.Close(File => Debug_Stream_File);
          end if;
          Write_Output(Name => Natural'Image(Pmu_Check_Case_Test));
          Test_Phase := 1;
          Test_Timer := 0.0;
          Pmu_Check_Case_Test := 0;
          Jpats_Powerplant.Test.Reset_Test_Modes;
          JPATS_Propeller.Reset_Test_Modes;
          Jpats_Powerplant.Test.Stop_Recording_Debug_Output;
          JPATS_Propeller.Stop_Recording_Debug_Output;
        end if;
      end if;
    elsif Pmu_Check_Case_Test = 50 then
      if Test_Phase = 1 then
        Test_Phase := 2;  -- pause
        Jpats_Powerplant.Test.Set_Prop_Feather_Cut_Off_Switch
          (Position => True);
        Jpats_Powerplant.Test.Set_Pmu_Mode_Off_Switch  -- manual mode = true
          (Position => false);
        Jpats_Powerplant.Test.Set_Cbs ( State => True);
        Jpats_Powerplant.Test.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.6876936);
        JPATS_Propeller.Set_Ambient_Pressure_Ratio
          (Ambient_Pressure_Ratio => 0.6876936);
        Jpats_Powerplant.Test.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.9312473);
        JPATS_Propeller.Set_Ambient_Temperature_Ratio
          (Ambient_Temperature_Ratio => 0.9312473);
        Jpats_Powerplant.Test.Set_Weight_On_Wheels
          (State => False);
        Jpats_Powerplant.Test.Set_Mach_Number
          (Mach_Number => 0.4);
        JPATS_Propeller.Set_Mach_Number
          (Mach_Number => 0.4);
        Jpats_Powerplant.Test.Set_Aircraft_Cg
          (Aircraft_Cg => (165.2900/12.0,0.5/12.0,91.31/12.0));
        JPATS_Propeller.Set_Aircraft_Cg
          (Aircraft_Cg => (165.2900/12.0,0.5/12.0,91.31/12.0));
        JPATS_Propeller.Set_Aircraft_Angular_Rate
          (Aircraft_Angular_Rate => (0.0,0.0,0.0));

        JPATS_Propeller.Set_Angle_Of_Attack
          (Alpha => Angle_Types.Degrees_To_Radians(0.0));

        JPATS_Propeller.Set_Sideslip_Angle
          ( Beta => Angle_Types.Degrees_To_Radians(1.5));
        Jpats_Powerplant.Test.Set_Fuel_Available;
        Jpats_Powerplant.Test.Set_Bleed_Flow_Rate
          (Bleed_Flow_Rate => Mass_Types.Pph(5.2));
        Jpats_Powerplant.Test.Set_Air_Conditioner_Torque_Absorbed
          (Air_Conditioner_Torque => (0.0,0.0,0.0));
        Jpats_Powerplant.Test.Set_Accessory_Horsepower
          (Accessory_Horsepower => Torque_Types.Horsepower(7.5));
        Jpats_Powerplant.Test.Set_Adc_Pressure_Altitude
          (Pressure_Altitude => 10000.0);
        Jpats_Powerplant.Test.Set_Adc_Mach_Number
          (Mach_Number => 0.3934532);
        Pcl_Position := 18.0;
        Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
          (Position => Pcl_Position);
        JPATS_Powerplant.Ios_Interface.This_Ios_Interface.Quick_Start_Request := True;

      elsif Test_Phase = 3 then -- running
        JPATS_Powerplant.Ios_Interface.This_Ios_Interface.Quick_Start_Request := False;
        if Test_Timer >= 0.0 and Test_Timer <= 100.0 then
          if not Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            -- Log.Report("Opening stream.");
            Open_Stream;
            Jpats_Powerplant.Test.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
            JPATS_Propeller.Start_Recording_Debug_Output
              (Debug_Stream => Debug_Stream);
          end if;

          if Test_Timer <= 5.0 then
            JPATS_Powerplant.Ios_Interface.This_Ios_Interface.Mfen06 := False;
            --            Pcl_Position := 19.249;
          elsif Test_Timer >= 5.0 and Test_Timer <= 80.0 then
            JPATS_Powerplant.Ios_Interface.This_Ios_Interface.Mfen06 := True;
            --            pcl_position := 54.249;
          elsif Test_Timer > 80.0 then
            JPATS_Powerplant.Ios_Interface.This_Ios_Interface.Mfen06 := False;
            --            Pcl_Position := 19.249;
          end if;
          Jpats_Powerplant.Test.Set_Power_Control_Lever_Angle
            (Position => Pcl_Position);
          declare
            Time_Label  : String := "Time";
            Pcl_Label : String := "Pcl_Position";
            Frame_Delimiter : String := "|";
          begin
            String'Output(Debug_Stream, Frame_Delimiter);
            String'Output(Debug_Stream, Time_Label);
            Float'Output(Debug_Stream, Test_Timer);
            String'Output(Debug_Stream, Pcl_Label);
            Float'Output(Debug_Stream, Pcl_Position);
          end;
          Test_Timer := Test_Timer + Iconst;
        else
          Jpats_Powerplant.Test.Stop_Recording_Debug_Output;
          JPATS_Propeller.Stop_Recording_Debug_Output;
          Jpats_Powerplant.Test.Reset_Test_Modes;
          JPATS_Propeller.Reset_Test_Modes;
          if Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
            Ada.Streams.Stream_Io.Close(File => Debug_Stream_File);
          end if;
          Write_Output(Name => "a" ); -- Natural'Image(Pmu_Check_Case_Test));
          Test_Phase := 1;
          Test_Timer := 0.0;
          Pmu_Check_Case_Test := 0;
        end if;


      end if;
    else
      Test_Phase := 1;
--      Jpats_Powerplant.Test.Reset_Test_Modes;
--      JPATS_Propeller.Reset_Test_Modes;
      if Ada.Streams.Stream_Io.Is_Open(File => Debug_Stream_File) then
        Ada.Streams.Stream_Io.Close(File => Debug_Stream_File);
      end if;
    end if;

  end Update;

  procedure Update
    (Integration_Constant : in Float) is
  begin
    Update
      (Next_Subsystem => Container.Next_Subsystem,
       This_Subsystem => Container.This_Subsystem,
       Iconst         => Integration_Constant);
  end Update;

  procedure Register_Stethoscope_Labels is

  begin

    Stethoscope.Register_Signal
      (Name           => "Powerplant/Auto_Test_Controller/Test_Phase",
       Units          => "enumerated",
       Object_Address => Test_Phase'Address,
       Value_Type     => "int",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Auto_Test_Controller/Test_Timer",
       Units          => "seconds",
       Object_Address => Test_Timer'Address,
       Value_Type     => "float",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Auto_Test_Controller/Engine_Check_Case_Test",
       Units          => "integer",
       Object_Address => Engine_Check_Case_Test'Address,
       Value_Type     => "int",
       Scope_Index    => 0);
    Stethoscope.Register_Signal
      (Name           => "Powerplant/Auto_Test_Controller/Pmu_Check_Case_Test",
       Units          => "integer",
       Object_Address => Pmu_Check_Case_Test'Address,
       Value_Type     => "int",
       Scope_Index    => 0);

  end Register_Stethoscope_Labels;

  -- Method Initialize
  procedure Initialize
    (A_Subsystem : in out JPATS_Powerplant.Container.Instance_Ptr) is

  begin
    --|  Initialize the auto test controller variables
    Register_Stethoscope_Labels;
  end Initialize;

  -- Method Read_Tables
  procedure Read_Tables is
    Powerplant_Cat_Path : String := Simulation_Dictionary.Lookup ("Powerplant_Cat_Path");
  begin
    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & "test25.ito",
        Table     => test25pcl_Table );
  end Read_Tables;

  procedure Initialize is
  begin
    Read_Tables;
    Initialize
      (A_Subsystem => Container.Next_Subsystem);
    Initialize
      (A_Subsystem => Container.This_Subsystem);
  end Initialize;

end JPATS_Powerplant.Auto_Test_Controller;







