-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0
with Interpolation_Table.Singly_Indexed;
with Simulation_Dictionary;

package body Gear_Pump is

  Pressure_Differential_Table : aliased Interpolation_Table.Singly_Indexed.Instance;
  Flow_Rate_Table             : aliased Interpolation_Table.Singly_Indexed.Instance;


  -- Accessor function Outlet_pressure
  function Outlet_Pressure
    (An_Instance : in Instance) return Force_Types.Psi is
  begin
    return An_Instance.Outlet_Pressure;
  end Outlet_Pressure;

  -- Method Update
  procedure Update
    (An_Instance    : in out Instance;
     Inlet_Pressure : in     Force_Types.Psi;
     Rpm            : in     Angle_Types.Rpm )
  is
    Pressure_Differential : Force_Types.Psi;
  begin

    --| Look up table of Pressure differential versus RPM
    --|
    Pressure_Differential := Interpolation_Table.Singly_Indexed.Interpolate
      ( Input => Rpm,
        Table => Pressure_Differential_Table'Access );
    An_Instance.Bypass_Pressure_Regulating_Valve_State := Pressure_Differential > Bypass_Pressure_Regulating_Valve_Set_Point;
    if Inlet_Pressure > 3.0 then
      An_Instance.Outlet_Pressure := Inlet_Pressure + Pressure_Differential;
    else
      An_Instance.Outlet_Pressure := 0.0;
    end if;

    --| Look up table of Flow Rate versus pressure differential
    --| across the pump.
    --|
    An_Instance.Flow_Rate := Interpolation_Table.Singly_Indexed.Interpolate
      ( Input => Pressure_Differential,
        Table => Flow_Rate_Table'Access );

  end Update;

  -- Method Initialize
  procedure Initialize
    (An_Instance : in out Instance) is
  begin
    An_Instance.Outlet_Pressure := Force_Types.Psi(0.0);
    An_Instance.Flow_Rate       := Force_Types.Psi(0.0);
    An_Instance.Bypass_Pressure_Regulating_Valve_State := False;
  end Initialize;


  procedure Read_Tables is
    Powerplant_Cat_Path : String := Simulation_Dictionary.Lookup ("Powerplant_Cat_Path");
  begin

    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & Pump_Pressure_Differential_Table,
        Table     => Pressure_Differential_Table );

    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & Pump_Flow_Rate_Table,
        Table     => Flow_Rate_Table );

  end Read_Tables;

end Gear_Pump;



