-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Shaft;
with Normalized_Types;
with Torque_Types;

package Gear_Box is

  type Instance is private;

-- Access Chip_Detect
   function  Chip_Detect (An_Instance : in Instance) return Boolean;
   procedure Set_Chip_Detect (An_Instance       : in out Instance;
                              Chip_Detect_State : in     Boolean);

-- Access Ng_Sensor
   function  Ng_Sensor (An_Instance : in Instance) return Normalized_Types.Normalize;
   procedure Set_Ng_Sensor (An_Instance : in out Instance;
                            Ng_Sensor   : in     Normalized_Types.Normalize);

-- Method Initialize
   procedure Initialize
     (An_Instance : in out Instance);

-- Method Update
   procedure Gas_Generator_Driven_Update (An_Instance : in out Instance;
                                          Moment_Input_Shaft1 : in Torque_Types.Ft_Lbf;
                                          Moment_Input_Shaft2 : in Torque_Types.Ft_Lbf;
                                          Moment_Input_Shaft3 : in Torque_Types.Ft_Lbf;
                                          Moment_Input_Shaft4 : in Torque_Types.Ft_Lbf;
                                          Moment_Input_Shaft5 : in Torque_Types.Ft_Lbf );

   procedure Starter_Driven_Update (An_Instance : in out Instance;
                                    Moment_Input_Shaft1 : in Torque_Types.Ft_Lbf;
                                    Moment_Input_Shaft2 : in Torque_Types.Ft_Lbf;
                                    Moment_Input_Shaft3 : in Torque_Types.Ft_Lbf;
                                    Moment_Input_Shaft4 : in Torque_Types.Ft_Lbf;
                                    Moment_Input_Shaft5 : in Torque_Types.Ft_Lbf );

private
--   type Set_Of_Shafts is array (Shaft_Names'Range) of Shaft.Instance;
   type Instance is record
      Shaft1             : Shaft.Instance;
      Shaft2             : Shaft.Instance;
      Shaft3             : Shaft.Instance;
      Shaft4             : Shaft.Instance;
      Shaft5             : Shaft.Instance;
      Chip_Detect        : Boolean;
      Ng_Sensor          : Normalized_Types.Normalize;
   end record;

end Gear_Box;





