-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0
with Cam;
with Stepper_Motor;
with Solenoid;
with Metering_Valve;
with Angle_Types;
with Normalized_Types;
with Force_Types;
with Mass_Types;
with Jpats_Powerplant_Types;

package Fuel_Metering_Unit is


--| The fuel metering unit controls fuel flow to the engine model
--| according to power lever angle, the stepper motor position request
--| from the PMU, and ambient pressure.  Currently the unit is modeled
--| for the operating range of ground idle through maximum rated power,
--| for PMU in Auto or Manual mode.  Shutdown logic is also incorporated.

  type Instance is private;

  -- Accessor Altitude_Gain
  function Altitude_Gain
    (An_Instance : in Instance)
    return Normalized_Types.Normalize;

  -- Accessor Power_Control_Lever_Angle
  function Power_Control_Lever_Angle_Lvdt
    (An_Instance : in Instance)
    return Angle_Types.Degrees;

  -- Accessor Power_Lever_Angle
  function Power_Lever_Angle
    (An_Instance : in Instance)
    return Angle_Types.Degrees;

  -- Accessor Fuel_Output_Pressure
  function Fuel_Output_Pressure
    (An_Instance : in   Instance)
    return Force_Types.Psi;

  -- Access Fuel_Flow_Rate
  function Fuel_Flow_Rate
    (An_Instance : in Instance)
    return Mass_Types.Pph;

  -- Access Fuel_Bypass_Flow_Rate
  function Fuel_Bypass_Flow_Rate
    (An_Instance : in Instance)
    return Mass_Types.Pph;

  -- Access Fmu_Reset
  procedure Fmu_Reset
    (An_Instance : in out Instance);

  -- Method Update
  procedure Update
    ( Next_Instance                        : in out Instance;
      This_Instance                        : in     Instance;
      Iconst                               : in     Float;
      Power_Control_Lever_Angle_In_Degrees : in     Angle_Types.Degrees;
      Stepper_Motor_Position_Requested     : in     Jpats_Powerplant_Types.Step_Type;
      Shutdown_Solenoid_Power              : in     Boolean;
      Energize_Shutdown_Solenoid           : in     Boolean;
      Cam_Reset_Solenoid                   : in     Boolean;
      Ambient_Pressure_Ratio               : in     Normalized_Types.Normalize;
      Return_Line_Pressure                 : in     Force_Types.Psi;
      Inlet_Pressure                       : in     Force_Types.Psi;
      Linkage_Failure                      : in     Boolean;
      Restrain_Fuel_Flow                   : in     Boolean;
      Fmu_Malfunction                      : in     Boolean);

  -- Method Initialize
  procedure Initialize (An_Instance : in out Instance);

  -- Method Read_Tables
  procedure Read_Tables;

  -- Method Eec_Shutdown_Solenoid_Valve
  --   procedure Eec_Shutdown_Solenoid_Valve
  --               (An_Instance : in out Instance);

  -- Method Cam_Reset_Solenoid
  --   procedure Energize_Cam_Reset_Solenoid
  --     ( An_Instance : in out Instance);

private

  subtype New_Cam_Rate_Limit_Type is Angle_Types.Degrees_Per_Sec range -25.0.. 8.0;
  package New_Cam is new Cam
    (Degrees_Type            => Angle_Types.Degrees,
     Degrees_Per_Sec_Type    => New_Cam_Rate_Limit_Type,
     Table_File_Name         => "plapcl.ito");

  package New_Stepper_Motor is new Stepper_Motor
    (Step_Type => Jpats_Powerplant_Types.Step_Type);

  package Fuel_Metering_Valve is new Metering_Valve
    ( Degrees_Type                         =>  Angle_Types.Degrees,
      Step_Type                            =>  Jpats_Powerplant_Types.Step_Type,
      High_Pressure_Relief_Valve_Set_Point =>  1175.0,
      Bypass_Valve_Set_Point               =>  50.0,
      Cam_Profile_Table_Name               =>  "ff3dcam.ito",
      Gain_Table_Name                      =>  "kfmvdelt.ito");

  type Instance is record
    Hydro_Mechanical_Cam               : New_Cam.Instance;
    Fmu_Stepper_Motor                  : New_Stepper_Motor.Instance;
    Shutdown_Solenoid                  : Solenoid.Instance;
    Cam_Reset_Solenoid                 : Solenoid.Instance;
    Fmu_Metering_Valve                 : Fuel_Metering_Valve.Instance;
    Cutoff_Pla_Angle                   : Angle_Types.Degrees;
    Power_Control_Lever_Angle_Lvdt     : Angle_Types.Degrees;
    Smp_Req                            : Jpats_Powerplant_Types.Step_Type;
    Delta_Pcl_Linkage                  : Angle_Types.Degrees;
    Fmu_Reset                          : Boolean;
  end record;


end Fuel_Metering_Unit;














