-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0
with Force_Types;
with Mass_Types;
with Angle_Types;

generic
   Pump_Pressure_Differential_Table           : String;
   Bypass_Pressure_Regulating_Valve_Set_Point : Force_Types.Psi;

package Centrifugal_Pump is


  type Instance is private;

-- Function Outlet_Pressure
  function Outlet_Pressure
    (An_Instance : in Instance)
     return Force_Types.Psi;

-- Method Update
   procedure Update
     (Next_Instance  : in out Instance;
      This_Instance  : in     Instance;
      Iconst         : in     Float;
      Inlet_Pressure : in     Force_Types.Psi;
      Rpm            : in     Angle_Types.Rpm;
      Flow_Rate      : in     Mass_Types.Pph;
      Cavitating     : in     Boolean);

-- Method Initialize
   procedure Initialize
     (An_Instance : in out Instance);

-- Method Read_Tables
   procedure Read_Tables;

private

  type Instance is record
    Outlet_Pressure : Force_Types.Psi;
    Bypass_Pressure_Regulating_Valve_State : Boolean;
  end record;


end Centrifugal_Pump;

