-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0
with Interpolation_Table.Doubly_Indexed;
with Simulation_Dictionary;

package body Centrifugal_Pump is

  Pressure_Differential_Table : aliased Interpolation_Table.Doubly_Indexed.Instance;

  -- Accessor function Outlet_pressure
  function Outlet_Pressure
    (An_Instance : in Instance) return Force_Types.Psi is
  begin
    return An_Instance.Outlet_Pressure;
  end Outlet_Pressure;

  Pressure_Differential : Force_Types.Psi;
  Eng_Rpm               : Angle_Types.Rpm;
  Fuel_Flow_Rate        : Mass_Types.Pph;

  -- Method Update
  procedure Update
    (Next_Instance  : in out Instance;
     This_Instance  : in     Instance;
     Iconst         : in     Float;
     Inlet_Pressure : in     Force_Types.Psi;
     Rpm            : in     Angle_Types.Rpm;
     Flow_Rate      : in     Mass_Types.Pph;
     Cavitating     : in     Boolean)
  is
--    Pressure_Differential : Force_Types.Psi;
  begin

    --| Look up table of Pressure differential versus RPM and Flow Rate in Pph
    if (Inlet_Pressure > 1.0  and Flow_Rate >= 0.0) then

      Pressure_Differential := Interpolation_Table.Doubly_Indexed.Interpolate
        ( X => Float(Rpm),
          Y => Float(Flow_Rate),
          Table => Pressure_Differential_Table'Access );

      if Cavitating then
--        Pressure_Differential := 1.0 - 1.5*(This_Instance.Outlet_Pressure - Inlet_Pressure)*Iconst;
--        Pressure_Differential := Pressure_Differential + (7.47E-6*Rpm - 0.00525)*Flow_Rate; --This_Instance.Pressure_Difference-60.0*Iconst);
--        Pressure_Differential := Pressure_Differential - 33.5/2454.0*Flow_Rate; --This_Instance.Pressure_Difference-60.0*Iconst);
        Pressure_Differential := Pressure_Differential - 47.3/2454.0*Flow_Rate; --This_Instance.Pressure_Difference-60.0*Iconst);
      end if;

      if (Inlet_Pressure + Pressure_Differential) > Bypass_Pressure_Regulating_Valve_Set_Point then
        Next_Instance.Bypass_Pressure_Regulating_Valve_State := True;
        Next_Instance.Outlet_Pressure := Bypass_Pressure_Regulating_Valve_Set_Point;
      else
        Next_Instance.Outlet_Pressure := Inlet_Pressure + Pressure_Differential;
      end if;

    else
      Next_Instance.Bypass_Pressure_Regulating_Valve_State := False;
      Next_Instance.Outlet_Pressure := 0.0;
    end if;

  end Update;

  -- Method Initialize
  procedure Initialize
    (An_Instance : in out Instance) is
  begin
    An_Instance.Outlet_Pressure := Force_Types.Psi(0.0);
    An_Instance.Bypass_Pressure_Regulating_Valve_State := False;
  end Initialize;


  procedure Read_Tables is
    Powerplant_Cat_Path : String := Simulation_Dictionary.Lookup ("Powerplant_Cat_Path");
  begin

    Interpolation_Table.Read
      ( File_Name => Powerplant_Cat_Path & Pump_Pressure_Differential_Table,
        Table     => Pressure_Differential_Table );

  end Read_Tables;

end Centrifugal_Pump;



