-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
generic
   type Degrees_Type is digits <>;
   type Degrees_Per_Sec_Type is digits <>;
   Table_File_Name     : String;

package Cam is

  type Instance is private;

  function Position
    (An_Instance : in Instance) return Degrees_Type;

  procedure Update
    (Next_Instance             : in out Instance;
     This_Instance             : in     Instance;
     Iconst                    : in     Float;
     Power_Control_Lever_Angle : in     Degrees_Type;
     Linkage_Failure           : in     Boolean;
     Cam_Reset                 : in     Boolean);

  procedure Initialize
    (This_Instance : in out Instance;
     Initial_Value : in     Degrees_Type);

  procedure Read_Tables;

private

  type Instance is record
    Position          : Degrees_Type;  -- Power lever angle cam Position
    Follower_Position : Degrees_Type;  -- Rate Limited Power Lever Angle
                                       -- Cam Follower Position
  end record;

end Cam;

