-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Interpolation_Table.Singly_Indexed;
with Ada.Text_Io;
with Simulation_Dictionary;

package body Cam is

   Cam_Table     : aliased Interpolation_Table.Singly_Indexed.Instance;

-- Method Position
   function Position
     (An_Instance : in Instance) return Degrees_Type is
   begin
      return An_Instance.Follower_Position;
   end Position;

--   function "/"
--     ( X : in Degrees_Type;
--       Y : in Float) return Degrees_Per_Sec_Type is
--   begin
--      return Degrees_Per_Sec_Type(Float(X)/Y);
--   end "/";

--   function "*"
--     ( X : in Degrees_Per_Sec_Type;
--       Y : in Float) return Degrees_Type is
--   begin
--      return Degrees_Type(Float(X)*Y);
--   end "*";


-- Method Update
   procedure Update
     (Next_Instance             : in out Instance;
      This_Instance             : in     Instance;
      Iconst                    : in     Float;
      Power_Control_Lever_Angle : in     Degrees_Type;
      Linkage_Failure           : in     Boolean;
      Cam_Reset                 : in     Boolean) is

     Delta_Pcl            : Degrees_Type renames Power_Control_Lever_Angle;
     Delta_Pla            : Degrees_Type renames Next_Instance.Position;
     Delta_Pla_Prime      : Degrees_Type renames Next_Instance.Follower_Position;
     Delta_Pla_Prime_Last : Degrees_Type renames This_Instance.Follower_Position;
   begin

     --| Lookup the power lever angle, a funtion of the cockpit
     --| power control lever angle:
     --|
     --| Delta_Pla := Table PLAPCL = f( Delta_Pcl)  (deg)

     Delta_Pla :=
       Degrees_Type'Max
       ( Degrees_Type'First,
         Degrees_Type'Min(Degrees_Type'Last,
                          Degrees_Type(Interpolation_Table.Singly_Indexed.Interpolate
                                       ( Input => Float(Delta_Pcl),
                                         Table => Cam_Table'Access ))));
     --| Rate limit the power lever request to represent the effect of the
     --| tracking servo pilot valve with dual rate restrictor:
     --|
--     if Linkage_Failure and Delta_Pla < This_Instance.Position then
--       Delta_Pla := This_Instance.Position;
--     end if;


--     if Linkage_Failure then
--       Delta_Pla_prime := Delta_Pla_Prime_Last  +
--         Degrees_Type(Float'Max(Float(0.0),(Float'Min(Float(Degrees_Per_Sec_Type'Last),
--                                            (Float(Delta_pla - Delta_Pla_Prime_Last)/Iconst))))*Iconst);

--     Ada.Text_IO.Put ("Linkage Failure");
     --     else
     if Cam_Reset then
       Delta_Pla_Prime := Delta_Pla;
     else
       Delta_Pla_prime := Delta_Pla_Prime_Last  +
         Degrees_Type( Float'Max(Float(Degrees_Per_Sec_Type'First),
                                 Float'Min(Float(Degrees_Per_Sec_Type'Last),
                                           Float(Delta_pla - Delta_Pla_Prime_Last)/Iconst ))*Iconst);
     end if;
       --     end if;
     --| where: Delta_Pla_Prime_Last is the last pass value of Delta_Pla_Prime
     --| Note that Delta_pla is calculated in Step 1 of equation 11.3.1

   end Update;

   procedure Initialize
     (This_Instance : in out Instance;
      Initial_Value : in     Degrees_Type) is
   begin -- Initialize
     This_Instance.Position := Initial_Value;
     This_Instance.Follower_Position := Initial_Value;
   end Initialize;

   procedure Read_Tables is
     Powerplant_Cat_Path : String := Simulation_Dictionary.Lookup ("Powerplant_Cat_Path");
   begin

     Interpolation_Table.Read
       ( File_Name => Powerplant_Cat_Path & Table_File_Name,
         Table     => Cam_Table );
   end Read_Tables;

end Cam;
