-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0

generic
   type Load_Type is digits <>;
   Energized_State_Load : in Load_Type;

package Auto_Return_Relay_G is


  type Instance is private;

-- Accessor Load
   function Load
     ( An_Instance : in Instance) return Load_Type;

-- Accessor State
   function Is_Energized
     ( An_Instance : in Instance) return Boolean;

-- Method Update
   procedure Update
     ( An_Instance      : in out Instance;
       Power_And_Ground : in     boolean);

-- Method Initialize
   procedure Initialize
     ( An_Instance   : in out Instance;
       Initial_State : in     Boolean);


private

  type Instance is record
    State : Boolean;
    Load  : Load_Type;
  end record;


end Auto_Return_Relay_G;
