-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0

package body Auto_Return_Relay_G is

-- Accessor Load
   function Load
     ( An_Instance : in Instance) return Load_Type is
   begin
     return An_Instance.Load;
   end Load;

-- Accessor Is_Energized
   function Is_Energized
     ( An_Instance : in Instance ) return Boolean is
   begin
     return An_Instance.State;
   end Is_Energized;

-- Method Update
   procedure Update
     (An_Instance      : in out Instance;
      Power_And_Ground : in     boolean) is
   begin
      --| Set the state of the relay
      An_Instance.State := Power_And_Ground;
      if An_Instance.State then
         An_Instance.Load := Energized_State_Load;
      else
         An_Instance.Load := 0.0;
      end if;
   end Update;

-- Method Initialize
   procedure Initialize
     (An_Instance      : in out Instance;
      Initial_State    : in     Boolean ) is
   begin
      --|  Initialize the Auto Return Relay Attributes
      An_Instance.State := Initial_State;
   end Initialize;


end Auto_Return_Relay_G;

