-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with ada.Numerics.Elementary_Functions,
  Nav_Instruments_Types,
  Radio_Utilities,
  Coordinate_Types;

use ada.Numerics.Elementary_Functions;

package Standby_Mag_Compass is

   package It renames Nav_Instruments_Types;
   package Ru renames Radio_Utilities;

   type Instance is private;

   procedure Set_Aircraft_Position
     (An_Instance       : in out Instance;
      Aircraft_Position : in     It.Position_Type);

   procedure Set_Translational_Acceleration
     (An_Instance                : in out Instance;
      Translational_Acceleration : in     Coordinate_Types.Cartesian);

   procedure Set_Aircraft_Attitude
     (An_Instance       : in out Instance;
      Aircraft_Attitude : in     It.Attitude_Type);

   procedure Set_Body_Axis_Velocity
     (An_Instance        : in out Instance;
      Body_Axis_Velocity : in     Coordinate_Types.Cartesian);

   procedure Set_Turbulence_Level
     (An_Instance      : in out Instance;
      Turbulence_Level : in     Float);

   procedure Set_Weight_On_Wheels
     (An_Instance      : in out Instance;
      Weight_On_Wheels : in     Boolean);

   procedure Set_Magnetic_Heading
     (An_Instance      : in out Instance;
      Magnetic_Heading : in     It.Heading_Type);

   procedure Set_Compass_Heading
     (An_Instance     : in out Instance;
      Compass_Heading : in     It.Heading_Type);

   function Aircraft_Position
     (An_Instance : in Instance)
      return It.Position_Type;

   function Translational_Acceleration
     (An_Instance : in Instance)
      return Coordinate_Types.Cartesian;

   function Aircraft_Attitude
     (An_Instance : in Instance)
      return It.Attitude_Type;

   function Body_Axis_Velocity
     (An_Instance : in Instance)
      return Coordinate_Types.Cartesian;

   function Turbulence_Level
     (An_Instance : in Instance)
      return Float;

   function Weight_On_Wheels
     (An_Instance : in Instance)
      return Boolean;

   function Magnetic_Heading
     (An_Instance : in Instance)
      return It.Heading_Type;

   -- Access Compass_Heading
   function Compass_Heading
     (An_Instance : in Instance)
      return It.Heading_Type;

   -- Method Init
   procedure Init
     (An_Instance : in out Instance);

   -- Method Update
   procedure Update(Integration_Constant : in     Float;
                    An_Instance          : in out Instance);

private

   type Instance is record
      Aircraft_Position          : It.Position_Type;
      Translational_Acceleration : Coordinate_Types.Cartesian;
      Aircraft_Attitude          : It.Attitude_Type;
      Body_Axis_Velocity         : Coordinate_Types.Cartesian;
      Turbulence_Level           : Float;
      Weight_On_Wheels           : Boolean;
      Magnetic_Heading           : It.Heading_Type;
      Compass_Heading            : It.Bearing_Type;
  end record;


end Standby_Mag_Compass;
