-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Nav_Instruments_Types;

package Standby_Attitude_Indicator is

   type Instance is private;

   procedure Set_Power
     (An_Instance : in out Instance;
      Power       : in     Boolean);

   procedure Set_Cage
     (An_Instance : in out Instance;
      Cage        : in     Boolean);

   procedure Set_Off_Flag
     (An_Instance : in out Instance;
      Off_Flag    : in     Boolean);

   procedure Set_Aircraft_Attitude
     (An_Instance       : in out Instance;
      Aircraft_Attitude : in     Nav_Instruments_Types.Attitude_Type);

   procedure Set_Indicated_Attitude
     (An_Instance        : in out Instance;
      Indicated_Attitude : in     Nav_Instruments_Types.Attitude_Type);

   function  Power
     (An_Instance : in Instance)
      return Boolean;

   function  Cage
     (An_Instance : in Instance)
      return Boolean;

   function Off_Flag
     (An_Instance : in Instance)
      return Boolean;

   function Aircraft_Attitude
     (An_Instance : in Instance)
      return Nav_Instruments_Types.Attitude_Type;

   -- Access Indicated_Attitude
   function  Indicated_Attitude
     (An_Instance : in Instance)
      return Nav_Instruments_Types.Attitude_Type;

   -- Method Init
   procedure Init
     (An_Instance : in out Instance);

   -- Method Update
   procedure Update(Iconst      : in     Float;
                    An_Instance : in out Instance);

private

   type Instance is record
      Power              : Boolean;
      Cage               : Boolean;
      Off_Flag           : Boolean;
      Aircraft_Attitude  : Nav_Instruments_Types.Attitude_Type;
      Indicated_Attitude : Nav_Instruments_Types.Attitude_Type;
   end record;


end Standby_Attitude_Indicator;
