-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package Nav_Instruments_Types is

   type Attitude_Type is
      record
         Pitch : Float;
         Roll  : Float;
         Yaw   : Float;
      end record;

   subtype Bearing_Type is Float;

   subtype Heading_Type is Float;

   type Attitude_Rate_Type is
      record
         P : Float;
         Q : Float;
         R : Float;
      end record;

   type Attitude_Accel_Type is
      record
         P : Float;
         Q : Float;
         R : Float;
      end record;

   subtype Degrees_DP_Type is Long_Float;

   subtype Lat_Type is Degrees_DP_Type range -90.0 .. 90.0;

   subtype Lon_Type is Degrees_DP_Type range -180.0 .. 180.0;

   subtype Altitude_Type is Float range -1_000.0 .. 100_000.0;

   type Position_Type is
      record
         Latitude    : Lat_Type;
         Longitude   : Lon_Type;
         Altitude    : Altitude_Type;
      end record;

end Nav_Instruments_Types;
