with Stethoscope;

separate (JPATS_Nav_Instruments.Controller)

procedure Scope is

begin

   Stethoscope.Register_Signal
     (Name              => "nav_inst/Attitude.Pitch",
      Units             => "degrees",
      Object_Address    => Attitude.Pitch'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "nav_inst/Attitude.Roll",
      Units             => "degrees",
      Object_Address    => Attitude.Roll'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "nav_inst/Attitude.Yaw",
      Units             => "degrees",
      Object_Address    => Attitude.Yaw'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "nav_inst/Display_Attitude.Pitch",
      Units             => "degrees",
      Object_Address    => Display_Attitude.Pitch'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "nav_inst/Display_Attitude.Roll",
      Units             => "degrees",
      Object_Address    => Display_Attitude.Roll'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "nav_inst/Display_Attitude.Yaw",
      Units             => "degrees",
      Object_Address    => Display_Attitude.Yaw'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "nav_inst/Display_Heading",
      Units             => "deg's",
      Object_Address    => Display_Heading'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "nav_inst/Position.Latitude",
      Units             => "deg's",
      Object_Address    => Position.Latitude'address,
      Value_Type        => "double",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "nav_inst/Position.Longitude",
      Units             => "deg's",
      Object_Address    => Position.Longitude'address,
      Value_Type        => "double",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "nav_inst/Position.Altitude",
      Units             => "feet",
      Object_Address    => Position.Altitude'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   Stethoscope.Register_Signal
     (Name              => "nav_inst/Magnetic_Heading",
      Units             => "deg's",
      Object_Address    => Magnetic_Heading'address,
      Value_Type        => "float",
      Scope_Index       => 0);
end;
