-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Standby_Mag_Compass,
     Standby_Attitude_Indicator;

package JPATS_Nav_Instruments.Container is

   type Instance is
      record
         The_Stby_Mag : Standby_Mag_Compass.Instance;
         The_Stby_Att : Standby_Attitude_Indicator.Instance;
      end record;

   This_Subsystem : Instance;

   type Io_Interface_Instance is
      record
         Stby_Horizon_Roll_Sin : Float := 0.0;
         Stby_Horizon_Roll_Cos : Float := 0.0;
         Stby_Horizon_Pitch    : Float := 0.0;
         Stby_Horizon_Cage     : Boolean := False;
         Stby_Horizon_Flag     : Boolean := False;
         Stby_Compass_Sin      : Float := 0.0;
         Stby_Compass_Cos      : Float := 0.0;
      end record;

   Io_Size : constant := 4;

   for Io_Interface_Instance use
      record
         Stby_Horizon_Roll_Sin at 000*Io_Size range 0 .. 31;
         Stby_Horizon_Roll_Cos at 001*Io_Size range 0 .. 31;
         Stby_Horizon_Pitch    at 002*Io_Size range 0 .. 31;
         Stby_Horizon_Cage     at 003*Io_Size range 0 .. 31;
         Stby_Horizon_Flag     at 004*Io_Size range 0 .. 31;
         Stby_Compass_Sin      at 005*Io_Size range 0 .. 31;
         Stby_Compass_Cos      at 006*Io_Size range 0 .. 31;
      end record;

   This_Io_Interface : Io_Interface_Instance;

end JPATS_Nav_Instruments.Container;
