-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Wing_Lights_Power_Supply_G is

   procedure Update
     (An_Instance       : in out Instance;
      Anti_Collision_In : in     Boolean;
      Nav_In            : in     Boolean)
   is
   begin
      An_Instance.Anti_Collision_Out := Anti_Collision_In;
      An_Instance.Nav_Out            := Nav_In;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Anti_Collision_Out := False;
      An_Instance.Nav_Out            := False;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;

   function Anti_Collision_Out
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Anti_Collision_Out;
   exception
      when others =>
         Log.Report(Package_Name & ".Anti_Collision_Out()");
         raise;
   end Anti_Collision_Out;

   function Nav_Out
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Nav_Out;
   exception
      when others =>
         Log.Report(Package_Name & ".Nav_Out()");
         raise;
   end Nav_Out;

end Wing_Lights_Power_Supply_G;
