-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

generic

   type Current_Type is digits <>;
   type Light_Type is private;
   with procedure Turn_On_A_Light (An_Instance : in out Light_Type);
   with procedure Turn_Off_A_Light (An_Instance : in out Light_Type);
   with function A_Lights_Load (A_Light : in Light_Type) return Current_Type;
   with function A_Light_Is_On (A_Light : in Light_Type) return Boolean;
   with procedure Initialize_A_Light (A_Light : in out Light_Type);
   with procedure Update_A_Light (A_Light : in out Light_Type; Request : in Boolean);
   Package_Name : in String;

package Wing_Lights_G is

   type Instance is private;

   procedure Initialize
     (An_Instance : in out Instance);

   procedure Update
     (An_Instance   : in out Instance;
      Left_Request  : in     Boolean;
      Right_Request : in    Boolean);

   procedure Turn_On
     (An_Instance : in out Instance);

   procedure Turn_Off
     (An_Instance : in out Instance);

   function Load
     (An_Instance : in Instance)
      return Current_Type;

   function Left_Wing_Light_Is_On
     (An_Instance : in Instance)
     return Boolean;

   function Right_Wing_Light_Is_On
     (An_Instance : in Instance)
     return Boolean;

private

   type Instance is
      record
         Left_Wing_Light  : Light_Type;
         Right_Wing_Light : Light_Type;
      end record;

end Wing_Lights_G;
