-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Electrical_Units_Types;

package Jpats_Lights is

   function Lamp_Test_Sw
     return Boolean;

   function Inst_Panel_On_Sw
     return Boolean;

   function Landing_Light_Load
      return Electrical_Units_Types.Amps;
   function Utility_Light_Load
      return Electrical_Units_Types.Amps;
   function Flood_Lights_Load
      return Electrical_Units_Types.Amps;
   function Instrument_Lights_Load
      return Electrical_Units_Types.Amps;
   function Taxi_Light_Load
      return Electrical_Units_Types.Amps;
   function Navigation_Lights_Load
      return Electrical_Units_Types.Amps;
   function Position_Lights_Load
      return Electrical_Units_Types.Amps;
   function Anti_Collision_Lights_Load
      return Electrical_Units_Types.Amps;


   -- visual
   function Landing_Light_On
     return Boolean;
   function Taxi_Light_On
     return Boolean;
   function Left_Nav_Light_On
     return Boolean;
   function Right_Nav_Light_On
     return Boolean;
   function Left_Anti_Collision_Light_On
     return Boolean;
   function Right_Anti_Collision_Light_On
     return Boolean;
   function Left_Position_Light_On
     return Boolean;
   function Right_Position_Light_On
     return Boolean;


   --
   function Day_Night_Relay return Boolean;

end Jpats_Lights;
