-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Lights.Container;
with Log;

package body Jpats_Lights is

   function Lamp_Test_Sw
     return Boolean
   is
      package Ctnr renames Container;
      Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
   begin
      return Io.Lamp_Test_Sw;
   exception
      when others =>
         Log.Report("Jpats_Lights.Lamp_Test_Sw()");
         raise;
   end Lamp_Test_Sw;

   function Inst_Panel_On_Sw
     return Boolean
   is
      package Ctnr renames Container;
      Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
   begin
      return Io.Instrument_Pnl_On_Sw;
   exception
      when others =>
         Log.Report("Jpats_Lights.Inst_Panel_On_Sw()");
         raise;
   end Inst_Panel_On_Sw;


   function Landing_Light_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
      The_Landing_Light : Ctnr.Landing_Light.Instance renames Ctnr.This_Subsystem.The_Landing_Light;
   begin
      return Ctnr.Landing_Light.Load (The_Landing_Light);
   exception
      when others =>
         Log.Report("Jpats_Lights.Landing_Light_Load()");
         raise;
   end Landing_Light_Load;

   function Utility_Light_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
      The_Utility_Light : Ctnr.Utility_Lighting.Instance renames Ctnr.This_Subsystem.The_Utility_Light;
   begin
      return Ctnr.Utility_Lighting.Load (The_Utility_Light);
   exception
      when others =>
         Log.Report("Jpats_Lights.Utility_Light_Load()");
         raise;
   end Utility_Light_Load;

   function Flood_Lights_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
      The_Flood_Lights : Ctnr.Flood_Lighting.Instance renames Ctnr.This_Subsystem.The_Flood_Lights;
   begin
      return 1.0;  --Ctnr.Flood_Lighting.Load (The_Flood_Lights);
   exception
      when others =>
         Log.Report("Jpats_Lights.Flood_Lights_Load()");
         raise;
   end Flood_Lights_Load;

   function Instrument_Lights_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
      The_Instr_Lights : Ctnr.Instrument_Lighting.Instance renames Ctnr.This_Subsystem.The_Instrument_Lights;
   begin
      return 1.0;  --Ctnr.Instrument_Lighting.Load (The_Instr_Lights);
   exception
      when others =>
         Log.Report("Jpats_Lights.Instrument_Lights_Load()");
         raise;
   end Instrument_Lights_Load;

   function Taxi_Light_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
      The_Taxi_Light : Ctnr.Taxi_Light.Instance renames Ctnr.This_Subsystem.The_Taxi_Light;
   begin
      return  Ctnr.Taxi_Light.Load (The_Taxi_Light);
   exception
      when others =>
         Log.Report("Jpats_Lights.Taxi_Light_Load()");
         raise;
   end Taxi_Light_Load;

   function Navigation_Lights_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
      The_Nav_Lights : Ctnr.Navigation_Lights.Instance renames Ctnr.This_Subsystem.The_Navigation_Lights;
   begin
      return Ctnr.Navigation_Lights.Load (The_Nav_Lights);
   exception
      when others =>
         Log.Report("Jpats_Lights.Navigation_Lights_Load()");
         raise;
   end Navigation_Lights_Load;

   function Position_Lights_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
      The_Position_Lights : Ctnr.Position_Lights.Instance renames Ctnr.This_Subsystem.The_Position_Lights;
   begin
      return Ctnr.Position_Lights.Load (The_Position_Lights);
   exception
      when others =>
         Log.Report("Jpats_Lights.Position_Lights_Load()");
         raise;
   end Position_Lights_Load;

   function Anti_Collision_Lights_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
      The_Anti_Coll_Lights : Ctnr.Anti_Collision_Lights.Instance renames Ctnr.This_Subsystem.The_Anti_Collision_Lights;
   begin
      return Ctnr.Anti_Collision_Lights.Load (The_Anti_Coll_Lights);
   exception
      when others =>
         Log.Report("Jpats_Lights.Anti_Collision_Lights_Load()");
         raise;
   end Anti_Collision_Lights_Load;



   -- visual
   package Ctnr renames Container;
   JPATS : Ctnr.Instance renames Ctnr.This_Subsystem;

   function Landing_Light_On
     return Boolean
   is
   begin
      return Ctnr.Landing_Light.Is_On(JPATS.The_Landing_Light);
   exception
      when others =>
         Log.Report("Jpats_Lights.Landing_Light_On()");
         raise;
   end Landing_Light_On;

   function Taxi_Light_On
     return Boolean
   is
   begin
      return Ctnr.Taxi_Light.Is_On(JPATS.The_Taxi_Light);
   exception
      when others =>
         Log.Report("Jpats_Lights.Taxi_Light_On()");
         raise;
   end Taxi_Light_On;

   function Left_Nav_Light_On
     return Boolean
   is
   begin
      return Ctnr.Navigation_Lights.Left_Wing_Light_Is_On(JPATS.The_Navigation_Lights);
   exception
      when others =>
         Log.Report("Jpats_Lights.Left_Nav_Light_On()");
         raise;
   end Left_Nav_Light_On;

   function Right_Nav_Light_On
     return Boolean
   is
   begin
      return Ctnr.Navigation_Lights.Right_Wing_Light_Is_On(JPATS.The_Navigation_Lights);
   exception
      when others =>
         Log.Report("Jpats_Lights.Right_Nav_Light_On()");
         raise;
   end Right_Nav_Light_On;

   function Left_Anti_Collision_Light_On
     return Boolean
   is
   begin
      return Ctnr.Anti_Collision_Lights.Left_Wing_Light_Is_On(JPATS.The_Anti_Collision_Lights);
   exception
      when others =>
         Log.Report("Jpats_Lights.Left_Anti_Collision_Light_On()");
         raise;
   end Left_Anti_Collision_Light_On;

   function Right_Anti_Collision_Light_On
     return Boolean
   is
   begin
      return Ctnr.Anti_Collision_Lights.Right_Wing_Light_Is_On(JPATS.The_Anti_Collision_Lights);
   exception
      when others =>
         Log.Report("Jpats_Lights.Right_Anti_Collision_Light_On()");
         raise;
   end Right_Anti_Collision_Light_On;

   function Left_Position_Light_On
     return Boolean
   is
   begin
      return Ctnr.Position_Lights.Left_Wing_Light_Is_On(JPATS.The_Position_Lights);
   exception
      when others =>
         Log.Report("Jpats_Lights.Left_Position_Light_On()");
         raise;
   end Left_Position_Light_On;

   function Right_Position_Light_On
     return Boolean
   is
   begin
      return Ctnr.Position_Lights.Right_Wing_Light_Is_On(JPATS.The_Position_Lights);
   exception
      when others =>
         Log.Report("Jpats_Lights.Right_Position_Light_On()");
         raise;
   end Right_Position_Light_On;

   function Day_Night_Relay
     return Boolean
   is
   begin
      return Ctnr.This_Io_Interface.Fwd_Panel_Ltg_Relay_Cont;
   exception
      when others =>
         Log.Report("Jpats_Lights.Day_Night_Relay()");
         raise;
   end Day_Night_Relay;


end Jpats_Lights;
