-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Lights.Container;
with Jpats_Ios_Interface;
with Log;


package body Jpats_Lights.Ios_Interface is

   package Ctnr renames Container;
   Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
   Io  : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
   package JII renames Jpats_Ios_Interface;


   procedure Register_Ios_Variables
   is
   begin

      JPATS_IOS_Interface.Register
        (Name        => "Lamp_Test_Sw",
         Variable    => Io.Lamp_Test_Sw'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Ldg_Lts_Sw",
         Variable    => Io.Ldg_Lts_Sw'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Taxi_Lts_Sw",
         Variable    => Io.Taxi_Lts_Sw'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Anti_Collision_Lts_Sw",
         Variable    => Io.Anti_Collision_Lts_Sw'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Cont_Nav_Lts_Sw",
         Variable    => Io.Cont_Nav_Lts_Sw'Address
         );

   exception
      when others =>
         Log.Report("Jpats_Lights.Ios_Interface.Register_Ios_Variables()");
         raise;
   end Register_Ios_Variables;


end Jpats_Lights.Ios_Interface;
