-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Lights.Container;
with Jpats_Io;
with Jpats_Io_Types;
with Io_Types;
with Log;

package body Jpats_Lights.Io_Interface is

   package JIOT renames Jpats_Io_Types;
   Io : Container.Io_Interface_Instance renames Container.This_Io_Interface;

   procedure Register_Io_Variables
   is
   begin
      -- digital input
      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "LAMP_TEST_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Lamp_Test_Sw'Address,
         A_Size          => Io.Lamp_Test_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "LDG_LTS_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Ldg_Lts_Sw'Address,
         A_Size          => Io.Ldg_Lts_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "TAXI_LTS_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Taxi_Lts_Sw 'Address,
         A_Size          => Io.Taxi_Lts_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANTI_COLLISION_LTS_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Anti_Collision_Lts_Sw'Address,
         A_Size          => Io.Anti_Collision_Lts_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "CONT_NAV_LTS_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Cont_Nav_Lts_Sw'Address,
         A_Size          => Io.Cont_Nav_Lts_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "INSTRUMENT_PNL_ON_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Instrument_Pnl_On_Sw'Address,
         A_Size          => Io.Instrument_Pnl_On_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "SIDE_PNL_ON_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Side_Pnl_On_Sw'Address,
         A_Size          => Io.Side_Pnl_On_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "FLOOD_LTG_ON_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Flood_Ltg_On_Sw'Address,
         A_Size          => Io.Flood_Ltg_On_Sw'Size);

      -- digital output
--       Jpats_Io.Map_To_Icd_mnemonic
--         (An_Interface    => JIOT.Flight_Deck,
--          An_Icd_Mnemonic => "ANN_PNL_DIMMING_INPUT",
--          A_Direction     => IO_Types.Output,
--          An_Address      => Io.Ann_Pnl_Dimming_Input'Address,
--          A_Size          => Io.Ann_Pnl_Dimming_Input'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "INSTRUMENT_PNL_DIMMER_PWR",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Instrument_Pnl_Dimmer_Pwr'Address,
         A_Size          => Io.Instrument_Pnl_Dimmer_Pwr'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "SIDE_PNL_DIMMER_PWR",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Side_Pnl_Dimmer_Pwr'Address,
         A_Size          => Io.Side_Pnl_Dimmer_Pwr'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "EMERGENCY_DIMMER_PWR",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Emergency_Dimmer_Pwr'Address,
         A_Size          => Io.Emergency_Dimmer_Pwr'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "EMERGENCY_5V_LTG_RELAY",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Emergency_5v_Ltg_Relay'Address,
         A_Size          => Io.Emergency_5v_Ltg_Relay'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "FWD_PANEL_LTG_RELAY_CONT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Fwd_Panel_Ltg_Relay_Cont'Address,
         A_Size          => Io.Fwd_Panel_Ltg_Relay_Cont'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "FLOOD_LTS_DIMMER_PWR",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Flood_Lts_Dimmer_Pwr'Address,
         A_Size          => Io.Flood_Lts_Dimmer_Pwr'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "COCKPIT_UTILITY_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Cockpit_Utility_Lt'Address,
         A_Size          => Io.Cockpit_Utility_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "BATTERY_BUS_DIMMER_PWR",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Battery_Bus_Dimmer_Pwr'Address,
         A_Size          => Io.Battery_Bus_Dimmer_Pwr'Size);

      -- analog input
      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "INSTRUMENT_PNL_LTG_CONT",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Instrument_Pnl_Ltg_Cont'Address,
         A_Size          => Io.Instrument_Pnl_Ltg_Cont'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "SIDE_PNL_LTG_CONT",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Side_Pnl_Ltg_Cont'Address,
         A_Size          => Io.Side_Pnl_Ltg_Cont'Size);

      -- analog output
      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "INSTRUMENT_PNL_DIMMER_CONT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Instrument_Pnl_Dimmer_Cont'Address,
         A_Size          => Io.Instrument_Pnl_Dimmer_Cont'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "SIDE_PNL_DIMMER_CONT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Side_Pnl_Dimmer_Cont'Address,
         A_Size          => Io.Side_Pnl_Dimmer_Cont'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "EMERGENCY_DIMMER_CONT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Emergency_Dimmer_Cont'Address,
         A_Size          => Io.Emergency_Dimmer_Cont'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "BATTERY_BUS_DIMMER_CONTROL",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Battery_Bus_Dimmer_Control'Address,
         A_Size          => Io.Battery_Bus_Dimmer_Control'Size);


      null;
   exception
      when others =>
         Log.Report("Jpats_Lights.Io_Interface.Register_Io_Variables()");
         raise;
   end Register_Io_Variables;

end Jpats_Lights.Io_Interface;

