-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--  INTERIOR LIGHTING
--  All instruments, control panels, and displays in both cockpits
--  are lighted for operation during night or reduced light
--  conditions. Additionally, area lights are provided near the
--  circuit breaker panels in each cockpit. All lighting within
--  the cockpits, except for the electronic displays, is blue/white
--  in color. All switches and placards required for safe flight
--  are also illuminated. Balanced lighting output from the
--  instruments, control panels, and displays can be adjusted
--  and maintained throughout the dimmable range. Balanced
--  lighting is accomplished by dimming controls for the instrument
--  panel, area lighting and side console lighting, located
--  on the trim control panel in each cockpit.
--  Instrument panel lighting is controlled by a rheostat knob,
--  placarded INST. Area lighting is controlled by a rheostat
--  knob placarded FLOOD. Side panel lighting is Controlled
--  by a rheostat knob placarded SIDE. Independent lighting
--  controls for GPS, radio management unit, and EFIS displays
--  are mounted on the individual units. In addition, the
--  electronic air data and EIDs incorporate an automatic
--  brightness control function that adjusts the display to maintain
--  an optimum brightness contrast and balance for the
--  lighting environment during daylight operation.
--  Power for the area lighting is provided through a circuit
--  breaker placarded FLDT, located on the battery bus circuit
--  breaker panel in each cockpit.

--  INSTRUMENT PANEL LIGHTING
--  Instrument panel lighting and console lighting are controlled
--  by two dimming rheostats located on the forward left
--  console of each cockpit. One control is for the instrument
--  panel (INST), and the other is for the side consoles (SIDE).
--  Rotation allows variable adjustment of the panel lights.
--  Power for the instrument panel lighting is provided through
--  a circuit breaker placarded INST, located on the battery bus
--  circuit breaker panel in the front cockpit, and a circuit
--  breaker placarded INST LT, located on the battery bus circuit
--  breaker panel in the rear cockpit. Power for the console
--  lighting is provided through a circuit breaker placarded
--  SIDE, located on the generator bus circuit breaker panel in
--  each cockpit.

--  UTILITY LIGHT
--  A utility light is provided on the right console of each cockpit.
--  This light can be detached and relocated to the right canopy
--  rail for use as an area light or map light, or the light may
--  be detached as required for local illumination. The utility
--  light is powered through a coil cord to allow freedom of
--  movement to any position in the cockpit. A variable dimmer
--  with an OFF position is an integral part of the utility light,
--  as is a selectable red lens for preserving night vision.
--  Power for the utility lights is provided through a circuit
--  breaker placarded UTIL, located on the battery bus circuit
--  breaker panel in the front cockpit, and a circuit breaker placarded
--  UTIL LT, located on the battery bus circuit breaker
--  panel in the rear cockpit.

--  EXTERIOR LIGHTING
--  The aircraft is equipped with exterior lighting (Figure 1-57)
--  that meets the requirements for operation of the aircraft during
--  night and low light conditions.

--  LANDING AND TAXI LIGHTS
--  The landing light is located aft and inboard of the left main
--  landing gear strut, and is exposed as the landing gear is
--  extended. The landing light is oriented to provide Ground
--  illumination and visibility during landing. The landing light
--  will illuminate only when the gear is down and locked. Control
--  of the landing light is through a toggle switch placarded
--  LDG, located on the trim control panel in the front cockpit.
--  The landing light control switch head features three bumps
--  to assist in identifying the switch by feel. Power for the
--  landing light is provided through a circuit breaker placarded
--  LDG, located on the battery bus circuit breaker panel in the
--  front cockpit,
--  The taxi light is located aft and inboard of the right main
--  landing gear strut and is exposed as the landing gear is
--  extended. The taxi light is oriented to provide ground illumination
--  and visibility during landing and taxi operations.
--  The taxi light will illuminate only when the gear is down
--  and locked. Control of the taxi light is through a switch
--  placarded TAXI, located on the trim control panel in the
--  front cockpit. Power for the taxi light is provided through a
--  circuit breaker placarded TAXI, located on the generator
--  bus circuit breaker panel in the front cockpit.

--  NAVIGATION AND ANTI-COLLISION STROBE LIGHTS
--  The navigation lights include a red light installed at the
--  leading edge of the left wing tip, a green light installed at
--  the leading edge of the right wing tip, and white lights
--  installed at the trailing edge of each wing tip. The navigation
--  lights are controlled by a switch placarded NAV, located
--  on the trim control panel in the front cockpit. Power for the
--  navigation lights is provided through a circuit breaker placarded
--  NAV, located on the generator bus circuit breaker
--  panel in the front cockpit.
--  The anti-collision strobe lights are installed on each wing
--  tip near the leading edge. The anti-collision strobe lights are
--  controlled by a switch placarded ANTI-COLL, located on
--  the trim control panel in the front cockpit. Power for the
--  anti-collision strobe lights is provided through a circuit
--  breaker placarded COLL, located on the battery bus circuit
--  breaker panel in the front cockpit.
-------------------------------------------------------------------------------

private package Jpats_Lights.Controller is

   procedure Initialize;
   procedure Update
     (Iconst : in Float);

end Jpats_Lights.Controller;
